/** @file
 * @brief Check a honey table.
 */
/* Copyright (C) 2008,2009,2012,2013,2014,2016,2024 Olly Betts
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 */

#ifndef XAPIAN_INCLUDED_HONEY_DBCHECK_H
#define XAPIAN_INCLUDED_HONEY_DBCHECK_H

#include "xapian/types.h"

#include <sys/types.h> // For size_t and off_t.
#include <iosfwd>
#include <string>
#include <string_view>
#include <vector>

class HoneyVersion;

size_t check_honey_table(const char* tablename, std::string_view db_dir,
			 int fd, off_t offset_,
			 const HoneyVersion& version_file, int opts,
			 std::vector<Xapian::termcount>& doclens,
			 std::ostream* out);

inline size_t
check_honey_table(const char* tablename, std::string_view db_dir,
		  const HoneyVersion& version_file, int opts,
		  std::vector<Xapian::termcount>& doclens,
		  std::ostream* out)
{
    return check_honey_table(tablename, db_dir, -1, 0, version_file, opts,
			     doclens, out);
}

inline size_t
check_honey_table(const char* tablename, int fd, off_t offset_,
		  const HoneyVersion& version_file, int opts,
		  std::vector<Xapian::termcount>& doclens,
		  std::ostream* out)
{
    return check_honey_table(tablename, std::string(), fd, offset_,
			     version_file, opts,
			     doclens, out);
}

#endif // XAPIAN_INCLUDED_HONEY_DBCHECK_H
