.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH weston.ini 5 "2025-07-29" "Weston @version@"
.\"---------------------------------------------------------------------
.SH NAME
weston.ini \- configuration file for
.B Weston
\- the reference Wayland
compositor
.\"---------------------------------------------------------------------
.SH INTRODUCTION
.B Weston
obtains configuration from its command line parameters and the configuration
file described here.
.\"---------------------------------------------------------------------
.SH DESCRIPTION
.B Weston
uses a configuration file called
.I weston.ini
for its setup.
The
.I weston.ini
configuration file is searched for in one of the following places when the
server is started:
.PP
.RS 4
.nf
.BR "$XDG_CONFIG_HOME/weston.ini   " "(if $XDG_CONFIG_HOME is set)"
.BR "$HOME/.config/weston.ini      " "(if $HOME is set)"
.B  "weston/weston.ini in each"
.BR "\ \ \ \ $XDG_CONFIG_DIR           " "(if $XDG_CONFIG_DIRS is set)"
.BR "/etc/xdg/weston/weston.ini    " "(if $XDG_CONFIG_DIRS is not set)"
.fi
.RE
.PP
where environment variable
.B $HOME
is the user's home directory, and
.B $XDG_CONFIG_HOME
is the user specific configuration directory, and
.B $XDG_CONFIG_DIRS
is a colon
.B ':'
delimited listed of configuration base directories, such as
.BR /etc/xdg-foo:/etc/xdg .
.PP
The
.I weston.ini
file is composed of a number of sections which may be present in any order, or
omitted to use default configuration values. Each section has the form:
.PP
.RS 4
.nf
.BI [ SectionHeader ]
.RI Key1=Value1
.RI Key2=Value2
    ...
.fi
.RE
.PP
The spaces are significant.
Comment lines are ignored:
.PP
.RS 4
.nf
.IR "#comment"
.fi
.RE
.PP
The section headers are:
.PP
.RS 4
.nf
.BR "core           " "The core modules and options"
.BR "libinput       " "Input device configuration"
.BR "shell          " "Desktop customization"
.BR "launcher       " "Add launcher to the panel"
.BR "output         " "Output configuration"
.BR "input-method   " "Onscreen keyboard input"
.BR "keyboard       " "Keyboard layouts"
.BR "terminal       " "Terminal application options"
.BR "xwayland       " "XWayland options"
.BR "screen-share   " "Screen sharing options (deprecated)"
.BR "autolaunch     " "Autolaunch options"
.fi
.RE
.PP
Possible value types are string, signed and unsigned 32-bit
integer, and boolean. Strings must not be quoted, do not support any
escape sequences, and run till the end of the line. Integers can
be given in decimal (e.g. 123), octal (e.g. 0173), and hexadecimal
(e.g. 0x7b) form. Boolean values can be only 'true' or 'false'.
.\"---------------------------------------------------------------------
.SH "CORE SECTION"
The
.B core
section is used to select the startup compositor modules and general options.
.TP 7
.BI "shell=" desktop
specifies a shell to load (string). This can be used to load your own
implemented shell or one with Weston as default. Available shells
in the
.IR "@weston_modules_dir@"
directory are:
.PP
.RS 10
.nf
.BR desktop
.BR fullscreen (deprecated)
.BR ivi
.BR kiosk
.BR lua
.fi
.RE
.TP 7
.BI "xwayland=" true
ask Weston to load the XWayland module (boolean).
.TP 7
.BI "modules=" screen-share.so
specifies the modules to load (string, comma separated). Available modules
in the
.IR "@weston_modules_dir@"
directory are:
.PP
.RS 10
.nf
.BR screen-share.so (deprecated)
.fi
.RE
.TP 7
.BI "backend=" headless
overrides defaults backend. Available backends are:
.PP
.RS 10
.nf
.BR drm
.BR headless
.BR rdp
.BR pipewire
.BR vnc
.BR wayland
.BR x11
.fi
.RE
.TP 7
.BI "repaint-window=" N
Set the approximate length of the repaint window in milliseconds. The repaint
window is used to control and reduce the output latency for clients. If the
window is longer than the output refresh period, the repaint will be done
immediately when the previous repaint finishes, not processing client requests
in between. If the repaint window is too short, the compositor may miss the
target vertical blank, increasing output latency. The default value is 7
milliseconds. The allowed range is from 1 to 1000 milliseconds, but the
compositor will reduce large values to 1 millisecond less than the current
refresh rate.
.TP 7
.BI "idle-time="seconds
sets Weston's idle timeout in seconds. This idle timeout is the time
after which Weston will enter an "inactive" mode and screen will fade to
black. A value of 0 disables the timeout.

.IR Important
: This option may also be set via Weston's '-i' command
line option and will take precedence over the current .ini option. This
means that if both weston.ini and command line define this idle-timeout
time, the one specified in the command-line will be used. On the other
hand, if none of these sets the value, default idle timeout will be
set to 300 seconds.
.TP 7
.BI "require-input=" true
require an input device for launch
.TP 7
.BI "require-outputs=" any
configures the behavior if Weston fails to configure and enable outputs.

Depending on the use-case, it may preferable to ensure that Weston only starts
if it can enable all available outputs, or that it ignores failed outputs. The
possible options are:
.PP
.RS 10
.nf
.BR "all-found    " "all available outputs must be enabled"
.BR "any          " "start if any output could be enabled"
.BR "none         " "start even if no output was enabled"
.fi
.RE
.TP 7
.BI "wait-for-debugger=" true
Raises SIGSTOP before initializing the compositor. This allows the user to
attach with a debugger and continue execution by sending SIGCONT. This is
useful for debugging a crash on start-up when it would be inconvenient to
launch weston directly from a debugger. Boolean, defaults to
.BR false .
There is also a command line option to do the same.
.TP 7
.BI "remoting="remoting-plugin.so
specifies a plugin for remote output to load (string). This can be used to load
your own implemented remoting plugin or one with Weston as default. Available
remoting plugins in the
.IR "__libweston_modules_dir__"
directory are:
.PP
.RS 10
.nf
.BR remoting-plugin.so
.fi
.RE
.TP 7
.BI "renderer=" auto
Selects a renderer to use for internal composition when required, or
.BI auto
to select the most appropriate renderer. Available renderers are:
.PP
.RS 10
.nf
.BR auto
.BR gl
.BR noop
.BR pixman
.fi
.RE
Not all backends support all renderers.
.TP 7
.BI "use-pixman=" true
Deprecated in favour of the
.BI "renderer="
option.
Enables pixman-based rendering for all outputs on backends that support it.
Boolean, defaults to
.BR false .
There is also a command line option to do the same.
.TP 7
.BI "color-management=" true
Enables color management and requires using GL-renderer.
Boolean, defaults to
.BR false .

.I TENTATIVE, EXPERIMENTAL, WORK IN PROGRESS:
Color management enables the use of ICC files to describe monitor color
behavior, Wayland protocol extensions for clients to describe their color
spaces and perform monitor profiling, and tone mapping required to enable HDR
video modes. This extended functionality comes at the cost of heavier image
processing and sometimes a loss of some hardware off-loading features like
composite-bypass.
.TP 7
.BI "output-decorations=" true
For headless-backend with GL-renderer only: draws output window decorations,
similar to what wayland-backend does for floating output windows.
Boolean, defaults to
.BR false .
These decorations cannot normally be screenshot. This option is useful for
the Weston test suite only.
.TP 7
.BI "placeholder-color=" 0xRRGGBB
sets the color of the placeholder (unsigned integer). The hexadecimal digit
pairs are in order red, green, and blue. This placeholder is used for
content-protection or when we're not able to lift a surface/view in a HW plane,
but we require direct scan-out of buffers. Defaults to 0x660000 (red grenadier).
.\"---------------------------------------------------------------------
.SH "LIBINPUT SECTION"
The
.B libinput
section is used to configure input devices when using the libinput input device
backend. The defaults are determined by libinput and vary according to what is
most sensible for any given device.
.PP
Available configuration are:
.TP 7
.BI "enable-tap=" false
Enables tap to click on touchpad devices.
.TP 7
.BI "tap-and-drag=" false
For touchpad devices with \fBenable-tap\fR enabled. If the user taps, then
taps a second time, this time holding, the virtual mouse button stays down for
as long as the user keeps their finger on the touchpad, allowing the user to
click and drag with taps alone.
.TP 7
.BI "tap-and-drag-lock=" false
For touchpad devices with \fBenable-tap\fR and \fBtap-and-drag\fR enabled.
In the middle of a tap-and-drag, if the user releases the touchpad for less
than a certain number of milliseconds, then touches it again, the virtual mouse
button will remain pressed and the drag can continue.
.TP 7
.BI "disable-while-typing=" true
For devices that may be accidentally triggered while typing on the keyboard,
causing a disruption of the typing.  Disables them while the keyboard is in
use.
.TP 7
.BI "middle-button-emulation=" false
For pointer devices with left and right buttons, but no middle button.  When
enabled, a middle button event is emitted when the left and right buttons are
pressed simultaneously.
.TP 7
.BI "left-handed=" false
Configures the device for use by left-handed people. Exactly what this option
does depends on the device. For pointers with left and right buttons, the
buttons are swapped. On tablets, the tablet is logically turned upside down,
because it will be physically turned upside down.
.TP 7
.BI "rotation=" n
Changes the direction of the logical north, rotating it \fIn\fR degrees
clockwise away from the default orientation, where \fIn\fR is a whole
number between 0 and 359 inclusive. Needed for trackballs, mainly. Allows the
user to orient the trackball sideways, for example.
.TP 7
.BI "accel-profile=" "{flat,adaptive}"
Set the pointer acceleration profile. The pointer's screen speed is
proportional to the physical speed with a certain constant of proportionality.
Call that constant alpha. \fIflat\fR keeps alpha fixed. See \fBaccel-speed\fR.
\fIadaptive\fR causes alpha to increase with physical speed, giving the user
more control when the speed is slow, and more reach when the speed is high.
\fIadaptive\fR is the default.
.TP 7
.BI "accel-speed=" v
If \fBaccel-profile\fR is set to \fIflat\fR, it simply sets the value of alpha.
If \fBaccel-profile\fR is set to \fIadaptive\fR, the effect is more
complicated, but generally speaking, it will change the pointer's speed.
\fIv\fR is normalised and must lie in the range [-1, 1]. The exact mapping
between \fIv\fR and alpha is hardware-dependent, but higher values cause higher
cursor speeds.
.TP 7
.BI "natural-scroll=" false
Enables natural scrolling, mimicking the behaviour of touchscreen scrolling.
That is, if the wheel, finger, or fingers are moved down, the surface is
scrolled up instead of down, as if the finger, or fingers were in contact with
the surface being scrolled.
.TP 7
.BI "scroll-method=" {two-finger,edge,button,none}
Sets the scroll method. \fItwo-finger\fR scrolls with two fingers on a
touchpad. \fIedge\fR scrolls with one finger on the right edge of a touchpad.
\fIbutton\fR scrolls when the pointer is moved while a certain button is
pressed. See \fBscroll-button\fR. \fInone\fR disables scrolling altogether.
.TP 7
.BI "scroll-button=" {BTN_LEFT,BTN_RIGHT,BTN_MIDDLE,...}
For devices with \fBscroll-method\fR set to \fIbutton\fR. Specifies the
button that will trigger scrolling. See /usr/include/linux/input-event-codes.h
for the complete list of possible values.
.TP 7
.BI "disable-input=" false
Ignore all libinput-based input devices.
.TP 7
.BI "touchscreen_calibrator=" true
Advertise the touchscreen calibrator interface to all clients. This is a
potential denial-of-service attack vector, so it should only be enabled on
trusted userspace. Boolean, defaults to
.BR false .

The interface is required for running touchscreen calibrator applications. It
provides the application raw touch events, bypassing the normal touch handling.
It also allows the application to upload a new calibration into the compositor.

Even though this option is listed in the libinput section, it does affect all
Weston configurations regardless of the used backend. If the backend does not
use libinput, the interface can still be advertised, but it will not list any
devices.
.TP 7
.BI "calibration_helper=" /bin/echo
An optional calibration helper program to permanently save a new touchscreen
calibration. String, defaults to unset.

The given program will be executed with seven arguments when a calibrator
application requests the server to take a new calibration matrix into use.
The program is executed synchronously and will therefore block Weston for its
duration. If the program exit status is non-zero, Weston will not apply the
new calibration. If the helper is unset or the program exit status is zero,
Weston will use the new calibration immediately.

The program is invoked as:
.PP
.RS 10
.nf
.I calibration_helper syspath m1 m2 m3 m4 m5 m6
.fi
.RE
.IP
.RI "where " syspath
is the udev sys path for the device and
.IR m1 "  through " m6
are the calibration matrix elements in libinput's
.BR LIBINPUT_CALIBRATION_MATRIX " udev property format."
The sys path is an absolute path and starts with the sys mount point.
.\"---------------------------------------------------------------------
.SH "SHELL SECTION"
The
.B shell
section is used to customize the compositor. Some keys may not be handled by
different shell plugins.
.PP
The entries that can appear in this section are:
.TP 7
.BI "client=" "@weston_libexecdir@/@weston_shell_client@"
specifies the path for the shell client to run.
It is possible to pass arguments and environment variables to the program,
for example, 'ENVFOO=bar ENVBAR=baz /path/to/program --arg anotherarg',
with entries that are space-separated but with no support for quoting.
If no client was specified then
.I @weston_shell_client@
is launched (string).
.TP 7
.BI "background-image=" file
sets the path for the background image file (string).
.TP 7
.BI "background-type=" tile
determines how the background image is drawn (string). Can be
.BR centered ", " scale ", " scale-crop ", " scale-fit " or " tile " (default)."
Centered shows the image once centered. If the image is smaller than the
output, the rest of the surface will be in background color. If the image
size does fit the output it will be cropped left and right, or top and bottom.
Scale means scaled to fit the output precisely, not preserving aspect ratio.
Scale-crop preserves aspect ratio, scales the background image just big
enough to cover the output, and centers it. The image ends up cropped from
left and right, or top and bottom, if the aspect ratio does not match the
output. Scale-fit is similar to scale-crop but it fits to the output so the
image does not get cropped. Tile repeats the background image to fill the output.
.TP 7
.BI "background-color=" 0xRRGGBB
sets the color of the background (unsigned integer). The hexadecimal
digit pairs are in order red, green, and blue.
.TP 7
.BI "clock-format=" format
sets the panel clock format (string). Can be
.BR "none" ","
.BR "minutes" ","
.BR "seconds" ","
.BR "minutes-24h" ","
.BR "seconds-24h" "."
By default, minutes format is used.
.TP 7
.BI "panel-color=" 0xAARRGGBB
sets the color of the panel (unsigned integer). The hexadecimal
digit pairs are in order transparency, red, green, and blue. Examples:
.PP
.RS 10
.nf
.BR "0xffff0000    " "Red"
.BR "0xff00ff00    " "Green"
.BR "0xff0000ff    " "Blue"
.BR "0x00ffffff    " "Fully transparent"
.fi
.RE
.TP 7
.BI "panel-position=" top
sets the position of the panel (string). Can be
.B top,
.B bottom,
.B left,
.B right,
.B none.
.TP 7
.BI "locking=" true
enables screen locking (boolean).
.TP 7
.BI "animation=" zoom
sets the effect used for opening new windows (string). Can be
.B zoom,
.B fade,
.B none.
By default, no animation is used.
.TP 7
.BI "close-animation=" fade
sets the effect used when closing windows (string). Can be
.B fade,
.B none.
By default, the fade animation is used.
.TP 7
.BI "startup-animation=" fade
sets the effect used by desktop-shell when starting up (string). Can be
.B fade,
.B none.
By default, the fade animation is used.
.TP 7
.BI "focus-animation=" dim-layer
sets the effect used with the focused and unfocused windows. Can be
.B dim-layer,
.B none.
By default, no animation is used.
.TP 7
.BI "allow-zap=" true
whether the shell should quit when the Ctrl-Alt-Backspace key combination is
pressed
.TP 7
.BI "disallow-output-changed-move=" false
whether the shell should move client's window to a different/another output than the one
assigned initially and is no longer available/enabled/plugged in.
.TP 7
.BI "binding-modifier=" ctrl
sets the modifier key used for common bindings (string), such as moving
surfaces, resizing, rotating, switching, closing and setting the transparency
for windows, controlling the backlight and zooming the desktop. See
.BR weston-bindings (7).
Possible values: none, ctrl, alt, super (default)
.TP 7
.BI "cursor-theme=" theme
sets the cursor theme (string).
.TP 7
.BI "cursor-size=" 24
sets the cursor size (unsigned integer).
.TP 7
.BI "lua-script=" script
sets the script for the lua shell.
.\"---------------------------------------------------------------------
.SH "LAUNCHER SECTION"
There can be multiple launcher sections, one for each launcher.
.TP 7
.BI "icon=" icon
sets the path to icon image (string). Svg images are not currently supported.
.TP 7
.BI "displayname=" displayname
sets the display name of the launcher that appears in the tooltip.
.TP 7
.BI "path=" program
sets the path to the program that is run by clicking on this launcher (string).
It is possible to pass arguments and environment variables to the program. For
example:
.nf
.in +4n

path=GDK_BACKEND=wayland gnome-terminal --full-screen
.in
.fi
.\"---------------------------------------------------------------------
.SH "OUTPUT SECTION"
There can be multiple output sections, each corresponding to one output. It is
currently only recognized by the drm and x11 backends.
.TP 7
.BI "name=" name
sets a name for the output (string). The backend uses the name to
identify the output. All X11 output names start with a letter X.  All
Wayland output names start with the letters WL.
Examples of usage:
.PP
.RS 10
.nf
.BR "LVDS1    " "DRM backend, Laptop internal panel no.1"
.BR "VGA1     " "DRM backend, VGA connector no.1"
.BR "X1       " "X11 backend, X window no.1"
.BR "WL1      " "Wayland backend, Wayland window no.1"
.fi
.RE
.IP
See
.B "weston-drm(7)"
for more details.
.TP 7
.BI "mode=" mode
sets the output mode (string). The mode parameter is handled differently
depending on the backend. On the X11 backend, it just sets the WIDTHxHEIGHT of
the weston window.
The DRM backend accepts different modes, along with an option of a modeline string.

See
.B "weston-drm(7)"
for examples of modes-formats supported by DRM backend.
.TP 7
.BI "transform=" normal
How you have rotated your monitor from its normal orientation (string).
The transform key can be one of the following 8 strings:
.PP
.RS 10
.nf
.BR  "normal               " "Normal output."
.BR  "rotate-90            " "90 degrees clockwise."
.BR  "rotate-180           " "Upside down."
.BR  "rotate-270           " "90 degrees counter clockwise."
.BR  "flipped              " "Horizontally flipped"
.BR  "flipped-rotate-90    " "Flipped and 90 degrees clockwise"
.BR  "flipped-rotate-180   " "Flipped and upside down"
.BR  "flipped-rotate-270   " "Flipped and 90 degrees counter clockwise"
.fi
.RE
.TP 7
.BI "scale=" factor
The scaling multiplier applied to the entire output, in support of high
resolution ("HiDPI" or "retina") displays, that roughly corresponds to the
pixel ratio of the display's physical resolution to the logical resolution.
Applications that do not support high resolution displays typically appear tiny
and unreadable. Weston will scale the output of such applications by this
multiplier, to make them readable. Applications that do support their own output
scaling can draw their content in high resolution, in which case they avoid
compositor scaling. Weston will not scale the output of such applications, and
they are not affected by this multiplier.
.IP
An integer, 1 by default, typically configured as 2 or higher when needed,
denoting the scaling multiplier for the output.
.TP 7
.BI "icc_profile=" file
If option
.B color-management
is true, load the given ICC file as the output color profile. This works only
on DRM, headless, wayland, and x11 backends, and for remoting and pipewire
outputs.
.TP 7
.BI "color-profile=" name

.B NOTE:
This feature is not fully implemented yet, and therefore it is not expected to
work.

Color profiles describe how the display is assumed to behave. Knowing the
display color behavior, Weston can adapt window contents to produce the
presumed appearance. The option
.B color-management
must be set to true for this to work. This works only on DRM, headless,
wayland, and x11 backends, and for remoting and pipewire outputs. If
.B icc_profile
is also set, that is used instead.

This key creates a parametric profile to be used as the output color profile.
The profile can be created from parameters recorded in a
.B color-profile
section by referring to it by its
.B name
value. Alternatively this key can use one of the special profile names that
contain a colon (:).

The default, once implemented, will be
.BR "color-profile=auto:" .

The following special names are accepted:
.RS 11
.TP
.B "srgb:"
Creates a parametric sRGB color profile (gamma 2.2).
.TP
.BI  "auto:" "[flags...]"
Creates an automatic parametric color profile.
.RE

.IP
Automatic parametric color profiles are created based on the
.BR eotf-mode " and " colorimetry-mode
configuration keys of the respective
.B output
section, and optionally using the monitor reported EDID (DRM-backend only).
Multiple flags must be separated by whitespace. The available flags are:
.RS 11
.TP
.B edid-primaries
Get primaries and white point from EDID if
.BR colorimetry-mode " is " default .
Ignored if EDID does not provide all of them.

.TP
.B edid-tf
Get transfer function from EDID if
.BR eoft-mode " is " sdr " or " hdr-gamma .
The transfer function is the power-law curve with the EDID indicated exponent.

.TP
.B edid-dr
Get dynamic range information from EDID if
.BR eotf-mode " is " st2084 .
.RE

.IP
Examples:
.RS 11
.EX
.B color-profile=srgb:
.B color-profile=auto:
.B color-profile=auto:edid-tf edid-dr
.B color-profile=auto: edid-primaries
.B color-profile=my-awesome-display
.EE
.RE

.IP
The last example causes Weston to read the
.B color-profile
section that has
.BR name=my-awesome-display .

.IP
Notably, setting

.RS 11
.EX
.B eotf-mode=sdr
.B colorimetry-mode=default
.B color-profile=auto:
.EE
.RE
.IP
produces the same color profile as
.BR color-profile=srgb: .
.TP 7
.BI "color-effect=" name
Use the given color effect for the output. For now we only provide color effects
for color vision deficiencies (CVD). Only works when option
.B color-management
is false.

The effect can be one of the following strings:
.RS 11
.TP
.B inversion
color inversion
.TP
.B deuteranopia
color correction (not simulation) for deuteranopia
.TP
.B protanopia
color correction (not simulation) for protanopia
.TP
.B tritanopia
color correction (not simulation) for tritanopia
.RE
.TP 7
.BI "seat=" name
The logical seat name that this output should be associated with. If this
is set then the seat's input will be confined to the output that has the seat
set on it. The expectation is that this functionality will be used in a
multiheaded environment with a single compositor for multiple output and input
configurations. The default seat is called "default" and will always be
present. This seat can be constrained like any other.
.TP 7
.BI "allow_hdcp=" true
Allows HDCP support for this output. If set to true, HDCP can be tried for the
content-protection, provided by the backends, on this output. By
default, HDCP support is always allowed for an output. The
content-protection can actually be realized, only if the hardware
(source and sink) support HDCP, and the backend has the implementation
of content-protection protocol. Currently, HDCP is supported by drm-backend.
.TP 7
.BI "content-type=" content_type
The type of the content being primarily displayed to this output. Can be "no
data" (default), "graphics", "photo", "cinema" or "game".
.TP 7
.BI "app-ids=" app-id[,app_id]*
A comma separated list of the IDs of applications to place on this output.
These IDs should match the application IDs as set with the xdg_shell.set_app_id
request. Currently, this option is supported by kiosk-shell.
.TP 7
.BI "colorimetry-mode=" default
Sets the colorimetry mode on the output. The colorimetry mode together with
the EOTF mode below define the color encoding used in the video signal. The
colorimetry mode is used for choosing between the default sink defined
colorimetry (intended to be described by EDID), and standardised other
encodings that support wide color gamut (WCG).

The display driver, the graphics card, and the video sink (monitor) need to
support the chosen mode, otherwise the result is undefined or fails.

The mode can be one of the following strings:
.PP
.RS 10
.nf
.BR  "default              " "default (RGB) colorimetry, video sink dependant"
.BR  "bt2020cycc           " "Rec. ITU-R BT.2020 constant luminance YCbCr"
.BR  "bt2020ycc            " "Rec. ITU-R BT.2020 non-constant luminance YCbCr"
.BR  "bt2020rgb            " "Rec. ITU-R BT.2020 RGB"
.BR  "p3d65                " "SMPTE ST 2113 DCI-P3 RGB D65"
.BR  "p3dci                " "SMPTE ST 2113 DCI-P3 RGB Theater"
.BR  "ictcp                " "Rec. ITU-R BT.2100 ICtCp"
.fi
.RE
.IP
Defaults to
.BR default ". Non-default modes require " "color-management=true" .

Note: The operating system might not honor the choice between RGB and YCbCr,
that may be picked by a Linux display driver automatically.
.TP 7
.BI "eotf-mode=" sdr
Sets the EOTF mode on the output. This is used for choosing between standard
dynamic range (SDR) mode and the various high dynamic range (HDR) modes. The
display driver, the graphics card, and the video sink (monitor) need to support
the chosen mode, otherwise the result is undefined.
The mode can be one of the following strings:
.PP
.RS 10
.nf
.BR  "sdr                  " "traditional gamma, SDR"
.BR  "hdr-gamma            " "traditional gamma, HDR"
.BR  "st2084               " "SMPTE ST 2084, a.k.a Perceptual Quantizer"
.BR  "hlg                  " "Hybrid Log-Gamma (ITU-R BT.2100)"
.fi
.RE
.IP
Defaults to
.BR sdr ". Non-SDR modes require " "color-management=true" .
.TP 7
.BI "color_characteristics=" name
Sets the basic output color characteristics by loading the parameters from the
.B color_characteristics
section with the key
.BI "name=" name
\&. If an ICC profile is also set, the ICC profile takes precedence.
.TP 7
.BI "mirror-of=" ouput_name
Makes the remote output overlap (mirror) the native output identified by the
mirror-of value.  This is useful for sharing or mirroring a native DRM output.
The output mirroring the DRM native one, will inherit the same video modeline
as the DRM native one, including the refresh rate and scale of the native
output.  Note that depending on the remote backend, automatic output resize
will be disabled when mirroring is in effect. Mirroring a DRM native
output to another DRM native output is yet not supported, being intended
only for remote outputs.

NOTE: The native outputs created by the DRM backend using the 'clone-of'
are for cloning the outputs, and not sharing or mirroring. See also
.BR weston-drm(7).
.TP 7
.BI "vrr-mode=" mode
Sets the variable refresh rate mode of the display.
The mode can be one of the following strings:
.PP
.RS 10
.nf
.BR  "none                 " "variable refresh rate is disabled"
.BR  "game                 " "game variable refresh rate"
.fi
.RE
.IP
Defaults to "none".
.\"---------------------------------------------------------------------
.SH "INPUT-METHOD SECTION"
.TP 7
.BI "path=" "@weston_libexecdir@/weston-keyboard"
sets the path of the on screen keyboard input method (string).
It is possible to pass arguments and environment variables to the program,
for example, 'ENVFOO=bar ENVBAR=baz /path/to/program --arg anotherarg',
with entries that are space-separated but with no support for quoting.

.TP 7
.BI "overlay-keyboard=" false
sets weston-keyboard as overlay panel.
.\"---------------------------------------------------------------------
.SH "KEYBOARD SECTION"
This section contains the following keys:
.TP 7
.BI "keymap_rules=" "evdev"
sets the keymap rules file (string). Used to map layout and model to input
device.
.TP 7
.BI "keymap_model=" "pc105"
sets the keymap model (string). See the Models section in
.B "xkeyboard-config(7)."
.TP 7
.BI "keymap_layout=" "us,de,gb"
sets the comma separated list of keyboard layout codes (string). See the
Layouts section in
.B "xkeyboard-config(7)."
.TP 7
.BI "keymap_variant=" "euro,,intl"
sets the comma separated list of keyboard layout variants (string). The number
of variants must be the same as the number of layouts above. See the Layouts
section in
.B "xkeyboard-config(7)."
.TP 7
.BI "keymap_options=" "grp:alt_shift_toggle,grp_led:scroll"
sets the keymap options (string). See the Options section in
.B "xkeyboard-config(7)."
.TP 7
.BI "repeat-rate=" "40"
sets the rate of repeating keys in characters per second (unsigned integer)
.TP 7
.BI "repeat-delay=" "400"
sets the delay in milliseconds since key down until repeating starts (unsigned
integer)
.TP 7
.BI "numlock-on=" "false"
sets the default state of the numlock on weston startup for the backends which
support it.
.TP 7
.BI "vt-switching=" "true"
Whether to allow the use of Ctrl+Alt+Fn key combinations to switch away from
the compositor's virtual console.
.\"---------------------------------------------------------------------
.SH "TERMINAL SECTION"
Contains settings for the weston terminal application (weston-terminal). It
allows to customize the font and shell of the command line interface.
.TP 7
.BI "font=" "DejaVu Sans Mono"
sets the font of the terminal (string). For a good experience it is recommended
to use monospace fonts. In case the font is not found, the default one is used.
.TP 7
.BI "font-size=" "14"
sets the size of the terminal font (unsigned integer).
.TP 7
.BI "term=" "xterm-256color"
The terminal shell (string). Sets the $TERM variable.
.\"---------------------------------------------------------------------
.SH "XWAYLAND SECTION"
.TP 7
.BI "path=" "@xserver_path@"
sets the path to the xserver to run (string).
.\"---------------------------------------------------------------------
.SH "SCREEN-SHARE SECTION"
.TP 7
.SH "DEPRECATED: screen-share module is not built by default and has been deprecated, pending removal."
Use deprecated-screenshare=true option to build it. Note that mirroring
functionality has been added to replace this deprecated screen-share
module.  See mirror-of key entry in the output section for how to configure it.
.TP 7
.BI "command=" "@weston_bindir@/weston --backend=rdp \
--shell=fullscreen --no-resizeable --no-config"
sets the command to start a fullscreen-shell server for screen sharing (string).
.TP 7
.BI "start-on-startup=" "false"
If set to true, start screen sharing of all outputs available on Weston startup.
Set to false by default.
.\"---------------------------------------------------------------------
Set to false by default. When using this option make sure you enable --no-config
to avoid re-loading the screen-share module and implictly trigger screen-sharing
for the RDP output already performing the screen share. Alternatively, you could
also supply a different configuration file, by using --config /path/to/config/file,
and make sure that the configuration file doesn't load the screen-share module.
.RE
.RE
.SH "AUTOLAUNCH SECTION"
.TP 7
.BI "path=" "/usr/bin/echo"
Path to an executable file to run after startup. This file is executed in
parallel to Weston, so it does not have to immediately exit. Defaults to empty.
.TP 7
.BI "watch=" "false"
If set to true, quit Weston after the auto-launched executable exits. Set to false
by default.
.\"---------------------------------------------------------------------
.SH "COLOR_CHARACTERISTICS SECTION"
Each
.B color_characteristics
section records one set of basic display or monitor color characterisation
parameters. The parameters are defined in CTA-861-H specification as Static
Metadata Type 1, and they can also be found in EDID. The parameters are
divided into groups. Each group must be given either fully or not at all.
.PP
Each section should be named with
.B name
key by which it can be referenced from other sections. A metadata section is
just a collection of parameter values and does nothing on its own. It has an
effect only when referenced from elsewhere.
.PP
See
.BR output " section key " color_characteristics .
.TP 7
.BI "name=" name
An arbitrary name for this section. You can choose any name you want as long as
it does not contain the colon
.RB ( : )
character. Names with at least one colon are reserved.
.SS Primaries group
.TP 7
.BI "red_x=" x
.TQ
.BI "red_y=" y
.TQ
.BI "green_x=" x
.TQ
.BI "green_y=" y
.TQ
.BI "blue_x=" x
.TQ
.BI "blue_y=" y
The CIE 1931 xy chromaticity coordinates of the display primaries.
These floating point values must reside between 0.0 and 1.0, inclusive.
.SS White point group
.TP 7
.BI "white_x=" x
.TQ
.BI "white_y=" y
The CIE 1931 xy chromaticity coordinates of the display white point.
These floating point values must reside between 0.0 and 1.0, inclusive.
.SS Independent parameters
Each parameter listed here has its own group and therefore can be given
alone.
.TP 7
.BI "max_L=" L
Display's desired maximum content luminance (peak)
.IR L \~cd/m²,
a floating point value in the range 0.0\(en100000.0.
.TP 7
.BI "min_L=" L
Display's desired minimum content luminance
.IR L \~cd/m²,
a floating point value in the range 0.0\(en100000.0.
.TP 7
.BI "maxFALL=" L
Display's desired maximum frame-average light level
.IR L \~cd/m²,
a floating point value in the range 0.0\(en100000.0.
.\"---------------------------------------------------------------------
.SH "COLOR-PROFILE SECTION"
Each
.B color-profile
section records one set of basic display color characterisation parameters.
Some parameters are collected into groups. Each group must be given either fully
or not at all. A usable section must contain at least the signaling primaries
.RB ( "Signaling primaries group" " or " prim_named )
and the transfer function
.RB ( tf_named " or " tf_power ).
.PP
Each section must be named with
.B name
key by which it can be referenced from other sections. A
.B color-profile
section is just a collection of parameter values and does nothing on its own.
It has an effect only when referenced from elsewhere.
.PP
See
.BR output " section key " color-profile .
.TP 7
.BI "name=" name
An arbitrary name for this section. You can choose any name you want as long as
it does not contain the colon
.RB ( : )
character. Names with at least one colon are reserved.
.TP 7
.BI "prim_named=" name
A standardised set of primaries and white point for signaling.
The following names are recognized:
.RS 11
.TP
.B srgb
sRGB (IEC 61966-2-1) and ITU-R BT.709
.TP
.B pal_m
PAL-M (ITU-R BT.470-6)
.TP
.B pal
PAL (ITU-R BT.470-6), ITU-R BT.601-7 625-line
.TP
.B ntsc
NTSC (SMPTE 170M-2004), ITU-R BT.601-7 525-line
.TP
.B generic_film
generic film with color filters using Illuminant C (ITU-T H.273)
.TP
.B bt2020
ITU-R BT.2020 and BT.2100
.TP
.B cie1931_xyz
CIE 1931 XYZ (ITU-T H.273)
.TP
.B dci_p3
DCI P3 (SMPTE RP 431-2)
.TP
.B display_p3
Apple Display P3, SMPTE EG 432-1
.TP
.B adobe_rgb
Adobe RGB (ISO 12640)
.RE
.IP
Mutually exclusive with the
.B Signaling primaries group
with which one can define custom primaries and white point.
.TP 7
.BI "target_named=" name
A standardised set of primaries and white point for the targeted color volume.
The same set of names are recognized as for
.BR prim_named .
.IP
Mutually exclusive with the
.B Target primaries group
with which one can define custom primaries and white point.
.TP 7
.BI "tf_named=" name
A standard transfer function or characteristic. The following names are
recognized:
.PP
.RS 11
.TP
.B bt1886
Rec. ITU-R BT.1886 display transfer characteristic.
Defaults to min_lum=0.01. ref_lum=100, max_lum=100.
.TP
.B gamma22
Assumed display gamma 2.2 transfer function.
An sRGB display (IEC 61966-2-1) uses this transfer function.
.TP
.B gamma28
Assumed display gamma 2.8 transfer function.
.TP
.B st240
SMPTE ST 240 (1999)
.TP
.B st428
SMPTE ST 428-1 (2019)
.TP
.B st2084
SMPTE ST 2084 Perceptual Quantizer (PQ) transfer characteristic.
Defaults to min_lum=0.005, ref_lum=203.
.TP
.B linear
Linear transfer function defined over all real numbers.
Normalised electrical values are equal the normalised optical values.
.TP
.B log100
Logarithmic transfer characteristic (100:1 range).
.TP
.B log316
Logarithmic transfer characteristic (100 * Sqrt(10) : 1 range).
.TP
.B xvycc
IEC 61966-2-4
.TP
.B hlg
Rec. ITU-R BT.2100 HLG transfer characteristic.
Defaults to min_lum=0.005, ref_lum=203, max_lum=1000.
.RE
.IP
Unless otherwise stated above, the default signaling luminance values are
min_lum=0.2, ref_lum=80, max_lum=80. See
.BR "Signaling luminances group" .
.IP
Mutually exclusive with
.B tf_power.
.TP 7
.BI "tf_power=" E
Mutually exclusive with
.B tf_named.
Set the transfer function as the power-law curve with the given exponent
.IR E ,
a real number in the range [1.0, 10.0].
Defaults to min_lum=0.2, ref_lum=80, max_lum=80.
.TP 7
.BI "max_fall=" L
Display's desired maximum frame-average light level
.IR L " cd/m²."
Undefined when not set.
.TP 7
.BI "max_cll=" L
Display's maximum content light level
.IR L " cd/m²."
Undefined when not set.
.SS Signaling primaries group
.TP 7
.BI "prim_red=" "x y"
.TQ
.BI "prim_green=" "x y"
.TQ
.BI "prim_blue=" "x y"
.TQ
.BI "prim_white=" "x y"
The signaling primaries group defines the primaries and the white point used
for encoding tristimulus into RGB values, also known as the primary color
volume.
.RI "The " x " and " y
are the CIE 1931 2-degree observer chromaticity coordinates. The values must be
in the range [-1.0, 2.0].

For an easier way to define standard primaries, see
.B prim_named
which is mutually exclusive with the signaling primaries group.
.SS Signaling luminances group
.TP 7
.BI "min_lum=" Lmin
.TQ
.BI "ref_lum=" Lref
.TQ
.BI "max_lum=" Lmax
.IR Lmin \(en Lmax
is the dynamic range of the display corresponding to 0%\(en100% signal levels.
For the
.B tf_named=st2084
setting the
.I Lmax
value is overwritten with 10'000 +
.IR Lmin .
.I Lref
is the reference luminance level to which all application contents are matched,
also referred to as graphics white luminance or standard dynamic range peak
luminance. All values are positive real numbers in cd/m².
.IR Lmin " can also be zero."
.IR Lmin " must be less than " Lref " and " Lmax .

When not set, the default values depend on the chosen transfer function or
characteristic.
.SS Target primaries group
.TP 7
.BI "target_red=" "x y"
.TQ
.BI "target_green=" "x y"
.TQ
.BI "target_blue=" "x y"
.TQ
.BI "target_white=" "x y"
The target color volume is similar to the Mastering Display Color Volume
(MDCV) in that any encoded stimulus outside of it has an undefined presentation.
This is particularly useful with a display that uses a wide gamut signal
encoding (e.g. BT.2020) but can only produce a subset of that color gamut.
.RI "The " x " and " y
are the CIE 1931 2-degree observer chromaticity coordinates. The values must be
in the range [-1.0, 2.0].

When not set, defaults to the primary color volume.

For an easier way to define standard targets, see
.B target_named
which is mutually exclusive with the target primaries group.
.SS Target luminances group
.TP 7
.BI "target_min_lum=" Lmin
.TQ
.BI "target_max_lum=" Lmax
Luminance range of the target color volume.
.IR Lmin " and " Lmax
are positive real numbers in cd/m².
.I Lmin
may also be zero, and it must be less than
.IR Lmax .

When not set, defaults to the signaling luminance range.
.\"---------------------------------------------------------------------
.SH "SEE ALSO"
.BR weston (1),
.BR weston-bindings (7),
.BR weston-drm (7),
.BR xkeyboard-config (7)
