---
myst:
  html_meta:
    keywords: LaTeX, fichiers, PDF
---

# Comment créer des fichiers PDF permettant les "copier-coller" et autres recherches ?

Les fichiers PDF générés à partir de TeX (et autres) contiennent par défaut leur texte 
dans l'encodage de la police TeX originale utilisée par le document.

Lorsque les lecteurs PDF, etc., proposent des fonctions de copier-coller ou de recherche, 
les opérations s'effectuent sur les codes de glyphes utilisés 
pour les polices sélectionnées par le document. 
Cela convient pour les documents les plus simples (en anglais, au moins). 
Le problème se pose lorsque vous utilisez une [langue flexionnelle](wpfr:Flexion_(linguistique)) 
(avec des lettres accentuées ou des glyphes composites tels que "œ"). 


## Avec TeX

TeX utilisera généralement un encodage non standard, et il y aura probablement des problèmes, 
car les lecteurs PDF supposent que le texte est présenté en [Unicode](wpfr:Unicode).


## Avec LaTeX

Pour les PDF générés à partir de LaTeX (le DVI étant converti, par quelque moyen que ce soit), 
ou de pdfLaTeX, les codes de caractères utilisés dans le fichier PDF 
sont en fait ceux de l'[encodage de police](/2_programmation/encodage/notion_d_encodage) du document. 
Si vous utilisez OT1 ou T1, votre document sera correct pour presque tous les caractères ASCII, 
mais il est probable que tout ce qui "sort de l'ordinaire" ne sera pas représenté correctement. 

La solution vient des possibilités de mise en correspondance des caractères dans la spécification PDF :
le fichier peut spécifier une table de traductions des caractères présents
dans le codage utilisé dans le fichier, vers une version Unicode des caractères.

Les extensions <ctanpkg:cmap> et <ctanpkg:mmap> offrent toutes deux des moyens de générer 
de telles tables (<ctanpkg:mmap> a, en particulier, une couverture plus large, 
incluant les différents encodages mathématiques). Elles fonctionnent uniquement avec pdfTeX. 
Ainsi, votre document aura une forme proche de la suivante :

```{noedit}
\documentclass{article}
  \usepackage{mmap} % (or cmap)
  \usepackage[T1]{fontenc}
  % la suite de votre préambule

\begin{document}
  % Votre texte
\end{document}
```

Malheureusement, elles ne fonctionnent qu'avec les polices qui sont directement encodées, 
comme les polices par défaut (*Computer Modern*) et des polices telles `cm-super` ou *Latin Modern*. 
Les polices comme *Adobe Times Roman* (qui sont encodées pour l'utilisation de (La)TeX 
via des polices virtuelles) ne se prêtent pas à ce traitement.


## Avec XeTeX et LuaTeX

Les PDF générés à partir de formats basés sur XeTeX ou LuaTeX seront corrects, 
puisque ces moteurs fonctionnent en Unicode.

:::{sources}
[Copy-paste-able/searchable PDF files](faquk:FAQ-cpy-srchpdf)
:::