use indieweb::http::Client;
use indieweb::standards::indieauth::AccessToken;
use indieweb::standards::micropub::action::{Action, ActionResponse};
use serde::Serialize;
use url::Url;

#[derive(Serialize)]
pub struct DeleteResult {
    pub url: String,
    pub deleted: bool,
}

pub async fn run(
    client: &impl Client,
    endpoint: &Url,
    access_token: &AccessToken,
    post_url: &Url,
) -> miette::Result<DeleteResult> {
    let action = Action::Delete(post_url.clone());

    let response = action.send(client, endpoint, access_token).await?;

    match response {
        ActionResponse::Deleted(_) => {
            Ok(DeleteResult {
                url: post_url.to_string(),
                deleted: true,
            })
        }
        _ => Err(miette::miette!("Unexpected response from Micropub server")),
    }
}
