# typed: strict

=begin
This file is generated by the templates/template.rb script and should not be
modified manually. See templates/rbi/prism/dsl.rbi.erb
if you are looking to modify the template
=end

module Prism::DSL
  sig { params(string: String).returns(Prism::Source) }
  def source(string); end

  sig { params(source: Prism::Source, start_offset: Integer, length: Integer).returns(Prism::Location) }
  def location(source: default_source, start_offset: 0, length: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, new_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode), old_name: T.any(Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::SymbolNode, Prism::MissingNode), keyword_loc: Prism::Location).returns(Prism::AliasGlobalVariableNode) }
  def alias_global_variable_node(source: default_source, node_id: 0, location: default_location, flags: 0, new_name: global_variable_read_node(source: source), old_name: global_variable_read_node(source: source), keyword_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, new_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode), old_name: T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode, Prism::GlobalVariableReadNode, Prism::MissingNode), keyword_loc: Prism::Location).returns(Prism::AliasMethodNode) }
  def alias_method_node(source: default_source, node_id: 0, location: default_location, flags: 0, new_name: symbol_node(source: source), old_name: symbol_node(source: source), keyword_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, left: Prism::Node, right: Prism::Node, operator_loc: Prism::Location).returns(Prism::AlternationPatternNode) }
  def alternation_pattern_node(source: default_source, node_id: 0, location: default_location, flags: 0, left: default_node(source, location), right: default_node(source, location), operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, left: Prism::Node, right: Prism::Node, operator_loc: Prism::Location).returns(Prism::AndNode) }
  def and_node(source: default_source, node_id: 0, location: default_location, flags: 0, left: default_node(source, location), right: default_node(source, location), operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, arguments: T::Array[Prism::Node]).returns(Prism::ArgumentsNode) }
  def arguments_node(source: default_source, node_id: 0, location: default_location, flags: 0, arguments: []); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, elements: T::Array[Prism::Node], opening_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location)).returns(Prism::ArrayNode) }
  def array_node(source: default_source, node_id: 0, location: default_location, flags: 0, elements: [], opening_loc: nil, closing_loc: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, constant: T.nilable(T.any(Prism::ConstantPathNode, Prism::ConstantReadNode)), requireds: T::Array[Prism::Node], rest: T.nilable(Prism::Node), posts: T::Array[Prism::Node], opening_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location)).returns(Prism::ArrayPatternNode) }
  def array_pattern_node(source: default_source, node_id: 0, location: default_location, flags: 0, constant: nil, requireds: [], rest: nil, posts: [], opening_loc: nil, closing_loc: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, key: Prism::Node, value: Prism::Node, operator_loc: T.nilable(Prism::Location)).returns(Prism::AssocNode) }
  def assoc_node(source: default_source, node_id: 0, location: default_location, flags: 0, key: default_node(source, location), value: default_node(source, location), operator_loc: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, value: T.nilable(Prism::Node), operator_loc: Prism::Location).returns(Prism::AssocSplatNode) }
  def assoc_splat_node(source: default_source, node_id: 0, location: default_location, flags: 0, value: nil, operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::BackReferenceReadNode) }
  def back_reference_read_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, begin_keyword_loc: T.nilable(Prism::Location), statements: T.nilable(Prism::StatementsNode), rescue_clause: T.nilable(Prism::RescueNode), else_clause: T.nilable(Prism::ElseNode), ensure_clause: T.nilable(Prism::EnsureNode), end_keyword_loc: T.nilable(Prism::Location)).returns(Prism::BeginNode) }
  def begin_node(source: default_source, node_id: 0, location: default_location, flags: 0, begin_keyword_loc: nil, statements: nil, rescue_clause: nil, else_clause: nil, ensure_clause: nil, end_keyword_loc: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, expression: T.nilable(Prism::Node), operator_loc: Prism::Location).returns(Prism::BlockArgumentNode) }
  def block_argument_node(source: default_source, node_id: 0, location: default_location, flags: 0, expression: nil, operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::BlockLocalVariableNode) }
  def block_local_variable_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)), body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)), opening_loc: Prism::Location, closing_loc: Prism::Location).returns(Prism::BlockNode) }
  def block_node(source: default_source, node_id: 0, location: default_location, flags: 0, locals: [], parameters: nil, body: nil, opening_loc: location, closing_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: T.nilable(Symbol), name_loc: T.nilable(Prism::Location), operator_loc: Prism::Location).returns(Prism::BlockParameterNode) }
  def block_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: nil, name_loc: nil, operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, parameters: T.nilable(Prism::ParametersNode), locals: T::Array[Prism::BlockLocalVariableNode], opening_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location)).returns(Prism::BlockParametersNode) }
  def block_parameters_node(source: default_source, node_id: 0, location: default_location, flags: 0, parameters: nil, locals: [], opening_loc: nil, closing_loc: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, arguments: T.nilable(Prism::ArgumentsNode), keyword_loc: Prism::Location).returns(Prism::BreakNode) }
  def break_node(source: default_source, node_id: 0, location: default_location, flags: 0, arguments: nil, keyword_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), message_loc: T.nilable(Prism::Location), read_name: Symbol, write_name: Symbol, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::CallAndWriteNode) }
  def call_and_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: nil, call_operator_loc: nil, message_loc: nil, read_name: :"", write_name: :"", operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), name: Symbol, message_loc: T.nilable(Prism::Location), opening_loc: T.nilable(Prism::Location), arguments: T.nilable(Prism::ArgumentsNode), closing_loc: T.nilable(Prism::Location), equal_loc: T.nilable(Prism::Location), block: T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))).returns(Prism::CallNode) }
  def call_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: nil, call_operator_loc: nil, name: :"", message_loc: nil, opening_loc: nil, arguments: nil, closing_loc: nil, equal_loc: nil, block: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), message_loc: T.nilable(Prism::Location), read_name: Symbol, write_name: Symbol, binary_operator: Symbol, binary_operator_loc: Prism::Location, value: Prism::Node).returns(Prism::CallOperatorWriteNode) }
  def call_operator_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: nil, call_operator_loc: nil, message_loc: nil, read_name: :"", write_name: :"", binary_operator: :"", binary_operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), message_loc: T.nilable(Prism::Location), read_name: Symbol, write_name: Symbol, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::CallOrWriteNode) }
  def call_or_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: nil, call_operator_loc: nil, message_loc: nil, read_name: :"", write_name: :"", operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: Prism::Node, call_operator_loc: Prism::Location, name: Symbol, message_loc: Prism::Location).returns(Prism::CallTargetNode) }
  def call_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: default_node(source, location), call_operator_loc: location, name: :"", message_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, value: Prism::Node, target: Prism::LocalVariableTargetNode, operator_loc: Prism::Location).returns(Prism::CapturePatternNode) }
  def capture_pattern_node(source: default_source, node_id: 0, location: default_location, flags: 0, value: default_node(source, location), target: local_variable_target_node(source: source), operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, predicate: T.nilable(Prism::Node), conditions: T::Array[Prism::InNode], else_clause: T.nilable(Prism::ElseNode), case_keyword_loc: Prism::Location, end_keyword_loc: Prism::Location).returns(Prism::CaseMatchNode) }
  def case_match_node(source: default_source, node_id: 0, location: default_location, flags: 0, predicate: nil, conditions: [], else_clause: nil, case_keyword_loc: location, end_keyword_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, predicate: T.nilable(Prism::Node), conditions: T::Array[Prism::WhenNode], else_clause: T.nilable(Prism::ElseNode), case_keyword_loc: Prism::Location, end_keyword_loc: Prism::Location).returns(Prism::CaseNode) }
  def case_node(source: default_source, node_id: 0, location: default_location, flags: 0, predicate: nil, conditions: [], else_clause: nil, case_keyword_loc: location, end_keyword_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], class_keyword_loc: Prism::Location, constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::CallNode), inheritance_operator_loc: T.nilable(Prism::Location), superclass: T.nilable(Prism::Node), body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)), end_keyword_loc: Prism::Location, name: Symbol).returns(Prism::ClassNode) }
  def class_node(source: default_source, node_id: 0, location: default_location, flags: 0, locals: [], class_keyword_loc: location, constant_path: constant_read_node(source: source), inheritance_operator_loc: nil, superclass: nil, body: nil, end_keyword_loc: location, name: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::ClassVariableAndWriteNode) }
  def class_variable_and_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, binary_operator_loc: Prism::Location, value: Prism::Node, binary_operator: Symbol).returns(Prism::ClassVariableOperatorWriteNode) }
  def class_variable_operator_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, binary_operator_loc: location, value: default_node(source, location), binary_operator: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::ClassVariableOrWriteNode) }
  def class_variable_or_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::ClassVariableReadNode) }
  def class_variable_read_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::ClassVariableTargetNode) }
  def class_variable_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, value: Prism::Node, operator_loc: Prism::Location).returns(Prism::ClassVariableWriteNode) }
  def class_variable_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, value: default_node(source, location), operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::ConstantAndWriteNode) }
  def constant_and_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, binary_operator_loc: Prism::Location, value: Prism::Node, binary_operator: Symbol).returns(Prism::ConstantOperatorWriteNode) }
  def constant_operator_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, binary_operator_loc: location, value: default_node(source, location), binary_operator: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::ConstantOrWriteNode) }
  def constant_or_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, target: Prism::ConstantPathNode, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::ConstantPathAndWriteNode) }
  def constant_path_and_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, target: constant_path_node(source: source), operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, parent: T.nilable(Prism::Node), name: T.nilable(Symbol), delimiter_loc: Prism::Location, name_loc: Prism::Location).returns(Prism::ConstantPathNode) }
  def constant_path_node(source: default_source, node_id: 0, location: default_location, flags: 0, parent: nil, name: nil, delimiter_loc: location, name_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, target: Prism::ConstantPathNode, binary_operator_loc: Prism::Location, value: Prism::Node, binary_operator: Symbol).returns(Prism::ConstantPathOperatorWriteNode) }
  def constant_path_operator_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, target: constant_path_node(source: source), binary_operator_loc: location, value: default_node(source, location), binary_operator: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, target: Prism::ConstantPathNode, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::ConstantPathOrWriteNode) }
  def constant_path_or_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, target: constant_path_node(source: source), operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, parent: T.nilable(Prism::Node), name: T.nilable(Symbol), delimiter_loc: Prism::Location, name_loc: Prism::Location).returns(Prism::ConstantPathTargetNode) }
  def constant_path_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, parent: nil, name: nil, delimiter_loc: location, name_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, target: Prism::ConstantPathNode, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::ConstantPathWriteNode) }
  def constant_path_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, target: constant_path_node(source: source), operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::ConstantReadNode) }
  def constant_read_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::ConstantTargetNode) }
  def constant_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, value: Prism::Node, operator_loc: Prism::Location).returns(Prism::ConstantWriteNode) }
  def constant_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, value: default_node(source, location), operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, receiver: T.nilable(Prism::Node), parameters: T.nilable(Prism::ParametersNode), body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)), locals: T::Array[Symbol], def_keyword_loc: Prism::Location, operator_loc: T.nilable(Prism::Location), lparen_loc: T.nilable(Prism::Location), rparen_loc: T.nilable(Prism::Location), equal_loc: T.nilable(Prism::Location), end_keyword_loc: T.nilable(Prism::Location)).returns(Prism::DefNode) }
  def def_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, receiver: nil, parameters: nil, body: nil, locals: [], def_keyword_loc: location, operator_loc: nil, lparen_loc: nil, rparen_loc: nil, equal_loc: nil, end_keyword_loc: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, lparen_loc: T.nilable(Prism::Location), value: Prism::Node, rparen_loc: T.nilable(Prism::Location), keyword_loc: Prism::Location).returns(Prism::DefinedNode) }
  def defined_node(source: default_source, node_id: 0, location: default_location, flags: 0, lparen_loc: nil, value: default_node(source, location), rparen_loc: nil, keyword_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, else_keyword_loc: Prism::Location, statements: T.nilable(Prism::StatementsNode), end_keyword_loc: T.nilable(Prism::Location)).returns(Prism::ElseNode) }
  def else_node(source: default_source, node_id: 0, location: default_location, flags: 0, else_keyword_loc: location, statements: nil, end_keyword_loc: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, statements: T.nilable(Prism::StatementsNode), closing_loc: Prism::Location).returns(Prism::EmbeddedStatementsNode) }
  def embedded_statements_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: location, statements: nil, closing_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, operator_loc: Prism::Location, variable: T.any(Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)).returns(Prism::EmbeddedVariableNode) }
  def embedded_variable_node(source: default_source, node_id: 0, location: default_location, flags: 0, operator_loc: location, variable: instance_variable_read_node(source: source)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, ensure_keyword_loc: Prism::Location, statements: T.nilable(Prism::StatementsNode), end_keyword_loc: Prism::Location).returns(Prism::EnsureNode) }
  def ensure_node(source: default_source, node_id: 0, location: default_location, flags: 0, ensure_keyword_loc: location, statements: nil, end_keyword_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::FalseNode) }
  def false_node(source: default_source, node_id: 0, location: default_location, flags: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, constant: T.nilable(T.any(Prism::ConstantPathNode, Prism::ConstantReadNode)), left: Prism::SplatNode, requireds: T::Array[Prism::Node], right: T.any(Prism::SplatNode, Prism::MissingNode), opening_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location)).returns(Prism::FindPatternNode) }
  def find_pattern_node(source: default_source, node_id: 0, location: default_location, flags: 0, constant: nil, left: splat_node(source: source), requireds: [], right: splat_node(source: source), opening_loc: nil, closing_loc: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, left: T.nilable(Prism::Node), right: T.nilable(Prism::Node), operator_loc: Prism::Location).returns(Prism::FlipFlopNode) }
  def flip_flop_node(source: default_source, node_id: 0, location: default_location, flags: 0, left: nil, right: nil, operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, value: Float).returns(Prism::FloatNode) }
  def float_node(source: default_source, node_id: 0, location: default_location, flags: 0, value: 0.0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, index: T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode), collection: Prism::Node, statements: T.nilable(Prism::StatementsNode), for_keyword_loc: Prism::Location, in_keyword_loc: Prism::Location, do_keyword_loc: T.nilable(Prism::Location), end_keyword_loc: Prism::Location).returns(Prism::ForNode) }
  def for_node(source: default_source, node_id: 0, location: default_location, flags: 0, index: local_variable_target_node(source: source), collection: default_node(source, location), statements: nil, for_keyword_loc: location, in_keyword_loc: location, do_keyword_loc: nil, end_keyword_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ForwardingArgumentsNode) }
  def forwarding_arguments_node(source: default_source, node_id: 0, location: default_location, flags: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ForwardingParameterNode) }
  def forwarding_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, block: T.nilable(Prism::BlockNode)).returns(Prism::ForwardingSuperNode) }
  def forwarding_super_node(source: default_source, node_id: 0, location: default_location, flags: 0, block: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::GlobalVariableAndWriteNode) }
  def global_variable_and_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, binary_operator_loc: Prism::Location, value: Prism::Node, binary_operator: Symbol).returns(Prism::GlobalVariableOperatorWriteNode) }
  def global_variable_operator_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, binary_operator_loc: location, value: default_node(source, location), binary_operator: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::GlobalVariableOrWriteNode) }
  def global_variable_or_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::GlobalVariableReadNode) }
  def global_variable_read_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::GlobalVariableTargetNode) }
  def global_variable_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, value: Prism::Node, operator_loc: Prism::Location).returns(Prism::GlobalVariableWriteNode) }
  def global_variable_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, value: default_node(source, location), operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)], closing_loc: Prism::Location).returns(Prism::HashNode) }
  def hash_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: location, elements: [], closing_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, constant: T.nilable(T.any(Prism::ConstantPathNode, Prism::ConstantReadNode)), elements: T::Array[Prism::AssocNode], rest: T.nilable(T.any(Prism::AssocSplatNode, Prism::NoKeywordsParameterNode)), opening_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location)).returns(Prism::HashPatternNode) }
  def hash_pattern_node(source: default_source, node_id: 0, location: default_location, flags: 0, constant: nil, elements: [], rest: nil, opening_loc: nil, closing_loc: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, if_keyword_loc: T.nilable(Prism::Location), predicate: Prism::Node, then_keyword_loc: T.nilable(Prism::Location), statements: T.nilable(Prism::StatementsNode), subsequent: T.nilable(T.any(Prism::ElseNode, Prism::IfNode)), end_keyword_loc: T.nilable(Prism::Location)).returns(Prism::IfNode) }
  def if_node(source: default_source, node_id: 0, location: default_location, flags: 0, if_keyword_loc: nil, predicate: default_node(source, location), then_keyword_loc: nil, statements: nil, subsequent: nil, end_keyword_loc: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, numeric: T.any(Prism::FloatNode, Prism::IntegerNode, Prism::RationalNode)).returns(Prism::ImaginaryNode) }
  def imaginary_node(source: default_source, node_id: 0, location: default_location, flags: 0, numeric: float_node(source: source)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, value: T.any(Prism::LocalVariableReadNode, Prism::CallNode, Prism::ConstantReadNode, Prism::LocalVariableTargetNode)).returns(Prism::ImplicitNode) }
  def implicit_node(source: default_source, node_id: 0, location: default_location, flags: 0, value: local_variable_read_node(source: source)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ImplicitRestNode) }
  def implicit_rest_node(source: default_source, node_id: 0, location: default_location, flags: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, pattern: Prism::Node, statements: T.nilable(Prism::StatementsNode), in_loc: Prism::Location, then_loc: T.nilable(Prism::Location)).returns(Prism::InNode) }
  def in_node(source: default_source, node_id: 0, location: default_location, flags: 0, pattern: default_node(source, location), statements: nil, in_loc: location, then_loc: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), opening_loc: Prism::Location, arguments: T.nilable(Prism::ArgumentsNode), closing_loc: Prism::Location, block: T.nilable(Prism::BlockArgumentNode), operator_loc: Prism::Location, value: Prism::Node).returns(Prism::IndexAndWriteNode) }
  def index_and_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: nil, call_operator_loc: nil, opening_loc: location, arguments: nil, closing_loc: location, block: nil, operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), opening_loc: Prism::Location, arguments: T.nilable(Prism::ArgumentsNode), closing_loc: Prism::Location, block: T.nilable(Prism::BlockArgumentNode), binary_operator: Symbol, binary_operator_loc: Prism::Location, value: Prism::Node).returns(Prism::IndexOperatorWriteNode) }
  def index_operator_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: nil, call_operator_loc: nil, opening_loc: location, arguments: nil, closing_loc: location, block: nil, binary_operator: :"", binary_operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: T.nilable(Prism::Node), call_operator_loc: T.nilable(Prism::Location), opening_loc: Prism::Location, arguments: T.nilable(Prism::ArgumentsNode), closing_loc: Prism::Location, block: T.nilable(Prism::BlockArgumentNode), operator_loc: Prism::Location, value: Prism::Node).returns(Prism::IndexOrWriteNode) }
  def index_or_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: nil, call_operator_loc: nil, opening_loc: location, arguments: nil, closing_loc: location, block: nil, operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, receiver: Prism::Node, opening_loc: Prism::Location, arguments: T.nilable(Prism::ArgumentsNode), closing_loc: Prism::Location, block: T.nilable(Prism::BlockArgumentNode)).returns(Prism::IndexTargetNode) }
  def index_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, receiver: default_node(source, location), opening_loc: location, arguments: nil, closing_loc: location, block: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::InstanceVariableAndWriteNode) }
  def instance_variable_and_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, binary_operator_loc: Prism::Location, value: Prism::Node, binary_operator: Symbol).returns(Prism::InstanceVariableOperatorWriteNode) }
  def instance_variable_operator_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, binary_operator_loc: location, value: default_node(source, location), binary_operator: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::InstanceVariableOrWriteNode) }
  def instance_variable_or_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::InstanceVariableReadNode) }
  def instance_variable_read_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::InstanceVariableTargetNode) }
  def instance_variable_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, value: Prism::Node, operator_loc: Prism::Location).returns(Prism::InstanceVariableWriteNode) }
  def instance_variable_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, value: default_node(source, location), operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, value: Integer).returns(Prism::IntegerNode) }
  def integer_node(source: default_source, node_id: 0, location: default_location, flags: 0, value: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)], closing_loc: Prism::Location).returns(Prism::InterpolatedMatchLastLineNode) }
  def interpolated_match_last_line_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: location, parts: [], closing_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)], closing_loc: Prism::Location).returns(Prism::InterpolatedRegularExpressionNode) }
  def interpolated_regular_expression_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: location, parts: [], closing_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: T.nilable(Prism::Location), parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode, Prism::InterpolatedStringNode, Prism::XStringNode, Prism::InterpolatedXStringNode, Prism::SymbolNode, Prism::InterpolatedSymbolNode)], closing_loc: T.nilable(Prism::Location)).returns(Prism::InterpolatedStringNode) }
  def interpolated_string_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: nil, parts: [], closing_loc: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: T.nilable(Prism::Location), parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)], closing_loc: T.nilable(Prism::Location)).returns(Prism::InterpolatedSymbolNode) }
  def interpolated_symbol_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: nil, parts: [], closing_loc: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, parts: T::Array[T.any(Prism::StringNode, Prism::EmbeddedStatementsNode, Prism::EmbeddedVariableNode)], closing_loc: Prism::Location).returns(Prism::InterpolatedXStringNode) }
  def interpolated_x_string_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: location, parts: [], closing_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ItLocalVariableReadNode) }
  def it_local_variable_read_node(source: default_source, node_id: 0, location: default_location, flags: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::ItParametersNode) }
  def it_parameters_node(source: default_source, node_id: 0, location: default_location, flags: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, elements: T::Array[T.any(Prism::AssocNode, Prism::AssocSplatNode)]).returns(Prism::KeywordHashNode) }
  def keyword_hash_node(source: default_source, node_id: 0, location: default_location, flags: 0, elements: []); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: T.nilable(Symbol), name_loc: T.nilable(Prism::Location), operator_loc: Prism::Location).returns(Prism::KeywordRestParameterNode) }
  def keyword_rest_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: nil, name_loc: nil, operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], operator_loc: Prism::Location, opening_loc: Prism::Location, closing_loc: Prism::Location, parameters: T.nilable(T.any(Prism::BlockParametersNode, Prism::NumberedParametersNode, Prism::ItParametersNode)), body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode))).returns(Prism::LambdaNode) }
  def lambda_node(source: default_source, node_id: 0, location: default_location, flags: 0, locals: [], operator_loc: location, opening_loc: location, closing_loc: location, parameters: nil, body: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node, name: Symbol, depth: Integer).returns(Prism::LocalVariableAndWriteNode) }
  def local_variable_and_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name_loc: location, operator_loc: location, value: default_node(source, location), name: :"", depth: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name_loc: Prism::Location, binary_operator_loc: Prism::Location, value: Prism::Node, name: Symbol, binary_operator: Symbol, depth: Integer).returns(Prism::LocalVariableOperatorWriteNode) }
  def local_variable_operator_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name_loc: location, binary_operator_loc: location, value: default_node(source, location), name: :"", binary_operator: :"", depth: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node, name: Symbol, depth: Integer).returns(Prism::LocalVariableOrWriteNode) }
  def local_variable_or_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name_loc: location, operator_loc: location, value: default_node(source, location), name: :"", depth: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, depth: Integer).returns(Prism::LocalVariableReadNode) }
  def local_variable_read_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", depth: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, depth: Integer).returns(Prism::LocalVariableTargetNode) }
  def local_variable_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", depth: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, depth: Integer, name_loc: Prism::Location, value: Prism::Node, operator_loc: Prism::Location).returns(Prism::LocalVariableWriteNode) }
  def local_variable_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", depth: 0, name_loc: location, value: default_node(source, location), operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, content_loc: Prism::Location, closing_loc: Prism::Location, unescaped: String).returns(Prism::MatchLastLineNode) }
  def match_last_line_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: location, content_loc: location, closing_loc: location, unescaped: ""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, value: Prism::Node, pattern: Prism::Node, operator_loc: Prism::Location).returns(Prism::MatchPredicateNode) }
  def match_predicate_node(source: default_source, node_id: 0, location: default_location, flags: 0, value: default_node(source, location), pattern: default_node(source, location), operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, value: Prism::Node, pattern: Prism::Node, operator_loc: Prism::Location).returns(Prism::MatchRequiredNode) }
  def match_required_node(source: default_source, node_id: 0, location: default_location, flags: 0, value: default_node(source, location), pattern: default_node(source, location), operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, call: Prism::CallNode, targets: T::Array[Prism::LocalVariableTargetNode]).returns(Prism::MatchWriteNode) }
  def match_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, call: call_node(source: source), targets: []); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::MissingNode) }
  def missing_node(source: default_source, node_id: 0, location: default_location, flags: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], module_keyword_loc: Prism::Location, constant_path: T.any(Prism::ConstantReadNode, Prism::ConstantPathNode, Prism::MissingNode), body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)), end_keyword_loc: Prism::Location, name: Symbol).returns(Prism::ModuleNode) }
  def module_node(source: default_source, node_id: 0, location: default_location, flags: 0, locals: [], module_keyword_loc: location, constant_path: constant_read_node(source: source), body: nil, end_keyword_loc: location, name: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)], rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)), rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::RequiredParameterNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)], lparen_loc: T.nilable(Prism::Location), rparen_loc: T.nilable(Prism::Location)).returns(Prism::MultiTargetNode) }
  def multi_target_node(source: default_source, node_id: 0, location: default_location, flags: 0, lefts: [], rest: nil, rights: [], lparen_loc: nil, rparen_loc: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, lefts: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)], rest: T.nilable(T.any(Prism::ImplicitRestNode, Prism::SplatNode)), rights: T::Array[T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::MultiTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode)], lparen_loc: T.nilable(Prism::Location), rparen_loc: T.nilable(Prism::Location), operator_loc: Prism::Location, value: Prism::Node).returns(Prism::MultiWriteNode) }
  def multi_write_node(source: default_source, node_id: 0, location: default_location, flags: 0, lefts: [], rest: nil, rights: [], lparen_loc: nil, rparen_loc: nil, operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, arguments: T.nilable(Prism::ArgumentsNode), keyword_loc: Prism::Location).returns(Prism::NextNode) }
  def next_node(source: default_source, node_id: 0, location: default_location, flags: 0, arguments: nil, keyword_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::NilNode) }
  def nil_node(source: default_source, node_id: 0, location: default_location, flags: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, operator_loc: Prism::Location, keyword_loc: Prism::Location).returns(Prism::NoKeywordsParameterNode) }
  def no_keywords_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0, operator_loc: location, keyword_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, maximum: Integer).returns(Prism::NumberedParametersNode) }
  def numbered_parameters_node(source: default_source, node_id: 0, location: default_location, flags: 0, maximum: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, number: Integer).returns(Prism::NumberedReferenceReadNode) }
  def numbered_reference_read_node(source: default_source, node_id: 0, location: default_location, flags: 0, number: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, value: Prism::Node).returns(Prism::OptionalKeywordParameterNode) }
  def optional_keyword_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location, operator_loc: Prism::Location, value: Prism::Node).returns(Prism::OptionalParameterNode) }
  def optional_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location, operator_loc: location, value: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, left: Prism::Node, right: Prism::Node, operator_loc: Prism::Location).returns(Prism::OrNode) }
  def or_node(source: default_source, node_id: 0, location: default_location, flags: 0, left: default_node(source, location), right: default_node(source, location), operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, requireds: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode)], optionals: T::Array[Prism::OptionalParameterNode], rest: T.nilable(T.any(Prism::RestParameterNode, Prism::ImplicitRestNode)), posts: T::Array[T.any(Prism::RequiredParameterNode, Prism::MultiTargetNode, Prism::KeywordRestParameterNode, Prism::NoKeywordsParameterNode, Prism::ForwardingParameterNode)], keywords: T::Array[T.any(Prism::RequiredKeywordParameterNode, Prism::OptionalKeywordParameterNode)], keyword_rest: T.nilable(T.any(Prism::KeywordRestParameterNode, Prism::ForwardingParameterNode, Prism::NoKeywordsParameterNode)), block: T.nilable(Prism::BlockParameterNode)).returns(Prism::ParametersNode) }
  def parameters_node(source: default_source, node_id: 0, location: default_location, flags: 0, requireds: [], optionals: [], rest: nil, posts: [], keywords: [], keyword_rest: nil, block: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, body: T.nilable(Prism::Node), opening_loc: Prism::Location, closing_loc: Prism::Location).returns(Prism::ParenthesesNode) }
  def parentheses_node(source: default_source, node_id: 0, location: default_location, flags: 0, body: nil, opening_loc: location, closing_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, expression: Prism::Node, operator_loc: Prism::Location, lparen_loc: Prism::Location, rparen_loc: Prism::Location).returns(Prism::PinnedExpressionNode) }
  def pinned_expression_node(source: default_source, node_id: 0, location: default_location, flags: 0, expression: default_node(source, location), operator_loc: location, lparen_loc: location, rparen_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, variable: T.any(Prism::LocalVariableReadNode, Prism::InstanceVariableReadNode, Prism::ClassVariableReadNode, Prism::GlobalVariableReadNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::ItLocalVariableReadNode, Prism::MissingNode), operator_loc: Prism::Location).returns(Prism::PinnedVariableNode) }
  def pinned_variable_node(source: default_source, node_id: 0, location: default_location, flags: 0, variable: local_variable_read_node(source: source), operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, statements: T.nilable(Prism::StatementsNode), keyword_loc: Prism::Location, opening_loc: Prism::Location, closing_loc: Prism::Location).returns(Prism::PostExecutionNode) }
  def post_execution_node(source: default_source, node_id: 0, location: default_location, flags: 0, statements: nil, keyword_loc: location, opening_loc: location, closing_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, statements: T.nilable(Prism::StatementsNode), keyword_loc: Prism::Location, opening_loc: Prism::Location, closing_loc: Prism::Location).returns(Prism::PreExecutionNode) }
  def pre_execution_node(source: default_source, node_id: 0, location: default_location, flags: 0, statements: nil, keyword_loc: location, opening_loc: location, closing_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], statements: Prism::StatementsNode).returns(Prism::ProgramNode) }
  def program_node(source: default_source, node_id: 0, location: default_location, flags: 0, locals: [], statements: statements_node(source: source)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, left: T.nilable(Prism::Node), right: T.nilable(Prism::Node), operator_loc: Prism::Location).returns(Prism::RangeNode) }
  def range_node(source: default_source, node_id: 0, location: default_location, flags: 0, left: nil, right: nil, operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, numerator: Integer, denominator: Integer).returns(Prism::RationalNode) }
  def rational_node(source: default_source, node_id: 0, location: default_location, flags: 0, numerator: 0, denominator: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::RedoNode) }
  def redo_node(source: default_source, node_id: 0, location: default_location, flags: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, content_loc: Prism::Location, closing_loc: Prism::Location, unescaped: String).returns(Prism::RegularExpressionNode) }
  def regular_expression_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: location, content_loc: location, closing_loc: location, unescaped: ""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol, name_loc: Prism::Location).returns(Prism::RequiredKeywordParameterNode) }
  def required_keyword_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :"", name_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: Symbol).returns(Prism::RequiredParameterNode) }
  def required_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: :""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, expression: Prism::Node, keyword_loc: Prism::Location, rescue_expression: Prism::Node).returns(Prism::RescueModifierNode) }
  def rescue_modifier_node(source: default_source, node_id: 0, location: default_location, flags: 0, expression: default_node(source, location), keyword_loc: location, rescue_expression: default_node(source, location)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, exceptions: T::Array[Prism::Node], operator_loc: T.nilable(Prism::Location), reference: T.nilable(T.any(Prism::LocalVariableTargetNode, Prism::InstanceVariableTargetNode, Prism::ClassVariableTargetNode, Prism::GlobalVariableTargetNode, Prism::ConstantTargetNode, Prism::ConstantPathTargetNode, Prism::CallTargetNode, Prism::IndexTargetNode, Prism::BackReferenceReadNode, Prism::NumberedReferenceReadNode, Prism::MissingNode)), then_keyword_loc: T.nilable(Prism::Location), statements: T.nilable(Prism::StatementsNode), subsequent: T.nilable(Prism::RescueNode)).returns(Prism::RescueNode) }
  def rescue_node(source: default_source, node_id: 0, location: default_location, flags: 0, keyword_loc: location, exceptions: [], operator_loc: nil, reference: nil, then_keyword_loc: nil, statements: nil, subsequent: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, name: T.nilable(Symbol), name_loc: T.nilable(Prism::Location), operator_loc: Prism::Location).returns(Prism::RestParameterNode) }
  def rest_parameter_node(source: default_source, node_id: 0, location: default_location, flags: 0, name: nil, name_loc: nil, operator_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::RetryNode) }
  def retry_node(source: default_source, node_id: 0, location: default_location, flags: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, arguments: T.nilable(Prism::ArgumentsNode)).returns(Prism::ReturnNode) }
  def return_node(source: default_source, node_id: 0, location: default_location, flags: 0, keyword_loc: location, arguments: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::SelfNode) }
  def self_node(source: default_source, node_id: 0, location: default_location, flags: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, write: T.any(Prism::ConstantWriteNode, Prism::ConstantAndWriteNode, Prism::ConstantOrWriteNode, Prism::ConstantOperatorWriteNode, Prism::ConstantPathWriteNode, Prism::ConstantPathAndWriteNode, Prism::ConstantPathOrWriteNode, Prism::ConstantPathOperatorWriteNode)).returns(Prism::ShareableConstantNode) }
  def shareable_constant_node(source: default_source, node_id: 0, location: default_location, flags: 0, write: constant_write_node(source: source)); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, locals: T::Array[Symbol], class_keyword_loc: Prism::Location, operator_loc: Prism::Location, expression: Prism::Node, body: T.nilable(T.any(Prism::StatementsNode, Prism::BeginNode)), end_keyword_loc: Prism::Location).returns(Prism::SingletonClassNode) }
  def singleton_class_node(source: default_source, node_id: 0, location: default_location, flags: 0, locals: [], class_keyword_loc: location, operator_loc: location, expression: default_node(source, location), body: nil, end_keyword_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::SourceEncodingNode) }
  def source_encoding_node(source: default_source, node_id: 0, location: default_location, flags: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, filepath: String).returns(Prism::SourceFileNode) }
  def source_file_node(source: default_source, node_id: 0, location: default_location, flags: 0, filepath: ""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::SourceLineNode) }
  def source_line_node(source: default_source, node_id: 0, location: default_location, flags: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, operator_loc: Prism::Location, expression: T.nilable(Prism::Node)).returns(Prism::SplatNode) }
  def splat_node(source: default_source, node_id: 0, location: default_location, flags: 0, operator_loc: location, expression: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, body: T::Array[Prism::Node]).returns(Prism::StatementsNode) }
  def statements_node(source: default_source, node_id: 0, location: default_location, flags: 0, body: []); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: T.nilable(Prism::Location), content_loc: Prism::Location, closing_loc: T.nilable(Prism::Location), unescaped: String).returns(Prism::StringNode) }
  def string_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: nil, content_loc: location, closing_loc: nil, unescaped: ""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, lparen_loc: T.nilable(Prism::Location), arguments: T.nilable(Prism::ArgumentsNode), rparen_loc: T.nilable(Prism::Location), block: T.nilable(T.any(Prism::BlockNode, Prism::BlockArgumentNode))).returns(Prism::SuperNode) }
  def super_node(source: default_source, node_id: 0, location: default_location, flags: 0, keyword_loc: location, lparen_loc: nil, arguments: nil, rparen_loc: nil, block: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: T.nilable(Prism::Location), value_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location), unescaped: String).returns(Prism::SymbolNode) }
  def symbol_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: nil, value_loc: nil, closing_loc: nil, unescaped: ""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer).returns(Prism::TrueNode) }
  def true_node(source: default_source, node_id: 0, location: default_location, flags: 0); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, names: T::Array[T.any(Prism::SymbolNode, Prism::InterpolatedSymbolNode)], keyword_loc: Prism::Location).returns(Prism::UndefNode) }
  def undef_node(source: default_source, node_id: 0, location: default_location, flags: 0, names: [], keyword_loc: location); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, predicate: Prism::Node, then_keyword_loc: T.nilable(Prism::Location), statements: T.nilable(Prism::StatementsNode), else_clause: T.nilable(Prism::ElseNode), end_keyword_loc: T.nilable(Prism::Location)).returns(Prism::UnlessNode) }
  def unless_node(source: default_source, node_id: 0, location: default_location, flags: 0, keyword_loc: location, predicate: default_node(source, location), then_keyword_loc: nil, statements: nil, else_clause: nil, end_keyword_loc: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, do_keyword_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location), predicate: Prism::Node, statements: T.nilable(Prism::StatementsNode)).returns(Prism::UntilNode) }
  def until_node(source: default_source, node_id: 0, location: default_location, flags: 0, keyword_loc: location, do_keyword_loc: nil, closing_loc: nil, predicate: default_node(source, location), statements: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, conditions: T::Array[Prism::Node], then_keyword_loc: T.nilable(Prism::Location), statements: T.nilable(Prism::StatementsNode)).returns(Prism::WhenNode) }
  def when_node(source: default_source, node_id: 0, location: default_location, flags: 0, keyword_loc: location, conditions: [], then_keyword_loc: nil, statements: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, do_keyword_loc: T.nilable(Prism::Location), closing_loc: T.nilable(Prism::Location), predicate: Prism::Node, statements: T.nilable(Prism::StatementsNode)).returns(Prism::WhileNode) }
  def while_node(source: default_source, node_id: 0, location: default_location, flags: 0, keyword_loc: location, do_keyword_loc: nil, closing_loc: nil, predicate: default_node(source, location), statements: nil); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, opening_loc: Prism::Location, content_loc: Prism::Location, closing_loc: Prism::Location, unescaped: String).returns(Prism::XStringNode) }
  def x_string_node(source: default_source, node_id: 0, location: default_location, flags: 0, opening_loc: location, content_loc: location, closing_loc: location, unescaped: ""); end

  sig { params(source: Prism::Source, node_id: Integer, location: Prism::Location, flags: Integer, keyword_loc: Prism::Location, lparen_loc: T.nilable(Prism::Location), arguments: T.nilable(Prism::ArgumentsNode), rparen_loc: T.nilable(Prism::Location)).returns(Prism::YieldNode) }
  def yield_node(source: default_source, node_id: 0, location: default_location, flags: 0, keyword_loc: location, lparen_loc: nil, arguments: nil, rparen_loc: nil); end

  sig { params(name: Symbol).returns(Integer) }
  def arguments_node_flag(name); end

  sig { params(name: Symbol).returns(Integer) }
  def array_node_flag(name); end

  sig { params(name: Symbol).returns(Integer) }
  def call_node_flag(name); end

  sig { params(name: Symbol).returns(Integer) }
  def encoding_flag(name); end

  sig { params(name: Symbol).returns(Integer) }
  def integer_base_flag(name); end

  sig { params(name: Symbol).returns(Integer) }
  def interpolated_string_node_flag(name); end

  sig { params(name: Symbol).returns(Integer) }
  def keyword_hash_node_flag(name); end

  sig { params(name: Symbol).returns(Integer) }
  def loop_flag(name); end

  sig { params(name: Symbol).returns(Integer) }
  def parameter_flag(name); end

  sig { params(name: Symbol).returns(Integer) }
  def parentheses_node_flag(name); end

  sig { params(name: Symbol).returns(Integer) }
  def range_flag(name); end

  sig { params(name: Symbol).returns(Integer) }
  def regular_expression_flag(name); end

  sig { params(name: Symbol).returns(Integer) }
  def shareable_constant_node_flag(name); end

  sig { params(name: Symbol).returns(Integer) }
  def string_flag(name); end

  sig { params(name: Symbol).returns(Integer) }
  def symbol_flag(name); end

  private

  sig { returns(Prism::Source) }
  def default_source; end

  sig { returns(Prism::Location) }
  def default_location; end

  sig { params(source: Prism::Source, location: Prism::Location).returns(Prism::Node) }
  def default_node(source, location); end
end
