### New features

* [#14512](https://github.com/rubocop/rubocop/pull/14512): Add `Style/ArrayIntersectWithSingleElement` cop. ([@r7kamura][])
* [#10971](https://github.com/rubocop/rubocop/issues/10971): Support `EnforcedStyleForMultiline: diff_comma` in `Style/TrailingCommaInArguments`. ([@akouryy][])

### Bug fixes

* [#14560](https://github.com/rubocop/rubocop/pull/14560): Fix an error for `Style/NilComparison` cop when using the `var.==(nil)` and `var.===(nil)` syntax. ([@viralpraxis][])
* [#14535](https://github.com/rubocop/rubocop/issues/14535): Fix autocorrect for `Style/ExplicitBlockArgument` when there are two methods that share the same implementation. ([@earlopain][])
* [#14527](https://github.com/rubocop/rubocop/pull/14527): Fix false negatives for `Style/NumberedParameters` and `Style/ItBlockParameter` when using multiline method chain with `EnforcedStyle: allow_single_line`. ([@koic][])
* [#14522](https://github.com/rubocop/rubocop/issues/14522): Fix false negatives for `Layout/MultilineOperationIndentation` when using indented code on LHS of equality operator in modifier method definition. ([@koic][])
* [#14496](https://github.com/rubocop/rubocop/issues/14496): Fix false negatives for `Layout/EmptyLineBetweenDefs` for `AllowAdjacentOneLineDefs: false` and `DefLikeMacros` that take no block. ([@earlopain][])
* [#14553](https://github.com/rubocop/rubocop/issues/14553): Fix false positives when `EnforcedStyle: allowed_in_returns` and `!!` appears across multiple lines in return position. ([@koic][])
* [#14557](https://github.com/rubocop/rubocop/issues/14557): Fix false positives for `Style/RedundantParentheses` when parentheses are used around a one-line `rescue` expression as a condition. ([@koic][])
* [#14525](https://github.com/rubocop/rubocop/pull/14525): Fix false positives for `Style/RedundantRegexpEscape` when an escaped variable sigil follows `#` (e.g., `/#\@foo/`, `/#\@@bar/`, `/#\$baz/`). ([@koic][])
* [#14529](https://github.com/rubocop/rubocop/issues/14529): Fix false negative in `Layout/RescueEnsureAlignment` with a block whose send node is split over multiple lines. ([@dvandersluis][])
* [#14528](https://github.com/rubocop/rubocop/issues/14528): Fix `Style/RedundantFormat` when the format string has a variable width that isn't given as a literal value. ([@dvandersluis][])
* [#14541](https://github.com/rubocop/rubocop/issues/14541): Fix gemspec parsing error when `ParserEngine: parser_prism` is configured in a base config file. ([@sudoremo][])
* [#14544](https://github.com/rubocop/rubocop/issues/14544): Fix an incorrect autocorrect for `Lint/Void` when using a return value in assignment method definition. ([@koic][])
* [#14543](https://github.com/rubocop/rubocop/issues/14543): Fix an incorrect autocorrect for `Style/RedundantRegexpArgument` when using escaped single quote character. ([@koic][])
* [#14540](https://github.com/rubocop/rubocop/issues/14540): Fix an incorrect autocorrect for `Style/UnlessElse` when using `unless` with `then`. ([@koic][])
* [#14507](https://github.com/rubocop/rubocop/pull/14507): Fix the built-in Ruby LSP add-on not restarting when config files (`.rubocop.yml`, `.rubocop_todo.yml`) change. ([@earlopain][])
* [#14514](https://github.com/rubocop/rubocop/pull/14514): Fix the built-in Ruby LSP add-on not respecting `.rubocop` config file. ([@earlopain][])
* [#14508](https://github.com/rubocop/rubocop/pull/14508): Fix the built-in Ruby LSP add-on getting in an irrecoverable state when the config is invalid on startup. ([@earlopain][])
* [#14534](https://github.com/rubocop/rubocop/issues/14534): Prevent `Layout/LineLength` autocorrection from splitting a block if its receiver contains a heredoc. ([@dvandersluis][])
* [#14497](https://github.com/rubocop/rubocop/pull/14497): Fix a false positive for `Lint/ShadowedArgument` when assigning inside a `rescue` block. ([@earlopain][])

### Changes

* [#14492](https://github.com/rubocop/rubocop/pull/14492): Add support for LSP `positionEncoding` `utf-8` and `utf-32`. ([@tmtm][])

[@r7kamura]: https://github.com/r7kamura
[@akouryy]: https://github.com/akouryy
[@viralpraxis]: https://github.com/viralpraxis
[@earlopain]: https://github.com/earlopain
[@koic]: https://github.com/koic
[@dvandersluis]: https://github.com/dvandersluis
[@sudoremo]: https://github.com/sudoremo
[@tmtm]: https://github.com/tmtm
