% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-linetype.R
\name{scale_linetype}
\alias{scale_linetype}
\alias{scale_linetype_binned}
\alias{scale_linetype_continuous}
\alias{scale_linetype_discrete}
\title{Scale for line patterns}
\usage{
scale_linetype(name = waiver(), ..., aesthetics = "linetype")

scale_linetype_binned(name = waiver(), ..., aesthetics = "linetype")

scale_linetype_continuous(...)

scale_linetype_discrete(name = waiver(), ..., aesthetics = "linetype")
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{...}{
  Arguments passed on to \code{\link[=discrete_scale]{discrete_scale}}
  \describe{
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} includes the levels in the factor. Please note that to display
every level in a legend, the layer should use \code{show.legend = TRUE}.}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{minor_breaks}}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (none for discrete, one minor break
between each major break for continuous)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks. Also
accepts rlang \link[rlang:as_function]{lambda} function notation. When
the function has two arguments, it will be given the limits and major
break positions.
}}
    \item{\code{labels}}{One of the options below. Please note that when \code{labels} is a
vector, it is highly recommended to also set the \code{breaks} argument as a
vector to protect against unintended mismatches.
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{guide}}{A function used to create a guide or its name. See
\code{\link[=guides]{guides()}} for more information.}
    \item{\code{call}}{The \code{call} used to construct the scale for reporting messages.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{aesthetics}{The names of the aesthetics that this scale works with.}
}
\description{
Default line types based on a set supplied by Richard Pearson,
University of Manchester. Continuous values can not be mapped to
line types unless \code{scale_linetype_binned()} is used. Still, as linetypes has
no inherent order, this use is not advised.
}
\details{
Lines can be referred to by number, name or hex code. Contrary to base R
graphics, \code{NA}s are interpreted as blanks.

\if{html}{\figure{linetype_table.svg}{Named linetypes by number and name}}
\if{latex}{\figure{linetype_table.pdf}}
}
\examples{
base <- ggplot(economics_long, aes(date, value01))
base + geom_line(aes(group = variable))
base + geom_line(aes(linetype = variable))

# See scale_manual for more flexibility

# Common line types ----------------------------
df_lines <- data.frame(
  linetype = factor(
    1:4,
    labels = c("solid", "longdash", "dashed", "dotted")
  )
)
ggplot(df_lines) +
  geom_hline(aes(linetype = linetype, yintercept = 0), linewidth = 2) +
  scale_linetype_identity() +
  facet_grid(linetype ~ .) +
  theme_void(20)
}
\seealso{
The documentation for \link[=aes_linetype_size_shape]{differentiation related aesthetics}.

Other linetype scales: \code{\link[=scale_linetype_manual]{scale_linetype_manual()}}, \code{\link[=scale_linetype_identity]{scale_linetype_identity()}}.

The \href{https://ggplot2-book.org/scales-other#sec-scale-linetype}{line type section} of the online ggplot2 book.
}
