/********************************************************************************/
/*										*/
/*			   TSS Transmit		   				*/
/*			     Written by Ken Goldman				*/
/*		       IBM Thomas J. Watson Research Center			*/
/*	      $Id: tsstransmit.h 1257 2018-06-27 20:52:08Z kgoldman $		*/
/*										*/
/* (c) Copyright IBM Corporation 2015, 2017, 2018				*/
/*										*/
/* All rights reserved.								*/
/* 										*/
/* Redistribution and use in source and binary forms, with or without		*/
/* modification, are permitted provided that the following conditions are	*/
/* met:										*/
/* 										*/
/* Redistributions of source code must retain the above copyright notice,	*/
/* this list of conditions and the following disclaimer.			*/
/* 										*/
/* Redistributions in binary form must reproduce the above copyright		*/
/* notice, this list of conditions and the following disclaimer in the		*/
/* documentation and/or other materials provided with the distribution.		*/
/* 										*/
/* Neither the names of the IBM Corporation nor the names of its		*/
/* contributors may be used to endorse or promote products derived from		*/
/* this software without specific prior written permission.			*/
/* 										*/
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS		*/
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT		*/
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR	*/
/* A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT		*/
/* HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,	*/
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT		*/
/* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,	*/
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY	*/
/* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT		*/
/* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE	*/
/* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.		*/
/********************************************************************************/

#ifndef TSSTRANSMIT_H
#define TSSTRANSMIT_H

#include <stdint.h>

#include <ibmtss/tss.h>

/* copy of TpmTcpProtocol.h.  These are only used with the SW TPM. */
#define TPM_SIGNAL_POWER_ON         1
#define TPM_SIGNAL_POWER_OFF        2
#define TPM_SIGNAL_NV_ON            11

/* copy of TpmTcpProtocol.h.  These are only used with the SW TPM, but they may be used with a
   resource manager in the future. */
#define TPM_SEND_COMMAND            8
#define TPM_SESSION_END             20
#define TPM_STOP                    21

#ifdef __cplusplus
extern "C" {
#endif
    LIB_EXPORT TPM_RC
    TSS_TransmitPlatform(TSS_CONTEXT *tssContext,
			 uint32_t command, const char *message);
    LIB_EXPORT TPM_RC
    TSS_TransmitCommand(TSS_CONTEXT *tssContext,
			uint32_t command, const char *message);
    LIB_EXPORT TPM_RC
    TSS_Transmit(TSS_CONTEXT *tssContext,
		 uint8_t *responseBuffer, uint32_t *read,
		 const uint8_t *commandBuffer, uint32_t written,
		 const char *message);

    LIB_EXPORT TPM_RC
    TSS_Close(TSS_CONTEXT *tssContext);

#ifdef __cplusplus
}
#endif

#endif
