# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class ActivationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The activation state of the WAF. Use 'Enabled' to enable the WAF and 'Disabled' to disable it."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class IdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identity Type."""

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"


class Level(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Warning or Info."""

    INFO = "Info"
    WARNING = "Warning"


class NginxDeploymentWafPolicyApplyingStatusCode(  # pylint: disable=name-too-long
    str, Enum, metaclass=CaseInsensitiveEnumMeta
):
    """Machine readable code indicating the applying status code of a WAF Policy."""

    NOT_APPLIED = "NotApplied"
    """The policy is not referenced in the nginx config and not applied."""
    APPLYING = "Applying"
    """The policy is referenced in the nginx config and is applying."""
    SUCCEEDED = "Succeeded"
    """The policy is referenced in the nginx config and that config has been successfully applied."""
    FAILED = "Failed"
    """The policy is referenced in the nginx config and that config failed to apply."""
    REMOVING = "Removing"
    """The policy is now not referenced in the nginx config and its being removed from the applied
    nginx config."""


class NginxDeploymentWafPolicyCompilingStatusCode(  # pylint: disable=name-too-long
    str, Enum, metaclass=CaseInsensitiveEnumMeta
):
    """Machine readable code indicating the compilation status of a WAF Policy."""

    NOT_STARTED = "NotStarted"
    """The compilation of the custom waf policy has not started"""
    IN_PROGRESS = "InProgress"
    """The compilation of the custom waf policy is in progress"""
    SUCCEEDED = "Succeeded"
    """The compilation of the custom waf policy is completed successfully and can now be referenced in
    the nginx config."""
    FAILED = "Failed"
    """The compilation of the custom waf policy failed."""


class NginxPrivateIPAllocationMethod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Nginx Private IP Allocation Method."""

    STATIC = "Static"
    DYNAMIC = "Dynamic"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning State."""

    ACCEPTED = "Accepted"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETED = "Deleted"
    NOT_SPECIFIED = "NotSpecified"
