# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.edgeactions import EdgeActionsMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-edgeactions
# USAGE
    python edge_action_execution_filters_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = EdgeActionsMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.edge_action_execution_filters.begin_create(
        resource_group_name="testrg",
        edge_action_name="edgeAction1",
        execution_filter="executionFilter1",
        resource={
            "location": "global",
            "properties": {
                "executionFilterIdentifierHeaderName": "header-key",
                "executionFilterIdentifierHeaderValue": "header-value",
                "versionId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/testrg/providers/Microsoft.Cdn/EdgeActions/edgeAction1/versions/version1",
            },
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-12-01-preview/EdgeActionExecutionFilters_Create.json
if __name__ == "__main__":
    main()
