# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.computebulkactions import ComputeBulkActionsMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-computebulkactions
# USAGE
    python bulk_actions_virtual_machines_get_operation_status_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ComputeBulkActionsMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.bulk_actions.virtual_machines_get_operation_status(
        location="eastus2euap",
        request_body={
            "correlationid": "4431320c-7a90-4300-b82b-73f0696ae50e",
            "operationIds": ["2a3fce8e-874c-45f4-9d27-1a804f3b7a0f"],
        },
    )
    print(response)


# x-ms-original-file: 2026-02-01-preview/BulkActions_VirtualMachinesGetOperationStatus_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
