# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AuthenticationTokenSettings(_Model):
    """The settings for an authentication token that the Task can use to perform Batch
    service operations.

    :ivar access: The Batch resources to which the token grants access. The authentication token
     grants access to a limited set of Batch service operations. Currently the only supported value
     for the access property is 'job', which grants access to all operations related to the Job
     which contains the Task.
    :vartype access: list[str or ~azure.batch.models.BatchAccessScope]
    """

    access: Optional[list[Union[str, "_models.BatchAccessScope"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The Batch resources to which the token grants access. The authentication token grants access to
     a limited set of Batch service operations. Currently the only supported value for the access
     property is 'job', which grants access to all operations related to the Job which contains the
     Task."""

    @overload
    def __init__(
        self,
        *,
        access: Optional[list[Union[str, "_models.BatchAccessScope"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutomaticOsUpgradePolicy(_Model):
    """The configuration parameters used for performing automatic OS upgrade.

    :ivar disable_automatic_rollback: Whether OS image rollback feature should be disabled.
    :vartype disable_automatic_rollback: bool
    :ivar enable_automatic_os_upgrade: Indicates whether OS upgrades should automatically be
     applied to scale set instances in a rolling fashion when a newer version of the OS image
     becomes available. <br /><br /> If this is set to true for Windows based pools,
     `WindowsConfiguration.enableAutomaticUpdates
     <https://learn.microsoft.com/rest/api/batchservice/pool/add?tabs=HTTP#windowsconfiguration>`_
     cannot be set to true.
    :vartype enable_automatic_os_upgrade: bool
    :ivar use_rolling_upgrade_policy: Indicates whether rolling upgrade policy should be used
     during Auto OS Upgrade. Auto OS Upgrade will fallback to the default policy if no policy is
     defined on the VMSS.
    :vartype use_rolling_upgrade_policy: bool
    :ivar os_rolling_upgrade_deferral: Defer OS upgrades on the TVMs if they are running tasks.
    :vartype os_rolling_upgrade_deferral: bool
    """

    disable_automatic_rollback: Optional[bool] = rest_field(
        name="disableAutomaticRollback", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether OS image rollback feature should be disabled."""
    enable_automatic_os_upgrade: Optional[bool] = rest_field(
        name="enableAutomaticOSUpgrade", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether OS upgrades should automatically be applied to scale set instances in a
     rolling fashion when a newer version of the OS image becomes available. <br /><br /> If this is
     set to true for Windows based pools, `WindowsConfiguration.enableAutomaticUpdates
     <https://learn.microsoft.com/rest/api/batchservice/pool/add?tabs=HTTP#windowsconfiguration>`_
     cannot be set to true."""
    use_rolling_upgrade_policy: Optional[bool] = rest_field(
        name="useRollingUpgradePolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether rolling upgrade policy should be used during Auto OS Upgrade. Auto OS Upgrade
     will fallback to the default policy if no policy is defined on the VMSS."""
    os_rolling_upgrade_deferral: Optional[bool] = rest_field(
        name="osRollingUpgradeDeferral", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defer OS upgrades on the TVMs if they are running tasks."""

    @overload
    def __init__(
        self,
        *,
        disable_automatic_rollback: Optional[bool] = None,
        enable_automatic_os_upgrade: Optional[bool] = None,
        use_rolling_upgrade_policy: Optional[bool] = None,
        os_rolling_upgrade_deferral: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutoScaleRun(_Model):
    """The results and errors from an execution of a Pool autoscale formula.

    :ivar timestamp: The time at which the autoscale formula was last evaluated. Required.
    :vartype timestamp: ~datetime.datetime
    :ivar results: The final values of all variables used in the evaluation of the autoscale
     formula. Each variable value is returned in the form $variable=value, and variables are
     separated by semicolons.
    :vartype results: str
    :ivar error: Details of the error encountered evaluating the autoscale formula on the Pool, if
     the evaluation was unsuccessful.
    :vartype error: ~azure.batch.models.AutoScaleRunError
    """

    timestamp: datetime.datetime = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the autoscale formula was last evaluated. Required."""
    results: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The final values of all variables used in the evaluation of the autoscale formula. Each
     variable value is returned in the form $variable=value, and variables are separated by
     semicolons."""
    error: Optional["_models.AutoScaleRunError"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Details of the error encountered evaluating the autoscale formula on the Pool, if the
     evaluation was unsuccessful."""

    @overload
    def __init__(
        self,
        *,
        timestamp: datetime.datetime,
        results: Optional[str] = None,
        error: Optional["_models.AutoScaleRunError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutoScaleRunError(_Model):
    """An error that occurred when executing or evaluating a Pool autoscale formula.

    :ivar code: An identifier for the autoscale error. Codes are invariant and are intended to be
     consumed programmatically.
    :vartype code: str
    :ivar message: A message describing the autoscale error, intended to be suitable for display in
     a user interface.
    :vartype message: str
    :ivar values_property: A list of additional error details related to the autoscale error.
    :vartype values_property: list[~azure.batch.models.NameValuePair]
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An identifier for the autoscale error. Codes are invariant and are intended to be consumed
     programmatically."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A message describing the autoscale error, intended to be suitable for display in a user
     interface."""
    values_property: Optional[list["_models.NameValuePair"]] = rest_field(
        name="values", visibility=["read", "create", "update", "delete", "query"], original_tsp_name="values"
    )
    """A list of additional error details related to the autoscale error."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        values_property: Optional[list["_models.NameValuePair"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AutoUserSpecification(_Model):
    """Specifies the options for the auto user that runs an Azure Batch Task.

    :ivar scope: The scope for the auto user. The default value is pool. If the pool is running
     Windows a value of Task should be specified if stricter isolation between tasks is required.
     For example, if the task mutates the registry in a way which could impact other tasks. Known
     values are: "task" and "pool".
    :vartype scope: str or ~azure.batch.models.AutoUserScope
    :ivar elevation_level: The elevation level of the auto user. The default value is nonAdmin.
     Known values are: "nonadmin" and "admin".
    :vartype elevation_level: str or ~azure.batch.models.ElevationLevel
    """

    scope: Optional[Union[str, "_models.AutoUserScope"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The scope for the auto user. The default value is pool. If the pool is running Windows a value
     of Task should be specified if stricter isolation between tasks is required. For example, if
     the task mutates the registry in a way which could impact other tasks. Known values are:
     \"task\" and \"pool\"."""
    elevation_level: Optional[Union[str, "_models.ElevationLevel"]] = rest_field(
        name="elevationLevel", visibility=["read", "create", "update", "delete", "query"]
    )
    """The elevation level of the auto user. The default value is nonAdmin. Known values are:
     \"nonadmin\" and \"admin\"."""

    @overload
    def __init__(
        self,
        *,
        scope: Optional[Union[str, "_models.AutoUserScope"]] = None,
        elevation_level: Optional[Union[str, "_models.ElevationLevel"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureBlobFileSystemConfiguration(_Model):
    """Information used to connect to an Azure Storage Container using Blobfuse.

    :ivar account_name: The Azure Storage Account name. Required.
    :vartype account_name: str
    :ivar container_name: The Azure Blob Storage Container name. Required.
    :vartype container_name: str
    :ivar account_key: The Azure Storage Account key. This property is mutually exclusive with both
     sasKey and identity; exactly one must be specified.
    :vartype account_key: str
    :ivar sas_key: The Azure Storage SAS token. This property is mutually exclusive with both
     accountKey and identity; exactly one must be specified.
    :vartype sas_key: str
    :ivar blobfuse_options: Additional command line options to pass to the mount command. These are
     'net use' options in Windows and 'mount' options in Linux.
    :vartype blobfuse_options: str
    :ivar relative_mount_path: The relative path on the compute node where the file system will be
     mounted. All file systems are mounted relative to the Batch mounts directory, accessible via
     the AZ_BATCH_NODE_MOUNTS_DIR environment variable. Required.
    :vartype relative_mount_path: str
    :ivar identity_reference: The reference to the user assigned identity to use to access
     containerName. This property is mutually exclusive with both accountKey and sasKey; exactly one
     must be specified.
    :vartype identity_reference: ~azure.batch.models.BatchNodeIdentityReference
    """

    account_name: str = rest_field(name="accountName", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Storage Account name. Required."""
    container_name: str = rest_field(name="containerName", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Blob Storage Container name. Required."""
    account_key: Optional[str] = rest_field(
        name="accountKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Azure Storage Account key. This property is mutually exclusive with both sasKey and
     identity; exactly one must be specified."""
    sas_key: Optional[str] = rest_field(name="sasKey", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Storage SAS token. This property is mutually exclusive with both accountKey and
     identity; exactly one must be specified."""
    blobfuse_options: Optional[str] = rest_field(
        name="blobfuseOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional command line options to pass to the mount command. These are 'net use' options in
     Windows and 'mount' options in Linux."""
    relative_mount_path: str = rest_field(
        name="relativeMountPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The relative path on the compute node where the file system will be mounted. All file systems
     are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR
     environment variable. Required."""
    identity_reference: Optional["_models.BatchNodeIdentityReference"] = rest_field(
        name="identityReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference to the user assigned identity to use to access containerName. This property is
     mutually exclusive with both accountKey and sasKey; exactly one must be specified."""

    @overload
    def __init__(
        self,
        *,
        account_name: str,
        container_name: str,
        relative_mount_path: str,
        account_key: Optional[str] = None,
        sas_key: Optional[str] = None,
        blobfuse_options: Optional[str] = None,
        identity_reference: Optional["_models.BatchNodeIdentityReference"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureFileShareConfiguration(_Model):
    """Information used to connect to an Azure Fileshare.

    :ivar account_name: The Azure Storage account name. Required.
    :vartype account_name: str
    :ivar account_key: The Azure Storage account key. Required.
    :vartype account_key: str
    :ivar azure_file_url: The Azure Files URL. This is of the form
     'https://{account}.file.core.windows.net/'. Required.
    :vartype azure_file_url: str
    :ivar relative_mount_path: The relative path on the compute node where the file system will be
     mounted. All file systems are mounted relative to the Batch mounts directory, accessible via
     the AZ_BATCH_NODE_MOUNTS_DIR environment variable. Required.
    :vartype relative_mount_path: str
    :ivar mount_options: Additional command line options to pass to the mount command. These are
     'net use' options in Windows and 'mount' options in Linux.
    :vartype mount_options: str
    """

    account_name: str = rest_field(name="accountName", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Storage account name. Required."""
    account_key: str = rest_field(name="accountKey", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Storage account key. Required."""
    azure_file_url: str = rest_field(name="azureFileUrl", visibility=["read", "create", "update", "delete", "query"])
    """The Azure Files URL. This is of the form 'https://{account}.file.core.windows.net/'. Required."""
    relative_mount_path: str = rest_field(
        name="relativeMountPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The relative path on the compute node where the file system will be mounted. All file systems
     are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR
     environment variable. Required."""
    mount_options: Optional[str] = rest_field(
        name="mountOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional command line options to pass to the mount command. These are 'net use' options in
     Windows and 'mount' options in Linux."""

    @overload
    def __init__(
        self,
        *,
        account_name: str,
        account_key: str,
        azure_file_url: str,
        relative_mount_path: str,
        mount_options: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchAffinityInfo(_Model):
    """A locality hint that can be used by the Batch service to select a Compute Node
    on which to start a Task.

    :ivar affinity_id: An opaque string representing the location of a Compute Node or a Task that
     has run previously. You can pass the affinityId of a Node to indicate that this Task needs to
     run on that Compute Node. Note that this is just a soft affinity. If the target Compute Node is
     busy or unavailable at the time the Task is scheduled, then the Task will be scheduled
     elsewhere. Required.
    :vartype affinity_id: str
    """

    affinity_id: str = rest_field(name="affinityId", visibility=["read", "create", "update", "delete", "query"])
    """An opaque string representing the location of a Compute Node or a Task that has run previously.
     You can pass the affinityId of a Node to indicate that this Task needs to run on that Compute
     Node. Note that this is just a soft affinity. If the target Compute Node is busy or unavailable
     at the time the Task is scheduled, then the Task will be scheduled elsewhere. Required."""

    @overload
    def __init__(
        self,
        *,
        affinity_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchApplication(_Model):
    """Contains information about an application in an Azure Batch Account.

    :ivar id: A string that uniquely identifies the application within the Account. Required.
    :vartype id: str
    :ivar display_name: The display name for the application. Required.
    :vartype display_name: str
    :ivar versions: The list of available versions of the application. Required.
    :vartype versions: list[str]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A string that uniquely identifies the application within the Account. Required."""
    display_name: str = rest_field(name="displayName", visibility=["read", "create", "update", "delete", "query"])
    """The display name for the application. Required."""
    versions: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The list of available versions of the application. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        display_name: str,
        versions: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchApplicationPackageReference(_Model):
    """A reference to an Package to be deployed to Compute Nodes.

    :ivar application_id: The ID of the application to deploy. When creating a pool, the package's
     application ID must be fully qualified
     (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
     Required.
    :vartype application_id: str
    :ivar version: The version of the application to deploy. If omitted, the default version is
     deployed. If this is omitted on a Pool, and no default version is specified for this
     application, the request fails with the error code InvalidApplicationPackageReferences and HTTP
     status code 409. If this is omitted on a Task, and no default version is specified for this
     application, the Task fails with a pre-processing error.
    :vartype version: str
    """

    application_id: str = rest_field(name="applicationId", visibility=["read", "create", "update", "delete", "query"])
    """The ID of the application to deploy. When creating a pool, the package's application ID must be
     fully qualified
     (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
     Required."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version of the application to deploy. If omitted, the default version is deployed. If this
     is omitted on a Pool, and no default version is specified for this application, the request
     fails with the error code InvalidApplicationPackageReferences and HTTP status code 409. If this
     is omitted on a Task, and no default version is specified for this application, the Task fails
     with a pre-processing error."""

    @overload
    def __init__(
        self,
        *,
        application_id: str,
        version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchAutoPoolSpecification(_Model):
    """Specifies characteristics for a temporary 'auto pool'. The Batch service will
    create this auto Pool when the Job is submitted.

    :ivar auto_pool_id_prefix: A prefix to be added to the unique identifier when a Pool is
     automatically created. The Batch service assigns each auto Pool a unique identifier on
     creation. To distinguish between Pools created for different purposes, you can specify this
     element to add a prefix to the ID that is assigned. The prefix can be up to 20 characters long.
    :vartype auto_pool_id_prefix: str
    :ivar pool_lifetime_option: The minimum lifetime of created auto Pools, and how multiple Jobs
     on a schedule are assigned to Pools. Required. Known values are: "jobschedule" and "job".
    :vartype pool_lifetime_option: str or ~azure.batch.models.BatchPoolLifetimeOption
    :ivar keep_alive: Whether to keep an auto Pool alive after its lifetime expires. If false, the
     Batch service deletes the Pool once its lifetime (as determined by the poolLifetimeOption
     setting) expires; that is, when the Job or Job Schedule completes. If true, the Batch service
     does not delete the Pool automatically. It is up to the user to delete auto Pools created with
     this option.
    :vartype keep_alive: bool
    :ivar pool: The Pool specification for the auto Pool.
    :vartype pool: ~azure.batch.models.BatchPoolSpecification
    """

    auto_pool_id_prefix: Optional[str] = rest_field(
        name="autoPoolIdPrefix", visibility=["read", "create", "update", "delete", "query"]
    )
    """A prefix to be added to the unique identifier when a Pool is automatically created. The Batch
     service assigns each auto Pool a unique identifier on creation. To distinguish between Pools
     created for different purposes, you can specify this element to add a prefix to the ID that is
     assigned. The prefix can be up to 20 characters long."""
    pool_lifetime_option: Union[str, "_models.BatchPoolLifetimeOption"] = rest_field(
        name="poolLifetimeOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """The minimum lifetime of created auto Pools, and how multiple Jobs on a schedule are assigned to
     Pools. Required. Known values are: \"jobschedule\" and \"job\"."""
    keep_alive: Optional[bool] = rest_field(
        name="keepAlive", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether to keep an auto Pool alive after its lifetime expires. If false, the Batch service
     deletes the Pool once its lifetime (as determined by the poolLifetimeOption setting) expires;
     that is, when the Job or Job Schedule completes. If true, the Batch service does not delete the
     Pool automatically. It is up to the user to delete auto Pools created with this option."""
    pool: Optional["_models.BatchPoolSpecification"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The Pool specification for the auto Pool."""

    @overload
    def __init__(
        self,
        *,
        pool_lifetime_option: Union[str, "_models.BatchPoolLifetimeOption"],
        auto_pool_id_prefix: Optional[str] = None,
        keep_alive: Optional[bool] = None,
        pool: Optional["_models.BatchPoolSpecification"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchContainerConfiguration(_Model):
    """The configuration for container-enabled Pools.

    :ivar type: The container technology to be used. Required. Known values are: "dockerCompatible"
     and "criCompatible".
    :vartype type: str or ~azure.batch.models.ContainerType
    :ivar container_image_names: The collection of container Image names. This is the full Image
     reference, as would be specified to "docker pull". An Image will be sourced from the default
     Docker registry unless the Image is fully qualified with an alternative registry.
    :vartype container_image_names: list[str]
    :ivar container_registries: Additional private registries from which containers can be pulled.
     If any Images must be downloaded from a private registry which requires credentials, then those
     credentials must be provided here.
    :vartype container_registries: list[~azure.batch.models.ContainerRegistryReference]
    """

    type: Union[str, "_models.ContainerType"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The container technology to be used. Required. Known values are: \"dockerCompatible\" and
     \"criCompatible\"."""
    container_image_names: Optional[list[str]] = rest_field(
        name="containerImageNames", visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of container Image names. This is the full Image reference, as would be
     specified to \"docker pull\". An Image will be sourced from the default Docker registry unless
     the Image is fully qualified with an alternative registry."""
    container_registries: Optional[list["_models.ContainerRegistryReference"]] = rest_field(
        name="containerRegistries", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional private registries from which containers can be pulled. If any Images must be
     downloaded from a private registry which requires credentials, then those credentials must be
     provided here."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ContainerType"],
        container_image_names: Optional[list[str]] = None,
        container_registries: Optional[list["_models.ContainerRegistryReference"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchCreateTaskCollectionResult(_Model):
    """The result of creating a collection of Tasks to a Job.

    :ivar values_property: The results of the create Task collection operation.
    :vartype values_property: list[~azure.batch.models.BatchTaskCreateResult]
    """

    values_property: Optional[list["_models.BatchTaskCreateResult"]] = rest_field(
        name="value", visibility=["read", "create", "update", "delete", "query"], original_tsp_name="values"
    )
    """The results of the create Task collection operation."""

    @overload
    def __init__(
        self,
        *,
        values_property: Optional[list["_models.BatchTaskCreateResult"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchDiffDiskSettings(_Model):
    """Specifies the ephemeral Disk Settings for the operating system disk used by the
    compute node (VM).

    :ivar placement: Specifies the ephemeral disk placement for operating system disk for all VMs
     in the pool. This property can be used by user in the request to choose the location e.g.,
     cache disk space for Ephemeral OS disk provisioning. For more information on Ephemeral OS disk
     size requirements, please refer to Ephemeral OS disk size requirements for Windows VMs at
     `https://learn.microsoft.com/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements
     <https://learn.microsoft.com/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements>`_
     and Linux VMs at
     `https://learn.microsoft.com/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements
     <https://learn.microsoft.com/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements>`_.
     "cachedisk"
    :vartype placement: str or ~azure.batch.models.DiffDiskPlacement
    """

    placement: Optional[Union[str, "_models.DiffDiskPlacement"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the ephemeral disk placement for operating system disk for all VMs in the pool. This
     property can be used by user in the request to choose the location e.g., cache disk space for
     Ephemeral OS disk provisioning. For more information on Ephemeral OS disk size requirements,
     please refer to Ephemeral OS disk size requirements for Windows VMs at
     `https://learn.microsoft.com/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements
     <https://learn.microsoft.com/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements>`_
     and Linux VMs at
     `https://learn.microsoft.com/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements
     <https://learn.microsoft.com/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements>`_.
     \"cachedisk\""""

    @overload
    def __init__(
        self,
        *,
        placement: Optional[Union[str, "_models.DiffDiskPlacement"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchError(_Model):
    """An error response received from the Azure Batch service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: ~azure.batch.models.BatchErrorMessage
    :ivar values_property: A collection of key-value pairs containing additional details about the
     error.
    :vartype values_property: list[~azure.batch.models.BatchErrorDetail]
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically."""
    message: Optional["_models.BatchErrorMessage"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A message describing the error, intended to be suitable for display in a user interface."""
    values_property: Optional[list["_models.BatchErrorDetail"]] = rest_field(
        name="values", visibility=["read", "create", "update", "delete", "query"], original_tsp_name="values"
    )
    """A collection of key-value pairs containing additional details about the error."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional["_models.BatchErrorMessage"] = None,
        values_property: Optional[list["_models.BatchErrorDetail"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchErrorDetail(_Model):
    """An item of additional information included in an Azure Batch error response.

    :ivar key: An identifier specifying the meaning of the Value property.
    :vartype key: str
    :ivar value: The additional information included with the error response.
    :vartype value: str
    """

    key: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An identifier specifying the meaning of the Value property."""
    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The additional information included with the error response."""

    @overload
    def __init__(
        self,
        *,
        key: Optional[str] = None,
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchErrorMessage(_Model):
    """An error message received in an Azure Batch error response.

    :ivar lang: The language code of the error message.
    :vartype lang: str
    :ivar value: The text of the message.
    :vartype value: str
    """

    lang: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The language code of the error message."""
    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text of the message."""

    @overload
    def __init__(
        self,
        *,
        lang: Optional[str] = None,
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchInboundNatPool(_Model):
    """A inbound NAT Pool that can be used to address specific ports on Compute Nodes
    in a Batch Pool externally.

    :ivar name: The name of the endpoint. The name must be unique within a Batch Pool, can contain
     letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number,
     must end with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid
     values are provided the request fails with HTTP status code 400. Required.
    :vartype name: str
    :ivar protocol: The protocol of the endpoint. Required. Known values are: "tcp" and "udp".
    :vartype protocol: str or ~azure.batch.models.InboundEndpointProtocol
    :ivar backend_port: The port number on the Compute Node. This must be unique within a Batch
     Pool. Acceptable values are between 1 and 65535 except for 29876 and 29877 as these are
     reserved. If any reserved values are provided the request fails with HTTP status code 400.
     Required.
    :vartype backend_port: int
    :ivar frontend_port_range_start: The first port number in the range of external ports that will
     be used to provide inbound access to the backendPort on individual Compute Nodes. Acceptable
     values range between 1 and 65534 except ports from 50000 to 55000 which are reserved. All
     ranges within a Pool must be distinct and cannot overlap. Each range must contain at least 40
     ports. If any reserved or overlapping values are provided the request fails with HTTP status
     code 400. Required.
    :vartype frontend_port_range_start: int
    :ivar frontend_port_range_end: The last port number in the range of external ports that will be
     used to provide inbound access to the backendPort on individual Compute Nodes. Acceptable
     values range between 1 and 65534 except ports from 50000 to 55000 which are reserved by the
     Batch service. All ranges within a Pool must be distinct and cannot overlap. Each range must
     contain at least 40 ports. If any reserved or overlapping values are provided the request fails
     with HTTP status code 400. Required.
    :vartype frontend_port_range_end: int
    :ivar network_security_group_rules: A list of network security group rules that will be applied
     to the endpoint. The maximum number of rules that can be specified across all the endpoints on
     a Batch Pool is 25. If no network security group rules are specified, a default rule will be
     created to allow inbound access to the specified backendPort. If the maximum number of network
     security group rules is exceeded the request fails with HTTP status code 400.
    :vartype network_security_group_rules: list[~azure.batch.models.NetworkSecurityGroupRule]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the endpoint. The name must be unique within a Batch Pool, can contain letters,
     numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end
     with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values
     are provided the request fails with HTTP status code 400. Required."""
    protocol: Union[str, "_models.InboundEndpointProtocol"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The protocol of the endpoint. Required. Known values are: \"tcp\" and \"udp\"."""
    backend_port: int = rest_field(name="backendPort", visibility=["read", "create", "update", "delete", "query"])
    """The port number on the Compute Node. This must be unique within a Batch Pool. Acceptable values
     are between 1 and 65535 except for 29876 and 29877 as these are reserved. If any reserved
     values are provided the request fails with HTTP status code 400. Required."""
    frontend_port_range_start: int = rest_field(
        name="frontendPortRangeStart", visibility=["read", "create", "update", "delete", "query"]
    )
    """The first port number in the range of external ports that will be used to provide inbound
     access to the backendPort on individual Compute Nodes. Acceptable values range between 1 and
     65534 except ports from 50000 to 55000 which are reserved. All ranges within a Pool must be
     distinct and cannot overlap. Each range must contain at least 40 ports. If any reserved or
     overlapping values are provided the request fails with HTTP status code 400. Required."""
    frontend_port_range_end: int = rest_field(
        name="frontendPortRangeEnd", visibility=["read", "create", "update", "delete", "query"]
    )
    """The last port number in the range of external ports that will be used to provide inbound access
     to the backendPort on individual Compute Nodes. Acceptable values range between 1 and 65534
     except ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a
     Pool must be distinct and cannot overlap. Each range must contain at least 40 ports. If any
     reserved or overlapping values are provided the request fails with HTTP status code 400.
     Required."""
    network_security_group_rules: Optional[list["_models.NetworkSecurityGroupRule"]] = rest_field(
        name="networkSecurityGroupRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of network security group rules that will be applied to the endpoint. The maximum number
     of rules that can be specified across all the endpoints on a Batch Pool is 25. If no network
     security group rules are specified, a default rule will be created to allow inbound access to
     the specified backendPort. If the maximum number of network security group rules is exceeded
     the request fails with HTTP status code 400."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        protocol: Union[str, "_models.InboundEndpointProtocol"],
        backend_port: int,
        frontend_port_range_start: int,
        frontend_port_range_end: int,
        network_security_group_rules: Optional[list["_models.NetworkSecurityGroupRule"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJob(_Model):
    """An Azure Batch Job.

    :ivar id: A string that uniquely identifies the Job within the Account. The ID is
     case-preserving and case-insensitive (that is, you may not have two IDs within an Account that
     differ only by case). Required.
    :vartype id: str
    :ivar display_name: The display name for the Job.
    :vartype display_name: str
    :ivar uses_task_dependencies: Whether Tasks in the Job can define dependencies on each other.
     The default is false.
    :vartype uses_task_dependencies: bool
    :ivar url: The URL of the Job. Required.
    :vartype url: str
    :ivar e_tag: The ETag of the Job. This is an opaque string. You can use it to detect whether
     the Job has changed between requests. In particular, you can be pass the ETag when updating a
     Job to specify that your changes should take effect only if nobody else has modified the Job in
     the meantime. Required.
    :vartype e_tag: str
    :ivar last_modified: The last modified time of the Job. This is the last time at which the Job
     level data, such as the Job state or priority, changed. It does not factor in task-level
     changes such as adding new Tasks or Tasks changing state. Required.
    :vartype last_modified: ~datetime.datetime
    :ivar creation_time: The creation time of the Job. Required.
    :vartype creation_time: ~datetime.datetime
    :ivar state: The current state of the Job. Required. Known values are: "active", "disabling",
     "disabled", "enabling", "terminating", "completed", and "deleting".
    :vartype state: str or ~azure.batch.models.BatchJobState
    :ivar state_transition_time: The time at which the Job entered its current state. Required.
    :vartype state_transition_time: ~datetime.datetime
    :ivar previous_state: The previous state of the Job. This property is not set if the Job is in
     its initial Active state. Known values are: "active", "disabling", "disabled", "enabling",
     "terminating", "completed", and "deleting".
    :vartype previous_state: str or ~azure.batch.models.BatchJobState
    :ivar previous_state_transition_time: The time at which the Job entered its previous state.
     This property is not set if the Job is in its initial Active state.
    :vartype previous_state_transition_time: ~datetime.datetime
    :ivar priority: The priority of the Job. Priority values can range from -1000 to 1000, with
     -1000 being the lowest priority and 1000 being the highest priority. The default value is 0.
    :vartype priority: int
    :ivar allow_task_preemption: Whether Tasks in this job can be preempted by other high priority
     jobs. (This property is not available by default. Please contact support for more information)
     If the value is set to True, other high priority jobs submitted to the system will take
     precedence and will be able requeue tasks from this job. You can update a job's
     allowTaskPreemption after it has been created using the update job API.
    :vartype allow_task_preemption: bool
    :ivar max_parallel_tasks: The maximum number of tasks that can be executed in parallel for the
     job. (This property is not available by default. Please contact support for more information)
     The value of maxParallelTasks must be -1 or greater than 0 if specified. If not specified, the
     default value is -1, which means there's no limit to the number of tasks that can be run at
     once. You can update a job's maxParallelTasks after it has been created using the update job
     API.
    :vartype max_parallel_tasks: int
    :ivar constraints: The execution constraints for the Job.
    :vartype constraints: ~azure.batch.models.BatchJobConstraints
    :ivar job_manager_task: Details of a Job Manager Task to be launched when the Job is started.
    :vartype job_manager_task: ~azure.batch.models.BatchJobManagerTask
    :ivar job_preparation_task: The Job Preparation Task. The Job Preparation Task is a special
     Task run on each Compute Node before any other Task of the Job.
    :vartype job_preparation_task: ~azure.batch.models.BatchJobPreparationTask
    :ivar job_release_task: The Job Release Task. The Job Release Task is a special Task run at the
     end of the Job on each Compute Node that has run any other Task of the Job.
    :vartype job_release_task: ~azure.batch.models.BatchJobReleaseTask
    :ivar common_environment_settings: The list of common environment variable settings. These
     environment variables are set for all Tasks in the Job (including the Job Manager, Job
     Preparation and Job Release Tasks). Individual Tasks can override an environment setting
     specified here by specifying the same setting name with a different value.
    :vartype common_environment_settings: list[~azure.batch.models.EnvironmentSetting]
    :ivar pool_info: The Pool settings associated with the Job. Required.
    :vartype pool_info: ~azure.batch.models.BatchPoolInfo
    :ivar all_tasks_complete_mode: The action the Batch service should take when all Tasks in the
     Job are in the completed state. The default is noaction. Known values are: "noaction" and
     "terminatejob".
    :vartype all_tasks_complete_mode: str or ~azure.batch.models.BatchAllTasksCompleteMode
    :ivar task_failure_mode: The action the Batch service should take when any Task in the Job
     fails. A Task is considered to have failed if has a failureInfo. A failureInfo is set if the
     Task completes with a non-zero exit code after exhausting its retry count, or if there was an
     error starting the Task, for example due to a resource file download error. The default is
     noaction. Known values are: "noaction" and "performexitoptionsjobaction".
    :vartype task_failure_mode: str or ~azure.batch.models.BatchTaskFailureMode
    :ivar network_configuration: (This property is not available by default. Please contact support
     for more information) The network configuration for the Job.
    :vartype network_configuration: ~azure.batch.models.BatchJobNetworkConfiguration
    :ivar metadata: A list of name-value pairs associated with the Job as metadata. The Batch
     service does not assign any meaning to metadata; it is solely for the use of user code.
    :vartype metadata: list[~azure.batch.models.BatchMetadataItem]
    :ivar execution_info: The execution information for the Job.
    :vartype execution_info: ~azure.batch.models.BatchJobExecutionInfo
    :ivar job_statistics: Resource usage statistics for the entire lifetime of the Job. This
     property is populated only if the BatchJob was retrieved with an expand clause including the
     'stats' attribute; otherwise it is null. The statistics may not be immediately available. The
     Batch service performs periodic roll-up of statistics. The typical delay is about 30 minutes.
    :vartype job_statistics: ~azure.batch.models.BatchJobStatistics
    """

    id: str = rest_field(visibility=["read"])
    """A string that uniquely identifies the Job within the Account. The ID is case-preserving and
     case-insensitive (that is, you may not have two IDs within an Account that differ only by
     case). Required."""
    display_name: Optional[str] = rest_field(name="displayName", visibility=["read"])
    """The display name for the Job."""
    uses_task_dependencies: Optional[bool] = rest_field(name="usesTaskDependencies", visibility=["read"])
    """Whether Tasks in the Job can define dependencies on each other. The default is false."""
    url: str = rest_field(visibility=["read"])
    """The URL of the Job. Required."""
    e_tag: str = rest_field(name="eTag", visibility=["read"])
    """The ETag of the Job. This is an opaque string. You can use it to detect whether the Job has
     changed between requests. In particular, you can be pass the ETag when updating a Job to
     specify that your changes should take effect only if nobody else has modified the Job in the
     meantime. Required."""
    last_modified: datetime.datetime = rest_field(name="lastModified", visibility=["read"], format="rfc3339")
    """The last modified time of the Job. This is the last time at which the Job level data, such as
     the Job state or priority, changed. It does not factor in task-level changes such as adding new
     Tasks or Tasks changing state. Required."""
    creation_time: datetime.datetime = rest_field(name="creationTime", visibility=["read"], format="rfc3339")
    """The creation time of the Job. Required."""
    state: Union[str, "_models.BatchJobState"] = rest_field(visibility=["read"])
    """The current state of the Job. Required. Known values are: \"active\", \"disabling\",
     \"disabled\", \"enabling\", \"terminating\", \"completed\", and \"deleting\"."""
    state_transition_time: datetime.datetime = rest_field(
        name="stateTransitionTime", visibility=["read"], format="rfc3339"
    )
    """The time at which the Job entered its current state. Required."""
    previous_state: Optional[Union[str, "_models.BatchJobState"]] = rest_field(
        name="previousState", visibility=["read"]
    )
    """The previous state of the Job. This property is not set if the Job is in its initial Active
     state. Known values are: \"active\", \"disabling\", \"disabled\", \"enabling\",
     \"terminating\", \"completed\", and \"deleting\"."""
    previous_state_transition_time: Optional[datetime.datetime] = rest_field(
        name="previousStateTransitionTime", visibility=["read"], format="rfc3339"
    )
    """The time at which the Job entered its previous state. This property is not set if the Job is in
     its initial Active state."""
    priority: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The priority of the Job. Priority values can range from -1000 to 1000, with -1000 being the
     lowest priority and 1000 being the highest priority. The default value is 0."""
    allow_task_preemption: Optional[bool] = rest_field(
        name="allowTaskPreemption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether Tasks in this job can be preempted by other high priority jobs. (This property is not
     available by default. Please contact support for more information) If the value is set to True,
     other high priority jobs submitted to the system will take precedence and will be able requeue
     tasks from this job. You can update a job's allowTaskPreemption after it has been created using
     the update job API."""
    max_parallel_tasks: Optional[int] = rest_field(
        name="maxParallelTasks", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of tasks that can be executed in parallel for the job. (This property is not
     available by default. Please contact support for more information) The value of
     maxParallelTasks must be -1 or greater than 0 if specified. If not specified, the default value
     is -1, which means there's no limit to the number of tasks that can be run at once. You can
     update a job's maxParallelTasks after it has been created using the update job API."""
    constraints: Optional["_models.BatchJobConstraints"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The execution constraints for the Job."""
    job_manager_task: Optional["_models.BatchJobManagerTask"] = rest_field(name="jobManagerTask", visibility=["read"])
    """Details of a Job Manager Task to be launched when the Job is started."""
    job_preparation_task: Optional["_models.BatchJobPreparationTask"] = rest_field(
        name="jobPreparationTask", visibility=["read"]
    )
    """The Job Preparation Task. The Job Preparation Task is a special Task run on each Compute Node
     before any other Task of the Job."""
    job_release_task: Optional["_models.BatchJobReleaseTask"] = rest_field(name="jobReleaseTask", visibility=["read"])
    """The Job Release Task. The Job Release Task is a special Task run at the end of the Job on each
     Compute Node that has run any other Task of the Job."""
    common_environment_settings: Optional[list["_models.EnvironmentSetting"]] = rest_field(
        name="commonEnvironmentSettings", visibility=["read"]
    )
    """The list of common environment variable settings. These environment variables are set for all
     Tasks in the Job (including the Job Manager, Job Preparation and Job Release Tasks). Individual
     Tasks can override an environment setting specified here by specifying the same setting name
     with a different value."""
    pool_info: "_models.BatchPoolInfo" = rest_field(
        name="poolInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Pool settings associated with the Job. Required."""
    all_tasks_complete_mode: Optional[Union[str, "_models.BatchAllTasksCompleteMode"]] = rest_field(
        name="onAllTasksComplete", visibility=["read", "create", "update", "delete", "query"]
    )
    """The action the Batch service should take when all Tasks in the Job are in the completed state.
     The default is noaction. Known values are: \"noaction\" and \"terminatejob\"."""
    task_failure_mode: Optional[Union[str, "_models.BatchTaskFailureMode"]] = rest_field(
        name="onTaskFailure", visibility=["read"]
    )
    """The action the Batch service should take when any Task in the Job fails. A Task is considered
     to have failed if has a failureInfo. A failureInfo is set if the Task completes with a non-zero
     exit code after exhausting its retry count, or if there was an error starting the Task, for
     example due to a resource file download error. The default is noaction. Known values are:
     \"noaction\" and \"performexitoptionsjobaction\"."""
    network_configuration: Optional["_models.BatchJobNetworkConfiguration"] = rest_field(
        name="networkConfiguration", visibility=["read"]
    )
    """(This property is not available by default. Please contact support for more information) The
     network configuration for the Job."""
    metadata: Optional[list["_models.BatchMetadataItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of name-value pairs associated with the Job as metadata. The Batch service does not
     assign any meaning to metadata; it is solely for the use of user code."""
    execution_info: Optional["_models.BatchJobExecutionInfo"] = rest_field(name="executionInfo", visibility=["read"])
    """The execution information for the Job."""
    job_statistics: Optional["_models.BatchJobStatistics"] = rest_field(name="stats", visibility=["read"])
    """Resource usage statistics for the entire lifetime of the Job. This property is populated only
     if the BatchJob was retrieved with an expand clause including the 'stats' attribute; otherwise
     it is null. The statistics may not be immediately available. The Batch service performs
     periodic roll-up of statistics. The typical delay is about 30 minutes."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        pool_info: "_models.BatchPoolInfo",
        priority: Optional[int] = None,
        allow_task_preemption: Optional[bool] = None,
        max_parallel_tasks: Optional[int] = None,
        constraints: Optional["_models.BatchJobConstraints"] = None,
        all_tasks_complete_mode: Optional[Union[str, "_models.BatchAllTasksCompleteMode"]] = None,
        metadata: Optional[list["_models.BatchMetadataItem"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobConstraints(_Model):
    """The execution constraints for a Job.

    :ivar max_wall_clock_time: The maximum elapsed time that the Job may run, measured from the
     time the Job is created. If the Job does not complete within the time limit, the Batch service
     terminates it and any Tasks that are still running. In this case, the termination reason will
     be MaxWallClockTimeExpiry. If this property is not specified, there is no time limit on how
     long the Job may run.
    :vartype max_wall_clock_time: ~datetime.timedelta
    :ivar max_task_retry_count: The maximum number of times each Task may be retried. The Batch
     service retries a Task if its exit code is nonzero. Note that this value specifically controls
     the number of retries. The Batch service will try each Task once, and may then retry up to this
     limit. For example, if the maximum retry count is 3, Batch tries a Task up to 4 times (one
     initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry
     Tasks. If the maximum retry count is -1, the Batch service retries Tasks without limit. The
     default value is 0 (no retries).
    :vartype max_task_retry_count: int
    """

    max_wall_clock_time: Optional[datetime.timedelta] = rest_field(
        name="maxWallClockTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum elapsed time that the Job may run, measured from the time the Job is created. If
     the Job does not complete within the time limit, the Batch service terminates it and any Tasks
     that are still running. In this case, the termination reason will be MaxWallClockTimeExpiry. If
     this property is not specified, there is no time limit on how long the Job may run."""
    max_task_retry_count: Optional[int] = rest_field(
        name="maxTaskRetryCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of times each Task may be retried. The Batch service retries a Task if its
     exit code is nonzero. Note that this value specifically controls the number of retries. The
     Batch service will try each Task once, and may then retry up to this limit. For example, if the
     maximum retry count is 3, Batch tries a Task up to 4 times (one initial try and 3 retries). If
     the maximum retry count is 0, the Batch service does not retry Tasks. If the maximum retry
     count is -1, the Batch service retries Tasks without limit. The default value is 0 (no
     retries)."""

    @overload
    def __init__(
        self,
        *,
        max_wall_clock_time: Optional[datetime.timedelta] = None,
        max_task_retry_count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobCreateOptions(_Model):
    """Parameters for creating an Azure Batch Job.

    :ivar id: A string that uniquely identifies the Job within the Account. The ID can contain any
     combination of alphanumeric characters including hyphens and underscores, and cannot contain
     more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not
     have two IDs within an Account that differ only by case). Required.
    :vartype id: str
    :ivar display_name: The display name for the Job. The display name need not be unique and can
     contain any Unicode characters up to a maximum length of 1024.
    :vartype display_name: str
    :ivar uses_task_dependencies: Whether Tasks in the Job can define dependencies on each other.
     The default is false.
    :vartype uses_task_dependencies: bool
    :ivar priority: The priority of the Job. Priority values can range from -1000 to 1000, with
     -1000 being the lowest priority and 1000 being the highest priority. The default value is 0.
    :vartype priority: int
    :ivar allow_task_preemption: Whether Tasks in this job can be preempted by other high priority
     jobs. (This property is not available by default. Please contact support for more information)
     If the value is set to True, other high priority jobs submitted to the system will take
     precedence and will be able requeue tasks from this job. You can update a job's
     allowTaskPreemption after it has been created using the update job API.
    :vartype allow_task_preemption: bool
    :ivar max_parallel_tasks: The maximum number of tasks that can be executed in parallel for the
     job. (This property is not available by default. Please contact support for more information)
     The value of maxParallelTasks must be -1 or greater than 0 if specified. If not specified, the
     default value is -1, which means there's no limit to the number of tasks that can be run at
     once. You can update a job's maxParallelTasks after it has been created using the update job
     API.
    :vartype max_parallel_tasks: int
    :ivar constraints: The execution constraints for the Job.
    :vartype constraints: ~azure.batch.models.BatchJobConstraints
    :ivar job_manager_task: Details of a Job Manager Task to be launched when the Job is started.
     If the Job does not specify a Job Manager Task, the user must explicitly add Tasks to the Job.
     If the Job does specify a Job Manager Task, the Batch service creates the Job Manager Task when
     the Job is created, and will try to schedule the Job Manager Task before scheduling other Tasks
     in the Job. The Job Manager Task's typical purpose is to control and/or monitor Job execution,
     for example by deciding what additional Tasks to run, determining when the work is complete,
     etc. (However, a Job Manager Task is not restricted to these activities - it is a fully-fledged
     Task in the system and perform whatever actions are required for the Job.) For example, a Job
     Manager Task might download a file specified as a parameter, analyze the contents of that file
     and submit additional Tasks based on those contents.
    :vartype job_manager_task: ~azure.batch.models.BatchJobManagerTask
    :ivar job_preparation_task: The Job Preparation Task. If a Job has a Job Preparation Task, the
     Batch service will run the Job Preparation Task on a Node before starting any Tasks of that Job
     on that Compute Node.
    :vartype job_preparation_task: ~azure.batch.models.BatchJobPreparationTask
    :ivar job_release_task: The Job Release Task. A Job Release Task cannot be specified without
     also specifying a Job Preparation Task for the Job. The Batch service runs the Job Release Task
     on the Nodes that have run the Job Preparation Task. The primary purpose of the Job Release
     Task is to undo changes to Compute Nodes made by the Job Preparation Task. Example activities
     include deleting local files, or shutting down services that were started as part of Job
     preparation.
    :vartype job_release_task: ~azure.batch.models.BatchJobReleaseTask
    :ivar common_environment_settings: The list of common environment variable settings. These
     environment variables are set for all Tasks in the Job (including the Job Manager, Job
     Preparation and Job Release Tasks). Individual Tasks can override an environment setting
     specified here by specifying the same setting name with a different value.
    :vartype common_environment_settings: list[~azure.batch.models.EnvironmentSetting]
    :ivar pool_info: The Pool on which the Batch service runs the Job's Tasks. Required.
    :vartype pool_info: ~azure.batch.models.BatchPoolInfo
    :ivar all_tasks_complete_mode: The action the Batch service should take when all Tasks in the
     Job are in the completed state. Note that if a Job contains no Tasks, then all Tasks are
     considered complete. This option is therefore most commonly used with a Job Manager task; if
     you want to use automatic Job termination without a Job Manager, you should initially set
     onAllTasksComplete to noaction and update the Job properties to set onAllTasksComplete to
     terminatejob once you have finished adding Tasks. The default is noaction. Known values are:
     "noaction" and "terminatejob".
    :vartype all_tasks_complete_mode: str or ~azure.batch.models.BatchAllTasksCompleteMode
    :ivar task_failure_mode: The action the Batch service should take when any Task in the Job
     fails. A Task is considered to have failed if has a failureInfo. A failureInfo is set if the
     Task completes with a non-zero exit code after exhausting its retry count, or if there was an
     error starting the Task, for example due to a resource file download error. The default is
     noaction. Known values are: "noaction" and "performexitoptionsjobaction".
    :vartype task_failure_mode: str or ~azure.batch.models.BatchTaskFailureMode
    :ivar network_configuration: (This property is not available by default. Please contact support
     for more information) The network configuration for the Job.
    :vartype network_configuration: ~azure.batch.models.BatchJobNetworkConfiguration
    :ivar metadata: A list of name-value pairs associated with the Job as metadata. The Batch
     service does not assign any meaning to metadata; it is solely for the use of user code.
    :vartype metadata: list[~azure.batch.models.BatchMetadataItem]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A string that uniquely identifies the Job within the Account. The ID can contain any
     combination of alphanumeric characters including hyphens and underscores, and cannot contain
     more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not
     have two IDs within an Account that differ only by case). Required."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The display name for the Job. The display name need not be unique and can contain any Unicode
     characters up to a maximum length of 1024."""
    uses_task_dependencies: Optional[bool] = rest_field(
        name="usesTaskDependencies", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether Tasks in the Job can define dependencies on each other. The default is false."""
    priority: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The priority of the Job. Priority values can range from -1000 to 1000, with -1000 being the
     lowest priority and 1000 being the highest priority. The default value is 0."""
    allow_task_preemption: Optional[bool] = rest_field(
        name="allowTaskPreemption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether Tasks in this job can be preempted by other high priority jobs. (This property is not
     available by default. Please contact support for more information) If the value is set to True,
     other high priority jobs submitted to the system will take precedence and will be able requeue
     tasks from this job. You can update a job's allowTaskPreemption after it has been created using
     the update job API."""
    max_parallel_tasks: Optional[int] = rest_field(
        name="maxParallelTasks", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of tasks that can be executed in parallel for the job. (This property is not
     available by default. Please contact support for more information) The value of
     maxParallelTasks must be -1 or greater than 0 if specified. If not specified, the default value
     is -1, which means there's no limit to the number of tasks that can be run at once. You can
     update a job's maxParallelTasks after it has been created using the update job API."""
    constraints: Optional["_models.BatchJobConstraints"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The execution constraints for the Job."""
    job_manager_task: Optional["_models.BatchJobManagerTask"] = rest_field(
        name="jobManagerTask", visibility=["read", "create", "update", "delete", "query"]
    )
    """Details of a Job Manager Task to be launched when the Job is started. If the Job does not
     specify a Job Manager Task, the user must explicitly add Tasks to the Job. If the Job does
     specify a Job Manager Task, the Batch service creates the Job Manager Task when the Job is
     created, and will try to schedule the Job Manager Task before scheduling other Tasks in the
     Job. The Job Manager Task's typical purpose is to control and/or monitor Job execution, for
     example by deciding what additional Tasks to run, determining when the work is complete, etc.
     (However, a Job Manager Task is not restricted to these activities - it is a fully-fledged Task
     in the system and perform whatever actions are required for the Job.) For example, a Job
     Manager Task might download a file specified as a parameter, analyze the contents of that file
     and submit additional Tasks based on those contents."""
    job_preparation_task: Optional["_models.BatchJobPreparationTask"] = rest_field(
        name="jobPreparationTask", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Job Preparation Task. If a Job has a Job Preparation Task, the Batch service will run the
     Job Preparation Task on a Node before starting any Tasks of that Job on that Compute Node."""
    job_release_task: Optional["_models.BatchJobReleaseTask"] = rest_field(
        name="jobReleaseTask", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Job Release Task. A Job Release Task cannot be specified without also specifying a Job
     Preparation Task for the Job. The Batch service runs the Job Release Task on the Nodes that
     have run the Job Preparation Task. The primary purpose of the Job Release Task is to undo
     changes to Compute Nodes made by the Job Preparation Task. Example activities include deleting
     local files, or shutting down services that were started as part of Job preparation."""
    common_environment_settings: Optional[list["_models.EnvironmentSetting"]] = rest_field(
        name="commonEnvironmentSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of common environment variable settings. These environment variables are set for all
     Tasks in the Job (including the Job Manager, Job Preparation and Job Release Tasks). Individual
     Tasks can override an environment setting specified here by specifying the same setting name
     with a different value."""
    pool_info: "_models.BatchPoolInfo" = rest_field(
        name="poolInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Pool on which the Batch service runs the Job's Tasks. Required."""
    all_tasks_complete_mode: Optional[Union[str, "_models.BatchAllTasksCompleteMode"]] = rest_field(
        name="onAllTasksComplete", visibility=["read", "create", "update", "delete", "query"]
    )
    """The action the Batch service should take when all Tasks in the Job are in the completed state.
     Note that if a Job contains no Tasks, then all Tasks are considered complete. This option is
     therefore most commonly used with a Job Manager task; if you want to use automatic Job
     termination without a Job Manager, you should initially set onAllTasksComplete to noaction and
     update the Job properties to set onAllTasksComplete to terminatejob once you have finished
     adding Tasks. The default is noaction. Known values are: \"noaction\" and \"terminatejob\"."""
    task_failure_mode: Optional[Union[str, "_models.BatchTaskFailureMode"]] = rest_field(
        name="onTaskFailure", visibility=["read", "create", "update", "delete", "query"]
    )
    """The action the Batch service should take when any Task in the Job fails. A Task is considered
     to have failed if has a failureInfo. A failureInfo is set if the Task completes with a non-zero
     exit code after exhausting its retry count, or if there was an error starting the Task, for
     example due to a resource file download error. The default is noaction. Known values are:
     \"noaction\" and \"performexitoptionsjobaction\"."""
    network_configuration: Optional["_models.BatchJobNetworkConfiguration"] = rest_field(
        name="networkConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """(This property is not available by default. Please contact support for more information) The
     network configuration for the Job."""
    metadata: Optional[list["_models.BatchMetadataItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of name-value pairs associated with the Job as metadata. The Batch service does not
     assign any meaning to metadata; it is solely for the use of user code."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        pool_info: "_models.BatchPoolInfo",
        display_name: Optional[str] = None,
        uses_task_dependencies: Optional[bool] = None,
        priority: Optional[int] = None,
        allow_task_preemption: Optional[bool] = None,
        max_parallel_tasks: Optional[int] = None,
        constraints: Optional["_models.BatchJobConstraints"] = None,
        job_manager_task: Optional["_models.BatchJobManagerTask"] = None,
        job_preparation_task: Optional["_models.BatchJobPreparationTask"] = None,
        job_release_task: Optional["_models.BatchJobReleaseTask"] = None,
        common_environment_settings: Optional[list["_models.EnvironmentSetting"]] = None,
        all_tasks_complete_mode: Optional[Union[str, "_models.BatchAllTasksCompleteMode"]] = None,
        task_failure_mode: Optional[Union[str, "_models.BatchTaskFailureMode"]] = None,
        network_configuration: Optional["_models.BatchJobNetworkConfiguration"] = None,
        metadata: Optional[list["_models.BatchMetadataItem"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobDisableOptions(_Model):
    """Parameters for disabling an Azure Batch Job.

    :ivar disable_tasks: What to do with active Tasks associated with the Job. Required. Known
     values are: "requeue", "terminate", and "wait".
    :vartype disable_tasks: str or ~azure.batch.models.DisableBatchJobOption
    """

    disable_tasks: Union[str, "_models.DisableBatchJobOption"] = rest_field(
        name="disableTasks", visibility=["read", "create", "update", "delete", "query"]
    )
    """What to do with active Tasks associated with the Job. Required. Known values are: \"requeue\",
     \"terminate\", and \"wait\"."""

    @overload
    def __init__(
        self,
        *,
        disable_tasks: Union[str, "_models.DisableBatchJobOption"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobExecutionInfo(_Model):
    """Contains information about the execution of a Job in the Azure Batch service.

    :ivar start_time: The start time of the Job. This is the time at which the Job was created.
     Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The completion time of the Job. This property is set only if the Job is in the
     completed state.
    :vartype end_time: ~datetime.datetime
    :ivar pool_id: The ID of the Pool to which this Job is assigned. This element contains the
     actual Pool where the Job is assigned. When you get Job details from the service, they also
     contain a poolInfo element, which contains the Pool configuration data from when the Job was
     added or updated. That poolInfo element may also contain a poolId element. If it does, the two
     IDs are the same. If it does not, it means the Job ran on an auto Pool, and this property
     contains the ID of that auto Pool.
    :vartype pool_id: str
    :ivar scheduling_error: Details of any error encountered by the service in starting the Job.
     This property is not set if there was no error starting the Job.
    :vartype scheduling_error: ~azure.batch.models.BatchJobSchedulingError
    :ivar termination_reason: A string describing the reason the Job ended. This property is set
     only if the Job is in the completed state. If the Batch service terminates the Job, it sets the
     reason as follows: JMComplete - the Job Manager Task completed, and killJobOnCompletion was set
     to true. MaxWallClockTimeExpiry - the Job reached its maxWallClockTime constraint.
     TerminateJobSchedule - the Job ran as part of a schedule, and the schedule terminated.
     AllTasksComplete - the Job's onAllTasksComplete attribute is set to terminatejob, and all Tasks
     in the Job are complete. TaskFailed - the Job's onTaskFailure attribute is set to
     performExitOptionsJobAction, and a Task in the Job failed with an exit condition that specified
     a jobAction of terminatejob. Any other string is a user-defined reason specified in a call to
     the 'Terminate a Job' operation.
    :vartype termination_reason: str
    """

    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The start time of the Job. This is the time at which the Job was created. Required."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The completion time of the Job. This property is set only if the Job is in the completed state."""
    pool_id: Optional[str] = rest_field(name="poolId", visibility=["read", "create", "update", "delete", "query"])
    """The ID of the Pool to which this Job is assigned. This element contains the actual Pool where
     the Job is assigned. When you get Job details from the service, they also contain a poolInfo
     element, which contains the Pool configuration data from when the Job was added or updated.
     That poolInfo element may also contain a poolId element. If it does, the two IDs are the same.
     If it does not, it means the Job ran on an auto Pool, and this property contains the ID of that
     auto Pool."""
    scheduling_error: Optional["_models.BatchJobSchedulingError"] = rest_field(
        name="schedulingError", visibility=["read", "create", "update", "delete", "query"]
    )
    """Details of any error encountered by the service in starting the Job. This property is not set
     if there was no error starting the Job."""
    termination_reason: Optional[str] = rest_field(
        name="terminateReason", visibility=["read", "create", "update", "delete", "query"]
    )
    """A string describing the reason the Job ended. This property is set only if the Job is in the
     completed state. If the Batch service terminates the Job, it sets the reason as follows:
     JMComplete - the Job Manager Task completed, and killJobOnCompletion was set to true.
     MaxWallClockTimeExpiry - the Job reached its maxWallClockTime constraint. TerminateJobSchedule
     - the Job ran as part of a schedule, and the schedule terminated. AllTasksComplete - the Job's
     onAllTasksComplete attribute is set to terminatejob, and all Tasks in the Job are complete.
     TaskFailed - the Job's onTaskFailure attribute is set to performExitOptionsJobAction, and a
     Task in the Job failed with an exit condition that specified a jobAction of terminatejob. Any
     other string is a user-defined reason specified in a call to the 'Terminate a Job' operation."""

    @overload
    def __init__(
        self,
        *,
        start_time: datetime.datetime,
        end_time: Optional[datetime.datetime] = None,
        pool_id: Optional[str] = None,
        scheduling_error: Optional["_models.BatchJobSchedulingError"] = None,
        termination_reason: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobManagerTask(_Model):
    """Specifies details of a Job Manager Task.
    The Job Manager Task is automatically started when the Job is created. The
    Batch service tries to schedule the Job Manager Task before any other Tasks in
    the Job. When shrinking a Pool, the Batch service tries to preserve Nodes where
    Job Manager Tasks are running for as long as possible (that is, Compute Nodes
    running 'normal' Tasks are removed before Compute Nodes running Job Manager
    Tasks). When a Job Manager Task fails and needs to be restarted, the system
    tries to schedule it at the highest priority. If there are no idle Compute
    Nodes available, the system may terminate one of the running Tasks in the Pool
    and return it to the queue in order to make room for the Job Manager Task to
    restart. Note that a Job Manager Task in one Job does not have priority over
    Tasks in other Jobs. Across Jobs, only Job level priorities are observed. For
    example, if a Job Manager in a priority 0 Job needs to be restarted, it will
    not displace Tasks of a priority 1 Job. Batch will retry Tasks when a recovery
    operation is triggered on a Node. Examples of recovery operations include (but
    are not limited to) when an unhealthy Node is rebooted or a Compute Node
    disappeared due to host failure. Retries due to recovery operations are
    independent of and are not counted against the maxTaskRetryCount. Even if the
    maxTaskRetryCount is 0, an internal retry due to a recovery operation may
    occur. Because of this, all Tasks should be idempotent. This means Tasks need
    to tolerate being interrupted and restarted without causing any corruption or
    duplicate data. The best practice for long running Tasks is to use some form of
    checkpointing.

    :ivar id: A string that uniquely identifies the Job Manager Task within the Job. The ID can
     contain any combination of alphanumeric characters including hyphens and underscores and cannot
     contain more than 64 characters. Required.
    :vartype id: str
    :ivar display_name: The display name of the Job Manager Task. It need not be unique and can
     contain any Unicode characters up to a maximum length of 1024.
    :vartype display_name: str
    :ivar command_line: The command line of the Job Manager Task. The command line does not run
     under a shell, and therefore cannot take advantage of shell features such as environment
     variable expansion. If you want to take advantage of such features, you should invoke the shell
     in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand"
     in Linux. If the command line refers to file paths, it should use a relative path (relative to
     the Task working directory), or use the Batch provided environment variable
     (`https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables
     <https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables>`_).
     Required.
    :vartype command_line: str
    :ivar container_settings: The settings for the container under which the Job Manager Task runs.
     If the Pool that will run this Task has containerConfiguration set, this must be set as well.
     If the Pool that will run this Task doesn't have containerConfiguration set, this must not be
     set. When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the
     root of Azure Batch directories on the node) are mapped into the container, all Task
     environment variables are mapped into the container, and the Task command line is executed in
     the container. Files produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be
     reflected to the host disk, meaning that Batch file APIs will not be able to access those
     files.
    :vartype container_settings: ~azure.batch.models.BatchTaskContainerSettings
    :ivar resource_files: A list of files that the Batch service will download to the Compute Node
     before running the command line. Files listed under this element are located in the Task's
     working directory. There is a maximum size for the list of resource files.  When the max size
     is exceeded, the request will fail and the response error code will be RequestEntityTooLarge.
     If this occurs, the collection of ResourceFiles must be reduced in size. This can be achieved
     using .zip files, Application Packages, or Docker Containers.
    :vartype resource_files: list[~azure.batch.models.ResourceFile]
    :ivar output_files: A list of files that the Batch service will upload from the Compute Node
     after running the command line. For multi-instance Tasks, the files will only be uploaded from
     the Compute Node on which the primary Task is executed.
    :vartype output_files: list[~azure.batch.models.OutputFile]
    :ivar environment_settings: A list of environment variable settings for the Job Manager Task.
    :vartype environment_settings: list[~azure.batch.models.EnvironmentSetting]
    :ivar constraints: Constraints that apply to the Job Manager Task.
    :vartype constraints: ~azure.batch.models.BatchTaskConstraints
    :ivar required_slots: The number of scheduling slots that the Task requires to run. The default
     is 1. A Task can only be scheduled to run on a compute node if the node has enough free
     scheduling slots available. For multi-instance Tasks, this property is not supported and must
     not be specified.
    :vartype required_slots: int
    :ivar kill_job_on_completion: Whether completion of the Job Manager Task signifies completion
     of the entire Job. If true, when the Job Manager Task completes, the Batch service marks the
     Job as complete. If any Tasks are still running at this time (other than Job Release), those
     Tasks are terminated. If false, the completion of the Job Manager Task does not affect the Job
     status. In this case, you should either use the onAllTasksComplete attribute to terminate the
     Job, or have a client or user terminate the Job explicitly. An example of this is if the Job
     Manager creates a set of Tasks but then takes no further role in their execution. The default
     value is true. If you are using the onAllTasksComplete and onTaskFailure attributes to control
     Job lifetime, and using the Job Manager Task only to create the Tasks for the Job (not to
     monitor progress), then it is important to set killJobOnCompletion to false.
    :vartype kill_job_on_completion: bool
    :ivar user_identity: The user identity under which the Job Manager Task runs. If omitted, the
     Task runs as a non-administrative user unique to the Task.
    :vartype user_identity: ~azure.batch.models.UserIdentity
    :ivar run_exclusive: Whether the Job Manager Task requires exclusive use of the Compute Node
     where it runs. If true, no other Tasks will run on the same Node for as long as the Job Manager
     is running. If false, other Tasks can run simultaneously with the Job Manager on a Compute
     Node. The Job Manager Task counts normally against the Compute Node's concurrent Task limit, so
     this is only relevant if the Compute Node allows multiple concurrent Tasks. The default value
     is true.
    :vartype run_exclusive: bool
    :ivar application_package_references: A list of Application Packages that the Batch service
     will deploy to the
     Compute Node before running the command line.Application Packages are
     downloaded and deployed to a shared directory, not the Task working
     directory. Therefore, if a referenced Application Package is already
     on the Compute Node, and is up to date, then it is not re-downloaded;
     the existing copy on the Compute Node is used. If a referenced Application
     Package cannot be installed, for example because the package has been deleted
     or because download failed, the Task fails.
    :vartype application_package_references:
     list[~azure.batch.models.BatchApplicationPackageReference]
    :ivar authentication_token_settings: The settings for an authentication token that the Task can
     use to perform Batch service operations. If this property is set, the Batch service provides
     the Task with an authentication token which can be used to authenticate Batch service
     operations without requiring an Account access key. The token is provided via the
     AZ_BATCH_AUTHENTICATION_TOKEN environment variable. The operations that the Task can carry out
     using the token depend on the settings. For example, a Task can request Job permissions in
     order to add other Tasks to the Job, or check the status of the Job or of other Tasks under the
     Job.
    :vartype authentication_token_settings: ~azure.batch.models.AuthenticationTokenSettings
    :ivar allow_low_priority_node: Whether the Job Manager Task may run on a Spot/Low-priority
     Compute Node. The default value is true.
    :vartype allow_low_priority_node: bool
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A string that uniquely identifies the Job Manager Task within the Job. The ID can contain any
     combination of alphanumeric characters including hyphens and underscores and cannot contain
     more than 64 characters. Required."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The display name of the Job Manager Task. It need not be unique and can contain any Unicode
     characters up to a maximum length of 1024."""
    command_line: str = rest_field(name="commandLine", visibility=["read", "create", "update", "delete", "query"])
    """The command line of the Job Manager Task. The command line does not run under a shell, and
     therefore cannot take advantage of shell features such as environment variable expansion. If
     you want to take advantage of such features, you should invoke the shell in the command line,
     for example using \"cmd /c MyCommand\" in Windows or \"/bin/sh -c MyCommand\" in Linux. If the
     command line refers to file paths, it should use a relative path (relative to the Task working
     directory), or use the Batch provided environment variable
     (`https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables
     <https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables>`_).
     Required."""
    container_settings: Optional["_models.BatchTaskContainerSettings"] = rest_field(
        name="containerSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The settings for the container under which the Job Manager Task runs. If the Pool that will run
     this Task has containerConfiguration set, this must be set as well. If the Pool that will run
     this Task doesn't have containerConfiguration set, this must not be set. When this is
     specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure
     Batch directories on the node) are mapped into the container, all Task environment variables
     are mapped into the container, and the Task command line is executed in the container. Files
     produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host
     disk, meaning that Batch file APIs will not be able to access those files."""
    resource_files: Optional[list["_models.ResourceFile"]] = rest_field(
        name="resourceFiles", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of files that the Batch service will download to the Compute Node before running the
     command line. Files listed under this element are located in the Task's working directory.
     There is a maximum size for the list of resource files.  When the max size is exceeded, the
     request will fail and the response error code will be RequestEntityTooLarge. If this occurs,
     the collection of ResourceFiles must be reduced in size. This can be achieved using .zip files,
     Application Packages, or Docker Containers."""
    output_files: Optional[list["_models.OutputFile"]] = rest_field(
        name="outputFiles", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of files that the Batch service will upload from the Compute Node after running the
     command line. For multi-instance Tasks, the files will only be uploaded from the Compute Node
     on which the primary Task is executed."""
    environment_settings: Optional[list["_models.EnvironmentSetting"]] = rest_field(
        name="environmentSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of environment variable settings for the Job Manager Task."""
    constraints: Optional["_models.BatchTaskConstraints"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Constraints that apply to the Job Manager Task."""
    required_slots: Optional[int] = rest_field(
        name="requiredSlots", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of scheduling slots that the Task requires to run. The default is 1. A Task can only
     be scheduled to run on a compute node if the node has enough free scheduling slots available.
     For multi-instance Tasks, this property is not supported and must not be specified."""
    kill_job_on_completion: Optional[bool] = rest_field(
        name="killJobOnCompletion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether completion of the Job Manager Task signifies completion of the entire Job. If true,
     when the Job Manager Task completes, the Batch service marks the Job as complete. If any Tasks
     are still running at this time (other than Job Release), those Tasks are terminated. If false,
     the completion of the Job Manager Task does not affect the Job status. In this case, you should
     either use the onAllTasksComplete attribute to terminate the Job, or have a client or user
     terminate the Job explicitly. An example of this is if the Job Manager creates a set of Tasks
     but then takes no further role in their execution. The default value is true. If you are using
     the onAllTasksComplete and onTaskFailure attributes to control Job lifetime, and using the Job
     Manager Task only to create the Tasks for the Job (not to monitor progress), then it is
     important to set killJobOnCompletion to false."""
    user_identity: Optional["_models.UserIdentity"] = rest_field(
        name="userIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user identity under which the Job Manager Task runs. If omitted, the Task runs as a
     non-administrative user unique to the Task."""
    run_exclusive: Optional[bool] = rest_field(
        name="runExclusive", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the Job Manager Task requires exclusive use of the Compute Node where it runs. If true,
     no other Tasks will run on the same Node for as long as the Job Manager is running. If false,
     other Tasks can run simultaneously with the Job Manager on a Compute Node. The Job Manager Task
     counts normally against the Compute Node's concurrent Task limit, so this is only relevant if
     the Compute Node allows multiple concurrent Tasks. The default value is true."""
    application_package_references: Optional[list["_models.BatchApplicationPackageReference"]] = rest_field(
        name="applicationPackageReferences", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of Application Packages that the Batch service will deploy to the
     Compute Node before running the command line.Application Packages are
     downloaded and deployed to a shared directory, not the Task working
     directory. Therefore, if a referenced Application Package is already
     on the Compute Node, and is up to date, then it is not re-downloaded;
     the existing copy on the Compute Node is used. If a referenced Application
     Package cannot be installed, for example because the package has been deleted
     or because download failed, the Task fails."""
    authentication_token_settings: Optional["_models.AuthenticationTokenSettings"] = rest_field(
        name="authenticationTokenSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The settings for an authentication token that the Task can use to perform Batch service
     operations. If this property is set, the Batch service provides the Task with an authentication
     token which can be used to authenticate Batch service operations without requiring an Account
     access key. The token is provided via the AZ_BATCH_AUTHENTICATION_TOKEN environment variable.
     The operations that the Task can carry out using the token depend on the settings. For example,
     a Task can request Job permissions in order to add other Tasks to the Job, or check the status
     of the Job or of other Tasks under the Job."""
    allow_low_priority_node: Optional[bool] = rest_field(
        name="allowLowPriorityNode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the Job Manager Task may run on a Spot/Low-priority Compute Node. The default value is
     true."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        command_line: str,
        display_name: Optional[str] = None,
        container_settings: Optional["_models.BatchTaskContainerSettings"] = None,
        resource_files: Optional[list["_models.ResourceFile"]] = None,
        output_files: Optional[list["_models.OutputFile"]] = None,
        environment_settings: Optional[list["_models.EnvironmentSetting"]] = None,
        constraints: Optional["_models.BatchTaskConstraints"] = None,
        required_slots: Optional[int] = None,
        kill_job_on_completion: Optional[bool] = None,
        user_identity: Optional["_models.UserIdentity"] = None,
        run_exclusive: Optional[bool] = None,
        application_package_references: Optional[list["_models.BatchApplicationPackageReference"]] = None,
        authentication_token_settings: Optional["_models.AuthenticationTokenSettings"] = None,
        allow_low_priority_node: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobNetworkConfiguration(_Model):
    """(This property is not available by default. Please contact support for more information) The
    network configuration for the Job.

    :ivar subnet_id: The ARM resource identifier of the virtual network subnet which Compute Nodes
     running Tasks from the Job will join for the duration of the Task. The virtual network must be
     in the same region and subscription as the Azure Batch Account. The specified subnet should
     have enough free IP addresses to accommodate the number of Compute Nodes which will run Tasks
     from the Job. This can be up to the number of Compute Nodes in the Pool. The
     'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor'
     Role-Based Access Control (RBAC) role for the specified VNet so that Azure Batch service can
     schedule Tasks on the Nodes. This can be verified by checking if the specified VNet has any
     associated Network Security Groups (NSG). If communication to the Nodes in the specified subnet
     is denied by an NSG, then the Batch service will set the state of the Compute Nodes to
     unusable. This is of the form
     /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
     If the specified VNet has any associated Network Security Groups (NSG), then a few reserved
     system ports must be enabled for inbound communication from the Azure Batch service. For Pools
     created with a Virtual Machine configuration, enable ports 29876 and 29877, as well as port 22
     for Linux and port 3389 for Windows. Port 443 is also required to be open for outbound
     connections for communications to Azure Storage. For more details see:
     `https://learn.microsoft.com/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
     <https://learn.microsoft.com/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration>`_.
     Required.
    :vartype subnet_id: str
    :ivar skip_withdraw_from_vnet: Whether to withdraw Compute Nodes from the virtual network to
     DNC when the job is terminated or deleted.  If true, nodes will remain joined to the virtual
     network to DNC. If false, nodes will automatically withdraw when the job ends. Defaults to
     false.
    :vartype skip_withdraw_from_vnet: bool
    """

    subnet_id: str = rest_field(name="subnetId", visibility=["read", "create", "update", "delete", "query"])
    """The ARM resource identifier of the virtual network subnet which Compute Nodes running Tasks
     from the Job will join for the duration of the Task. The virtual network must be in the same
     region and subscription as the Azure Batch Account. The specified subnet should have enough
     free IP addresses to accommodate the number of Compute Nodes which will run Tasks from the Job.
     This can be up to the number of Compute Nodes in the Pool. The 'MicrosoftAzureBatch' service
     principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC)
     role for the specified VNet so that Azure Batch service can schedule Tasks on the Nodes. This
     can be verified by checking if the specified VNet has any associated Network Security Groups
     (NSG). If communication to the Nodes in the specified subnet is denied by an NSG, then the
     Batch service will set the state of the Compute Nodes to unusable. This is of the form
     /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
     If the specified VNet has any associated Network Security Groups (NSG), then a few reserved
     system ports must be enabled for inbound communication from the Azure Batch service. For Pools
     created with a Virtual Machine configuration, enable ports 29876 and 29877, as well as port 22
     for Linux and port 3389 for Windows. Port 443 is also required to be open for outbound
     connections for communications to Azure Storage. For more details see:
     `https://learn.microsoft.com/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
     <https://learn.microsoft.com/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration>`_.
     Required."""
    skip_withdraw_from_vnet: Optional[bool] = rest_field(
        name="skipWithdrawFromVNet", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether to withdraw Compute Nodes from the virtual network to DNC when the job is terminated or
     deleted.  If true, nodes will remain joined to the virtual network to DNC. If false, nodes will
     automatically withdraw when the job ends. Defaults to false."""

    @overload
    def __init__(
        self,
        *,
        subnet_id: str,
        skip_withdraw_from_vnet: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobPreparationAndReleaseTaskStatus(_Model):
    """The status of the Job Preparation and Job Release Tasks on a Compute Node.

    :ivar pool_id: The ID of the Pool containing the Compute Node to which this entry refers.
    :vartype pool_id: str
    :ivar node_id: The ID of the Compute Node to which this entry refers.
    :vartype node_id: str
    :ivar node_url: The URL of the Compute Node to which this entry refers.
    :vartype node_url: str
    :ivar job_preparation_task_execution_info: Information about the execution status of the Job
     Preparation Task on this Compute Node.
    :vartype job_preparation_task_execution_info:
     ~azure.batch.models.BatchJobPreparationTaskExecutionInfo
    :ivar job_release_task_execution_info: Information about the execution status of the Job
     Release Task on this Compute Node. This property is set only if the Job Release Task has run on
     the Compute Node.
    :vartype job_release_task_execution_info: ~azure.batch.models.BatchJobReleaseTaskExecutionInfo
    """

    pool_id: Optional[str] = rest_field(name="poolId", visibility=["read", "create", "update", "delete", "query"])
    """The ID of the Pool containing the Compute Node to which this entry refers."""
    node_id: Optional[str] = rest_field(name="nodeId", visibility=["read", "create", "update", "delete", "query"])
    """The ID of the Compute Node to which this entry refers."""
    node_url: Optional[str] = rest_field(name="nodeUrl", visibility=["read", "create", "update", "delete", "query"])
    """The URL of the Compute Node to which this entry refers."""
    job_preparation_task_execution_info: Optional["_models.BatchJobPreparationTaskExecutionInfo"] = rest_field(
        name="jobPreparationTaskExecutionInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information about the execution status of the Job Preparation Task on this Compute Node."""
    job_release_task_execution_info: Optional["_models.BatchJobReleaseTaskExecutionInfo"] = rest_field(
        name="jobReleaseTaskExecutionInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information about the execution status of the Job Release Task on this Compute Node. This
     property is set only if the Job Release Task has run on the Compute Node."""

    @overload
    def __init__(
        self,
        *,
        pool_id: Optional[str] = None,
        node_id: Optional[str] = None,
        node_url: Optional[str] = None,
        job_preparation_task_execution_info: Optional["_models.BatchJobPreparationTaskExecutionInfo"] = None,
        job_release_task_execution_info: Optional["_models.BatchJobReleaseTaskExecutionInfo"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobPreparationTask(_Model):
    """A Job Preparation Task to run before any Tasks of the Job on any given Compute Node.
    You can use Job Preparation to prepare a Node to run Tasks for the Job.
    Activities commonly performed in Job Preparation include: Downloading common
    resource files used by all the Tasks in the Job. The Job Preparation Task can
    download these common resource files to the shared location on the Node.
    (AZ_BATCH_NODE_ROOT_DIR\\shared), or starting a local service on the Node so
    that all Tasks of that Job can communicate with it. If the Job Preparation Task
    fails (that is, exhausts its retry count before exiting with exit code 0),
    Batch will not run Tasks of this Job on the Node. The Compute Node remains
    ineligible to run Tasks of this Job until it is reimaged. The Compute Node
    remains active and can be used for other Jobs. The Job Preparation Task can run
    multiple times on the same Node. Therefore, you should write the Job
    Preparation Task to handle re-execution. If the Node is rebooted, the Job
    Preparation Task is run again on the Compute Node before scheduling any other
    Task of the Job, if rerunOnNodeRebootAfterSuccess is true or if the Job
    Preparation Task did not previously complete. If the Node is reimaged, the Job
    Preparation Task is run again before scheduling any Task of the Job. Batch will
    retry Tasks when a recovery operation is triggered on a Node. Examples of
    recovery operations include (but are not limited to) when an unhealthy Node is
    rebooted or a Compute Node disappeared due to host failure. Retries due to
    recovery operations are independent of and are not counted against the
    maxTaskRetryCount. Even if the maxTaskRetryCount is 0, an internal retry due to
    a recovery operation may occur. Because of this, all Tasks should be
    idempotent. This means Tasks need to tolerate being interrupted and restarted
    without causing any corruption or duplicate data. The best practice for long
    running Tasks is to use some form of checkpointing.

    :ivar id: A string that uniquely identifies the Job Preparation Task within the Job. The ID can
     contain any combination of alphanumeric characters including hyphens and underscores and cannot
     contain more than 64 characters. If you do not specify this property, the Batch service assigns
     a default value of 'jobpreparation'. No other Task in the Job can have the same ID as the Job
     Preparation Task. If you try to submit a Task with the same id, the Batch service rejects the
     request with error code TaskIdSameAsJobPreparationTask; if you are calling the REST API
     directly, the HTTP status code is 409 (Conflict).
    :vartype id: str
    :ivar command_line: The command line of the Job Preparation Task. The command line does not run
     under a shell, and therefore cannot take advantage of shell features such as environment
     variable expansion. If you want to take advantage of such features, you should invoke the shell
     in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand"
     in Linux. If the command line refers to file paths, it should use a relative path (relative to
     the Task working directory), or use the Batch provided environment variable
     (`https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables
     <https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables>`_).
     Required.
    :vartype command_line: str
    :ivar container_settings: The settings for the container under which the Job Preparation Task
     runs. When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the
     root of Azure Batch directories on the node) are mapped into the container, all Task
     environment variables are mapped into the container, and the Task command line is executed in
     the container. Files produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be
     reflected to the host disk, meaning that Batch file APIs will not be able to access those
     files.
    :vartype container_settings: ~azure.batch.models.BatchTaskContainerSettings
    :ivar resource_files: A list of files that the Batch service will download to the Compute Node
     before running the command line. Files listed under this element are located in the Task's
     working directory.  There is a maximum size for the list of resource files.  When the max size
     is exceeded, the request will fail and the response error code will be RequestEntityTooLarge.
     If this occurs, the collection of ResourceFiles must be reduced in size. This can be achieved
     using .zip files, Application Packages, or Docker Containers.
    :vartype resource_files: list[~azure.batch.models.ResourceFile]
    :ivar environment_settings: A list of environment variable settings for the Job Preparation
     Task.
    :vartype environment_settings: list[~azure.batch.models.EnvironmentSetting]
    :ivar constraints: Constraints that apply to the Job Preparation Task.
    :vartype constraints: ~azure.batch.models.BatchTaskConstraints
    :ivar wait_for_success: Whether the Batch service should wait for the Job Preparation Task to
     complete successfully before scheduling any other Tasks of the Job on the Compute Node. A Job
     Preparation Task has completed successfully if it exits with exit code 0. If true and the Job
     Preparation Task fails on a Node, the Batch service retries the Job Preparation Task up to its
     maximum retry count (as specified in the constraints element). If the Task has still not
     completed successfully after all retries, then the Batch service will not schedule Tasks of the
     Job to the Node. The Node remains active and eligible to run Tasks of other Jobs. If false, the
     Batch service will not wait for the Job Preparation Task to complete. In this case, other Tasks
     of the Job can start executing on the Compute Node while the Job Preparation Task is still
     running; and even if the Job Preparation Task fails, new Tasks will continue to be scheduled on
     the Compute Node. The default value is true.
    :vartype wait_for_success: bool
    :ivar user_identity: The user identity under which the Job Preparation Task runs. If omitted,
     the Task runs as a non-administrative user unique to the Task on Windows Compute Nodes, or a
     non-administrative user unique to the Pool on Linux Compute Nodes.
    :vartype user_identity: ~azure.batch.models.UserIdentity
    :ivar rerun_on_node_reboot_after_success: Whether the Batch service should rerun the Job
     Preparation Task after a Compute Node reboots. The Job Preparation Task is always rerun if a
     Compute Node is reimaged, or if the Job Preparation Task did not complete (e.g. because the
     reboot occurred while the Task was running). Therefore, you should always write a Job
     Preparation Task to be idempotent and to behave correctly if run multiple times. The default
     value is true.
    :vartype rerun_on_node_reboot_after_success: bool
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A string that uniquely identifies the Job Preparation Task within the Job. The ID can contain
     any combination of alphanumeric characters including hyphens and underscores and cannot contain
     more than 64 characters. If you do not specify this property, the Batch service assigns a
     default value of 'jobpreparation'. No other Task in the Job can have the same ID as the Job
     Preparation Task. If you try to submit a Task with the same id, the Batch service rejects the
     request with error code TaskIdSameAsJobPreparationTask; if you are calling the REST API
     directly, the HTTP status code is 409 (Conflict)."""
    command_line: str = rest_field(name="commandLine", visibility=["read", "create", "update", "delete", "query"])
    """The command line of the Job Preparation Task. The command line does not run under a shell, and
     therefore cannot take advantage of shell features such as environment variable expansion. If
     you want to take advantage of such features, you should invoke the shell in the command line,
     for example using \"cmd /c MyCommand\" in Windows or \"/bin/sh -c MyCommand\" in Linux. If the
     command line refers to file paths, it should use a relative path (relative to the Task working
     directory), or use the Batch provided environment variable
     (`https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables
     <https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables>`_).
     Required."""
    container_settings: Optional["_models.BatchTaskContainerSettings"] = rest_field(
        name="containerSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The settings for the container under which the Job Preparation Task runs. When this is
     specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure
     Batch directories on the node) are mapped into the container, all Task environment variables
     are mapped into the container, and the Task command line is executed in the container. Files
     produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host
     disk, meaning that Batch file APIs will not be able to access those files."""
    resource_files: Optional[list["_models.ResourceFile"]] = rest_field(
        name="resourceFiles", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of files that the Batch service will download to the Compute Node before running the
     command line. Files listed under this element are located in the Task's working directory.
     There is a maximum size for the list of resource files.  When the max size is exceeded, the
     request will fail and the response error code will be RequestEntityTooLarge. If this occurs,
     the collection of ResourceFiles must be reduced in size. This can be achieved using .zip files,
     Application Packages, or Docker Containers."""
    environment_settings: Optional[list["_models.EnvironmentSetting"]] = rest_field(
        name="environmentSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of environment variable settings for the Job Preparation Task."""
    constraints: Optional["_models.BatchTaskConstraints"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Constraints that apply to the Job Preparation Task."""
    wait_for_success: Optional[bool] = rest_field(
        name="waitForSuccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the Batch service should wait for the Job Preparation Task to complete successfully
     before scheduling any other Tasks of the Job on the Compute Node. A Job Preparation Task has
     completed successfully if it exits with exit code 0. If true and the Job Preparation Task fails
     on a Node, the Batch service retries the Job Preparation Task up to its maximum retry count (as
     specified in the constraints element). If the Task has still not completed successfully after
     all retries, then the Batch service will not schedule Tasks of the Job to the Node. The Node
     remains active and eligible to run Tasks of other Jobs. If false, the Batch service will not
     wait for the Job Preparation Task to complete. In this case, other Tasks of the Job can start
     executing on the Compute Node while the Job Preparation Task is still running; and even if the
     Job Preparation Task fails, new Tasks will continue to be scheduled on the Compute Node. The
     default value is true."""
    user_identity: Optional["_models.UserIdentity"] = rest_field(
        name="userIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user identity under which the Job Preparation Task runs. If omitted, the Task runs as a
     non-administrative user unique to the Task on Windows Compute Nodes, or a non-administrative
     user unique to the Pool on Linux Compute Nodes."""
    rerun_on_node_reboot_after_success: Optional[bool] = rest_field(
        name="rerunOnNodeRebootAfterSuccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the Batch service should rerun the Job Preparation Task after a Compute Node reboots.
     The Job Preparation Task is always rerun if a Compute Node is reimaged, or if the Job
     Preparation Task did not complete (e.g. because the reboot occurred while the Task was
     running). Therefore, you should always write a Job Preparation Task to be idempotent and to
     behave correctly if run multiple times. The default value is true."""

    @overload
    def __init__(
        self,
        *,
        command_line: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        container_settings: Optional["_models.BatchTaskContainerSettings"] = None,
        resource_files: Optional[list["_models.ResourceFile"]] = None,
        environment_settings: Optional[list["_models.EnvironmentSetting"]] = None,
        constraints: Optional["_models.BatchTaskConstraints"] = None,
        wait_for_success: Optional[bool] = None,
        user_identity: Optional["_models.UserIdentity"] = None,
        rerun_on_node_reboot_after_success: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobPreparationTaskExecutionInfo(_Model):
    """Contains information about the execution of a Job Preparation Task on a Compute
    Node.

    :ivar start_time: The time at which the Task started running. If the Task has been restarted or
     retried, this is the most recent time at which the Task started running. Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The time at which the Job Preparation Task completed. This property is set only
     if the Task is in the Completed state.
    :vartype end_time: ~datetime.datetime
    :ivar state: The current state of the Job Preparation Task on the Compute Node. Required. Known
     values are: "running" and "completed".
    :vartype state: str or ~azure.batch.models.BatchJobPreparationTaskState
    :ivar task_root_directory: The root directory of the Job Preparation Task on the Compute Node.
     You can use this path to retrieve files created by the Task, such as log files.
    :vartype task_root_directory: str
    :ivar task_root_directory_url: The URL to the root directory of the Job Preparation Task on the
     Compute Node.
    :vartype task_root_directory_url: str
    :ivar exit_code: The exit code of the program specified on the Task command line. This
     parameter is returned only if the Task is in the completed state. The exit code for a process
     reflects the specific convention implemented by the application developer for that process. If
     you use the exit code value to make decisions in your code, be sure that you know the exit code
     convention used by the application process. Note that the exit code may also be generated by
     the Compute Node operating system, such as when a process is forcibly terminated.
    :vartype exit_code: int
    :ivar container_info: Information about the container under which the Task is executing. This
     property is set only if the Task runs in a container context.
    :vartype container_info: ~azure.batch.models.BatchTaskContainerExecutionInfo
    :ivar failure_info: Information describing the Task failure, if any. This property is set only
     if the Task is in the completed state and encountered a failure.
    :vartype failure_info: ~azure.batch.models.BatchTaskFailureInfo
    :ivar retry_count: The number of times the Task has been retried by the Batch service. Task
     application failures (non-zero exit code) are retried, pre-processing errors (the Task could
     not be run) and file upload errors are not retried. The Batch service will retry the Task up to
     the limit specified by the constraints. Task application failures (non-zero exit code) are
     retried, pre-processing errors (the Task could not be run) and file upload errors are not
     retried. The Batch service will retry the Task up to the limit specified by the constraints.
     Required.
    :vartype retry_count: int
    :ivar last_retry_time: The most recent time at which a retry of the Job Preparation Task
     started running. This property is set only if the Task was retried (i.e. retryCount is
     nonzero). If present, this is typically the same as startTime, but may be different if the Task
     has been restarted for reasons other than retry; for example, if the Compute Node was rebooted
     during a retry, then the startTime is updated but the lastRetryTime is not.
    :vartype last_retry_time: ~datetime.datetime
    :ivar result: The result of the Task execution. If the value is 'failed', then the details of
     the failure can be found in the failureInfo property. Known values are: "success" and
     "failure".
    :vartype result: str or ~azure.batch.models.BatchTaskExecutionResult
    """

    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the Task started running. If the Task has been restarted or retried, this is
     the most recent time at which the Task started running. Required."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the Job Preparation Task completed. This property is set only if the Task is
     in the Completed state."""
    state: Union[str, "_models.BatchJobPreparationTaskState"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The current state of the Job Preparation Task on the Compute Node. Required. Known values are:
     \"running\" and \"completed\"."""
    task_root_directory: Optional[str] = rest_field(
        name="taskRootDirectory", visibility=["read", "create", "update", "delete", "query"]
    )
    """The root directory of the Job Preparation Task on the Compute Node. You can use this path to
     retrieve files created by the Task, such as log files."""
    task_root_directory_url: Optional[str] = rest_field(
        name="taskRootDirectoryUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URL to the root directory of the Job Preparation Task on the Compute Node."""
    exit_code: Optional[int] = rest_field(name="exitCode", visibility=["read", "create", "update", "delete", "query"])
    """The exit code of the program specified on the Task command line. This parameter is returned
     only if the Task is in the completed state. The exit code for a process reflects the specific
     convention implemented by the application developer for that process. If you use the exit code
     value to make decisions in your code, be sure that you know the exit code convention used by
     the application process. Note that the exit code may also be generated by the Compute Node
     operating system, such as when a process is forcibly terminated."""
    container_info: Optional["_models.BatchTaskContainerExecutionInfo"] = rest_field(
        name="containerInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information about the container under which the Task is executing. This property is set only if
     the Task runs in a container context."""
    failure_info: Optional["_models.BatchTaskFailureInfo"] = rest_field(
        name="failureInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information describing the Task failure, if any. This property is set only if the Task is in
     the completed state and encountered a failure."""
    retry_count: int = rest_field(name="retryCount", visibility=["read", "create", "update", "delete", "query"])
    """The number of times the Task has been retried by the Batch service. Task application failures
     (non-zero exit code) are retried, pre-processing errors (the Task could not be run) and file
     upload errors are not retried. The Batch service will retry the Task up to the limit specified
     by the constraints. Task application failures (non-zero exit code) are retried, pre-processing
     errors (the Task could not be run) and file upload errors are not retried. The Batch service
     will retry the Task up to the limit specified by the constraints. Required."""
    last_retry_time: Optional[datetime.datetime] = rest_field(
        name="lastRetryTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The most recent time at which a retry of the Job Preparation Task started running. This
     property is set only if the Task was retried (i.e. retryCount is nonzero). If present, this is
     typically the same as startTime, but may be different if the Task has been restarted for
     reasons other than retry; for example, if the Compute Node was rebooted during a retry, then
     the startTime is updated but the lastRetryTime is not."""
    result: Optional[Union[str, "_models.BatchTaskExecutionResult"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The result of the Task execution. If the value is 'failed', then the details of the failure can
     be found in the failureInfo property. Known values are: \"success\" and \"failure\"."""

    @overload
    def __init__(
        self,
        *,
        start_time: datetime.datetime,
        state: Union[str, "_models.BatchJobPreparationTaskState"],
        retry_count: int,
        end_time: Optional[datetime.datetime] = None,
        task_root_directory: Optional[str] = None,
        task_root_directory_url: Optional[str] = None,
        exit_code: Optional[int] = None,
        container_info: Optional["_models.BatchTaskContainerExecutionInfo"] = None,
        failure_info: Optional["_models.BatchTaskFailureInfo"] = None,
        last_retry_time: Optional[datetime.datetime] = None,
        result: Optional[Union[str, "_models.BatchTaskExecutionResult"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobReleaseTask(_Model):
    """A Job Release Task to run on Job completion on any Compute Node where the Job has run.
    The Job Release Task runs when the Job ends, because of one of the following:
    The user calls the Terminate Job API, or the Delete Job API while the Job is
    still active, the Job's maximum wall clock time constraint is reached, and the
    Job is still active, or the Job's Job Manager Task completed, and the Job is
    configured to terminate when the Job Manager completes. The Job Release Task
    runs on each Node where Tasks of the Job have run and the Job Preparation Task
    ran and completed. If you reimage a Node after it has run the Job Preparation
    Task, and the Job ends without any further Tasks of the Job running on that
    Node (and hence the Job Preparation Task does not re-run), then the Job Release
    Task does not run on that Compute Node. If a Node reboots while the Job Release
    Task is still running, the Job Release Task runs again when the Compute Node
    starts up. The Job is not marked as complete until all Job Release Tasks have
    completed. The Job Release Task runs in the background. It does not occupy a
    scheduling slot; that is, it does not count towards the taskSlotsPerNode limit
    specified on the Pool.

    :ivar id: A string that uniquely identifies the Job Release Task within the Job. The ID can
     contain any combination of alphanumeric characters including hyphens and underscores and cannot
     contain more than 64 characters. If you do not specify this property, the Batch service assigns
     a default value of 'jobrelease'. No other Task in the Job can have the same ID as the Job
     Release Task. If you try to submit a Task with the same id, the Batch service rejects the
     request with error code TaskIdSameAsJobReleaseTask; if you are calling the REST API directly,
     the HTTP status code is 409 (Conflict).
    :vartype id: str
    :ivar command_line: The command line of the Job Release Task. The command line does not run
     under a shell, and therefore cannot take advantage of shell features such as environment
     variable expansion. If you want to take advantage of such features, you should invoke the shell
     in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand"
     in Linux. If the command line refers to file paths, it should use a relative path (relative to
     the Task working directory), or use the Batch provided environment variable
     (`https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables
     <https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables>`_).
     Required.
    :vartype command_line: str
    :ivar container_settings: The settings for the container under which the Job Release Task runs.
     When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root
     of Azure Batch directories on the node) are mapped into the container, all Task environment
     variables are mapped into the container, and the Task command line is executed in the
     container. Files produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be
     reflected to the host disk, meaning that Batch file APIs will not be able to access those
     files.
    :vartype container_settings: ~azure.batch.models.BatchTaskContainerSettings
    :ivar resource_files: A list of files that the Batch service will download to the Compute Node
     before running the command line.  There is a maximum size for the list of resource files.  When
     the max size is exceeded, the request will fail and the response error code will be
     RequestEntityTooLarge. If this occurs, the collection of ResourceFiles must be reduced in size.
     This can be achieved using .zip files, Application Packages, or Docker Containers. Files listed
     under this element are located in the Task's working directory.
    :vartype resource_files: list[~azure.batch.models.ResourceFile]
    :ivar environment_settings: A list of environment variable settings for the Job Release Task.
    :vartype environment_settings: list[~azure.batch.models.EnvironmentSetting]
    :ivar max_wall_clock_time: The maximum elapsed time that the Job Release Task may run on a
     given Compute Node, measured from the time the Task starts. If the Task does not complete
     within the time limit, the Batch service terminates it. The default value is 15 minutes. You
     may not specify a timeout longer than 15 minutes. If you do, the Batch service rejects it with
     an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
    :vartype max_wall_clock_time: ~datetime.timedelta
    :ivar retention_time: The minimum time to retain the Task directory for the Job Release Task on
     the Compute Node. After this time, the Batch service may delete the Task directory and all its
     contents. The default is 7 days, i.e. the Task directory will be retained for 7 days unless the
     Compute Node is removed or the Job is deleted.
    :vartype retention_time: ~datetime.timedelta
    :ivar user_identity: The user identity under which the Job Release Task runs. If omitted, the
     Task runs as a non-administrative user unique to the Task.
    :vartype user_identity: ~azure.batch.models.UserIdentity
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A string that uniquely identifies the Job Release Task within the Job. The ID can contain any
     combination of alphanumeric characters including hyphens and underscores and cannot contain
     more than 64 characters. If you do not specify this property, the Batch service assigns a
     default value of 'jobrelease'. No other Task in the Job can have the same ID as the Job Release
     Task. If you try to submit a Task with the same id, the Batch service rejects the request with
     error code TaskIdSameAsJobReleaseTask; if you are calling the REST API directly, the HTTP
     status code is 409 (Conflict)."""
    command_line: str = rest_field(name="commandLine", visibility=["read", "create", "update", "delete", "query"])
    """The command line of the Job Release Task. The command line does not run under a shell, and
     therefore cannot take advantage of shell features such as environment variable expansion. If
     you want to take advantage of such features, you should invoke the shell in the command line,
     for example using \"cmd /c MyCommand\" in Windows or \"/bin/sh -c MyCommand\" in Linux. If the
     command line refers to file paths, it should use a relative path (relative to the Task working
     directory), or use the Batch provided environment variable
     (`https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables
     <https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables>`_).
     Required."""
    container_settings: Optional["_models.BatchTaskContainerSettings"] = rest_field(
        name="containerSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The settings for the container under which the Job Release Task runs. When this is specified,
     all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch
     directories on the node) are mapped into the container, all Task environment variables are
     mapped into the container, and the Task command line is executed in the container. Files
     produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host
     disk, meaning that Batch file APIs will not be able to access those files."""
    resource_files: Optional[list["_models.ResourceFile"]] = rest_field(
        name="resourceFiles", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of files that the Batch service will download to the Compute Node before running the
     command line.  There is a maximum size for the list of resource files.  When the max size is
     exceeded, the request will fail and the response error code will be RequestEntityTooLarge. If
     this occurs, the collection of ResourceFiles must be reduced in size. This can be achieved
     using .zip files, Application Packages, or Docker Containers. Files listed under this element
     are located in the Task's working directory."""
    environment_settings: Optional[list["_models.EnvironmentSetting"]] = rest_field(
        name="environmentSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of environment variable settings for the Job Release Task."""
    max_wall_clock_time: Optional[datetime.timedelta] = rest_field(
        name="maxWallClockTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum elapsed time that the Job Release Task may run on a given Compute Node, measured
     from the time the Task starts. If the Task does not complete within the time limit, the Batch
     service terminates it. The default value is 15 minutes. You may not specify a timeout longer
     than 15 minutes. If you do, the Batch service rejects it with an error; if you are calling the
     REST API directly, the HTTP status code is 400 (Bad Request)."""
    retention_time: Optional[datetime.timedelta] = rest_field(
        name="retentionTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The minimum time to retain the Task directory for the Job Release Task on the Compute Node.
     After this time, the Batch service may delete the Task directory and all its contents. The
     default is 7 days, i.e. the Task directory will be retained for 7 days unless the Compute Node
     is removed or the Job is deleted."""
    user_identity: Optional["_models.UserIdentity"] = rest_field(
        name="userIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user identity under which the Job Release Task runs. If omitted, the Task runs as a
     non-administrative user unique to the Task."""

    @overload
    def __init__(
        self,
        *,
        command_line: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        container_settings: Optional["_models.BatchTaskContainerSettings"] = None,
        resource_files: Optional[list["_models.ResourceFile"]] = None,
        environment_settings: Optional[list["_models.EnvironmentSetting"]] = None,
        max_wall_clock_time: Optional[datetime.timedelta] = None,
        retention_time: Optional[datetime.timedelta] = None,
        user_identity: Optional["_models.UserIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobReleaseTaskExecutionInfo(_Model):
    """Contains information about the execution of a Job Release Task on a Compute
    Node.

    :ivar start_time: The time at which the Task started running. If the Task has been restarted or
     retried, this is the most recent time at which the Task started running. Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The time at which the Job Release Task completed. This property is set only if
     the Task is in the Completed state.
    :vartype end_time: ~datetime.datetime
    :ivar state: The current state of the Job Release Task on the Compute Node. Required. Known
     values are: "running" and "completed".
    :vartype state: str or ~azure.batch.models.BatchJobReleaseTaskState
    :ivar task_root_directory: The root directory of the Job Release Task on the Compute Node. You
     can use this path to retrieve files created by the Task, such as log files.
    :vartype task_root_directory: str
    :ivar task_root_directory_url: The URL to the root directory of the Job Release Task on the
     Compute Node.
    :vartype task_root_directory_url: str
    :ivar exit_code: The exit code of the program specified on the Task command line. This
     parameter is returned only if the Task is in the completed state. The exit code for a process
     reflects the specific convention implemented by the application developer for that process. If
     you use the exit code value to make decisions in your code, be sure that you know the exit code
     convention used by the application process. Note that the exit code may also be generated by
     the Compute Node operating system, such as when a process is forcibly terminated.
    :vartype exit_code: int
    :ivar container_info: Information about the container under which the Task is executing. This
     property is set only if the Task runs in a container context.
    :vartype container_info: ~azure.batch.models.BatchTaskContainerExecutionInfo
    :ivar failure_info: Information describing the Task failure, if any. This property is set only
     if the Task is in the completed state and encountered a failure.
    :vartype failure_info: ~azure.batch.models.BatchTaskFailureInfo
    :ivar result: The result of the Task execution. If the value is 'failed', then the details of
     the failure can be found in the failureInfo property. Known values are: "success" and
     "failure".
    :vartype result: str or ~azure.batch.models.BatchTaskExecutionResult
    """

    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the Task started running. If the Task has been restarted or retried, this is
     the most recent time at which the Task started running. Required."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the Job Release Task completed. This property is set only if the Task is in
     the Completed state."""
    state: Union[str, "_models.BatchJobReleaseTaskState"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The current state of the Job Release Task on the Compute Node. Required. Known values are:
     \"running\" and \"completed\"."""
    task_root_directory: Optional[str] = rest_field(
        name="taskRootDirectory", visibility=["read", "create", "update", "delete", "query"]
    )
    """The root directory of the Job Release Task on the Compute Node. You can use this path to
     retrieve files created by the Task, such as log files."""
    task_root_directory_url: Optional[str] = rest_field(
        name="taskRootDirectoryUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URL to the root directory of the Job Release Task on the Compute Node."""
    exit_code: Optional[int] = rest_field(name="exitCode", visibility=["read", "create", "update", "delete", "query"])
    """The exit code of the program specified on the Task command line. This parameter is returned
     only if the Task is in the completed state. The exit code for a process reflects the specific
     convention implemented by the application developer for that process. If you use the exit code
     value to make decisions in your code, be sure that you know the exit code convention used by
     the application process. Note that the exit code may also be generated by the Compute Node
     operating system, such as when a process is forcibly terminated."""
    container_info: Optional["_models.BatchTaskContainerExecutionInfo"] = rest_field(
        name="containerInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information about the container under which the Task is executing. This property is set only if
     the Task runs in a container context."""
    failure_info: Optional["_models.BatchTaskFailureInfo"] = rest_field(
        name="failureInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information describing the Task failure, if any. This property is set only if the Task is in
     the completed state and encountered a failure."""
    result: Optional[Union[str, "_models.BatchTaskExecutionResult"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The result of the Task execution. If the value is 'failed', then the details of the failure can
     be found in the failureInfo property. Known values are: \"success\" and \"failure\"."""

    @overload
    def __init__(
        self,
        *,
        start_time: datetime.datetime,
        state: Union[str, "_models.BatchJobReleaseTaskState"],
        end_time: Optional[datetime.datetime] = None,
        task_root_directory: Optional[str] = None,
        task_root_directory_url: Optional[str] = None,
        exit_code: Optional[int] = None,
        container_info: Optional["_models.BatchTaskContainerExecutionInfo"] = None,
        failure_info: Optional["_models.BatchTaskFailureInfo"] = None,
        result: Optional[Union[str, "_models.BatchTaskExecutionResult"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobSchedule(_Model):
    """A Job Schedule that allows recurring Jobs by specifying when to run Jobs and a
    specification used to create each Job.

    :ivar id: A string that uniquely identifies the schedule within the Account. Required.
    :vartype id: str
    :ivar display_name: The display name for the schedule.
    :vartype display_name: str
    :ivar url: The URL of the Job Schedule. Required.
    :vartype url: str
    :ivar e_tag: The ETag of the Job Schedule. This is an opaque string. You can use it to detect
     whether the Job Schedule has changed between requests. In particular, you can be pass the ETag
     with an Update Job Schedule request to specify that your changes should take effect only if
     nobody else has modified the schedule in the meantime. Required.
    :vartype e_tag: str
    :ivar last_modified: The last modified time of the Job Schedule. This is the last time at which
     the schedule level data, such as the Job specification or recurrence information, changed. It
     does not factor in job-level changes such as new Jobs being created or Jobs changing state.
     Required.
    :vartype last_modified: ~datetime.datetime
    :ivar creation_time: The creation time of the Job Schedule. Required.
    :vartype creation_time: ~datetime.datetime
    :ivar state: The current state of the Job Schedule. Required. Known values are: "active",
     "completed", "disabled", "terminating", and "deleting".
    :vartype state: str or ~azure.batch.models.BatchJobScheduleState
    :ivar state_transition_time: The time at which the Job Schedule entered the current state.
     Required.
    :vartype state_transition_time: ~datetime.datetime
    :ivar previous_state: The previous state of the Job Schedule. This property is not present if
     the Job Schedule is in its initial active state. Known values are: "active", "completed",
     "disabled", "terminating", and "deleting".
    :vartype previous_state: str or ~azure.batch.models.BatchJobScheduleState
    :ivar previous_state_transition_time: The time at which the Job Schedule entered its previous
     state. This property is not present if the Job Schedule is in its initial active state.
    :vartype previous_state_transition_time: ~datetime.datetime
    :ivar schedule: The schedule according to which Jobs will be created. All times are fixed
     respective to UTC and are not impacted by daylight saving time.
    :vartype schedule: ~azure.batch.models.BatchJobScheduleConfiguration
    :ivar job_specification: The details of the Jobs to be created on this schedule. Required.
    :vartype job_specification: ~azure.batch.models.BatchJobSpecification
    :ivar execution_info: Information about Jobs that have been and will be run under this
     schedule. Required.
    :vartype execution_info: ~azure.batch.models.BatchJobScheduleExecutionInfo
    :ivar metadata: A list of name-value pairs associated with the schedule as metadata. The Batch
     service does not assign any meaning to metadata; it is solely for the use of user code.
    :vartype metadata: list[~azure.batch.models.BatchMetadataItem]
    :ivar job_schedule_statistics: The lifetime resource usage statistics for the Job Schedule. The
     statistics may not be immediately available. The Batch service performs periodic roll-up of
     statistics. The typical delay is about 30 minutes.
    :vartype job_schedule_statistics: ~azure.batch.models.BatchJobScheduleStatistics
    """

    id: str = rest_field(visibility=["read"])
    """A string that uniquely identifies the schedule within the Account. Required."""
    display_name: Optional[str] = rest_field(name="displayName", visibility=["read"])
    """The display name for the schedule."""
    url: str = rest_field(visibility=["read"])
    """The URL of the Job Schedule. Required."""
    e_tag: str = rest_field(name="eTag", visibility=["read"])
    """The ETag of the Job Schedule. This is an opaque string. You can use it to detect whether the
     Job Schedule has changed between requests. In particular, you can be pass the ETag with an
     Update Job Schedule request to specify that your changes should take effect only if nobody else
     has modified the schedule in the meantime. Required."""
    last_modified: datetime.datetime = rest_field(name="lastModified", visibility=["read"], format="rfc3339")
    """The last modified time of the Job Schedule. This is the last time at which the schedule level
     data, such as the Job specification or recurrence information, changed. It does not factor in
     job-level changes such as new Jobs being created or Jobs changing state. Required."""
    creation_time: datetime.datetime = rest_field(name="creationTime", visibility=["read"], format="rfc3339")
    """The creation time of the Job Schedule. Required."""
    state: Union[str, "_models.BatchJobScheduleState"] = rest_field(visibility=["read"])
    """The current state of the Job Schedule. Required. Known values are: \"active\", \"completed\",
     \"disabled\", \"terminating\", and \"deleting\"."""
    state_transition_time: datetime.datetime = rest_field(
        name="stateTransitionTime", visibility=["read"], format="rfc3339"
    )
    """The time at which the Job Schedule entered the current state. Required."""
    previous_state: Optional[Union[str, "_models.BatchJobScheduleState"]] = rest_field(
        name="previousState", visibility=["read"]
    )
    """The previous state of the Job Schedule. This property is not present if the Job Schedule is in
     its initial active state. Known values are: \"active\", \"completed\", \"disabled\",
     \"terminating\", and \"deleting\"."""
    previous_state_transition_time: Optional[datetime.datetime] = rest_field(
        name="previousStateTransitionTime", visibility=["read"], format="rfc3339"
    )
    """The time at which the Job Schedule entered its previous state. This property is not present if
     the Job Schedule is in its initial active state."""
    schedule: Optional["_models.BatchJobScheduleConfiguration"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The schedule according to which Jobs will be created. All times are fixed respective to UTC and
     are not impacted by daylight saving time."""
    job_specification: "_models.BatchJobSpecification" = rest_field(
        name="jobSpecification", visibility=["read", "create", "update", "delete", "query"]
    )
    """The details of the Jobs to be created on this schedule. Required."""
    execution_info: "_models.BatchJobScheduleExecutionInfo" = rest_field(name="executionInfo", visibility=["read"])
    """Information about Jobs that have been and will be run under this schedule. Required."""
    metadata: Optional[list["_models.BatchMetadataItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of name-value pairs associated with the schedule as metadata. The Batch service does not
     assign any meaning to metadata; it is solely for the use of user code."""
    job_schedule_statistics: Optional["_models.BatchJobScheduleStatistics"] = rest_field(
        name="stats", visibility=["read"]
    )
    """The lifetime resource usage statistics for the Job Schedule. The statistics may not be
     immediately available. The Batch service performs periodic roll-up of statistics. The typical
     delay is about 30 minutes."""

    @overload
    def __init__(
        self,
        *,
        job_specification: "_models.BatchJobSpecification",
        schedule: Optional["_models.BatchJobScheduleConfiguration"] = None,
        metadata: Optional[list["_models.BatchMetadataItem"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobScheduleConfiguration(_Model):
    """The schedule according to which Jobs will be created. All times are fixed
    respective to UTC and are not impacted by daylight saving time.

    :ivar do_not_run_until: The earliest time at which any Job may be created under this Job
     Schedule. If you do not specify a doNotRunUntil time, the schedule becomes ready to create Jobs
     immediately.
    :vartype do_not_run_until: ~datetime.datetime
    :ivar do_not_run_after: A time after which no Job will be created under this Job Schedule. The
     schedule will move to the completed state as soon as this deadline is past and there is no
     active Job under this Job Schedule. If you do not specify a doNotRunAfter time, and you are
     creating a recurring Job Schedule, the Job Schedule will remain active until you explicitly
     terminate it.
    :vartype do_not_run_after: ~datetime.datetime
    :ivar start_window: The time interval, starting from the time at which the schedule indicates a
     Job should be created, within which a Job must be created. If a Job is not created within the
     startWindow interval, then the 'opportunity' is lost; no Job will be created until the next
     recurrence of the schedule. If the schedule is recurring, and the startWindow is longer than
     the recurrence interval, then this is equivalent to an infinite startWindow, because the Job
     that is 'due' in one recurrenceInterval is not carried forward into the next recurrence
     interval. The default is infinite. The minimum value is 1 minute. If you specify a lower value,
     the Batch service rejects the schedule with an error; if you are calling the REST API directly,
     the HTTP status code is 400 (Bad Request).
    :vartype start_window: ~datetime.timedelta
    :ivar recurrence_interval: The time interval between the start times of two successive Jobs
     under the Job Schedule. A Job Schedule can have at most one active Job under it at any given
     time. Because a Job Schedule can have at most one active Job under it at any given time, if it
     is time to create a new Job under a Job Schedule, but the previous Job is still running, the
     Batch service will not create the new Job until the previous Job finishes. If the previous Job
     does not finish within the startWindow period of the new recurrenceInterval, then no new Job
     will be scheduled for that interval. For recurring Jobs, you should normally specify a
     jobManagerTask in the jobSpecification. If you do not use jobManagerTask, you will need an
     external process to monitor when Jobs are created, add Tasks to the Jobs and terminate the Jobs
     ready for the next recurrence. The default is that the schedule does not recur: one Job is
     created, within the startWindow after the doNotRunUntil time, and the schedule is complete as
     soon as that Job finishes. The minimum value is 1 minute. If you specify a lower value, the
     Batch service rejects the schedule with an error; if you are calling the REST API directly, the
     HTTP status code is 400 (Bad Request).
    :vartype recurrence_interval: ~datetime.timedelta
    """

    do_not_run_until: Optional[datetime.datetime] = rest_field(
        name="doNotRunUntil", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The earliest time at which any Job may be created under this Job Schedule. If you do not
     specify a doNotRunUntil time, the schedule becomes ready to create Jobs immediately."""
    do_not_run_after: Optional[datetime.datetime] = rest_field(
        name="doNotRunAfter", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """A time after which no Job will be created under this Job Schedule. The schedule will move to
     the completed state as soon as this deadline is past and there is no active Job under this Job
     Schedule. If you do not specify a doNotRunAfter time, and you are creating a recurring Job
     Schedule, the Job Schedule will remain active until you explicitly terminate it."""
    start_window: Optional[datetime.timedelta] = rest_field(
        name="startWindow", visibility=["read", "create", "update", "delete", "query"]
    )
    """The time interval, starting from the time at which the schedule indicates a Job should be
     created, within which a Job must be created. If a Job is not created within the startWindow
     interval, then the 'opportunity' is lost; no Job will be created until the next recurrence of
     the schedule. If the schedule is recurring, and the startWindow is longer than the recurrence
     interval, then this is equivalent to an infinite startWindow, because the Job that is 'due' in
     one recurrenceInterval is not carried forward into the next recurrence interval. The default is
     infinite. The minimum value is 1 minute. If you specify a lower value, the Batch service
     rejects the schedule with an error; if you are calling the REST API directly, the HTTP status
     code is 400 (Bad Request)."""
    recurrence_interval: Optional[datetime.timedelta] = rest_field(
        name="recurrenceInterval", visibility=["read", "create", "update", "delete", "query"]
    )
    """The time interval between the start times of two successive Jobs under the Job Schedule. A Job
     Schedule can have at most one active Job under it at any given time. Because a Job Schedule can
     have at most one active Job under it at any given time, if it is time to create a new Job under
     a Job Schedule, but the previous Job is still running, the Batch service will not create the
     new Job until the previous Job finishes. If the previous Job does not finish within the
     startWindow period of the new recurrenceInterval, then no new Job will be scheduled for that
     interval. For recurring Jobs, you should normally specify a jobManagerTask in the
     jobSpecification. If you do not use jobManagerTask, you will need an external process to
     monitor when Jobs are created, add Tasks to the Jobs and terminate the Jobs ready for the next
     recurrence. The default is that the schedule does not recur: one Job is created, within the
     startWindow after the doNotRunUntil time, and the schedule is complete as soon as that Job
     finishes. The minimum value is 1 minute. If you specify a lower value, the Batch service
     rejects the schedule with an error; if you are calling the REST API directly, the HTTP status
     code is 400 (Bad Request)."""

    @overload
    def __init__(
        self,
        *,
        do_not_run_until: Optional[datetime.datetime] = None,
        do_not_run_after: Optional[datetime.datetime] = None,
        start_window: Optional[datetime.timedelta] = None,
        recurrence_interval: Optional[datetime.timedelta] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobScheduleCreateOptions(_Model):
    """Parameters for creating an Azure Batch Job Schedule.

    :ivar id: A string that uniquely identifies the schedule within the Account. The ID can contain
     any combination of alphanumeric characters including hyphens and underscores, and cannot
     contain more than 64 characters. The ID is case-preserving and case-insensitive (that is, you
     may not have two IDs within an Account that differ only by case). Required.
    :vartype id: str
    :ivar display_name: The display name for the schedule. The display name need not be unique and
     can contain any Unicode characters up to a maximum length of 1024.
    :vartype display_name: str
    :ivar schedule: The schedule according to which Jobs will be created. All times are fixed
     respective to UTC and are not impacted by daylight saving time. Required.
    :vartype schedule: ~azure.batch.models.BatchJobScheduleConfiguration
    :ivar job_specification: The details of the Jobs to be created on this schedule. Required.
    :vartype job_specification: ~azure.batch.models.BatchJobSpecification
    :ivar metadata: A list of name-value pairs associated with the schedule as metadata. The Batch
     service does not assign any meaning to metadata; it is solely for the use of user code.
    :vartype metadata: list[~azure.batch.models.BatchMetadataItem]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A string that uniquely identifies the schedule within the Account. The ID can contain any
     combination of alphanumeric characters including hyphens and underscores, and cannot contain
     more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not
     have two IDs within an Account that differ only by case). Required."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The display name for the schedule. The display name need not be unique and can contain any
     Unicode characters up to a maximum length of 1024."""
    schedule: "_models.BatchJobScheduleConfiguration" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The schedule according to which Jobs will be created. All times are fixed respective to UTC and
     are not impacted by daylight saving time. Required."""
    job_specification: "_models.BatchJobSpecification" = rest_field(
        name="jobSpecification", visibility=["read", "create", "update", "delete", "query"]
    )
    """The details of the Jobs to be created on this schedule. Required."""
    metadata: Optional[list["_models.BatchMetadataItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of name-value pairs associated with the schedule as metadata. The Batch service does not
     assign any meaning to metadata; it is solely for the use of user code."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        schedule: "_models.BatchJobScheduleConfiguration",
        job_specification: "_models.BatchJobSpecification",
        display_name: Optional[str] = None,
        metadata: Optional[list["_models.BatchMetadataItem"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobScheduleExecutionInfo(_Model):
    """Contains information about Jobs that have been and will be run under a Job
    Schedule.

    :ivar next_run_time: The next time at which a Job will be created under this schedule. This
     property is meaningful only if the schedule is in the active state when the time comes around.
     For example, if the schedule is disabled, no Job will be created at nextRunTime unless the Job
     is enabled before then.
    :vartype next_run_time: ~datetime.datetime
    :ivar recent_job: Information about the most recent Job under the Job Schedule. This property
     is present only if the at least one Job has run under the schedule.
    :vartype recent_job: ~azure.batch.models.RecentBatchJob
    :ivar end_time: The time at which the schedule ended. This property is set only if the Job
     Schedule is in the completed state.
    :vartype end_time: ~datetime.datetime
    """

    next_run_time: Optional[datetime.datetime] = rest_field(
        name="nextRunTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The next time at which a Job will be created under this schedule. This property is meaningful
     only if the schedule is in the active state when the time comes around. For example, if the
     schedule is disabled, no Job will be created at nextRunTime unless the Job is enabled before
     then."""
    recent_job: Optional["_models.RecentBatchJob"] = rest_field(
        name="recentJob", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information about the most recent Job under the Job Schedule. This property is present only if
     the at least one Job has run under the schedule."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the schedule ended. This property is set only if the Job Schedule is in the
     completed state."""

    @overload
    def __init__(
        self,
        *,
        next_run_time: Optional[datetime.datetime] = None,
        recent_job: Optional["_models.RecentBatchJob"] = None,
        end_time: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobScheduleStatistics(_Model):
    """Resource usage statistics for a Job Schedule.

    :ivar url: The URL of the statistics. Required.
    :vartype url: str
    :ivar start_time: The start time of the time range covered by the statistics. Required.
    :vartype start_time: ~datetime.datetime
    :ivar last_update_time: The time at which the statistics were last updated. All statistics are
     limited to the range between startTime and lastUpdateTime. Required.
    :vartype last_update_time: ~datetime.datetime
    :ivar user_cpu_time: The total user mode CPU time (summed across all cores and all Compute
     Nodes) consumed by all Tasks in all Jobs created under the schedule. Required.
    :vartype user_cpu_time: ~datetime.timedelta
    :ivar kernel_cpu_time: The total kernel mode CPU time (summed across all cores and all Compute
     Nodes) consumed by all Tasks in all Jobs created under the schedule. Required.
    :vartype kernel_cpu_time: ~datetime.timedelta
    :ivar wall_clock_time: The total wall clock time of all the Tasks in all the Jobs created under
     the schedule. The wall clock time is the elapsed time from when the Task started running on a
     Compute Node to when it finished (or to the last time the statistics were updated, if the Task
     had not finished by then). If a Task was retried, this includes the wall clock time of all the
     Task retries. Required.
    :vartype wall_clock_time: ~datetime.timedelta
    :ivar read_iops: The total number of disk read operations made by all Tasks in all Jobs created
     under the schedule. Required.
    :vartype read_iops: int
    :ivar write_iops: The total number of disk write operations made by all Tasks in all Jobs
     created under the schedule. Required.
    :vartype write_iops: int
    :ivar read_io_gib: The total gibibytes read from disk by all Tasks in all Jobs created under
     the schedule. Required.
    :vartype read_io_gib: float
    :ivar write_io_gib: The total gibibytes written to disk by all Tasks in all Jobs created under
     the schedule. Required.
    :vartype write_io_gib: float
    :ivar succeeded_tasks_count: The total number of Tasks successfully completed during the given
     time range in Jobs created under the schedule. A Task completes successfully if it returns exit
     code 0. Required.
    :vartype succeeded_tasks_count: int
    :ivar failed_tasks_count: The total number of Tasks that failed during the given time range in
     Jobs created under the schedule. A Task fails if it exhausts its maximum retry count without
     returning exit code 0. Required.
    :vartype failed_tasks_count: int
    :ivar task_retries_count: The total number of retries during the given time range on all Tasks
     in all Jobs created under the schedule. Required.
    :vartype task_retries_count: int
    :ivar wait_time: The total wait time of all Tasks in all Jobs created under the schedule. The
     wait time for a Task is defined as the elapsed time between the creation of the Task and the
     start of Task execution. (If the Task is retried due to failures, the wait time is the time to
     the most recent Task execution.). This value is only reported in the Account lifetime
     statistics; it is not included in the Job statistics. Required.
    :vartype wait_time: ~datetime.timedelta
    """

    url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL of the statistics. Required."""
    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The start time of the time range covered by the statistics. Required."""
    last_update_time: datetime.datetime = rest_field(
        name="lastUpdateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the statistics were last updated. All statistics are limited to the range
     between startTime and lastUpdateTime. Required."""
    user_cpu_time: datetime.timedelta = rest_field(
        name="userCPUTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total user mode CPU time (summed across all cores and all Compute Nodes) consumed by all
     Tasks in all Jobs created under the schedule. Required."""
    kernel_cpu_time: datetime.timedelta = rest_field(
        name="kernelCPUTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total kernel mode CPU time (summed across all cores and all Compute Nodes) consumed by all
     Tasks in all Jobs created under the schedule. Required."""
    wall_clock_time: datetime.timedelta = rest_field(
        name="wallClockTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total wall clock time of all the Tasks in all the Jobs created under the schedule. The wall
     clock time is the elapsed time from when the Task started running on a Compute Node to when it
     finished (or to the last time the statistics were updated, if the Task had not finished by
     then). If a Task was retried, this includes the wall clock time of all the Task retries.
     Required."""
    read_iops: int = rest_field(
        name="readIOps", visibility=["read", "create", "update", "delete", "query"], format="str"
    )
    """The total number of disk read operations made by all Tasks in all Jobs created under the
     schedule. Required."""
    write_iops: int = rest_field(
        name="writeIOps", visibility=["read", "create", "update", "delete", "query"], format="str"
    )
    """The total number of disk write operations made by all Tasks in all Jobs created under the
     schedule. Required."""
    read_io_gib: float = rest_field(name="readIOGiB", visibility=["read", "create", "update", "delete", "query"])
    """The total gibibytes read from disk by all Tasks in all Jobs created under the schedule.
     Required."""
    write_io_gib: float = rest_field(name="writeIOGiB", visibility=["read", "create", "update", "delete", "query"])
    """The total gibibytes written to disk by all Tasks in all Jobs created under the schedule.
     Required."""
    succeeded_tasks_count: int = rest_field(
        name="numSucceededTasks", visibility=["read", "create", "update", "delete", "query"], format="str"
    )
    """The total number of Tasks successfully completed during the given time range in Jobs created
     under the schedule. A Task completes successfully if it returns exit code 0. Required."""
    failed_tasks_count: int = rest_field(
        name="numFailedTasks", visibility=["read", "create", "update", "delete", "query"], format="str"
    )
    """The total number of Tasks that failed during the given time range in Jobs created under the
     schedule. A Task fails if it exhausts its maximum retry count without returning exit code 0.
     Required."""
    task_retries_count: int = rest_field(
        name="numTaskRetries", visibility=["read", "create", "update", "delete", "query"], format="str"
    )
    """The total number of retries during the given time range on all Tasks in all Jobs created under
     the schedule. Required."""
    wait_time: datetime.timedelta = rest_field(
        name="waitTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total wait time of all Tasks in all Jobs created under the schedule. The wait time for a
     Task is defined as the elapsed time between the creation of the Task and the start of Task
     execution. (If the Task is retried due to failures, the wait time is the time to the most
     recent Task execution.). This value is only reported in the Account lifetime statistics; it is
     not included in the Job statistics. Required."""

    @overload
    def __init__(
        self,
        *,
        url: str,
        start_time: datetime.datetime,
        last_update_time: datetime.datetime,
        user_cpu_time: datetime.timedelta,
        kernel_cpu_time: datetime.timedelta,
        wall_clock_time: datetime.timedelta,
        read_iops: int,
        write_iops: int,
        read_io_gib: float,
        write_io_gib: float,
        succeeded_tasks_count: int,
        failed_tasks_count: int,
        task_retries_count: int,
        wait_time: datetime.timedelta,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobScheduleUpdateOptions(_Model):
    """Parameters for updating an Azure Batch Job Schedule.

    :ivar schedule: The schedule according to which Jobs will be created. All times are fixed
     respective to UTC and are not impacted by daylight saving time. If you do not specify this
     element, the existing schedule is left unchanged.
    :vartype schedule: ~azure.batch.models.BatchJobScheduleConfiguration
    :ivar job_specification: The details of the Jobs to be created on this schedule. Updates affect
     only Jobs that are started after the update has taken place. Any currently active Job continues
     with the older specification.
    :vartype job_specification: ~azure.batch.models.BatchJobSpecification
    :ivar metadata: A list of name-value pairs associated with the Job Schedule as metadata. If you
     do not specify this element, existing metadata is left unchanged.
    :vartype metadata: list[~azure.batch.models.BatchMetadataItem]
    """

    schedule: Optional["_models.BatchJobScheduleConfiguration"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The schedule according to which Jobs will be created. All times are fixed respective to UTC and
     are not impacted by daylight saving time. If you do not specify this element, the existing
     schedule is left unchanged."""
    job_specification: Optional["_models.BatchJobSpecification"] = rest_field(
        name="jobSpecification", visibility=["read", "create", "update", "delete", "query"]
    )
    """The details of the Jobs to be created on this schedule. Updates affect only Jobs that are
     started after the update has taken place. Any currently active Job continues with the older
     specification."""
    metadata: Optional[list["_models.BatchMetadataItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of name-value pairs associated with the Job Schedule as metadata. If you do not specify
     this element, existing metadata is left unchanged."""

    @overload
    def __init__(
        self,
        *,
        schedule: Optional["_models.BatchJobScheduleConfiguration"] = None,
        job_specification: Optional["_models.BatchJobSpecification"] = None,
        metadata: Optional[list["_models.BatchMetadataItem"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobSchedulingError(_Model):
    """An error encountered by the Batch service when scheduling a Job.

    :ivar category: The category of the Job scheduling error. Required. Known values are:
     "usererror" and "servererror".
    :vartype category: str or ~azure.batch.models.BatchErrorSourceCategory
    :ivar code: An identifier for the Job scheduling error. Codes are invariant and are intended to
     be consumed programmatically.
    :vartype code: str
    :ivar message: A message describing the Job scheduling error, intended to be suitable for
     display in a user interface.
    :vartype message: str
    :ivar details: A list of additional error details related to the scheduling error.
    :vartype details: list[~azure.batch.models.NameValuePair]
    """

    category: Union[str, "_models.BatchErrorSourceCategory"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The category of the Job scheduling error. Required. Known values are: \"usererror\" and
     \"servererror\"."""
    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An identifier for the Job scheduling error. Codes are invariant and are intended to be consumed
     programmatically."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A message describing the Job scheduling error, intended to be suitable for display in a user
     interface."""
    details: Optional[list["_models.NameValuePair"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of additional error details related to the scheduling error."""

    @overload
    def __init__(
        self,
        *,
        category: Union[str, "_models.BatchErrorSourceCategory"],
        code: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[list["_models.NameValuePair"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobSpecification(_Model):
    """Specifies details of the Jobs to be created on a schedule.

    :ivar priority: The priority of Jobs created under this schedule. Priority values can range
     from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority.
     The default value is 0. This priority is used as the default for all Jobs under the Job
     Schedule. You can update a Job's priority after it has been created using by using the update
     Job API.
    :vartype priority: int
    :ivar allow_task_preemption: Whether Tasks in this job can be preempted by other high priority
     jobs. (This property is not available by default. Please contact support for more information)
     If the value is set to True, other high priority jobs submitted to the system will take
     precedence and will be able requeue tasks from this job. You can update a job's
     allowTaskPreemption after it has been created using the update job API.
    :vartype allow_task_preemption: bool
    :ivar max_parallel_tasks: The maximum number of tasks that can be executed in parallel for the
     job. (This property is not available by default. Please contact support for more information)
     The value of maxParallelTasks must be -1 or greater than 0 if specified. If not specified, the
     default value is -1, which means there's no limit to the number of tasks that can be run at
     once. You can update a job's maxParallelTasks after it has been created using the update job
     API.
    :vartype max_parallel_tasks: int
    :ivar display_name: The display name for Jobs created under this schedule. The name need not be
     unique and can contain any Unicode characters up to a maximum length of 1024.
    :vartype display_name: str
    :ivar uses_task_dependencies: Whether Tasks in the Job can define dependencies on each other.
     The default is false.
    :vartype uses_task_dependencies: bool
    :ivar all_tasks_complete_mode: The action the Batch service should take when all Tasks in a Job
     created under this schedule are in the completed state. Note that if a Job contains no Tasks,
     then all Tasks are considered complete. This option is therefore most commonly used with a Job
     Manager task; if you want to use automatic Job termination without a Job Manager, you should
     initially set onAllTasksComplete to noaction and update the Job properties to set
     onAllTasksComplete to terminatejob once you have finished adding Tasks. The default is
     noaction. Known values are: "noaction" and "terminatejob".
    :vartype all_tasks_complete_mode: str or ~azure.batch.models.BatchAllTasksCompleteMode
    :ivar task_failure_mode: The action the Batch service should take when any Task fails in a Job
     created under this schedule. A Task is considered to have failed if it have failed if has a
     failureInfo. A failureInfo is set if the Task completes with a non-zero exit code after
     exhausting its retry count, or if there was an error starting the Task, for example due to a
     resource file download error. The default is noaction. Known values are: "noaction" and
     "performexitoptionsjobaction".
    :vartype task_failure_mode: str or ~azure.batch.models.BatchTaskFailureMode
    :ivar network_configuration: (This property is not available by default. Please contact support
     for more information) The network configuration for the Job.
    :vartype network_configuration: ~azure.batch.models.BatchJobNetworkConfiguration
    :ivar constraints: The execution constraints for Jobs created under this schedule.
    :vartype constraints: ~azure.batch.models.BatchJobConstraints
    :ivar job_manager_task: The details of a Job Manager Task to be launched when a Job is started
     under this schedule. If the Job does not specify a Job Manager Task, the user must explicitly
     add Tasks to the Job using the Task API. If the Job does specify a Job Manager Task, the Batch
     service creates the Job Manager Task when the Job is created, and will try to schedule the Job
     Manager Task before scheduling other Tasks in the Job.
    :vartype job_manager_task: ~azure.batch.models.BatchJobManagerTask
    :ivar job_preparation_task: The Job Preparation Task for Jobs created under this schedule. If a
     Job has a Job Preparation Task, the Batch service will run the Job Preparation Task on a Node
     before starting any Tasks of that Job on that Compute Node.
    :vartype job_preparation_task: ~azure.batch.models.BatchJobPreparationTask
    :ivar job_release_task: The Job Release Task for Jobs created under this schedule. The primary
     purpose of the Job Release Task is to undo changes to Nodes made by the Job Preparation Task.
     Example activities include deleting local files, or shutting down services that were started as
     part of Job preparation. A Job Release Task cannot be specified without also specifying a Job
     Preparation Task for the Job. The Batch service runs the Job Release Task on the Compute Nodes
     that have run the Job Preparation Task.
    :vartype job_release_task: ~azure.batch.models.BatchJobReleaseTask
    :ivar common_environment_settings: A list of common environment variable settings. These
     environment variables are set for all Tasks in Jobs created under this schedule (including the
     Job Manager, Job Preparation and Job Release Tasks). Individual Tasks can override an
     environment setting specified here by specifying the same setting name with a different value.
    :vartype common_environment_settings: list[~azure.batch.models.EnvironmentSetting]
    :ivar pool_info: The Pool on which the Batch service runs the Tasks of Jobs created under this
     schedule. Required.
    :vartype pool_info: ~azure.batch.models.BatchPoolInfo
    :ivar metadata: A list of name-value pairs associated with each Job created under this schedule
     as metadata. The Batch service does not assign any meaning to metadata; it is solely for the
     use of user code.
    :vartype metadata: list[~azure.batch.models.BatchMetadataItem]
    """

    priority: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The priority of Jobs created under this schedule. Priority values can range from -1000 to 1000,
     with -1000 being the lowest priority and 1000 being the highest priority. The default value is
     0. This priority is used as the default for all Jobs under the Job Schedule. You can update a
     Job's priority after it has been created using by using the update Job API."""
    allow_task_preemption: Optional[bool] = rest_field(
        name="allowTaskPreemption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether Tasks in this job can be preempted by other high priority jobs. (This property is not
     available by default. Please contact support for more information) If the value is set to True,
     other high priority jobs submitted to the system will take precedence and will be able requeue
     tasks from this job. You can update a job's allowTaskPreemption after it has been created using
     the update job API."""
    max_parallel_tasks: Optional[int] = rest_field(
        name="maxParallelTasks", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of tasks that can be executed in parallel for the job. (This property is not
     available by default. Please contact support for more information) The value of
     maxParallelTasks must be -1 or greater than 0 if specified. If not specified, the default value
     is -1, which means there's no limit to the number of tasks that can be run at once. You can
     update a job's maxParallelTasks after it has been created using the update job API."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The display name for Jobs created under this schedule. The name need not be unique and can
     contain any Unicode characters up to a maximum length of 1024."""
    uses_task_dependencies: Optional[bool] = rest_field(
        name="usesTaskDependencies", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether Tasks in the Job can define dependencies on each other. The default is false."""
    all_tasks_complete_mode: Optional[Union[str, "_models.BatchAllTasksCompleteMode"]] = rest_field(
        name="onAllTasksComplete", visibility=["read", "create", "update", "delete", "query"]
    )
    """The action the Batch service should take when all Tasks in a Job created under this schedule
     are in the completed state. Note that if a Job contains no Tasks, then all Tasks are considered
     complete. This option is therefore most commonly used with a Job Manager task; if you want to
     use automatic Job termination without a Job Manager, you should initially set
     onAllTasksComplete to noaction and update the Job properties to set onAllTasksComplete to
     terminatejob once you have finished adding Tasks. The default is noaction. Known values are:
     \"noaction\" and \"terminatejob\"."""
    task_failure_mode: Optional[Union[str, "_models.BatchTaskFailureMode"]] = rest_field(
        name="onTaskFailure", visibility=["read", "create", "update", "delete", "query"]
    )
    """The action the Batch service should take when any Task fails in a Job created under this
     schedule. A Task is considered to have failed if it have failed if has a failureInfo. A
     failureInfo is set if the Task completes with a non-zero exit code after exhausting its retry
     count, or if there was an error starting the Task, for example due to a resource file download
     error. The default is noaction. Known values are: \"noaction\" and
     \"performexitoptionsjobaction\"."""
    network_configuration: Optional["_models.BatchJobNetworkConfiguration"] = rest_field(
        name="networkConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """(This property is not available by default. Please contact support for more information) The
     network configuration for the Job."""
    constraints: Optional["_models.BatchJobConstraints"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The execution constraints for Jobs created under this schedule."""
    job_manager_task: Optional["_models.BatchJobManagerTask"] = rest_field(
        name="jobManagerTask", visibility=["read", "create", "update", "delete", "query"]
    )
    """The details of a Job Manager Task to be launched when a Job is started under this schedule. If
     the Job does not specify a Job Manager Task, the user must explicitly add Tasks to the Job
     using the Task API. If the Job does specify a Job Manager Task, the Batch service creates the
     Job Manager Task when the Job is created, and will try to schedule the Job Manager Task before
     scheduling other Tasks in the Job."""
    job_preparation_task: Optional["_models.BatchJobPreparationTask"] = rest_field(
        name="jobPreparationTask", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Job Preparation Task for Jobs created under this schedule. If a Job has a Job Preparation
     Task, the Batch service will run the Job Preparation Task on a Node before starting any Tasks
     of that Job on that Compute Node."""
    job_release_task: Optional["_models.BatchJobReleaseTask"] = rest_field(
        name="jobReleaseTask", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Job Release Task for Jobs created under this schedule. The primary purpose of the Job
     Release Task is to undo changes to Nodes made by the Job Preparation Task. Example activities
     include deleting local files, or shutting down services that were started as part of Job
     preparation. A Job Release Task cannot be specified without also specifying a Job Preparation
     Task for the Job. The Batch service runs the Job Release Task on the Compute Nodes that have
     run the Job Preparation Task."""
    common_environment_settings: Optional[list["_models.EnvironmentSetting"]] = rest_field(
        name="commonEnvironmentSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of common environment variable settings. These environment variables are set for all
     Tasks in Jobs created under this schedule (including the Job Manager, Job Preparation and Job
     Release Tasks). Individual Tasks can override an environment setting specified here by
     specifying the same setting name with a different value."""
    pool_info: "_models.BatchPoolInfo" = rest_field(
        name="poolInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Pool on which the Batch service runs the Tasks of Jobs created under this schedule.
     Required."""
    metadata: Optional[list["_models.BatchMetadataItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of name-value pairs associated with each Job created under this schedule as metadata.
     The Batch service does not assign any meaning to metadata; it is solely for the use of user
     code."""

    @overload
    def __init__(
        self,
        *,
        pool_info: "_models.BatchPoolInfo",
        priority: Optional[int] = None,
        allow_task_preemption: Optional[bool] = None,
        max_parallel_tasks: Optional[int] = None,
        display_name: Optional[str] = None,
        uses_task_dependencies: Optional[bool] = None,
        all_tasks_complete_mode: Optional[Union[str, "_models.BatchAllTasksCompleteMode"]] = None,
        task_failure_mode: Optional[Union[str, "_models.BatchTaskFailureMode"]] = None,
        network_configuration: Optional["_models.BatchJobNetworkConfiguration"] = None,
        constraints: Optional["_models.BatchJobConstraints"] = None,
        job_manager_task: Optional["_models.BatchJobManagerTask"] = None,
        job_preparation_task: Optional["_models.BatchJobPreparationTask"] = None,
        job_release_task: Optional["_models.BatchJobReleaseTask"] = None,
        common_environment_settings: Optional[list["_models.EnvironmentSetting"]] = None,
        metadata: Optional[list["_models.BatchMetadataItem"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobStatistics(_Model):
    """Resource usage statistics for a Job.

    :ivar url: The URL of the statistics. Required.
    :vartype url: str
    :ivar start_time: The start time of the time range covered by the statistics. Required.
    :vartype start_time: ~datetime.datetime
    :ivar last_update_time: The time at which the statistics were last updated. All statistics are
     limited to the range between startTime and lastUpdateTime. Required.
    :vartype last_update_time: ~datetime.datetime
    :ivar user_cpu_time: The total user mode CPU time (summed across all cores and all Compute
     Nodes) consumed by all Tasks in the Job. Required.
    :vartype user_cpu_time: ~datetime.timedelta
    :ivar kernel_cpu_time: The total kernel mode CPU time (summed across all cores and all Compute
     Nodes) consumed by all Tasks in the Job. Required.
    :vartype kernel_cpu_time: ~datetime.timedelta
    :ivar wall_clock_time: The total wall clock time of all Tasks in the Job.  The wall clock time
     is the elapsed time from when the Task started running on a Compute Node to when it finished
     (or to the last time the statistics were updated, if the Task had not finished by then). If a
     Task was retried, this includes the wall clock time of all the Task retries. Required.
    :vartype wall_clock_time: ~datetime.timedelta
    :ivar read_iops: The total number of disk read operations made by all Tasks in the Job.
     Required.
    :vartype read_iops: int
    :ivar write_iops: The total number of disk write operations made by all Tasks in the Job.
     Required.
    :vartype write_iops: int
    :ivar read_io_gib: The total amount of data in GiB read from disk by all Tasks in the Job.
     Required.
    :vartype read_io_gib: float
    :ivar write_io_gib: The total amount of data in GiB written to disk by all Tasks in the Job.
     Required.
    :vartype write_io_gib: float
    :ivar succeeded_tasks_count: The total number of Tasks successfully completed in the Job during
     the given time range. A Task completes successfully if it returns exit code 0. Required.
    :vartype succeeded_tasks_count: int
    :ivar failed_tasks_count: The total number of Tasks in the Job that failed during the given
     time range. A Task fails if it exhausts its maximum retry count without returning exit code 0.
     Required.
    :vartype failed_tasks_count: int
    :ivar task_retries_count: The total number of retries on all the Tasks in the Job during the
     given time range. Required.
    :vartype task_retries_count: int
    :ivar wait_time: The total wait time of all Tasks in the Job. The wait time for a Task is
     defined as the elapsed time between the creation of the Task and the start of Task execution.
     (If the Task is retried due to failures, the wait time is the time to the most recent Task
     execution.) This value is only reported in the Account lifetime statistics; it is not included
     in the Job statistics. Required.
    :vartype wait_time: ~datetime.timedelta
    """

    url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL of the statistics. Required."""
    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The start time of the time range covered by the statistics. Required."""
    last_update_time: datetime.datetime = rest_field(
        name="lastUpdateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the statistics were last updated. All statistics are limited to the range
     between startTime and lastUpdateTime. Required."""
    user_cpu_time: datetime.timedelta = rest_field(
        name="userCPUTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total user mode CPU time (summed across all cores and all Compute Nodes) consumed by all
     Tasks in the Job. Required."""
    kernel_cpu_time: datetime.timedelta = rest_field(
        name="kernelCPUTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total kernel mode CPU time (summed across all cores and all Compute Nodes) consumed by all
     Tasks in the Job. Required."""
    wall_clock_time: datetime.timedelta = rest_field(
        name="wallClockTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total wall clock time of all Tasks in the Job.  The wall clock time is the elapsed time
     from when the Task started running on a Compute Node to when it finished (or to the last time
     the statistics were updated, if the Task had not finished by then). If a Task was retried, this
     includes the wall clock time of all the Task retries. Required."""
    read_iops: int = rest_field(
        name="readIOps", visibility=["read", "create", "update", "delete", "query"], format="str"
    )
    """The total number of disk read operations made by all Tasks in the Job. Required."""
    write_iops: int = rest_field(
        name="writeIOps", visibility=["read", "create", "update", "delete", "query"], format="str"
    )
    """The total number of disk write operations made by all Tasks in the Job. Required."""
    read_io_gib: float = rest_field(name="readIOGiB", visibility=["read", "create", "update", "delete", "query"])
    """The total amount of data in GiB read from disk by all Tasks in the Job. Required."""
    write_io_gib: float = rest_field(name="writeIOGiB", visibility=["read", "create", "update", "delete", "query"])
    """The total amount of data in GiB written to disk by all Tasks in the Job. Required."""
    succeeded_tasks_count: int = rest_field(
        name="numSucceededTasks", visibility=["read", "create", "update", "delete", "query"], format="str"
    )
    """The total number of Tasks successfully completed in the Job during the given time range. A Task
     completes successfully if it returns exit code 0. Required."""
    failed_tasks_count: int = rest_field(
        name="numFailedTasks", visibility=["read", "create", "update", "delete", "query"], format="str"
    )
    """The total number of Tasks in the Job that failed during the given time range. A Task fails if
     it exhausts its maximum retry count without returning exit code 0. Required."""
    task_retries_count: int = rest_field(
        name="numTaskRetries", visibility=["read", "create", "update", "delete", "query"], format="str"
    )
    """The total number of retries on all the Tasks in the Job during the given time range. Required."""
    wait_time: datetime.timedelta = rest_field(
        name="waitTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total wait time of all Tasks in the Job. The wait time for a Task is defined as the elapsed
     time between the creation of the Task and the start of Task execution. (If the Task is retried
     due to failures, the wait time is the time to the most recent Task execution.) This value is
     only reported in the Account lifetime statistics; it is not included in the Job statistics.
     Required."""

    @overload
    def __init__(
        self,
        *,
        url: str,
        start_time: datetime.datetime,
        last_update_time: datetime.datetime,
        user_cpu_time: datetime.timedelta,
        kernel_cpu_time: datetime.timedelta,
        wall_clock_time: datetime.timedelta,
        read_iops: int,
        write_iops: int,
        read_io_gib: float,
        write_io_gib: float,
        succeeded_tasks_count: int,
        failed_tasks_count: int,
        task_retries_count: int,
        wait_time: datetime.timedelta,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobTerminateOptions(_Model):
    """Parameters for terminating an Azure Batch Job.

    :ivar termination_reason: The text you want to appear as the Job's TerminationReason. The
     default is 'UserTerminate'.
    :vartype termination_reason: str
    """

    termination_reason: Optional[str] = rest_field(
        name="terminateReason", visibility=["read", "create", "update", "delete", "query"]
    )
    """The text you want to appear as the Job's TerminationReason. The default is 'UserTerminate'."""

    @overload
    def __init__(
        self,
        *,
        termination_reason: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchJobUpdateOptions(_Model):
    """Parameters for updating an Azure Batch Job.

    :ivar priority: The priority of the Job. Priority values can range from -1000 to 1000, with
     -1000 being the lowest priority and 1000 being the highest priority. If omitted, the priority
     of the Job is left unchanged.
    :vartype priority: int
    :ivar allow_task_preemption: Whether Tasks in this job can be preempted by other high priority
     jobs. (This property is not available by default. Please contact support for more information)
     If the value is set to True, other high priority jobs submitted to the system will take
     precedence and will be able requeue tasks from this job. You can update a job's
     allowTaskPreemption after it has been created using the update job API.
    :vartype allow_task_preemption: bool
    :ivar max_parallel_tasks: The maximum number of tasks that can be executed in parallel for the
     job. (This property is not available by default. Please contact support for more information)
     The value of maxParallelTasks must be -1 or greater than 0 if specified. If not specified, the
     default value is -1, which means there's no limit to the number of tasks that can be run at
     once. You can update a job's maxParallelTasks after it has been created using the update job
     API.
    :vartype max_parallel_tasks: int
    :ivar constraints: The execution constraints for the Job. If omitted, the existing execution
     constraints are left unchanged.
    :vartype constraints: ~azure.batch.models.BatchJobConstraints
    :ivar pool_info: The Pool on which the Batch service runs the Job's Tasks. You may change the
     Pool for a Job only when the Job is disabled. The Patch Job call will fail if you include the
     poolInfo element and the Job is not disabled. If you specify an autoPoolSpecification in the
     poolInfo, only the keepAlive property of the autoPoolSpecification can be updated, and then
     only if the autoPoolSpecification has a poolLifetimeOption of Job (other job properties can be
     updated as normal). If omitted, the Job continues to run on its current Pool.
    :vartype pool_info: ~azure.batch.models.BatchPoolInfo
    :ivar all_tasks_complete_mode: The action the Batch service should take when all Tasks in the
     Job are in the completed state. If omitted, the completion behavior is left unchanged. You may
     not change the value from terminatejob to noaction - that is, once you have engaged automatic
     Job termination, you cannot turn it off again. If you try to do this, the request fails with an
     'invalid property value' error response; if you are calling the REST API directly, the HTTP
     status code is 400 (Bad Request). Known values are: "noaction" and "terminatejob".
    :vartype all_tasks_complete_mode: str or ~azure.batch.models.BatchAllTasksCompleteMode
    :ivar metadata: A list of name-value pairs associated with the Job as metadata. If omitted, the
     existing Job metadata is left unchanged.
    :vartype metadata: list[~azure.batch.models.BatchMetadataItem]
    :ivar network_configuration: (This property is not available by default. Please contact support
     for more information) The network configuration for the Job.
    :vartype network_configuration: ~azure.batch.models.BatchJobNetworkConfiguration
    """

    priority: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The priority of the Job. Priority values can range from -1000 to 1000, with -1000 being the
     lowest priority and 1000 being the highest priority. If omitted, the priority of the Job is
     left unchanged."""
    allow_task_preemption: Optional[bool] = rest_field(
        name="allowTaskPreemption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether Tasks in this job can be preempted by other high priority jobs. (This property is not
     available by default. Please contact support for more information) If the value is set to True,
     other high priority jobs submitted to the system will take precedence and will be able requeue
     tasks from this job. You can update a job's allowTaskPreemption after it has been created using
     the update job API."""
    max_parallel_tasks: Optional[int] = rest_field(
        name="maxParallelTasks", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of tasks that can be executed in parallel for the job. (This property is not
     available by default. Please contact support for more information) The value of
     maxParallelTasks must be -1 or greater than 0 if specified. If not specified, the default value
     is -1, which means there's no limit to the number of tasks that can be run at once. You can
     update a job's maxParallelTasks after it has been created using the update job API."""
    constraints: Optional["_models.BatchJobConstraints"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The execution constraints for the Job. If omitted, the existing execution constraints are left
     unchanged."""
    pool_info: Optional["_models.BatchPoolInfo"] = rest_field(
        name="poolInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Pool on which the Batch service runs the Job's Tasks. You may change the Pool for a Job
     only when the Job is disabled. The Patch Job call will fail if you include the poolInfo element
     and the Job is not disabled. If you specify an autoPoolSpecification in the poolInfo, only the
     keepAlive property of the autoPoolSpecification can be updated, and then only if the
     autoPoolSpecification has a poolLifetimeOption of Job (other job properties can be updated as
     normal). If omitted, the Job continues to run on its current Pool."""
    all_tasks_complete_mode: Optional[Union[str, "_models.BatchAllTasksCompleteMode"]] = rest_field(
        name="onAllTasksComplete", visibility=["read", "create", "update", "delete", "query"]
    )
    """The action the Batch service should take when all Tasks in the Job are in the completed state.
     If omitted, the completion behavior is left unchanged. You may not change the value from
     terminatejob to noaction - that is, once you have engaged automatic Job termination, you cannot
     turn it off again. If you try to do this, the request fails with an 'invalid property value'
     error response; if you are calling the REST API directly, the HTTP status code is 400 (Bad
     Request). Known values are: \"noaction\" and \"terminatejob\"."""
    metadata: Optional[list["_models.BatchMetadataItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of name-value pairs associated with the Job as metadata. If omitted, the existing Job
     metadata is left unchanged."""
    network_configuration: Optional["_models.BatchJobNetworkConfiguration"] = rest_field(
        name="networkConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """(This property is not available by default. Please contact support for more information) The
     network configuration for the Job."""

    @overload
    def __init__(
        self,
        *,
        priority: Optional[int] = None,
        allow_task_preemption: Optional[bool] = None,
        max_parallel_tasks: Optional[int] = None,
        constraints: Optional["_models.BatchJobConstraints"] = None,
        pool_info: Optional["_models.BatchPoolInfo"] = None,
        all_tasks_complete_mode: Optional[Union[str, "_models.BatchAllTasksCompleteMode"]] = None,
        metadata: Optional[list["_models.BatchMetadataItem"]] = None,
        network_configuration: Optional["_models.BatchJobNetworkConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchMetadataItem(_Model):
    """The Batch service does not assign any meaning to this metadata; it is solely
    for the use of user code.

    :ivar name: The name of the metadata item. Required.
    :vartype name: str
    :ivar value: The value of the metadata item. Required.
    :vartype value: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the metadata item. Required."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the metadata item. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNode(_Model):
    """A Compute Node in the Batch service.

    :ivar id: The ID of the Compute Node. Every Compute Node that is added to a Pool is assigned a
     unique ID. Whenever a Compute Node is removed from a Pool, all of its local files are deleted,
     and the ID is reclaimed and could be reused for new Compute Nodes. Required.
    :vartype id: str
    :ivar url: The URL of the Compute Node. Required.
    :vartype url: str
    :ivar state: The current state of the Compute Node. Required. Known values are: "idle",
     "rebooting", "reimaging", "running", "unusable", "creating", "starting", "waitingforstarttask",
     "starttaskfailed", "unknown", "leavingpool", "offline", "preempted", "upgradingos",
     "deallocated", and "deallocating".
    :vartype state: str or ~azure.batch.models.BatchNodeState
    :ivar scheduling_state: Whether the Compute Node is available for Task scheduling. Known values
     are: "enabled" and "disabled".
    :vartype scheduling_state: str or ~azure.batch.models.SchedulingState
    :ivar state_transition_time: The time at which the Compute Node entered its current state.
     Required.
    :vartype state_transition_time: ~datetime.datetime
    :ivar last_boot_time: The last time at which the Compute Node was started. This property may
     not be present if the Compute Node state is unusable. Required.
    :vartype last_boot_time: ~datetime.datetime
    :ivar allocation_time: The time at which this Compute Node was allocated to the Pool. This is
     the time when the Compute Node was initially allocated and doesn't change once set. It is not
     updated when the Compute Node is service healed or preempted. Required.
    :vartype allocation_time: ~datetime.datetime
    :ivar ip_address: The IP address that other Nodes can use to communicate with this Compute
     Node. Every Compute Node that is added to a Pool is assigned a unique IP address. Whenever a
     Compute Node is removed from a Pool, all of its local files are deleted, and the IP address is
     reclaimed and could be reused for new Compute Nodes. Required.
    :vartype ip_address: str
    :ivar ipv6_address: The IPv6 address that other Nodes can use to communicate with this Compute
     Node. Every Compute Node that is added to a Pool is assigned a unique IP address. Whenever a
     Compute Node is removed from a Pool, all of its local files are deleted, and the IP address is
     reclaimed and could be reused for new Compute Nodes. This property will not be present if the
     Pool is not configured for IPv6. Required.
    :vartype ipv6_address: str
    :ivar affinity_id: An identifier which can be passed when adding a Task to request that the
     Task be scheduled on this Compute Node. Note that this is just a soft affinity. If the target
     Compute Node is busy or unavailable at the time the Task is scheduled, then the Task will be
     scheduled elsewhere. Required.
    :vartype affinity_id: str
    :ivar vm_size: The size of the virtual machine hosting the Compute Node. For information about
     available sizes of virtual machines in Pools, see Choose a VM size for Compute Nodes in an
     Azure Batch Pool (`https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes
     <https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes>`_). Required.
    :vartype vm_size: str
    :ivar total_tasks_run: The total number of Job Tasks completed on the Compute Node. This
     includes Job Manager Tasks and normal Tasks, but not Job Preparation, Job Release or Start
     Tasks. Required.
    :vartype total_tasks_run: int
    :ivar running_tasks_count: The total number of currently running Job Tasks on the Compute Node.
     This includes Job Manager Tasks and normal Tasks, but not Job Preparation, Job Release or Start
     Tasks.
    :vartype running_tasks_count: int
    :ivar running_task_slots_count: The total number of scheduling slots used by currently running
     Job Tasks on the Compute Node. This includes Job Manager Tasks and normal Tasks, but not Job
     Preparation, Job Release or Start Tasks.
    :vartype running_task_slots_count: int
    :ivar total_tasks_succeeded: The total number of Job Tasks which completed successfully (with
     exitCode 0) on the Compute Node. This includes Job Manager Tasks and normal Tasks, but not Job
     Preparation, Job Release or Start Tasks.
    :vartype total_tasks_succeeded: int
    :ivar recent_tasks: A list of Tasks whose state has recently changed. This property is present
     only if at least one Task has run on this Compute Node since it was assigned to the Pool.
    :vartype recent_tasks: list[~azure.batch.models.BatchTaskInfo]
    :ivar start_task: The Task specified to run on the Compute Node as it joins the Pool.
    :vartype start_task: ~azure.batch.models.BatchStartTask
    :ivar start_task_info: Runtime information about the execution of the StartTask on the Compute
     Node.
    :vartype start_task_info: ~azure.batch.models.BatchStartTaskInfo
    :ivar errors: The list of errors that are currently being encountered by the Compute Node.
    :vartype errors: list[~azure.batch.models.BatchNodeError]
    :ivar is_dedicated: Whether this Compute Node is a dedicated Compute Node. If false, the
     Compute Node is a Spot/Low-priority Compute Node.
    :vartype is_dedicated: bool
    :ivar endpoint_configuration: The endpoint configuration for the Compute Node.
    :vartype endpoint_configuration: ~azure.batch.models.BatchNodeEndpointConfiguration
    :ivar node_agent_info: Information about the Compute Node agent version and the time the
     Compute Node upgraded to a new version.
    :vartype node_agent_info: ~azure.batch.models.BatchNodeAgentInfo
    :ivar virtual_machine_info: Info about the current state of the virtual machine. Required.
    :vartype virtual_machine_info: ~azure.batch.models.VirtualMachineInfo
    """

    id: str = rest_field(visibility=["read"])
    """The ID of the Compute Node. Every Compute Node that is added to a Pool is assigned a unique ID.
     Whenever a Compute Node is removed from a Pool, all of its local files are deleted, and the ID
     is reclaimed and could be reused for new Compute Nodes. Required."""
    url: str = rest_field(visibility=["read"])
    """The URL of the Compute Node. Required."""
    state: Union[str, "_models.BatchNodeState"] = rest_field(visibility=["read"])
    """The current state of the Compute Node. Required. Known values are: \"idle\", \"rebooting\",
     \"reimaging\", \"running\", \"unusable\", \"creating\", \"starting\", \"waitingforstarttask\",
     \"starttaskfailed\", \"unknown\", \"leavingpool\", \"offline\", \"preempted\", \"upgradingos\",
     \"deallocated\", and \"deallocating\"."""
    scheduling_state: Optional[Union[str, "_models.SchedulingState"]] = rest_field(
        name="schedulingState", visibility=["read"]
    )
    """Whether the Compute Node is available for Task scheduling. Known values are: \"enabled\" and
     \"disabled\"."""
    state_transition_time: datetime.datetime = rest_field(
        name="stateTransitionTime", visibility=["read"], format="rfc3339"
    )
    """The time at which the Compute Node entered its current state. Required."""
    last_boot_time: datetime.datetime = rest_field(name="lastBootTime", visibility=["read"], format="rfc3339")
    """The last time at which the Compute Node was started. This property may not be present if the
     Compute Node state is unusable. Required."""
    allocation_time: datetime.datetime = rest_field(name="allocationTime", visibility=["read"], format="rfc3339")
    """The time at which this Compute Node was allocated to the Pool. This is the time when the
     Compute Node was initially allocated and doesn't change once set. It is not updated when the
     Compute Node is service healed or preempted. Required."""
    ip_address: str = rest_field(name="ipAddress", visibility=["read"])
    """The IP address that other Nodes can use to communicate with this Compute Node. Every Compute
     Node that is added to a Pool is assigned a unique IP address. Whenever a Compute Node is
     removed from a Pool, all of its local files are deleted, and the IP address is reclaimed and
     could be reused for new Compute Nodes. Required."""
    ipv6_address: str = rest_field(name="ipv6Address", visibility=["read"])
    """The IPv6 address that other Nodes can use to communicate with this Compute Node. Every Compute
     Node that is added to a Pool is assigned a unique IP address. Whenever a Compute Node is
     removed from a Pool, all of its local files are deleted, and the IP address is reclaimed and
     could be reused for new Compute Nodes. This property will not be present if the Pool is not
     configured for IPv6. Required."""
    affinity_id: str = rest_field(name="affinityId", visibility=["read"])
    """An identifier which can be passed when adding a Task to request that the Task be scheduled on
     this Compute Node. Note that this is just a soft affinity. If the target Compute Node is busy
     or unavailable at the time the Task is scheduled, then the Task will be scheduled elsewhere.
     Required."""
    vm_size: str = rest_field(name="vmSize", visibility=["read"])
    """The size of the virtual machine hosting the Compute Node. For information about available sizes
     of virtual machines in Pools, see Choose a VM size for Compute Nodes in an Azure Batch Pool
     (`https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes
     <https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes>`_). Required."""
    total_tasks_run: int = rest_field(name="totalTasksRun", visibility=["read"])
    """The total number of Job Tasks completed on the Compute Node. This includes Job Manager Tasks
     and normal Tasks, but not Job Preparation, Job Release or Start Tasks. Required."""
    running_tasks_count: Optional[int] = rest_field(name="runningTasksCount", visibility=["read"])
    """The total number of currently running Job Tasks on the Compute Node. This includes Job Manager
     Tasks and normal Tasks, but not Job Preparation, Job Release or Start Tasks."""
    running_task_slots_count: Optional[int] = rest_field(name="runningTaskSlotsCount", visibility=["read"])
    """The total number of scheduling slots used by currently running Job Tasks on the Compute Node.
     This includes Job Manager Tasks and normal Tasks, but not Job Preparation, Job Release or Start
     Tasks."""
    total_tasks_succeeded: Optional[int] = rest_field(name="totalTasksSucceeded", visibility=["read"])
    """The total number of Job Tasks which completed successfully (with exitCode 0) on the Compute
     Node. This includes Job Manager Tasks and normal Tasks, but not Job Preparation, Job Release or
     Start Tasks."""
    recent_tasks: Optional[list["_models.BatchTaskInfo"]] = rest_field(name="recentTasks", visibility=["read"])
    """A list of Tasks whose state has recently changed. This property is present only if at least one
     Task has run on this Compute Node since it was assigned to the Pool."""
    start_task: Optional["_models.BatchStartTask"] = rest_field(name="startTask", visibility=["read"])
    """The Task specified to run on the Compute Node as it joins the Pool."""
    start_task_info: Optional["_models.BatchStartTaskInfo"] = rest_field(name="startTaskInfo", visibility=["read"])
    """Runtime information about the execution of the StartTask on the Compute Node."""
    errors: Optional[list["_models.BatchNodeError"]] = rest_field(visibility=["read"])
    """The list of errors that are currently being encountered by the Compute Node."""
    is_dedicated: Optional[bool] = rest_field(name="isDedicated", visibility=["read"])
    """Whether this Compute Node is a dedicated Compute Node. If false, the Compute Node is a
     Spot/Low-priority Compute Node."""
    endpoint_configuration: Optional["_models.BatchNodeEndpointConfiguration"] = rest_field(
        name="endpointConfiguration", visibility=["read"]
    )
    """The endpoint configuration for the Compute Node."""
    node_agent_info: Optional["_models.BatchNodeAgentInfo"] = rest_field(name="nodeAgentInfo", visibility=["read"])
    """Information about the Compute Node agent version and the time the Compute Node upgraded to a
     new version."""
    virtual_machine_info: "_models.VirtualMachineInfo" = rest_field(name="virtualMachineInfo", visibility=["read"])
    """Info about the current state of the virtual machine. Required."""


class BatchNodeAgentInfo(_Model):
    """The Batch Compute Node agent is a program that runs on each Compute Node in the
    Pool and provides Batch capability on the Compute Node.

    :ivar version: The version of the Batch Compute Node agent running on the Compute Node. This
     version number can be checked against the Compute Node agent release notes located at
     `https://github.com/Azure/Batch/blob/master/changelogs/nodeagent/CHANGELOG.md
     <https://github.com/Azure/Batch/blob/master/changelogs/nodeagent/CHANGELOG.md>`_. Required.
    :vartype version: str
    :ivar last_update_time: The time when the Compute Node agent was updated on the Compute Node.
     This is the most recent time that the Compute Node agent was updated to a new version.
     Required.
    :vartype last_update_time: ~datetime.datetime
    """

    version: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version of the Batch Compute Node agent running on the Compute Node. This version number
     can be checked against the Compute Node agent release notes located at
     `https://github.com/Azure/Batch/blob/master/changelogs/nodeagent/CHANGELOG.md
     <https://github.com/Azure/Batch/blob/master/changelogs/nodeagent/CHANGELOG.md>`_. Required."""
    last_update_time: datetime.datetime = rest_field(
        name="lastUpdateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time when the Compute Node agent was updated on the Compute Node. This is the most recent
     time that the Compute Node agent was updated to a new version. Required."""

    @overload
    def __init__(
        self,
        *,
        version: str,
        last_update_time: datetime.datetime,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNodeCounts(_Model):
    """The number of Compute Nodes in each Compute Node state.

    :ivar creating: The number of Compute Nodes in the creating state. Required.
    :vartype creating: int
    :ivar idle: The number of Compute Nodes in the idle state. Required.
    :vartype idle: int
    :ivar offline: The number of Compute Nodes in the offline state. Required.
    :vartype offline: int
    :ivar preempted: The number of Compute Nodes in the preempted state. Required.
    :vartype preempted: int
    :ivar rebooting: The count of Compute Nodes in the rebooting state. Required.
    :vartype rebooting: int
    :ivar reimaging: The number of Compute Nodes in the reimaging state. Required.
    :vartype reimaging: int
    :ivar running: The number of Compute Nodes in the running state. Required.
    :vartype running: int
    :ivar starting: The number of Compute Nodes in the starting state. Required.
    :vartype starting: int
    :ivar start_task_failed: The number of Compute Nodes in the startTaskFailed state. Required.
    :vartype start_task_failed: int
    :ivar leaving_pool: The number of Compute Nodes in the leavingPool state. Required.
    :vartype leaving_pool: int
    :ivar unknown: The number of Compute Nodes in the unknown state. Required.
    :vartype unknown: int
    :ivar unusable: The number of Compute Nodes in the unusable state. Required.
    :vartype unusable: int
    :ivar waiting_for_start_task: The number of Compute Nodes in the waitingForStartTask state.
     Required.
    :vartype waiting_for_start_task: int
    :ivar deallocated: The number of Compute Nodes in the deallocated state. Required.
    :vartype deallocated: int
    :ivar deallocating: The number of Compute Nodes in the deallocating state. Required.
    :vartype deallocating: int
    :ivar total: The total number of Compute Nodes. Required.
    :vartype total: int
    :ivar upgrading_os: The number of Compute Nodes in the upgradingOS state. Required.
    :vartype upgrading_os: int
    """

    creating: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of Compute Nodes in the creating state. Required."""
    idle: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of Compute Nodes in the idle state. Required."""
    offline: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of Compute Nodes in the offline state. Required."""
    preempted: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of Compute Nodes in the preempted state. Required."""
    rebooting: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The count of Compute Nodes in the rebooting state. Required."""
    reimaging: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of Compute Nodes in the reimaging state. Required."""
    running: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of Compute Nodes in the running state. Required."""
    starting: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of Compute Nodes in the starting state. Required."""
    start_task_failed: int = rest_field(
        name="startTaskFailed", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of Compute Nodes in the startTaskFailed state. Required."""
    leaving_pool: int = rest_field(name="leavingPool", visibility=["read", "create", "update", "delete", "query"])
    """The number of Compute Nodes in the leavingPool state. Required."""
    unknown: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of Compute Nodes in the unknown state. Required."""
    unusable: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of Compute Nodes in the unusable state. Required."""
    waiting_for_start_task: int = rest_field(
        name="waitingForStartTask", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of Compute Nodes in the waitingForStartTask state. Required."""
    deallocated: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of Compute Nodes in the deallocated state. Required."""
    deallocating: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of Compute Nodes in the deallocating state. Required."""
    total: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The total number of Compute Nodes. Required."""
    upgrading_os: int = rest_field(name="upgradingOS", visibility=["read", "create", "update", "delete", "query"])
    """The number of Compute Nodes in the upgradingOS state. Required."""

    @overload
    def __init__(
        self,
        *,
        creating: int,
        idle: int,
        offline: int,
        preempted: int,
        rebooting: int,
        reimaging: int,
        running: int,
        starting: int,
        start_task_failed: int,
        leaving_pool: int,
        unknown: int,
        unusable: int,
        waiting_for_start_task: int,
        deallocated: int,
        deallocating: int,
        total: int,
        upgrading_os: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNodeDeallocateOptions(_Model):
    """Options for deallocating a Compute Node.

    :ivar node_deallocate_option: When to deallocate the Compute Node and what to do with currently
     running Tasks. The default value is requeue. Known values are: "requeue", "terminate",
     "taskcompletion", and "retaineddata".
    :vartype node_deallocate_option: str or ~azure.batch.models.BatchNodeDeallocateOption
    """

    node_deallocate_option: Optional[Union[str, "_models.BatchNodeDeallocateOption"]] = rest_field(
        name="nodeDeallocateOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """When to deallocate the Compute Node and what to do with currently running Tasks. The default
     value is requeue. Known values are: \"requeue\", \"terminate\", \"taskcompletion\", and
     \"retaineddata\"."""

    @overload
    def __init__(
        self,
        *,
        node_deallocate_option: Optional[Union[str, "_models.BatchNodeDeallocateOption"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNodeDisableSchedulingOptions(_Model):
    """Parameters for disabling scheduling on an Azure Batch Compute Node.

    :ivar node_disable_scheduling_option: What to do with currently running Tasks when disabling
     Task scheduling on the Compute Node. The default value is requeue. Known values are: "requeue",
     "terminate", and "taskcompletion".
    :vartype node_disable_scheduling_option: str or
     ~azure.batch.models.BatchNodeDisableSchedulingOption
    """

    node_disable_scheduling_option: Optional[Union[str, "_models.BatchNodeDisableSchedulingOption"]] = rest_field(
        name="nodeDisableSchedulingOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """What to do with currently running Tasks when disabling Task scheduling on the Compute Node. The
     default value is requeue. Known values are: \"requeue\", \"terminate\", and \"taskcompletion\"."""

    @overload
    def __init__(
        self,
        *,
        node_disable_scheduling_option: Optional[Union[str, "_models.BatchNodeDisableSchedulingOption"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNodeEndpointConfiguration(_Model):
    """The endpoint configuration for the Compute Node.

    :ivar inbound_endpoints: The list of inbound endpoints that are accessible on the Compute Node.
     Required.
    :vartype inbound_endpoints: list[~azure.batch.models.InboundEndpoint]
    """

    inbound_endpoints: list["_models.InboundEndpoint"] = rest_field(
        name="inboundEndpoints", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of inbound endpoints that are accessible on the Compute Node. Required."""

    @overload
    def __init__(
        self,
        *,
        inbound_endpoints: list["_models.InboundEndpoint"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNodeError(_Model):
    """An error encountered by a Compute Node.

    :ivar code: An identifier for the Compute Node error. Codes are invariant and are intended to
     be consumed programmatically.
    :vartype code: str
    :ivar message: A message describing the Compute Node error, intended to be suitable for display
     in a user interface.
    :vartype message: str
    :ivar error_details: The list of additional error details related to the Compute Node error.
    :vartype error_details: list[~azure.batch.models.NameValuePair]
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An identifier for the Compute Node error. Codes are invariant and are intended to be consumed
     programmatically."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A message describing the Compute Node error, intended to be suitable for display in a user
     interface."""
    error_details: Optional[list["_models.NameValuePair"]] = rest_field(
        name="errorDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of additional error details related to the Compute Node error."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        error_details: Optional[list["_models.NameValuePair"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNodeFile(_Model):
    """Information about a file or directory on a Compute Node.

    :ivar name: The file path.
    :vartype name: str
    :ivar url: The URL of the file.
    :vartype url: str
    :ivar is_directory: Whether the object represents a directory.
    :vartype is_directory: bool
    :ivar properties: The file properties.
    :vartype properties: ~azure.batch.models.FileProperties
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The file path."""
    url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL of the file."""
    is_directory: Optional[bool] = rest_field(
        name="isDirectory", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the object represents a directory."""
    properties: Optional["_models.FileProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The file properties."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        url: Optional[str] = None,
        is_directory: Optional[bool] = None,
        properties: Optional["_models.FileProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNodeIdentityReference(_Model):
    """The reference to a user assigned identity associated with the Batch pool which
    a compute node will use.

    :ivar resource_id: The ARM resource id of the user assigned identity.
    :vartype resource_id: str
    """

    resource_id: Optional[str] = rest_field(
        name="resourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ARM resource id of the user assigned identity."""

    @overload
    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNodeInfo(_Model):
    """Information about the Compute Node on which a Task ran.

    :ivar affinity_id: An identifier for the Node on which the Task ran, which can be passed when
     adding a Task to request that the Task be scheduled on this Compute Node.
    :vartype affinity_id: str
    :ivar node_url: The URL of the Compute Node on which the Task ran.
    :vartype node_url: str
    :ivar pool_id: The ID of the Pool on which the Task ran.
    :vartype pool_id: str
    :ivar node_id: The ID of the Compute Node on which the Task ran.
    :vartype node_id: str
    :ivar task_root_directory: The root directory of the Task on the Compute Node.
    :vartype task_root_directory: str
    :ivar task_root_directory_url: The URL to the root directory of the Task on the Compute Node.
    :vartype task_root_directory_url: str
    """

    affinity_id: Optional[str] = rest_field(
        name="affinityId", visibility=["read", "create", "update", "delete", "query"]
    )
    """An identifier for the Node on which the Task ran, which can be passed when adding a Task to
     request that the Task be scheduled on this Compute Node."""
    node_url: Optional[str] = rest_field(name="nodeUrl", visibility=["read", "create", "update", "delete", "query"])
    """The URL of the Compute Node on which the Task ran."""
    pool_id: Optional[str] = rest_field(name="poolId", visibility=["read", "create", "update", "delete", "query"])
    """The ID of the Pool on which the Task ran."""
    node_id: Optional[str] = rest_field(name="nodeId", visibility=["read", "create", "update", "delete", "query"])
    """The ID of the Compute Node on which the Task ran."""
    task_root_directory: Optional[str] = rest_field(
        name="taskRootDirectory", visibility=["read", "create", "update", "delete", "query"]
    )
    """The root directory of the Task on the Compute Node."""
    task_root_directory_url: Optional[str] = rest_field(
        name="taskRootDirectoryUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URL to the root directory of the Task on the Compute Node."""

    @overload
    def __init__(
        self,
        *,
        affinity_id: Optional[str] = None,
        node_url: Optional[str] = None,
        pool_id: Optional[str] = None,
        node_id: Optional[str] = None,
        task_root_directory: Optional[str] = None,
        task_root_directory_url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNodePlacementConfiguration(_Model):
    """For regional placement, nodes in the pool will be allocated in the same region.
    For zonal placement, nodes in the pool will be spread across different zones
    with best effort balancing.

    :ivar policy: Node placement Policy type on Batch Pools. Allocation policy used by Batch
     Service to provision the nodes. If not specified, Batch will use the regional policy. Known
     values are: "regional" and "zonal".
    :vartype policy: str or ~azure.batch.models.BatchNodePlacementPolicyType
    """

    policy: Optional[Union[str, "_models.BatchNodePlacementPolicyType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Node placement Policy type on Batch Pools. Allocation policy used by Batch Service to provision
     the nodes. If not specified, Batch will use the regional policy. Known values are: \"regional\"
     and \"zonal\"."""

    @overload
    def __init__(
        self,
        *,
        policy: Optional[Union[str, "_models.BatchNodePlacementPolicyType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNodeRebootOptions(_Model):
    """Parameters for rebooting an Azure Batch Compute Node.

    :ivar node_reboot_kind: When to reboot the Compute Node and what to do with currently running
     Tasks. The default value is requeue. Known values are: "requeue", "terminate",
     "taskcompletion", and "retaineddata".
    :vartype node_reboot_kind: str or ~azure.batch.models.BatchNodeRebootKind
    """

    node_reboot_kind: Optional[Union[str, "_models.BatchNodeRebootKind"]] = rest_field(
        name="nodeRebootOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """When to reboot the Compute Node and what to do with currently running Tasks. The default value
     is requeue. Known values are: \"requeue\", \"terminate\", \"taskcompletion\", and
     \"retaineddata\"."""

    @overload
    def __init__(
        self,
        *,
        node_reboot_kind: Optional[Union[str, "_models.BatchNodeRebootKind"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNodeReimageOptions(_Model):
    """Parameters for reimaging an Azure Batch Compute Node.

    :ivar node_reimage_option: When to reimage the Compute Node and what to do with currently
     running Tasks. The default value is requeue. Known values are: "requeue", "terminate",
     "taskcompletion", and "retaineddata".
    :vartype node_reimage_option: str or ~azure.batch.models.BatchNodeReimageOption
    """

    node_reimage_option: Optional[Union[str, "_models.BatchNodeReimageOption"]] = rest_field(
        name="nodeReimageOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """When to reimage the Compute Node and what to do with currently running Tasks. The default value
     is requeue. Known values are: \"requeue\", \"terminate\", \"taskcompletion\", and
     \"retaineddata\"."""

    @overload
    def __init__(
        self,
        *,
        node_reimage_option: Optional[Union[str, "_models.BatchNodeReimageOption"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNodeRemoteLoginSettings(_Model):
    """The remote login settings for a Compute Node.

    :ivar ipv6_remote_login_ip_address: The IPv6 address used for remote login to the Compute Node.
    :vartype ipv6_remote_login_ip_address: str
    :ivar ipv6_remote_login_port: The port used for remote login to the Compute Node.
    :vartype ipv6_remote_login_port: int
    :ivar remote_login_ip_address: The IP address used for remote login to the Compute Node.
     Required.
    :vartype remote_login_ip_address: str
    :ivar remote_login_port: The port used for remote login to the Compute Node. Required.
    :vartype remote_login_port: int
    """

    ipv6_remote_login_ip_address: Optional[str] = rest_field(
        name="ipv6RemoteLoginIPAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """The IPv6 address used for remote login to the Compute Node."""
    ipv6_remote_login_port: Optional[int] = rest_field(
        name="ipv6RemoteLoginPort", visibility=["read", "create", "update", "delete", "query"]
    )
    """The port used for remote login to the Compute Node."""
    remote_login_ip_address: str = rest_field(
        name="remoteLoginIPAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """The IP address used for remote login to the Compute Node. Required."""
    remote_login_port: int = rest_field(
        name="remoteLoginPort", visibility=["read", "create", "update", "delete", "query"]
    )
    """The port used for remote login to the Compute Node. Required."""

    @overload
    def __init__(
        self,
        *,
        remote_login_ip_address: str,
        remote_login_port: int,
        ipv6_remote_login_ip_address: Optional[str] = None,
        ipv6_remote_login_port: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNodeRemoveOptions(_Model):
    """Parameters for removing nodes from an Azure Batch Pool.

    :ivar node_ids: A list containing the IDs of the Compute Nodes to be removed from the specified
     Pool. A maximum of 100 nodes may be removed per request. Required.
    :vartype node_ids: list[str]
    :ivar resize_timeout: The timeout for removal of Compute Nodes to the Pool. The default value
     is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the
     Batch service returns an error; if you are calling the REST API directly, the HTTP status code
     is 400 (Bad Request).
    :vartype resize_timeout: ~datetime.timedelta
    :ivar node_deallocation_option: Determines what to do with a Compute Node and its running
     task(s) after it has been selected for deallocation. The default value is requeue. Known values
     are: "requeue", "terminate", "taskcompletion", and "retaineddata".
    :vartype node_deallocation_option: str or ~azure.batch.models.BatchNodeDeallocationOption
    """

    node_ids: list[str] = rest_field(name="nodeList", visibility=["read", "create", "update", "delete", "query"])
    """A list containing the IDs of the Compute Nodes to be removed from the specified Pool. A maximum
     of 100 nodes may be removed per request. Required."""
    resize_timeout: Optional[datetime.timedelta] = rest_field(
        name="resizeTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """The timeout for removal of Compute Nodes to the Pool. The default value is 15 minutes. The
     minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service
     returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad
     Request)."""
    node_deallocation_option: Optional[Union[str, "_models.BatchNodeDeallocationOption"]] = rest_field(
        name="nodeDeallocationOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Determines what to do with a Compute Node and its running task(s) after it has been selected
     for deallocation. The default value is requeue. Known values are: \"requeue\", \"terminate\",
     \"taskcompletion\", and \"retaineddata\"."""

    @overload
    def __init__(
        self,
        *,
        node_ids: list[str],
        resize_timeout: Optional[datetime.timedelta] = None,
        node_deallocation_option: Optional[Union[str, "_models.BatchNodeDeallocationOption"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNodeUserCreateOptions(_Model):
    """Parameters for creating a user account for RDP or SSH access on an Azure Batch Compute Node.

    :ivar name: The user name of the Account. Required.
    :vartype name: str
    :ivar is_admin: Whether the Account should be an administrator on the Compute Node. The default
     value is false.
    :vartype is_admin: bool
    :ivar expiry_time: The time at which the Account should expire. If omitted, the default is 1
     day from the current time. For Linux Compute Nodes, the expiryTime has a precision up to a day.
    :vartype expiry_time: ~datetime.datetime
    :ivar password: The password of the Account. The password is required for Windows Compute
     Nodes. For Linux Compute Nodes, the password can optionally be specified along with the
     sshPublicKey property.
    :vartype password: str
    :ivar ssh_public_key: The SSH public key that can be used for remote login to the Compute Node.
     The public key should be compatible with OpenSSH encoding and should be base 64 encoded. This
     property can be specified only for Linux Compute Nodes. If this is specified for a Windows
     Compute Node, then the Batch service rejects the request; if you are calling the REST API
     directly, the HTTP status code is 400 (Bad Request).
    :vartype ssh_public_key: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The user name of the Account. Required."""
    is_admin: Optional[bool] = rest_field(name="isAdmin", visibility=["read", "create", "update", "delete", "query"])
    """Whether the Account should be an administrator on the Compute Node. The default value is false."""
    expiry_time: Optional[datetime.datetime] = rest_field(
        name="expiryTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the Account should expire. If omitted, the default is 1 day from the current
     time. For Linux Compute Nodes, the expiryTime has a precision up to a day."""
    password: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The password of the Account. The password is required for Windows Compute Nodes. For Linux
     Compute Nodes, the password can optionally be specified along with the sshPublicKey property."""
    ssh_public_key: Optional[str] = rest_field(
        name="sshPublicKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """The SSH public key that can be used for remote login to the Compute Node. The public key should
     be compatible with OpenSSH encoding and should be base 64 encoded. This property can be
     specified only for Linux Compute Nodes. If this is specified for a Windows Compute Node, then
     the Batch service rejects the request; if you are calling the REST API directly, the HTTP
     status code is 400 (Bad Request)."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        is_admin: Optional[bool] = None,
        expiry_time: Optional[datetime.datetime] = None,
        password: Optional[str] = None,
        ssh_public_key: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNodeUserUpdateOptions(_Model):
    """Parameters for updating a user account for RDP or SSH access on an Azure Batch Compute Node.

    :ivar password: The password of the Account. The password is required for Windows Compute
     Nodes. For Linux Compute Nodes, the password can optionally be specified along with the
     sshPublicKey property. If omitted, any existing password is removed.
    :vartype password: str
    :ivar expiry_time: The time at which the Account should expire. If omitted, the default is 1
     day from the current time. For Linux Compute Nodes, the expiryTime has a precision up to a day.
    :vartype expiry_time: ~datetime.datetime
    :ivar ssh_public_key: The SSH public key that can be used for remote login to the Compute Node.
     The public key should be compatible with OpenSSH encoding and should be base 64 encoded. This
     property can be specified only for Linux Compute Nodes. If this is specified for a Windows
     Compute Node, then the Batch service rejects the request; if you are calling the REST API
     directly, the HTTP status code is 400 (Bad Request). If omitted, any existing SSH public key is
     removed.
    :vartype ssh_public_key: str
    """

    password: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The password of the Account. The password is required for Windows Compute Nodes. For Linux
     Compute Nodes, the password can optionally be specified along with the sshPublicKey property.
     If omitted, any existing password is removed."""
    expiry_time: Optional[datetime.datetime] = rest_field(
        name="expiryTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the Account should expire. If omitted, the default is 1 day from the current
     time. For Linux Compute Nodes, the expiryTime has a precision up to a day."""
    ssh_public_key: Optional[str] = rest_field(
        name="sshPublicKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """The SSH public key that can be used for remote login to the Compute Node. The public key should
     be compatible with OpenSSH encoding and should be base 64 encoded. This property can be
     specified only for Linux Compute Nodes. If this is specified for a Windows Compute Node, then
     the Batch service rejects the request; if you are calling the REST API directly, the HTTP
     status code is 400 (Bad Request). If omitted, any existing SSH public key is removed."""

    @overload
    def __init__(
        self,
        *,
        password: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        ssh_public_key: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchNodeVMExtension(_Model):
    """The configuration for virtual machine extension instance view.

    :ivar provisioning_state: The provisioning state of the virtual machine extension.
    :vartype provisioning_state: str
    :ivar vm_extension: The virtual machine extension.
    :vartype vm_extension: ~azure.batch.models.VMExtension
    :ivar instance_view: The vm extension instance view.
    :vartype instance_view: ~azure.batch.models.VMExtensionInstanceView
    """

    provisioning_state: Optional[str] = rest_field(
        name="provisioningState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The provisioning state of the virtual machine extension."""
    vm_extension: Optional["_models.VMExtension"] = rest_field(
        name="vmExtension", visibility=["read", "create", "update", "delete", "query"]
    )
    """The virtual machine extension."""
    instance_view: Optional["_models.VMExtensionInstanceView"] = rest_field(
        name="instanceView", visibility=["read", "create", "update", "delete", "query"]
    )
    """The vm extension instance view."""

    @overload
    def __init__(
        self,
        *,
        provisioning_state: Optional[str] = None,
        vm_extension: Optional["_models.VMExtension"] = None,
        instance_view: Optional["_models.VMExtensionInstanceView"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchOsDisk(_Model):
    """Settings for the operating system disk of the compute node (VM).

    :ivar ephemeral_os_disk_settings: Specifies the ephemeral Disk Settings for the operating
     system disk used by the compute node (VM).
    :vartype ephemeral_os_disk_settings: ~azure.batch.models.BatchDiffDiskSettings
    :ivar caching: Specifies the caching requirements. Possible values are: None, ReadOnly,
     ReadWrite. The default values are: None for Standard storage. ReadOnly for Premium storage.
     Known values are: "none", "readonly", and "readwrite".
    :vartype caching: str or ~azure.batch.models.CachingType
    :ivar disk_size_gb: The initial disk size in GB when creating new OS disk.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk: ~azure.batch.models.ManagedDisk
    :ivar write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :vartype write_accelerator_enabled: bool
    """

    ephemeral_os_disk_settings: Optional["_models.BatchDiffDiskSettings"] = rest_field(
        name="ephemeralOSDiskSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the ephemeral Disk Settings for the operating system disk used by the compute node
     (VM)."""
    caching: Optional[Union[str, "_models.CachingType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the caching requirements. Possible values are: None, ReadOnly, ReadWrite. The default
     values are: None for Standard storage. ReadOnly for Premium storage. Known values are:
     \"none\", \"readonly\", and \"readwrite\"."""
    disk_size_gb: Optional[int] = rest_field(
        name="diskSizeGB", visibility=["read", "create", "update", "delete", "query"]
    )
    """The initial disk size in GB when creating new OS disk."""
    managed_disk: Optional["_models.ManagedDisk"] = rest_field(
        name="managedDisk", visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed disk parameters."""
    write_accelerator_enabled: Optional[bool] = rest_field(
        name="writeAcceleratorEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether writeAccelerator should be enabled or disabled on the disk."""

    @overload
    def __init__(
        self,
        *,
        ephemeral_os_disk_settings: Optional["_models.BatchDiffDiskSettings"] = None,
        caching: Optional[Union[str, "_models.CachingType"]] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["_models.ManagedDisk"] = None,
        write_accelerator_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPool(_Model):
    """A Pool in the Azure Batch service.

    :ivar id: A string that uniquely identifies the Pool within the Account. The ID can contain any
     combination of alphanumeric characters including hyphens and underscores, and cannot contain
     more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not
     have two IDs within an Account that differ only by case). Required.
    :vartype id: str
    :ivar display_name: The display name need not be unique and can contain any Unicode characters
     up to a maximum length of 1024.
    :vartype display_name: str
    :ivar url: The URL of the Pool. Required.
    :vartype url: str
    :ivar e_tag: The ETag of the Pool. This is an opaque string. You can use it to detect whether
     the Pool has changed between requests. In particular, you can be pass the ETag when updating a
     Pool to specify that your changes should take effect only if nobody else has modified the Pool
     in the meantime. Required.
    :vartype e_tag: str
    :ivar last_modified: The last modified time of the Pool. This is the last time at which the
     Pool level data, such as the targetDedicatedNodes or enableAutoscale settings, changed. It does
     not factor in node-level changes such as a Compute Node changing state. Required.
    :vartype last_modified: ~datetime.datetime
    :ivar creation_time: The creation time of the Pool. Required.
    :vartype creation_time: ~datetime.datetime
    :ivar state: The current state of the Pool. Required. Known values are: "active" and
     "deleting".
    :vartype state: str or ~azure.batch.models.BatchPoolState
    :ivar state_transition_time: The time at which the Pool entered its current state. Required.
    :vartype state_transition_time: ~datetime.datetime
    :ivar allocation_state: Whether the Pool is resizing. Known values are: "steady", "resizing",
     and "stopping".
    :vartype allocation_state: str or ~azure.batch.models.AllocationState
    :ivar allocation_state_transition_time: The time at which the Pool entered its current
     allocation state.
    :vartype allocation_state_transition_time: ~datetime.datetime
    :ivar vm_size: The size of virtual machines in the Pool. All virtual machines in a Pool are the
     same size. For information about available sizes of virtual machines in Pools, see Choose a VM
     size for Compute Nodes in an Azure Batch Pool
     (`https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes
     <https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes>`_). Required.
    :vartype vm_size: str
    :ivar virtual_machine_configuration: The virtual machine configuration for the Pool. This
     property must be specified.
    :vartype virtual_machine_configuration: ~azure.batch.models.VirtualMachineConfiguration
    :ivar resize_timeout: The timeout for allocation of Compute Nodes to the Pool. This is the
     timeout for the most recent resize operation. (The initial sizing when the Pool is created
     counts as a resize.) The default value is 15 minutes.
    :vartype resize_timeout: ~datetime.timedelta
    :ivar resize_errors: A list of errors encountered while performing the last resize on the Pool.
     This property is set only if one or more errors occurred during the last Pool resize, and only
     when the Pool allocationState is Steady.
    :vartype resize_errors: list[~azure.batch.models.ResizeError]
    :ivar current_dedicated_nodes: The number of dedicated Compute Nodes currently in the Pool.
     Required.
    :vartype current_dedicated_nodes: int
    :ivar current_low_priority_nodes: The number of Spot/Low-priority Compute Nodes currently in
     the Pool. Spot/Low-priority Compute Nodes which have been preempted are included in this count.
     Required.
    :vartype current_low_priority_nodes: int
    :ivar target_dedicated_nodes: The desired number of dedicated Compute Nodes in the Pool.
    :vartype target_dedicated_nodes: int
    :ivar target_low_priority_nodes: The desired number of Spot/Low-priority Compute Nodes in the
     Pool.
    :vartype target_low_priority_nodes: int
    :ivar enable_auto_scale: Whether the Pool size should automatically adjust over time. If false,
     at least one of targetDedicatedNodes and targetLowPriorityNodes must be specified. If true, the
     autoScaleFormula property is required and the Pool automatically resizes according to the
     formula. The default value is false.
    :vartype enable_auto_scale: bool
    :ivar auto_scale_formula: A formula for the desired number of Compute Nodes in the Pool. This
     property is set only if the Pool automatically scales, i.e. enableAutoScale is true.
    :vartype auto_scale_formula: str
    :ivar auto_scale_evaluation_interval: The time interval at which to automatically adjust the
     Pool size according to the autoscale formula. This property is set only if the Pool
     automatically scales, i.e. enableAutoScale is true.
    :vartype auto_scale_evaluation_interval: ~datetime.timedelta
    :ivar auto_scale_run: The results and errors from the last execution of the autoscale formula.
     This property is set only if the Pool automatically scales, i.e. enableAutoScale is true.
    :vartype auto_scale_run: ~azure.batch.models.AutoScaleRun
    :ivar enable_inter_node_communication: Whether the Pool permits direct communication between
     Compute Nodes. Enabling inter-node communication limits the maximum size of the Pool due to
     deployment restrictions on the Compute Nodes of the Pool. This may result in the Pool not
     reaching its desired size. The default value is false.
    :vartype enable_inter_node_communication: bool
    :ivar network_configuration: The network configuration for the Pool.
    :vartype network_configuration: ~azure.batch.models.NetworkConfiguration
    :ivar start_task: A Task specified to run on each Compute Node as it joins the Pool.
    :vartype start_task: ~azure.batch.models.BatchStartTask
    :ivar application_package_references: The list of Packages to be installed on each Compute Node
     in the Pool. Changes to Package references affect all new Nodes joining the Pool, but do not
     affect Compute Nodes that are already in the Pool until they are rebooted or reimaged. There is
     a maximum of 10 Package references on any given Pool.
    :vartype application_package_references:
     list[~azure.batch.models.BatchApplicationPackageReference]
    :ivar task_slots_per_node: The number of task slots that can be used to run concurrent tasks on
     a single compute node in the pool. The default value is 1. The maximum value is the smaller of
     4 times the number of cores of the vmSize of the pool or 256.
    :vartype task_slots_per_node: int
    :ivar task_scheduling_policy: How Tasks are distributed across Compute Nodes in a Pool. If not
     specified, the default is spread.
    :vartype task_scheduling_policy: ~azure.batch.models.BatchTaskSchedulingPolicy
    :ivar user_accounts: The list of user Accounts to be created on each Compute Node in the Pool.
    :vartype user_accounts: list[~azure.batch.models.UserAccount]
    :ivar metadata: A list of name-value pairs associated with the Pool as metadata.
    :vartype metadata: list[~azure.batch.models.BatchMetadataItem]
    :ivar pool_statistics: Utilization and resource usage statistics for the entire lifetime of the
     Pool. This property is populated only if the BatchPool was retrieved with an expand clause
     including the 'stats' attribute; otherwise it is null. The statistics may not be immediately
     available. The Batch service performs periodic roll-up of statistics. The typical delay is
     about 30 minutes.
    :vartype pool_statistics: ~azure.batch.models.BatchPoolStatistics
    :ivar mount_configuration: Mount storage using specified file system for the entire lifetime of
     the pool. Mount the storage using Azure fileshare, NFS, CIFS or Blobfuse based file system.
    :vartype mount_configuration: list[~azure.batch.models.MountConfiguration]
    :ivar identity: The identity of the Batch pool, if configured. The list of user identities
     associated with the Batch pool. The user identity dictionary key references will be ARM
     resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype identity: ~azure.batch.models.BatchPoolIdentity
    :ivar upgrade_policy: The upgrade policy for the Pool. Describes an upgrade policy - automatic,
     manual, or rolling.
    :vartype upgrade_policy: ~azure.batch.models.UpgradePolicy
    """

    id: str = rest_field(visibility=["read"])
    """A string that uniquely identifies the Pool within the Account. The ID can contain any
     combination of alphanumeric characters including hyphens and underscores, and cannot contain
     more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not
     have two IDs within an Account that differ only by case). Required."""
    display_name: Optional[str] = rest_field(name="displayName", visibility=["read"])
    """The display name need not be unique and can contain any Unicode characters up to a maximum
     length of 1024."""
    url: str = rest_field(visibility=["read"])
    """The URL of the Pool. Required."""
    e_tag: str = rest_field(name="eTag", visibility=["read"])
    """The ETag of the Pool. This is an opaque string. You can use it to detect whether the Pool has
     changed between requests. In particular, you can be pass the ETag when updating a Pool to
     specify that your changes should take effect only if nobody else has modified the Pool in the
     meantime. Required."""
    last_modified: datetime.datetime = rest_field(name="lastModified", visibility=["read"], format="rfc3339")
    """The last modified time of the Pool. This is the last time at which the Pool level data, such as
     the targetDedicatedNodes or enableAutoscale settings, changed. It does not factor in node-level
     changes such as a Compute Node changing state. Required."""
    creation_time: datetime.datetime = rest_field(name="creationTime", visibility=["read"], format="rfc3339")
    """The creation time of the Pool. Required."""
    state: Union[str, "_models.BatchPoolState"] = rest_field(visibility=["read"])
    """The current state of the Pool. Required. Known values are: \"active\" and \"deleting\"."""
    state_transition_time: datetime.datetime = rest_field(
        name="stateTransitionTime", visibility=["read"], format="rfc3339"
    )
    """The time at which the Pool entered its current state. Required."""
    allocation_state: Optional[Union[str, "_models.AllocationState"]] = rest_field(
        name="allocationState", visibility=["read"]
    )
    """Whether the Pool is resizing. Known values are: \"steady\", \"resizing\", and \"stopping\"."""
    allocation_state_transition_time: Optional[datetime.datetime] = rest_field(
        name="allocationStateTransitionTime", visibility=["read"], format="rfc3339"
    )
    """The time at which the Pool entered its current allocation state."""
    vm_size: str = rest_field(name="vmSize", visibility=["read"])
    """The size of virtual machines in the Pool. All virtual machines in a Pool are the same size. For
     information about available sizes of virtual machines in Pools, see Choose a VM size for
     Compute Nodes in an Azure Batch Pool
     (`https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes
     <https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes>`_). Required."""
    virtual_machine_configuration: Optional["_models.VirtualMachineConfiguration"] = rest_field(
        name="virtualMachineConfiguration", visibility=["read"]
    )
    """The virtual machine configuration for the Pool. This property must be specified."""
    resize_timeout: Optional[datetime.timedelta] = rest_field(name="resizeTimeout", visibility=["read"])
    """The timeout for allocation of Compute Nodes to the Pool. This is the timeout for the most
     recent resize operation. (The initial sizing when the Pool is created counts as a resize.) The
     default value is 15 minutes."""
    resize_errors: Optional[list["_models.ResizeError"]] = rest_field(name="resizeErrors", visibility=["read"])
    """A list of errors encountered while performing the last resize on the Pool. This property is set
     only if one or more errors occurred during the last Pool resize, and only when the Pool
     allocationState is Steady."""
    current_dedicated_nodes: int = rest_field(name="currentDedicatedNodes", visibility=["read"])
    """The number of dedicated Compute Nodes currently in the Pool. Required."""
    current_low_priority_nodes: int = rest_field(name="currentLowPriorityNodes", visibility=["read"])
    """The number of Spot/Low-priority Compute Nodes currently in the Pool. Spot/Low-priority Compute
     Nodes which have been preempted are included in this count. Required."""
    target_dedicated_nodes: Optional[int] = rest_field(name="targetDedicatedNodes", visibility=["read"])
    """The desired number of dedicated Compute Nodes in the Pool."""
    target_low_priority_nodes: Optional[int] = rest_field(name="targetLowPriorityNodes", visibility=["read"])
    """The desired number of Spot/Low-priority Compute Nodes in the Pool."""
    enable_auto_scale: Optional[bool] = rest_field(name="enableAutoScale", visibility=["read"])
    """Whether the Pool size should automatically adjust over time. If false, at least one of
     targetDedicatedNodes and targetLowPriorityNodes must be specified. If true, the
     autoScaleFormula property is required and the Pool automatically resizes according to the
     formula. The default value is false."""
    auto_scale_formula: Optional[str] = rest_field(name="autoScaleFormula", visibility=["read"])
    """A formula for the desired number of Compute Nodes in the Pool. This property is set only if the
     Pool automatically scales, i.e. enableAutoScale is true."""
    auto_scale_evaluation_interval: Optional[datetime.timedelta] = rest_field(
        name="autoScaleEvaluationInterval", visibility=["read"]
    )
    """The time interval at which to automatically adjust the Pool size according to the autoscale
     formula. This property is set only if the Pool automatically scales, i.e. enableAutoScale is
     true."""
    auto_scale_run: Optional["_models.AutoScaleRun"] = rest_field(name="autoScaleRun", visibility=["read"])
    """The results and errors from the last execution of the autoscale formula. This property is set
     only if the Pool automatically scales, i.e. enableAutoScale is true."""
    enable_inter_node_communication: Optional[bool] = rest_field(
        name="enableInterNodeCommunication", visibility=["read"]
    )
    """Whether the Pool permits direct communication between Compute Nodes. Enabling inter-node
     communication limits the maximum size of the Pool due to deployment restrictions on the Compute
     Nodes of the Pool. This may result in the Pool not reaching its desired size. The default value
     is false."""
    network_configuration: Optional["_models.NetworkConfiguration"] = rest_field(
        name="networkConfiguration", visibility=["read"]
    )
    """The network configuration for the Pool."""
    start_task: Optional["_models.BatchStartTask"] = rest_field(
        name="startTask", visibility=["read", "create", "update", "delete", "query"]
    )
    """A Task specified to run on each Compute Node as it joins the Pool."""
    application_package_references: Optional[list["_models.BatchApplicationPackageReference"]] = rest_field(
        name="applicationPackageReferences", visibility=["read"]
    )
    """The list of Packages to be installed on each Compute Node in the Pool. Changes to Package
     references affect all new Nodes joining the Pool, but do not affect Compute Nodes that are
     already in the Pool until they are rebooted or reimaged. There is a maximum of 10 Package
     references on any given Pool."""
    task_slots_per_node: Optional[int] = rest_field(name="taskSlotsPerNode", visibility=["read"])
    """The number of task slots that can be used to run concurrent tasks on a single compute node in
     the pool. The default value is 1. The maximum value is the smaller of 4 times the number of
     cores of the vmSize of the pool or 256."""
    task_scheduling_policy: Optional["_models.BatchTaskSchedulingPolicy"] = rest_field(
        name="taskSchedulingPolicy", visibility=["read"]
    )
    """How Tasks are distributed across Compute Nodes in a Pool. If not specified, the default is
     spread."""
    user_accounts: Optional[list["_models.UserAccount"]] = rest_field(name="userAccounts", visibility=["read"])
    """The list of user Accounts to be created on each Compute Node in the Pool."""
    metadata: Optional[list["_models.BatchMetadataItem"]] = rest_field(visibility=["read"])
    """A list of name-value pairs associated with the Pool as metadata."""
    pool_statistics: Optional["_models.BatchPoolStatistics"] = rest_field(name="stats", visibility=["read"])
    """Utilization and resource usage statistics for the entire lifetime of the Pool. This property is
     populated only if the BatchPool was retrieved with an expand clause including the 'stats'
     attribute; otherwise it is null. The statistics may not be immediately available. The Batch
     service performs periodic roll-up of statistics. The typical delay is about 30 minutes."""
    mount_configuration: Optional[list["_models.MountConfiguration"]] = rest_field(
        name="mountConfiguration", visibility=["read"]
    )
    """Mount storage using specified file system for the entire lifetime of the pool. Mount the
     storage using Azure fileshare, NFS, CIFS or Blobfuse based file system."""
    identity: Optional["_models.BatchPoolIdentity"] = rest_field(visibility=["read"])
    """The identity of the Batch pool, if configured. The list of user identities associated with the
     Batch pool. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'."""
    upgrade_policy: Optional["_models.UpgradePolicy"] = rest_field(
        name="upgradePolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The upgrade policy for the Pool. Describes an upgrade policy - automatic, manual, or rolling."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        start_task: Optional["_models.BatchStartTask"] = None,
        upgrade_policy: Optional["_models.UpgradePolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPoolCreateOptions(_Model):
    """Parameters for creating an Azure Batch Pool.

    :ivar id: A string that uniquely identifies the Pool within the Account. The ID can contain any
     combination of alphanumeric characters including hyphens and underscores, and cannot contain
     more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not
     have two Pool IDs within an Account that differ only by case). Required.
    :vartype id: str
    :ivar display_name: The display name for the Pool. The display name need not be unique and can
     contain any Unicode characters up to a maximum length of 1024.
    :vartype display_name: str
    :ivar vm_size: The size of virtual machines in the Pool. All virtual machines in a Pool are the
     same size. For information about available VM sizes for Pools using Images from the Virtual
     Machines Marketplace (pools created with virtualMachineConfiguration), see Sizes for Virtual
     Machines in Azure (`https://learn.microsoft.com/azure/virtual-machines/sizes/overview
     <https://learn.microsoft.com/azure/virtual-machines/sizes/overview>`_). Batch supports all
     Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and
     STANDARD_DSV2 series). Required.
    :vartype vm_size: str
    :ivar virtual_machine_configuration: The virtual machine configuration for the Pool. This
     property must be specified.
    :vartype virtual_machine_configuration: ~azure.batch.models.VirtualMachineConfiguration
    :ivar resize_timeout: The timeout for allocation of Compute Nodes to the Pool. This timeout
     applies only to manual scaling; it has no effect when enableAutoScale is set to true. The
     default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5
     minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP
     status code is 400 (Bad Request).
    :vartype resize_timeout: ~datetime.timedelta
    :ivar target_dedicated_nodes: The desired number of dedicated Compute Nodes in the Pool. This
     property must not be specified if enableAutoScale is set to true. If enableAutoScale is set to
     false, then you must set either targetDedicatedNodes, targetLowPriorityNodes, or both.
    :vartype target_dedicated_nodes: int
    :ivar target_low_priority_nodes: The desired number of Spot/Low-priority Compute Nodes in the
     Pool. This property must not be specified if enableAutoScale is set to true. If enableAutoScale
     is set to false, then you must set either targetDedicatedNodes, targetLowPriorityNodes, or
     both.
    :vartype target_low_priority_nodes: int
    :ivar enable_auto_scale: Whether the Pool size should automatically adjust over time. If false,
     at least one of targetDedicatedNodes and targetLowPriorityNodes must be specified. If true, the
     autoScaleFormula property is required and the Pool automatically resizes according to the
     formula. The default value is false.
    :vartype enable_auto_scale: bool
    :ivar auto_scale_formula: A formula for the desired number of Compute Nodes in the Pool. This
     property must not be specified if enableAutoScale is set to false. It is required if
     enableAutoScale is set to true. The formula is checked for validity before the Pool is created.
     If the formula is not valid, the Batch service rejects the request with detailed error
     information. For more information about specifying this formula, see 'Automatically scale
     Compute Nodes in an Azure Batch Pool'
     (`https://learn.microsoft.com/azure/batch/batch-automatic-scaling
     <https://learn.microsoft.com/azure/batch/batch-automatic-scaling>`_).
    :vartype auto_scale_formula: str
    :ivar auto_scale_evaluation_interval: The time interval at which to automatically adjust the
     Pool size according to the autoscale formula. The default value is 15 minutes. The minimum and
     maximum value are 5 minutes and 168 hours respectively. If you specify a value less than 5
     minutes or greater than 168 hours, the Batch service returns an error; if you are calling the
     REST API directly, the HTTP status code is 400 (Bad Request).
    :vartype auto_scale_evaluation_interval: ~datetime.timedelta
    :ivar enable_inter_node_communication: Whether the Pool permits direct communication between
     Compute Nodes. Enabling inter-node communication limits the maximum size of the Pool due to
     deployment restrictions on the Compute Nodes of the Pool. This may result in the Pool not
     reaching its desired size. The default value is false.
    :vartype enable_inter_node_communication: bool
    :ivar network_configuration: The network configuration for the Pool.
    :vartype network_configuration: ~azure.batch.models.NetworkConfiguration
    :ivar start_task: A Task specified to run on each Compute Node as it joins the Pool. The Task
     runs when the Compute Node is added to the Pool or when the Compute Node is restarted.
    :vartype start_task: ~azure.batch.models.BatchStartTask
    :ivar application_package_references: The list of Packages to be installed on each Compute Node
     in the Pool. When creating a pool, the package's application ID must be fully qualified
     (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
     Changes to Package references affect all new Nodes joining the Pool, but do not affect Compute
     Nodes that are already in the Pool until they are rebooted or reimaged. There is a maximum of
     10 Package references on any given Pool.
    :vartype application_package_references:
     list[~azure.batch.models.BatchApplicationPackageReference]
    :ivar task_slots_per_node: The number of task slots that can be used to run concurrent tasks on
     a single compute node in the pool. The default value is 1. The maximum value is the smaller of
     4 times the number of cores of the vmSize of the pool or 256.
    :vartype task_slots_per_node: int
    :ivar task_scheduling_policy: How Tasks are distributed across Compute Nodes in a Pool. If not
     specified, the default is spread.
    :vartype task_scheduling_policy: ~azure.batch.models.BatchTaskSchedulingPolicy
    :ivar user_accounts: The list of user Accounts to be created on each Compute Node in the Pool.
    :vartype user_accounts: list[~azure.batch.models.UserAccount]
    :ivar metadata: A list of name-value pairs associated with the Pool as metadata. The Batch
     service does not assign any meaning to metadata; it is solely for the use of user code.
    :vartype metadata: list[~azure.batch.models.BatchMetadataItem]
    :ivar mount_configuration: Mount storage using specified file system for the entire lifetime of
     the pool. Mount the storage using Azure fileshare, NFS, CIFS or Blobfuse based file system.
    :vartype mount_configuration: list[~azure.batch.models.MountConfiguration]
    :ivar upgrade_policy: The upgrade policy for the Pool. Describes an upgrade policy - automatic,
     manual, or rolling.
    :vartype upgrade_policy: ~azure.batch.models.UpgradePolicy
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A string that uniquely identifies the Pool within the Account. The ID can contain any
     combination of alphanumeric characters including hyphens and underscores, and cannot contain
     more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not
     have two Pool IDs within an Account that differ only by case). Required."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The display name for the Pool. The display name need not be unique and can contain any Unicode
     characters up to a maximum length of 1024."""
    vm_size: str = rest_field(name="vmSize", visibility=["read", "create", "update", "delete", "query"])
    """The size of virtual machines in the Pool. All virtual machines in a Pool are the same size. For
     information about available VM sizes for Pools using Images from the Virtual Machines
     Marketplace (pools created with virtualMachineConfiguration), see Sizes for Virtual Machines in
     Azure (`https://learn.microsoft.com/azure/virtual-machines/sizes/overview
     <https://learn.microsoft.com/azure/virtual-machines/sizes/overview>`_). Batch supports all
     Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and
     STANDARD_DSV2 series). Required."""
    virtual_machine_configuration: Optional["_models.VirtualMachineConfiguration"] = rest_field(
        name="virtualMachineConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The virtual machine configuration for the Pool. This property must be specified."""
    resize_timeout: Optional[datetime.timedelta] = rest_field(
        name="resizeTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """The timeout for allocation of Compute Nodes to the Pool. This timeout applies only to manual
     scaling; it has no effect when enableAutoScale is set to true. The default value is 15 minutes.
     The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service
     returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad
     Request)."""
    target_dedicated_nodes: Optional[int] = rest_field(
        name="targetDedicatedNodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired number of dedicated Compute Nodes in the Pool. This property must not be specified
     if enableAutoScale is set to true. If enableAutoScale is set to false, then you must set either
     targetDedicatedNodes, targetLowPriorityNodes, or both."""
    target_low_priority_nodes: Optional[int] = rest_field(
        name="targetLowPriorityNodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired number of Spot/Low-priority Compute Nodes in the Pool. This property must not be
     specified if enableAutoScale is set to true. If enableAutoScale is set to false, then you must
     set either targetDedicatedNodes, targetLowPriorityNodes, or both."""
    enable_auto_scale: Optional[bool] = rest_field(
        name="enableAutoScale", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the Pool size should automatically adjust over time. If false, at least one of
     targetDedicatedNodes and targetLowPriorityNodes must be specified. If true, the
     autoScaleFormula property is required and the Pool automatically resizes according to the
     formula. The default value is false."""
    auto_scale_formula: Optional[str] = rest_field(
        name="autoScaleFormula", visibility=["read", "create", "update", "delete", "query"]
    )
    """A formula for the desired number of Compute Nodes in the Pool. This property must not be
     specified if enableAutoScale is set to false. It is required if enableAutoScale is set to true.
     The formula is checked for validity before the Pool is created. If the formula is not valid,
     the Batch service rejects the request with detailed error information. For more information
     about specifying this formula, see 'Automatically scale Compute Nodes in an Azure Batch Pool'
     (`https://learn.microsoft.com/azure/batch/batch-automatic-scaling
     <https://learn.microsoft.com/azure/batch/batch-automatic-scaling>`_)."""
    auto_scale_evaluation_interval: Optional[datetime.timedelta] = rest_field(
        name="autoScaleEvaluationInterval", visibility=["read", "create", "update", "delete", "query"]
    )
    """The time interval at which to automatically adjust the Pool size according to the autoscale
     formula. The default value is 15 minutes. The minimum and maximum value are 5 minutes and 168
     hours respectively. If you specify a value less than 5 minutes or greater than 168 hours, the
     Batch service returns an error; if you are calling the REST API directly, the HTTP status code
     is 400 (Bad Request)."""
    enable_inter_node_communication: Optional[bool] = rest_field(
        name="enableInterNodeCommunication", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the Pool permits direct communication between Compute Nodes. Enabling inter-node
     communication limits the maximum size of the Pool due to deployment restrictions on the Compute
     Nodes of the Pool. This may result in the Pool not reaching its desired size. The default value
     is false."""
    network_configuration: Optional["_models.NetworkConfiguration"] = rest_field(
        name="networkConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The network configuration for the Pool."""
    start_task: Optional["_models.BatchStartTask"] = rest_field(
        name="startTask", visibility=["read", "create", "update", "delete", "query"]
    )
    """A Task specified to run on each Compute Node as it joins the Pool. The Task runs when the
     Compute Node is added to the Pool or when the Compute Node is restarted."""
    application_package_references: Optional[list["_models.BatchApplicationPackageReference"]] = rest_field(
        name="applicationPackageReferences", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of Packages to be installed on each Compute Node in the Pool. When creating a pool,
     the package's application ID must be fully qualified
     (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
     Changes to Package references affect all new Nodes joining the Pool, but do not affect Compute
     Nodes that are already in the Pool until they are rebooted or reimaged. There is a maximum of
     10 Package references on any given Pool."""
    task_slots_per_node: Optional[int] = rest_field(
        name="taskSlotsPerNode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of task slots that can be used to run concurrent tasks on a single compute node in
     the pool. The default value is 1. The maximum value is the smaller of 4 times the number of
     cores of the vmSize of the pool or 256."""
    task_scheduling_policy: Optional["_models.BatchTaskSchedulingPolicy"] = rest_field(
        name="taskSchedulingPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """How Tasks are distributed across Compute Nodes in a Pool. If not specified, the default is
     spread."""
    user_accounts: Optional[list["_models.UserAccount"]] = rest_field(
        name="userAccounts", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of user Accounts to be created on each Compute Node in the Pool."""
    metadata: Optional[list["_models.BatchMetadataItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of name-value pairs associated with the Pool as metadata. The Batch service does not
     assign any meaning to metadata; it is solely for the use of user code."""
    mount_configuration: Optional[list["_models.MountConfiguration"]] = rest_field(
        name="mountConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mount storage using specified file system for the entire lifetime of the pool. Mount the
     storage using Azure fileshare, NFS, CIFS or Blobfuse based file system."""
    upgrade_policy: Optional["_models.UpgradePolicy"] = rest_field(
        name="upgradePolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The upgrade policy for the Pool. Describes an upgrade policy - automatic, manual, or rolling."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        vm_size: str,
        display_name: Optional[str] = None,
        virtual_machine_configuration: Optional["_models.VirtualMachineConfiguration"] = None,
        resize_timeout: Optional[datetime.timedelta] = None,
        target_dedicated_nodes: Optional[int] = None,
        target_low_priority_nodes: Optional[int] = None,
        enable_auto_scale: Optional[bool] = None,
        auto_scale_formula: Optional[str] = None,
        auto_scale_evaluation_interval: Optional[datetime.timedelta] = None,
        enable_inter_node_communication: Optional[bool] = None,
        network_configuration: Optional["_models.NetworkConfiguration"] = None,
        start_task: Optional["_models.BatchStartTask"] = None,
        application_package_references: Optional[list["_models.BatchApplicationPackageReference"]] = None,
        task_slots_per_node: Optional[int] = None,
        task_scheduling_policy: Optional["_models.BatchTaskSchedulingPolicy"] = None,
        user_accounts: Optional[list["_models.UserAccount"]] = None,
        metadata: Optional[list["_models.BatchMetadataItem"]] = None,
        mount_configuration: Optional[list["_models.MountConfiguration"]] = None,
        upgrade_policy: Optional["_models.UpgradePolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPoolEnableAutoScaleOptions(_Model):
    """Parameters for enabling automatic scaling on an Azure Batch Pool.

    :ivar auto_scale_formula: The formula for the desired number of Compute Nodes in the Pool. The
     default value is 15 minutes. The minimum and maximum value are 5 minutes and 168 hours
     respectively. If you specify a value less than 5 minutes or greater than 168 hours, the Batch
     service rejects the request with an invalid property value error; if you are calling the REST
     API directly, the HTTP status code is 400 (Bad Request). If you specify a new interval, then
     the existing autoscale evaluation schedule will be stopped and a new autoscale evaluation
     schedule will be started, with its starting time being the time when this request was issued.
    :vartype auto_scale_formula: str
    :ivar auto_scale_evaluation_interval: The time interval at which to automatically adjust the
     Pool size according to the autoscale formula. The default value is 15 minutes. The minimum and
     maximum value are 5 minutes and 168 hours respectively. If you specify a value less than 5
     minutes or greater than 168 hours, the Batch service rejects the request with an invalid
     property value error; if you are calling the REST API directly, the HTTP status code is 400
     (Bad Request). If you specify a new interval, then the existing autoscale evaluation schedule
     will be stopped and a new autoscale evaluation schedule will be started, with its starting time
     being the time when this request was issued.
    :vartype auto_scale_evaluation_interval: ~datetime.timedelta
    """

    auto_scale_formula: Optional[str] = rest_field(
        name="autoScaleFormula", visibility=["read", "create", "update", "delete", "query"]
    )
    """The formula for the desired number of Compute Nodes in the Pool. The default value is 15
     minutes. The minimum and maximum value are 5 minutes and 168 hours respectively. If you specify
     a value less than 5 minutes or greater than 168 hours, the Batch service rejects the request
     with an invalid property value error; if you are calling the REST API directly, the HTTP status
     code is 400 (Bad Request). If you specify a new interval, then the existing autoscale
     evaluation schedule will be stopped and a new autoscale evaluation schedule will be started,
     with its starting time being the time when this request was issued."""
    auto_scale_evaluation_interval: Optional[datetime.timedelta] = rest_field(
        name="autoScaleEvaluationInterval", visibility=["read", "create", "update", "delete", "query"]
    )
    """The time interval at which to automatically adjust the Pool size according to the autoscale
     formula. The default value is 15 minutes. The minimum and maximum value are 5 minutes and 168
     hours respectively. If you specify a value less than 5 minutes or greater than 168 hours, the
     Batch service rejects the request with an invalid property value error; if you are calling the
     REST API directly, the HTTP status code is 400 (Bad Request). If you specify a new interval,
     then the existing autoscale evaluation schedule will be stopped and a new autoscale evaluation
     schedule will be started, with its starting time being the time when this request was issued."""

    @overload
    def __init__(
        self,
        *,
        auto_scale_formula: Optional[str] = None,
        auto_scale_evaluation_interval: Optional[datetime.timedelta] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPoolEndpointConfiguration(_Model):
    """The endpoint configuration for a Pool.

    :ivar inbound_nat_pools: A list of inbound NAT Pools that can be used to address specific ports
     on an individual Compute Node externally. The maximum number of inbound NAT Pools per Batch
     Pool is 5. If the maximum number of inbound NAT Pools is exceeded the request fails with HTTP
     status code 400. This cannot be specified if the IPAddressProvisioningType is
     NoPublicIPAddresses. Required.
    :vartype inbound_nat_pools: list[~azure.batch.models.BatchInboundNatPool]
    """

    inbound_nat_pools: list["_models.BatchInboundNatPool"] = rest_field(
        name="inboundNATPools", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of inbound NAT Pools that can be used to address specific ports on an individual Compute
     Node externally. The maximum number of inbound NAT Pools per Batch Pool is 5. If the maximum
     number of inbound NAT Pools is exceeded the request fails with HTTP status code 400. This
     cannot be specified if the IPAddressProvisioningType is NoPublicIPAddresses. Required."""

    @overload
    def __init__(
        self,
        *,
        inbound_nat_pools: list["_models.BatchInboundNatPool"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPoolEvaluateAutoScaleOptions(_Model):
    """Parameters for evaluating an automatic scaling formula on an Azure Batch Pool.

    :ivar auto_scale_formula: The formula for the desired number of Compute Nodes in the Pool. The
     formula is validated and its results calculated, but it is not applied to the Pool. To apply
     the formula to the Pool, 'Enable automatic scaling on a Pool'. For more information about
     specifying this formula, see Automatically scale Compute Nodes in an Azure Batch Pool
     (`https://learn.microsoft.com/azure/batch/batch-automatic-scaling
     <https://learn.microsoft.com/azure/batch/batch-automatic-scaling>`_). Required.
    :vartype auto_scale_formula: str
    """

    auto_scale_formula: str = rest_field(
        name="autoScaleFormula", visibility=["read", "create", "update", "delete", "query"]
    )
    """The formula for the desired number of Compute Nodes in the Pool. The formula is validated and
     its results calculated, but it is not applied to the Pool. To apply the formula to the Pool,
     'Enable automatic scaling on a Pool'. For more information about specifying this formula, see
     Automatically scale Compute Nodes in an Azure Batch Pool
     (`https://learn.microsoft.com/azure/batch/batch-automatic-scaling
     <https://learn.microsoft.com/azure/batch/batch-automatic-scaling>`_). Required."""

    @overload
    def __init__(
        self,
        *,
        auto_scale_formula: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPoolIdentity(_Model):
    """The identity of the Batch pool, if configured.

    :ivar type: The identity of the Batch pool, if configured. The list of user identities
     associated with the Batch pool. The user identity dictionary key references will be ARM
     resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     Required. Known values are: "UserAssigned" and "None".
    :vartype type: str or ~azure.batch.models.BatchPoolIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the Batch account.
     The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: list[~azure.batch.models.BatchUserAssignedIdentity]
    """

    type: Union[str, "_models.BatchPoolIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity of the Batch pool, if configured. The list of user identities associated with the
     Batch pool. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     Required. Known values are: \"UserAssigned\" and \"None\"."""
    user_assigned_identities: Optional[list["_models.BatchUserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of user identities associated with the Batch account. The user identity dictionary key
     references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.BatchPoolIdentityType"],
        user_assigned_identities: Optional[list["_models.BatchUserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPoolIdentityReference(_Model):
    """The reference of one of the pool identities to encrypt Disk. This identity will be used to
    access the key vault.

    :ivar resource_id: The ARM resource id of the user assigned identity. This reference must be
     included in the pool identities.
    :vartype resource_id: str
    """

    resource_id: Optional[str] = rest_field(
        name="resourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ARM resource id of the user assigned identity. This reference must be included in the pool
     identities."""

    @overload
    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPoolInfo(_Model):
    """Specifies how a Job should be assigned to a Pool.

    :ivar pool_id: The ID of an existing Pool. All the Tasks of the Job will run on the specified
     Pool. You must ensure that the Pool referenced by this property exists. If the Pool does not
     exist at the time the Batch service tries to schedule a Job, no Tasks for the Job will run
     until you create a Pool with that id. Note that the Batch service will not reject the Job
     request; it will simply not run Tasks until the Pool exists. You must specify either the Pool
     ID or the auto Pool specification, but not both.
    :vartype pool_id: str
    :ivar auto_pool_specification: Characteristics for a temporary 'auto pool'. The Batch service
     will create this auto Pool when the Job is submitted. If auto Pool creation fails, the Batch
     service moves the Job to a completed state, and the Pool creation error is set in the Job's
     scheduling error property. The Batch service manages the lifetime (both creation and, unless
     keepAlive is specified, deletion) of the auto Pool. Any user actions that affect the lifetime
     of the auto Pool while the Job is active will result in unexpected behavior. You must specify
     either the Pool ID or the auto Pool specification, but not both.
    :vartype auto_pool_specification: ~azure.batch.models.BatchAutoPoolSpecification
    """

    pool_id: Optional[str] = rest_field(name="poolId", visibility=["read", "create", "update", "delete", "query"])
    """The ID of an existing Pool. All the Tasks of the Job will run on the specified Pool. You must
     ensure that the Pool referenced by this property exists. If the Pool does not exist at the time
     the Batch service tries to schedule a Job, no Tasks for the Job will run until you create a
     Pool with that id. Note that the Batch service will not reject the Job request; it will simply
     not run Tasks until the Pool exists. You must specify either the Pool ID or the auto Pool
     specification, but not both."""
    auto_pool_specification: Optional["_models.BatchAutoPoolSpecification"] = rest_field(
        name="autoPoolSpecification", visibility=["read", "create", "update", "delete", "query"]
    )
    """Characteristics for a temporary 'auto pool'. The Batch service will create this auto Pool when
     the Job is submitted. If auto Pool creation fails, the Batch service moves the Job to a
     completed state, and the Pool creation error is set in the Job's scheduling error property. The
     Batch service manages the lifetime (both creation and, unless keepAlive is specified, deletion)
     of the auto Pool. Any user actions that affect the lifetime of the auto Pool while the Job is
     active will result in unexpected behavior. You must specify either the Pool ID or the auto Pool
     specification, but not both."""

    @overload
    def __init__(
        self,
        *,
        pool_id: Optional[str] = None,
        auto_pool_specification: Optional["_models.BatchAutoPoolSpecification"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPoolNodeCounts(_Model):
    """The number of Compute Nodes in each state for a Pool.

    :ivar pool_id: The ID of the Pool. Required.
    :vartype pool_id: str
    :ivar dedicated: The number of dedicated Compute Nodes in each state.
    :vartype dedicated: ~azure.batch.models.BatchNodeCounts
    :ivar low_priority: The number of Spot/Low-priority Compute Nodes in each state.
    :vartype low_priority: ~azure.batch.models.BatchNodeCounts
    """

    pool_id: str = rest_field(name="poolId", visibility=["read", "create", "update", "delete", "query"])
    """The ID of the Pool. Required."""
    dedicated: Optional["_models.BatchNodeCounts"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of dedicated Compute Nodes in each state."""
    low_priority: Optional["_models.BatchNodeCounts"] = rest_field(
        name="lowPriority", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of Spot/Low-priority Compute Nodes in each state."""

    @overload
    def __init__(
        self,
        *,
        pool_id: str,
        dedicated: Optional["_models.BatchNodeCounts"] = None,
        low_priority: Optional["_models.BatchNodeCounts"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPoolReplaceOptions(_Model):
    """Parameters for replacing properties on an Azure Batch Pool.

    :ivar start_task: A Task to run on each Compute Node as it joins the Pool. The Task runs when
     the Compute Node is added to the Pool or when the Compute Node is restarted. If this element is
     present, it overwrites any existing StartTask. If omitted, any existing StartTask is removed
     from the Pool.
    :vartype start_task: ~azure.batch.models.BatchStartTask
    :ivar application_package_references: The list of Application Packages to be installed on each
     Compute Node in the Pool. The list replaces any existing Application Package references on the
     Pool. Changes to Application Package references affect all new Compute Nodes joining the Pool,
     but do not affect Compute Nodes that are already in the Pool until they are rebooted or
     reimaged. There is a maximum of 10 Application Package references on any given Pool. If
     omitted, or if you specify an empty collection, any existing Application Packages references
     are removed from the Pool. A maximum of 10 references may be specified on a given Pool.
     Required.
    :vartype application_package_references:
     list[~azure.batch.models.BatchApplicationPackageReference]
    :ivar metadata: A list of name-value pairs associated with the Pool as metadata. This list
     replaces any existing metadata configured on the Pool. If omitted, or if you specify an empty
     collection, any existing metadata is removed from the Pool. Required.
    :vartype metadata: list[~azure.batch.models.BatchMetadataItem]
    """

    start_task: Optional["_models.BatchStartTask"] = rest_field(
        name="startTask", visibility=["read", "create", "update", "delete", "query"]
    )
    """A Task to run on each Compute Node as it joins the Pool. The Task runs when the Compute Node is
     added to the Pool or when the Compute Node is restarted. If this element is present, it
     overwrites any existing StartTask. If omitted, any existing StartTask is removed from the Pool."""
    application_package_references: list["_models.BatchApplicationPackageReference"] = rest_field(
        name="applicationPackageReferences", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of Application Packages to be installed on each Compute Node in the Pool. The list
     replaces any existing Application Package references on the Pool. Changes to Application
     Package references affect all new Compute Nodes joining the Pool, but do not affect Compute
     Nodes that are already in the Pool until they are rebooted or reimaged. There is a maximum of
     10 Application Package references on any given Pool. If omitted, or if you specify an empty
     collection, any existing Application Packages references are removed from the Pool. A maximum
     of 10 references may be specified on a given Pool. Required."""
    metadata: list["_models.BatchMetadataItem"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of name-value pairs associated with the Pool as metadata. This list replaces any
     existing metadata configured on the Pool. If omitted, or if you specify an empty collection,
     any existing metadata is removed from the Pool. Required."""

    @overload
    def __init__(
        self,
        *,
        application_package_references: list["_models.BatchApplicationPackageReference"],
        metadata: list["_models.BatchMetadataItem"],
        start_task: Optional["_models.BatchStartTask"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPoolResizeOptions(_Model):
    """Parameters for changing the size of an Azure Batch Pool.

    :ivar target_dedicated_nodes: The desired number of dedicated Compute Nodes in the Pool.
    :vartype target_dedicated_nodes: int
    :ivar target_low_priority_nodes: The desired number of Spot/Low-priority Compute Nodes in the
     Pool.
    :vartype target_low_priority_nodes: int
    :ivar resize_timeout: The timeout for allocation of Nodes to the Pool or removal of Compute
     Nodes from the Pool. The default value is 15 minutes. The minimum value is 5 minutes. If you
     specify a value less than 5 minutes, the Batch service returns an error; if you are calling the
     REST API directly, the HTTP status code is 400 (Bad Request).
    :vartype resize_timeout: ~datetime.timedelta
    :ivar node_deallocation_option: Determines what to do with a Compute Node and its running
     task(s) if the Pool size is decreasing. The default value is requeue. Known values are:
     "requeue", "terminate", "taskcompletion", and "retaineddata".
    :vartype node_deallocation_option: str or ~azure.batch.models.BatchNodeDeallocationOption
    """

    target_dedicated_nodes: Optional[int] = rest_field(
        name="targetDedicatedNodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired number of dedicated Compute Nodes in the Pool."""
    target_low_priority_nodes: Optional[int] = rest_field(
        name="targetLowPriorityNodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired number of Spot/Low-priority Compute Nodes in the Pool."""
    resize_timeout: Optional[datetime.timedelta] = rest_field(
        name="resizeTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """The timeout for allocation of Nodes to the Pool or removal of Compute Nodes from the Pool. The
     default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5
     minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP
     status code is 400 (Bad Request)."""
    node_deallocation_option: Optional[Union[str, "_models.BatchNodeDeallocationOption"]] = rest_field(
        name="nodeDeallocationOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """Determines what to do with a Compute Node and its running task(s) if the Pool size is
     decreasing. The default value is requeue. Known values are: \"requeue\", \"terminate\",
     \"taskcompletion\", and \"retaineddata\"."""

    @overload
    def __init__(
        self,
        *,
        target_dedicated_nodes: Optional[int] = None,
        target_low_priority_nodes: Optional[int] = None,
        resize_timeout: Optional[datetime.timedelta] = None,
        node_deallocation_option: Optional[Union[str, "_models.BatchNodeDeallocationOption"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPoolResourceStatistics(_Model):
    """Statistics related to resource consumption by Compute Nodes in a Pool.

    :ivar start_time: The start time of the time range covered by the statistics. Required.
    :vartype start_time: ~datetime.datetime
    :ivar last_update_time: The time at which the statistics were last updated. All statistics are
     limited to the range between startTime and lastUpdateTime. Required.
    :vartype last_update_time: ~datetime.datetime
    :ivar avg_cpu_percentage: The average CPU usage across all Compute Nodes in the Pool
     (percentage per node). Required.
    :vartype avg_cpu_percentage: float
    :ivar avg_memory_gi_b: The average memory usage in GiB across all Compute Nodes in the Pool.
     Required.
    :vartype avg_memory_gi_b: float
    :ivar peak_memory_gi_b: The peak memory usage in GiB across all Compute Nodes in the Pool.
     Required.
    :vartype peak_memory_gi_b: float
    :ivar avg_disk_gi_b: The average used disk space in GiB across all Compute Nodes in the Pool.
     Required.
    :vartype avg_disk_gi_b: float
    :ivar peak_disk_gi_b: The peak used disk space in GiB across all Compute Nodes in the Pool.
     Required.
    :vartype peak_disk_gi_b: float
    :ivar disk_read_iops: The total number of disk read operations across all Compute Nodes in the
     Pool. Required.
    :vartype disk_read_iops: int
    :ivar disk_write_iops: The total number of disk write operations across all Compute Nodes in
     the Pool. Required.
    :vartype disk_write_iops: int
    :ivar disk_read_gi_b: The total amount of data in GiB of disk reads across all Compute Nodes in
     the Pool. Required.
    :vartype disk_read_gi_b: float
    :ivar disk_write_gi_b: The total amount of data in GiB of disk writes across all Compute Nodes
     in the Pool. Required.
    :vartype disk_write_gi_b: float
    :ivar network_read_gi_b: The total amount of data in GiB of network reads across all Compute
     Nodes in the Pool. Required.
    :vartype network_read_gi_b: float
    :ivar network_write_gi_b: The total amount of data in GiB of network writes across all Compute
     Nodes in the Pool. Required.
    :vartype network_write_gi_b: float
    """

    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The start time of the time range covered by the statistics. Required."""
    last_update_time: datetime.datetime = rest_field(
        name="lastUpdateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the statistics were last updated. All statistics are limited to the range
     between startTime and lastUpdateTime. Required."""
    avg_cpu_percentage: float = rest_field(
        name="avgCPUPercentage", visibility=["read", "create", "update", "delete", "query"]
    )
    """The average CPU usage across all Compute Nodes in the Pool (percentage per node). Required."""
    avg_memory_gi_b: float = rest_field(name="avgMemoryGiB", visibility=["read", "create", "update", "delete", "query"])
    """The average memory usage in GiB across all Compute Nodes in the Pool. Required."""
    peak_memory_gi_b: float = rest_field(
        name="peakMemoryGiB", visibility=["read", "create", "update", "delete", "query"]
    )
    """The peak memory usage in GiB across all Compute Nodes in the Pool. Required."""
    avg_disk_gi_b: float = rest_field(name="avgDiskGiB", visibility=["read", "create", "update", "delete", "query"])
    """The average used disk space in GiB across all Compute Nodes in the Pool. Required."""
    peak_disk_gi_b: float = rest_field(name="peakDiskGiB", visibility=["read", "create", "update", "delete", "query"])
    """The peak used disk space in GiB across all Compute Nodes in the Pool. Required."""
    disk_read_iops: int = rest_field(
        name="diskReadIOps", visibility=["read", "create", "update", "delete", "query"], format="str"
    )
    """The total number of disk read operations across all Compute Nodes in the Pool. Required."""
    disk_write_iops: int = rest_field(
        name="diskWriteIOps", visibility=["read", "create", "update", "delete", "query"], format="str"
    )
    """The total number of disk write operations across all Compute Nodes in the Pool. Required."""
    disk_read_gi_b: float = rest_field(name="diskReadGiB", visibility=["read", "create", "update", "delete", "query"])
    """The total amount of data in GiB of disk reads across all Compute Nodes in the Pool. Required."""
    disk_write_gi_b: float = rest_field(name="diskWriteGiB", visibility=["read", "create", "update", "delete", "query"])
    """The total amount of data in GiB of disk writes across all Compute Nodes in the Pool. Required."""
    network_read_gi_b: float = rest_field(
        name="networkReadGiB", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total amount of data in GiB of network reads across all Compute Nodes in the Pool.
     Required."""
    network_write_gi_b: float = rest_field(
        name="networkWriteGiB", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total amount of data in GiB of network writes across all Compute Nodes in the Pool.
     Required."""

    @overload
    def __init__(
        self,
        *,
        start_time: datetime.datetime,
        last_update_time: datetime.datetime,
        avg_cpu_percentage: float,
        avg_memory_gi_b: float,
        peak_memory_gi_b: float,
        avg_disk_gi_b: float,
        peak_disk_gi_b: float,
        disk_read_iops: int,
        disk_write_iops: int,
        disk_read_gi_b: float,
        disk_write_gi_b: float,
        network_read_gi_b: float,
        network_write_gi_b: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPoolSpecification(_Model):
    """Specification for creating a new Pool.

    :ivar display_name: The display name for the Pool. The display name need not be unique and can
     contain any Unicode characters up to a maximum length of 1024.
    :vartype display_name: str
    :ivar vm_size: The size of the virtual machines in the Pool. All virtual machines in a Pool are
     the same size. For information about available sizes of virtual machines in Pools, see Choose a
     VM size for Compute Nodes in an Azure Batch Pool
     (`https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes
     <https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes>`_). Required.
    :vartype vm_size: str
    :ivar virtual_machine_configuration: The virtual machine configuration for the Pool. This
     property must be specified.
    :vartype virtual_machine_configuration: ~azure.batch.models.VirtualMachineConfiguration
    :ivar task_slots_per_node: The number of task slots that can be used to run concurrent tasks on
     a single compute node in the pool. The default value is 1. The maximum value is the smaller of
     4 times the number of cores of the vmSize of the pool or 256.
    :vartype task_slots_per_node: int
    :ivar task_scheduling_policy: How Tasks are distributed across Compute Nodes in a Pool. If not
     specified, the default is spread.
    :vartype task_scheduling_policy: ~azure.batch.models.BatchTaskSchedulingPolicy
    :ivar resize_timeout: The timeout for allocation of Compute Nodes to the Pool. This timeout
     applies only to manual scaling; it has no effect when enableAutoScale is set to true. The
     default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5
     minutes, the Batch service rejects the request with an error; if you are calling the REST API
     directly, the HTTP status code is 400 (Bad Request).
    :vartype resize_timeout: ~datetime.timedelta
    :ivar target_dedicated_nodes: The desired number of dedicated Compute Nodes in the Pool. This
     property must not be specified if enableAutoScale is set to true. If enableAutoScale is set to
     false, then you must set either targetDedicatedNodes, targetLowPriorityNodes, or both.
    :vartype target_dedicated_nodes: int
    :ivar target_low_priority_nodes: The desired number of Spot/Low-priority Compute Nodes in the
     Pool. This property must not be specified if enableAutoScale is set to true. If enableAutoScale
     is set to false, then you must set either targetDedicatedNodes, targetLowPriorityNodes, or
     both.
    :vartype target_low_priority_nodes: int
    :ivar enable_auto_scale: Whether the Pool size should automatically adjust over time. If false,
     at least one of targetDedicatedNodes and targetLowPriorityNodes must be specified. If true, the
     autoScaleFormula element is required. The Pool automatically resizes according to the formula.
     The default value is false.
    :vartype enable_auto_scale: bool
    :ivar auto_scale_formula: The formula for the desired number of Compute Nodes in the Pool. This
     property must not be specified if enableAutoScale is set to false. It is required if
     enableAutoScale is set to true. The formula is checked for validity before the Pool is created.
     If the formula is not valid, the Batch service rejects the request with detailed error
     information.
    :vartype auto_scale_formula: str
    :ivar auto_scale_evaluation_interval: The time interval at which to automatically adjust the
     Pool size according to the autoscale formula. The default value is 15 minutes. The minimum and
     maximum value are 5 minutes and 168 hours respectively. If you specify a value less than 5
     minutes or greater than 168 hours, the Batch service rejects the request with an invalid
     property value error; if you are calling the REST API directly, the HTTP status code is 400
     (Bad Request).
    :vartype auto_scale_evaluation_interval: ~datetime.timedelta
    :ivar enable_inter_node_communication: Whether the Pool permits direct communication between
     Compute Nodes. Enabling inter-node communication limits the maximum size of the Pool due to
     deployment restrictions on the Compute Nodes of the Pool. This may result in the Pool not
     reaching its desired size. The default value is false.
    :vartype enable_inter_node_communication: bool
    :ivar network_configuration: The network configuration for the Pool.
    :vartype network_configuration: ~azure.batch.models.NetworkConfiguration
    :ivar start_task: A Task to run on each Compute Node as it joins the Pool. The Task runs when
     the Compute Node is added to the Pool or when the Compute Node is restarted.
    :vartype start_task: ~azure.batch.models.BatchStartTask
    :ivar application_package_references: The list of Packages to be installed on each Compute Node
     in the Pool. When creating a pool, the package's application ID must be fully qualified
     (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
     Changes to Package references affect all new Nodes joining the Pool, but do not affect Compute
     Nodes that are already in the Pool until they are rebooted or reimaged. There is a maximum of
     10 Package references on any given Pool.
    :vartype application_package_references:
     list[~azure.batch.models.BatchApplicationPackageReference]
    :ivar user_accounts: The list of user Accounts to be created on each Compute Node in the Pool.
    :vartype user_accounts: list[~azure.batch.models.UserAccount]
    :ivar metadata: A list of name-value pairs associated with the Pool as metadata. The Batch
     service does not assign any meaning to metadata; it is solely for the use of user code.
    :vartype metadata: list[~azure.batch.models.BatchMetadataItem]
    :ivar mount_configuration: A list of file systems to mount on each node in the pool. This
     supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
    :vartype mount_configuration: list[~azure.batch.models.MountConfiguration]
    :ivar upgrade_policy: The upgrade policy for the Pool. Describes an upgrade policy - automatic,
     manual, or rolling.
    :vartype upgrade_policy: ~azure.batch.models.UpgradePolicy
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The display name for the Pool. The display name need not be unique and can contain any Unicode
     characters up to a maximum length of 1024."""
    vm_size: str = rest_field(name="vmSize", visibility=["read", "create", "update", "delete", "query"])
    """The size of the virtual machines in the Pool. All virtual machines in a Pool are the same size.
     For information about available sizes of virtual machines in Pools, see Choose a VM size for
     Compute Nodes in an Azure Batch Pool
     (`https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes
     <https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes>`_). Required."""
    virtual_machine_configuration: Optional["_models.VirtualMachineConfiguration"] = rest_field(
        name="virtualMachineConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The virtual machine configuration for the Pool. This property must be specified."""
    task_slots_per_node: Optional[int] = rest_field(
        name="taskSlotsPerNode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of task slots that can be used to run concurrent tasks on a single compute node in
     the pool. The default value is 1. The maximum value is the smaller of 4 times the number of
     cores of the vmSize of the pool or 256."""
    task_scheduling_policy: Optional["_models.BatchTaskSchedulingPolicy"] = rest_field(
        name="taskSchedulingPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """How Tasks are distributed across Compute Nodes in a Pool. If not specified, the default is
     spread."""
    resize_timeout: Optional[datetime.timedelta] = rest_field(
        name="resizeTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """The timeout for allocation of Compute Nodes to the Pool. This timeout applies only to manual
     scaling; it has no effect when enableAutoScale is set to true. The default value is 15 minutes.
     The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service
     rejects the request with an error; if you are calling the REST API directly, the HTTP status
     code is 400 (Bad Request)."""
    target_dedicated_nodes: Optional[int] = rest_field(
        name="targetDedicatedNodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired number of dedicated Compute Nodes in the Pool. This property must not be specified
     if enableAutoScale is set to true. If enableAutoScale is set to false, then you must set either
     targetDedicatedNodes, targetLowPriorityNodes, or both."""
    target_low_priority_nodes: Optional[int] = rest_field(
        name="targetLowPriorityNodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The desired number of Spot/Low-priority Compute Nodes in the Pool. This property must not be
     specified if enableAutoScale is set to true. If enableAutoScale is set to false, then you must
     set either targetDedicatedNodes, targetLowPriorityNodes, or both."""
    enable_auto_scale: Optional[bool] = rest_field(
        name="enableAutoScale", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the Pool size should automatically adjust over time. If false, at least one of
     targetDedicatedNodes and targetLowPriorityNodes must be specified. If true, the
     autoScaleFormula element is required. The Pool automatically resizes according to the formula.
     The default value is false."""
    auto_scale_formula: Optional[str] = rest_field(
        name="autoScaleFormula", visibility=["read", "create", "update", "delete", "query"]
    )
    """The formula for the desired number of Compute Nodes in the Pool. This property must not be
     specified if enableAutoScale is set to false. It is required if enableAutoScale is set to true.
     The formula is checked for validity before the Pool is created. If the formula is not valid,
     the Batch service rejects the request with detailed error information."""
    auto_scale_evaluation_interval: Optional[datetime.timedelta] = rest_field(
        name="autoScaleEvaluationInterval", visibility=["read", "create", "update", "delete", "query"]
    )
    """The time interval at which to automatically adjust the Pool size according to the autoscale
     formula. The default value is 15 minutes. The minimum and maximum value are 5 minutes and 168
     hours respectively. If you specify a value less than 5 minutes or greater than 168 hours, the
     Batch service rejects the request with an invalid property value error; if you are calling the
     REST API directly, the HTTP status code is 400 (Bad Request)."""
    enable_inter_node_communication: Optional[bool] = rest_field(
        name="enableInterNodeCommunication", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the Pool permits direct communication between Compute Nodes. Enabling inter-node
     communication limits the maximum size of the Pool due to deployment restrictions on the Compute
     Nodes of the Pool. This may result in the Pool not reaching its desired size. The default value
     is false."""
    network_configuration: Optional["_models.NetworkConfiguration"] = rest_field(
        name="networkConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The network configuration for the Pool."""
    start_task: Optional["_models.BatchStartTask"] = rest_field(
        name="startTask", visibility=["read", "create", "update", "delete", "query"]
    )
    """A Task to run on each Compute Node as it joins the Pool. The Task runs when the Compute Node is
     added to the Pool or when the Compute Node is restarted."""
    application_package_references: Optional[list["_models.BatchApplicationPackageReference"]] = rest_field(
        name="applicationPackageReferences", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of Packages to be installed on each Compute Node in the Pool. When creating a pool,
     the package's application ID must be fully qualified
     (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}).
     Changes to Package references affect all new Nodes joining the Pool, but do not affect Compute
     Nodes that are already in the Pool until they are rebooted or reimaged. There is a maximum of
     10 Package references on any given Pool."""
    user_accounts: Optional[list["_models.UserAccount"]] = rest_field(
        name="userAccounts", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of user Accounts to be created on each Compute Node in the Pool."""
    metadata: Optional[list["_models.BatchMetadataItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of name-value pairs associated with the Pool as metadata. The Batch service does not
     assign any meaning to metadata; it is solely for the use of user code."""
    mount_configuration: Optional[list["_models.MountConfiguration"]] = rest_field(
        name="mountConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of file systems to mount on each node in the pool. This supports Azure Files, NFS,
     CIFS/SMB, and Blobfuse."""
    upgrade_policy: Optional["_models.UpgradePolicy"] = rest_field(
        name="upgradePolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The upgrade policy for the Pool. Describes an upgrade policy - automatic, manual, or rolling."""

    @overload
    def __init__(
        self,
        *,
        vm_size: str,
        display_name: Optional[str] = None,
        virtual_machine_configuration: Optional["_models.VirtualMachineConfiguration"] = None,
        task_slots_per_node: Optional[int] = None,
        task_scheduling_policy: Optional["_models.BatchTaskSchedulingPolicy"] = None,
        resize_timeout: Optional[datetime.timedelta] = None,
        target_dedicated_nodes: Optional[int] = None,
        target_low_priority_nodes: Optional[int] = None,
        enable_auto_scale: Optional[bool] = None,
        auto_scale_formula: Optional[str] = None,
        auto_scale_evaluation_interval: Optional[datetime.timedelta] = None,
        enable_inter_node_communication: Optional[bool] = None,
        network_configuration: Optional["_models.NetworkConfiguration"] = None,
        start_task: Optional["_models.BatchStartTask"] = None,
        application_package_references: Optional[list["_models.BatchApplicationPackageReference"]] = None,
        user_accounts: Optional[list["_models.UserAccount"]] = None,
        metadata: Optional[list["_models.BatchMetadataItem"]] = None,
        mount_configuration: Optional[list["_models.MountConfiguration"]] = None,
        upgrade_policy: Optional["_models.UpgradePolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPoolStatistics(_Model):
    """Contains utilization and resource usage statistics for the lifetime of a Pool.

    :ivar url: The URL for the statistics. Required.
    :vartype url: str
    :ivar start_time: The start time of the time range covered by the statistics. Required.
    :vartype start_time: ~datetime.datetime
    :ivar last_update_time: The time at which the statistics were last updated. All statistics are
     limited to the range between startTime and lastUpdateTime. Required.
    :vartype last_update_time: ~datetime.datetime
    :ivar usage_statistics: Statistics related to Pool usage, such as the amount of core-time used.
    :vartype usage_statistics: ~azure.batch.models.BatchPoolUsageStatistics
    :ivar resource_statistics: Statistics related to resource consumption by Compute Nodes in the
     Pool.
    :vartype resource_statistics: ~azure.batch.models.BatchPoolResourceStatistics
    """

    url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL for the statistics. Required."""
    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The start time of the time range covered by the statistics. Required."""
    last_update_time: datetime.datetime = rest_field(
        name="lastUpdateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the statistics were last updated. All statistics are limited to the range
     between startTime and lastUpdateTime. Required."""
    usage_statistics: Optional["_models.BatchPoolUsageStatistics"] = rest_field(
        name="usageStats", visibility=["read", "create", "update", "delete", "query"]
    )
    """Statistics related to Pool usage, such as the amount of core-time used."""
    resource_statistics: Optional["_models.BatchPoolResourceStatistics"] = rest_field(
        name="resourceStats", visibility=["read", "create", "update", "delete", "query"]
    )
    """Statistics related to resource consumption by Compute Nodes in the Pool."""

    @overload
    def __init__(
        self,
        *,
        url: str,
        start_time: datetime.datetime,
        last_update_time: datetime.datetime,
        usage_statistics: Optional["_models.BatchPoolUsageStatistics"] = None,
        resource_statistics: Optional["_models.BatchPoolResourceStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPoolUpdateOptions(_Model):
    """Parameters for updating an Azure Batch Pool.

    :ivar display_name: The display name for the Pool. The display name need not be unique and can
     contain any Unicode characters up to a maximum length of 1024. This field can be updated only
     when the pool is empty.
    :vartype display_name: str
    :ivar vm_size: The size of virtual machines in the Pool. For information about available sizes
     of virtual machines in Pools, see Choose a VM size for Compute Nodes in an Azure Batch Pool
     (`https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes
     <https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes>`_).<br /><br />This field can be
     updated only when the pool is empty.
    :vartype vm_size: str
    :ivar enable_inter_node_communication: Whether the Pool permits direct communication between
     Compute Nodes. Enabling inter-node communication limits the maximum size of the Pool due to
     deployment restrictions on the Compute Nodes of the Pool. This may result in the Pool not
     reaching its desired size. The default value is false.<br /><br />This field can be updated
     only when the pool is empty.
    :vartype enable_inter_node_communication: bool
    :ivar start_task: A Task to run on each Compute Node as it joins the Pool. The Task runs when
     the Compute Node is added to the Pool or when the Compute Node is restarted. If this element is
     present, it overwrites any existing StartTask. If omitted, any existing StartTask is left
     unchanged.
    :vartype start_task: ~azure.batch.models.BatchStartTask
    :ivar application_package_references: A list of Packages to be installed on each Compute Node
     in the Pool. Changes to Package references affect all new Nodes joining the Pool, but do not
     affect Compute Nodes that are already in the Pool until they are rebooted or reimaged. If this
     element is present, it replaces any existing Package references. If you specify an empty
     collection, then all Package references are removed from the Pool. If omitted, any existing
     Package references are left unchanged.
    :vartype application_package_references:
     list[~azure.batch.models.BatchApplicationPackageReference]
    :ivar metadata: A list of name-value pairs associated with the Pool as metadata. If this
     element is present, it replaces any existing metadata configured on the Pool. If you specify an
     empty collection, any metadata is removed from the Pool. If omitted, any existing metadata is
     left unchanged.
    :vartype metadata: list[~azure.batch.models.BatchMetadataItem]
    :ivar virtual_machine_configuration: The virtual machine configuration for the Pool. This
     property must be specified.<br /><br />This field can be updated only when the pool is empty.
    :vartype virtual_machine_configuration: ~azure.batch.models.VirtualMachineConfiguration
    :ivar task_slots_per_node: The number of task slots that can be used to run concurrent tasks on
     a single compute node in the pool. The default value is 1. The maximum value is the smaller of
     4 times the number of cores of the vmSize of the pool or 256.<br /><br />This field can be
     updated only when the pool is empty.
    :vartype task_slots_per_node: int
    :ivar task_scheduling_policy: How Tasks are distributed across Compute Nodes in a Pool. If not
     specified, the default is spread.<br /><br />This field can be updated only when the pool is
     empty.
    :vartype task_scheduling_policy: ~azure.batch.models.BatchTaskSchedulingPolicy
    :ivar network_configuration: The network configuration for the Pool. This field can be updated
     only when the pool is empty.
    :vartype network_configuration: ~azure.batch.models.NetworkConfiguration
    :ivar user_accounts: The list of user Accounts to be created on each Compute Node in the Pool.
     This field can be updated only when the pool is empty.
    :vartype user_accounts: list[~azure.batch.models.UserAccount]
    :ivar mount_configuration: Mount storage using specified file system for the entire lifetime of
     the pool. Mount the storage using Azure fileshare, NFS, CIFS or Blobfuse based file system.<br
     /><br />This field can be updated only when the pool is empty.
    :vartype mount_configuration: list[~azure.batch.models.MountConfiguration]
    :ivar upgrade_policy: The upgrade policy for the Pool. Describes an upgrade policy - automatic,
     manual, or rolling.<br /><br />This field can be updated only when the pool is empty.
    :vartype upgrade_policy: ~azure.batch.models.UpgradePolicy
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The display name for the Pool. The display name need not be unique and can contain any Unicode
     characters up to a maximum length of 1024. This field can be updated only when the pool is
     empty."""
    vm_size: Optional[str] = rest_field(name="vmSize", visibility=["read", "create", "update", "delete", "query"])
    """The size of virtual machines in the Pool. For information about available sizes of virtual
     machines in Pools, see Choose a VM size for Compute Nodes in an Azure Batch Pool
     (`https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes
     <https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes>`_).<br /><br />This field can be
     updated only when the pool is empty."""
    enable_inter_node_communication: Optional[bool] = rest_field(
        name="enableInterNodeCommunication", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the Pool permits direct communication between Compute Nodes. Enabling inter-node
     communication limits the maximum size of the Pool due to deployment restrictions on the Compute
     Nodes of the Pool. This may result in the Pool not reaching its desired size. The default value
     is false.<br /><br />This field can be updated only when the pool is empty."""
    start_task: Optional["_models.BatchStartTask"] = rest_field(
        name="startTask", visibility=["read", "create", "update", "delete", "query"]
    )
    """A Task to run on each Compute Node as it joins the Pool. The Task runs when the Compute Node is
     added to the Pool or when the Compute Node is restarted. If this element is present, it
     overwrites any existing StartTask. If omitted, any existing StartTask is left unchanged."""
    application_package_references: Optional[list["_models.BatchApplicationPackageReference"]] = rest_field(
        name="applicationPackageReferences", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of Packages to be installed on each Compute Node in the Pool. Changes to Package
     references affect all new Nodes joining the Pool, but do not affect Compute Nodes that are
     already in the Pool until they are rebooted or reimaged. If this element is present, it
     replaces any existing Package references. If you specify an empty collection, then all Package
     references are removed from the Pool. If omitted, any existing Package references are left
     unchanged."""
    metadata: Optional[list["_models.BatchMetadataItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of name-value pairs associated with the Pool as metadata. If this element is present, it
     replaces any existing metadata configured on the Pool. If you specify an empty collection, any
     metadata is removed from the Pool. If omitted, any existing metadata is left unchanged."""
    virtual_machine_configuration: Optional["_models.VirtualMachineConfiguration"] = rest_field(
        name="virtualMachineConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The virtual machine configuration for the Pool. This property must be specified.<br /><br
     />This field can be updated only when the pool is empty."""
    task_slots_per_node: Optional[int] = rest_field(
        name="taskSlotsPerNode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of task slots that can be used to run concurrent tasks on a single compute node in
     the pool. The default value is 1. The maximum value is the smaller of 4 times the number of
     cores of the vmSize of the pool or 256.<br /><br />This field can be updated only when the pool
     is empty."""
    task_scheduling_policy: Optional["_models.BatchTaskSchedulingPolicy"] = rest_field(
        name="taskSchedulingPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """How Tasks are distributed across Compute Nodes in a Pool. If not specified, the default is
     spread.<br /><br />This field can be updated only when the pool is empty."""
    network_configuration: Optional["_models.NetworkConfiguration"] = rest_field(
        name="networkConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The network configuration for the Pool. This field can be updated only when the pool is empty."""
    user_accounts: Optional[list["_models.UserAccount"]] = rest_field(
        name="userAccounts", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of user Accounts to be created on each Compute Node in the Pool. This field can be
     updated only when the pool is empty."""
    mount_configuration: Optional[list["_models.MountConfiguration"]] = rest_field(
        name="mountConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mount storage using specified file system for the entire lifetime of the pool. Mount the
     storage using Azure fileshare, NFS, CIFS or Blobfuse based file system.<br /><br />This field
     can be updated only when the pool is empty."""
    upgrade_policy: Optional["_models.UpgradePolicy"] = rest_field(
        name="upgradePolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The upgrade policy for the Pool. Describes an upgrade policy - automatic, manual, or
     rolling.<br /><br />This field can be updated only when the pool is empty."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        vm_size: Optional[str] = None,
        enable_inter_node_communication: Optional[bool] = None,
        start_task: Optional["_models.BatchStartTask"] = None,
        application_package_references: Optional[list["_models.BatchApplicationPackageReference"]] = None,
        metadata: Optional[list["_models.BatchMetadataItem"]] = None,
        virtual_machine_configuration: Optional["_models.VirtualMachineConfiguration"] = None,
        task_slots_per_node: Optional[int] = None,
        task_scheduling_policy: Optional["_models.BatchTaskSchedulingPolicy"] = None,
        network_configuration: Optional["_models.NetworkConfiguration"] = None,
        user_accounts: Optional[list["_models.UserAccount"]] = None,
        mount_configuration: Optional[list["_models.MountConfiguration"]] = None,
        upgrade_policy: Optional["_models.UpgradePolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPoolUsageMetrics(_Model):
    """Usage metrics for a Pool across an aggregation interval.

    :ivar pool_id: The ID of the Pool whose metrics are aggregated in this entry. Required.
    :vartype pool_id: str
    :ivar start_time: The start time of the aggregation interval covered by this entry. Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the aggregation interval covered by this entry. Required.
    :vartype end_time: ~datetime.datetime
    :ivar vm_size: The size of virtual machines in the Pool. All VMs in a Pool are the same size.
     For information about available sizes of virtual machines in Pools, see Choose a VM size for
     Compute Nodes in an Azure Batch Pool
     (`https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes
     <https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes>`_). Required.
    :vartype vm_size: str
    :ivar total_core_hours: The total core hours used in the Pool during this aggregation interval.
     Required.
    :vartype total_core_hours: float
    """

    pool_id: str = rest_field(name="poolId", visibility=["read", "create", "update", "delete", "query"])
    """The ID of the Pool whose metrics are aggregated in this entry. Required."""
    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The start time of the aggregation interval covered by this entry. Required."""
    end_time: datetime.datetime = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The end time of the aggregation interval covered by this entry. Required."""
    vm_size: str = rest_field(name="vmSize", visibility=["read", "create", "update", "delete", "query"])
    """The size of virtual machines in the Pool. All VMs in a Pool are the same size. For information
     about available sizes of virtual machines in Pools, see Choose a VM size for Compute Nodes in
     an Azure Batch Pool (`https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes
     <https://learn.microsoft.com/azure/batch/batch-pool-vm-sizes>`_). Required."""
    total_core_hours: float = rest_field(
        name="totalCoreHours", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total core hours used in the Pool during this aggregation interval. Required."""

    @overload
    def __init__(
        self,
        *,
        pool_id: str,
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        vm_size: str,
        total_core_hours: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPoolUsageStatistics(_Model):
    """Statistics related to Pool usage information.

    :ivar start_time: The start time of the time range covered by the statistics. Required.
    :vartype start_time: ~datetime.datetime
    :ivar last_update_time: The time at which the statistics were last updated. All statistics are
     limited to the range between startTime and lastUpdateTime. Required.
    :vartype last_update_time: ~datetime.datetime
    :ivar dedicated_core_time: The aggregated wall-clock time of the dedicated Compute Node cores
     being part of the Pool. Required.
    :vartype dedicated_core_time: ~datetime.timedelta
    """

    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The start time of the time range covered by the statistics. Required."""
    last_update_time: datetime.datetime = rest_field(
        name="lastUpdateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the statistics were last updated. All statistics are limited to the range
     between startTime and lastUpdateTime. Required."""
    dedicated_core_time: datetime.timedelta = rest_field(
        name="dedicatedCoreTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The aggregated wall-clock time of the dedicated Compute Node cores being part of the Pool.
     Required."""

    @overload
    def __init__(
        self,
        *,
        start_time: datetime.datetime,
        last_update_time: datetime.datetime,
        dedicated_core_time: datetime.timedelta,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchPublicIpAddressConfiguration(_Model):
    """The public IP Address configuration of the networking configuration of a Pool.

    :ivar ip_address_provisioning_type: The provisioning type for Public IP Addresses for the Pool.
     The default value is BatchManaged. Known values are: "batchmanaged", "usermanaged", and
     "nopublicipaddresses".
    :vartype ip_address_provisioning_type: str or ~azure.batch.models.IpAddressProvisioningType
    :ivar ip_families: The IP families used to specify IP versions available to the pool. IP
     families are used to determine single-stack or dual-stack pools. For single-stack, the expected
     value is IPv4. For dual-stack, the expected values are IPv4 and IPv6.
    :vartype ip_families: list[str or ~azure.batch.models.IPFamily]
    :ivar ip_address_ids: The list of public IPs which the Batch service will use when provisioning
     Compute Nodes. The number of IPs specified here limits the maximum size of the Pool - 100
     dedicated nodes or 100 Spot/Low-priority nodes can be allocated for each public IP. For
     example, a pool needing 250 dedicated VMs would need at least 3 public IPs specified. Each
     element of this collection is of the form:
     /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
    :vartype ip_address_ids: list[str]
    :ivar ip_tags: A list of IP tags associated with the public IP addresses of the Pool. IP tags
     are used to categorize and filter public IP addresses for billing and management purposes.
    :vartype ip_tags: list[~azure.batch.models.IPTag]
    """

    ip_address_provisioning_type: Optional[Union[str, "_models.IpAddressProvisioningType"]] = rest_field(
        name="provision", visibility=["read", "create", "update", "delete", "query"]
    )
    """The provisioning type for Public IP Addresses for the Pool. The default value is BatchManaged.
     Known values are: \"batchmanaged\", \"usermanaged\", and \"nopublicipaddresses\"."""
    ip_families: Optional[list[Union[str, "_models.IPFamily"]]] = rest_field(
        name="ipFamilies", visibility=["read", "create", "update", "delete", "query"]
    )
    """The IP families used to specify IP versions available to the pool. IP families are used to
     determine single-stack or dual-stack pools. For single-stack, the expected value is IPv4. For
     dual-stack, the expected values are IPv4 and IPv6."""
    ip_address_ids: Optional[list[str]] = rest_field(
        name="ipAddressIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of public IPs which the Batch service will use when provisioning Compute Nodes. The
     number of IPs specified here limits the maximum size of the Pool - 100 dedicated nodes or 100
     Spot/Low-priority nodes can be allocated for each public IP. For example, a pool needing 250
     dedicated VMs would need at least 3 public IPs specified. Each element of this collection is of
     the form:
     /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}."""
    ip_tags: Optional[list["_models.IPTag"]] = rest_field(
        name="ipTags", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of IP tags associated with the public IP addresses of the Pool. IP tags are used to
     categorize and filter public IP addresses for billing and management purposes."""

    @overload
    def __init__(
        self,
        *,
        ip_address_provisioning_type: Optional[Union[str, "_models.IpAddressProvisioningType"]] = None,
        ip_families: Optional[list[Union[str, "_models.IPFamily"]]] = None,
        ip_address_ids: Optional[list[str]] = None,
        ip_tags: Optional[list["_models.IPTag"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchStartTask(_Model):
    """Batch will retry Tasks when a recovery operation is triggered on a Node.
    Examples of recovery operations include (but are not limited to) when an
    unhealthy Node is rebooted or a Compute Node disappeared due to host failure.
    Retries due to recovery operations are independent of and are not counted
    against the maxTaskRetryCount. Even if the maxTaskRetryCount is 0, an internal
    retry due to a recovery operation may occur. Because of this, all Tasks should
    be idempotent. This means Tasks need to tolerate being interrupted and
    restarted without causing any corruption or duplicate data. The best practice
    for long running Tasks is to use some form of checkpointing. In some cases the
    StartTask may be re-run even though the Compute Node was not rebooted. Special
    care should be taken to avoid StartTasks which create breakaway process or
    install/launch services from the StartTask working directory, as this will
    block Batch from being able to re-run the StartTask.

    :ivar command_line: The command line of the StartTask. The command line does not run under a
     shell, and therefore cannot take advantage of shell features such as environment variable
     expansion. If you want to take advantage of such features, you should invoke the shell in the
     command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in
     Linux. If the command line refers to file paths, it should use a relative path (relative to the
     Task working directory), or use the Batch provided environment variable
     (`https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables
     <https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables>`_).
     Required.
    :vartype command_line: str
    :ivar container_settings: The settings for the container under which the StartTask runs. When
     this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of
     Azure Batch directories on the node) are mapped into the container, all Task environment
     variables are mapped into the container, and the Task command line is executed in the
     container. Files produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be
     reflected to the host disk, meaning that Batch file APIs will not be able to access those
     files.
    :vartype container_settings: ~azure.batch.models.BatchTaskContainerSettings
    :ivar resource_files: A list of files that the Batch service will download to the Compute Node
     before running the command line.  There is a maximum size for the list of resource files. When
     the max size is exceeded, the request will fail and the response error code will be
     RequestEntityTooLarge. If this occurs, the collection of ResourceFiles must be reduced in size.
     This can be achieved using .zip files, Application Packages, or Docker Containers. Files listed
     under this element are located in the Task's working directory.
    :vartype resource_files: list[~azure.batch.models.ResourceFile]
    :ivar environment_settings: A list of environment variable settings for the StartTask.
    :vartype environment_settings: list[~azure.batch.models.EnvironmentSetting]
    :ivar user_identity: The user identity under which the StartTask runs. If omitted, the Task
     runs as a non-administrative user unique to the Task.
    :vartype user_identity: ~azure.batch.models.UserIdentity
    :ivar max_task_retry_count: The maximum number of times the Task may be retried. The Batch
     service retries a Task if its exit code is nonzero. Note that this value specifically controls
     the number of retries. The Batch service will try the Task once, and may then retry up to this
     limit. For example, if the maximum retry count is 3, Batch tries the Task up to 4 times (one
     initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry
     the Task. If the maximum retry count is -1, the Batch service retries the Task without limit,
     however this is not recommended for a start task or any task. The default value is 0 (no
     retries).
    :vartype max_task_retry_count: int
    :ivar wait_for_success: Whether the Batch service should wait for the StartTask to complete
     successfully (that is, to exit with exit code 0) before scheduling any Tasks on the Compute
     Node. If true and the StartTask fails on a Node, the Batch service retries the StartTask up to
     its maximum retry count (maxTaskRetryCount). If the Task has still not completed successfully
     after all retries, then the Batch service marks the Node unusable, and will not schedule Tasks
     to it. This condition can be detected via the Compute Node state and failure info details. If
     false, the Batch service will not wait for the StartTask to complete. In this case, other Tasks
     can start executing on the Compute Node while the StartTask is still running; and even if the
     StartTask fails, new Tasks will continue to be scheduled on the Compute Node. The default is
     true.
    :vartype wait_for_success: bool
    """

    command_line: str = rest_field(name="commandLine", visibility=["read", "create", "update", "delete", "query"])
    """The command line of the StartTask. The command line does not run under a shell, and therefore
     cannot take advantage of shell features such as environment variable expansion. If you want to
     take advantage of such features, you should invoke the shell in the command line, for example
     using \"cmd /c MyCommand\" in Windows or \"/bin/sh -c MyCommand\" in Linux. If the command line
     refers to file paths, it should use a relative path (relative to the Task working directory),
     or use the Batch provided environment variable
     (`https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables
     <https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables>`_).
     Required."""
    container_settings: Optional["_models.BatchTaskContainerSettings"] = rest_field(
        name="containerSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The settings for the container under which the StartTask runs. When this is specified, all
     directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories
     on the node) are mapped into the container, all Task environment variables are mapped into the
     container, and the Task command line is executed in the container. Files produced in the
     container outside of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host disk, meaning
     that Batch file APIs will not be able to access those files."""
    resource_files: Optional[list["_models.ResourceFile"]] = rest_field(
        name="resourceFiles", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of files that the Batch service will download to the Compute Node before running the
     command line.  There is a maximum size for the list of resource files. When the max size is
     exceeded, the request will fail and the response error code will be RequestEntityTooLarge. If
     this occurs, the collection of ResourceFiles must be reduced in size. This can be achieved
     using .zip files, Application Packages, or Docker Containers. Files listed under this element
     are located in the Task's working directory."""
    environment_settings: Optional[list["_models.EnvironmentSetting"]] = rest_field(
        name="environmentSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of environment variable settings for the StartTask."""
    user_identity: Optional["_models.UserIdentity"] = rest_field(
        name="userIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user identity under which the StartTask runs. If omitted, the Task runs as a
     non-administrative user unique to the Task."""
    max_task_retry_count: Optional[int] = rest_field(
        name="maxTaskRetryCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of times the Task may be retried. The Batch service retries a Task if its
     exit code is nonzero. Note that this value specifically controls the number of retries. The
     Batch service will try the Task once, and may then retry up to this limit. For example, if the
     maximum retry count is 3, Batch tries the Task up to 4 times (one initial try and 3 retries).
     If the maximum retry count is 0, the Batch service does not retry the Task. If the maximum
     retry count is -1, the Batch service retries the Task without limit, however this is not
     recommended for a start task or any task. The default value is 0 (no retries)."""
    wait_for_success: Optional[bool] = rest_field(
        name="waitForSuccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the Batch service should wait for the StartTask to complete successfully (that is, to
     exit with exit code 0) before scheduling any Tasks on the Compute Node. If true and the
     StartTask fails on a Node, the Batch service retries the StartTask up to its maximum retry
     count (maxTaskRetryCount). If the Task has still not completed successfully after all retries,
     then the Batch service marks the Node unusable, and will not schedule Tasks to it. This
     condition can be detected via the Compute Node state and failure info details. If false, the
     Batch service will not wait for the StartTask to complete. In this case, other Tasks can start
     executing on the Compute Node while the StartTask is still running; and even if the StartTask
     fails, new Tasks will continue to be scheduled on the Compute Node. The default is true."""

    @overload
    def __init__(
        self,
        *,
        command_line: str,
        container_settings: Optional["_models.BatchTaskContainerSettings"] = None,
        resource_files: Optional[list["_models.ResourceFile"]] = None,
        environment_settings: Optional[list["_models.EnvironmentSetting"]] = None,
        user_identity: Optional["_models.UserIdentity"] = None,
        max_task_retry_count: Optional[int] = None,
        wait_for_success: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchStartTaskInfo(_Model):
    """Information about a StartTask running on a Compute Node.

    :ivar state: The state of the StartTask on the Compute Node. Required. Known values are:
     "running" and "completed".
    :vartype state: str or ~azure.batch.models.BatchStartTaskState
    :ivar start_time: The time at which the StartTask started running. This value is reset every
     time the Task is restarted or retried (that is, this is the most recent time at which the
     StartTask started running). Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The time at which the StartTask stopped running. This is the end time of the
     most recent run of the StartTask, if that run has completed (even if that run failed and a
     retry is pending). This element is not present if the StartTask is currently running.
    :vartype end_time: ~datetime.datetime
    :ivar exit_code: The exit code of the program specified on the StartTask command line. This
     property is set only if the StartTask is in the completed state. In general, the exit code for
     a process reflects the specific convention implemented by the application developer for that
     process. If you use the exit code value to make decisions in your code, be sure that you know
     the exit code convention used by the application process. However, if the Batch service
     terminates the StartTask (due to timeout, or user termination via the API) you may see an
     operating system-defined exit code.
    :vartype exit_code: int
    :ivar container_info: Information about the container under which the Task is executing. This
     property is set only if the Task runs in a container context.
    :vartype container_info: ~azure.batch.models.BatchTaskContainerExecutionInfo
    :ivar failure_info: Information describing the Task failure, if any. This property is set only
     if the Task is in the completed state and encountered a failure.
    :vartype failure_info: ~azure.batch.models.BatchTaskFailureInfo
    :ivar retry_count: The number of times the Task has been retried by the Batch service. Task
     application failures (non-zero exit code) are retried, pre-processing errors (the Task could
     not be run) and file upload errors are not retried. The Batch service will retry the Task up to
     the limit specified by the constraints. Required.
    :vartype retry_count: int
    :ivar last_retry_time: The most recent time at which a retry of the Task started running. This
     element is present only if the Task was retried (i.e. retryCount is nonzero). If present, this
     is typically the same as startTime, but may be different if the Task has been restarted for
     reasons other than retry; for example, if the Compute Node was rebooted during a retry, then
     the startTime is updated but the lastRetryTime is not.
    :vartype last_retry_time: ~datetime.datetime
    :ivar result: The result of the Task execution. If the value is 'failed', then the details of
     the failure can be found in the failureInfo property. Known values are: "success" and
     "failure".
    :vartype result: str or ~azure.batch.models.BatchTaskExecutionResult
    """

    state: Union[str, "_models.BatchStartTaskState"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The state of the StartTask on the Compute Node. Required. Known values are: \"running\" and
     \"completed\"."""
    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the StartTask started running. This value is reset every time the Task is
     restarted or retried (that is, this is the most recent time at which the StartTask started
     running). Required."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the StartTask stopped running. This is the end time of the most recent run of
     the StartTask, if that run has completed (even if that run failed and a retry is pending). This
     element is not present if the StartTask is currently running."""
    exit_code: Optional[int] = rest_field(name="exitCode", visibility=["read", "create", "update", "delete", "query"])
    """The exit code of the program specified on the StartTask command line. This property is set only
     if the StartTask is in the completed state. In general, the exit code for a process reflects
     the specific convention implemented by the application developer for that process. If you use
     the exit code value to make decisions in your code, be sure that you know the exit code
     convention used by the application process. However, if the Batch service terminates the
     StartTask (due to timeout, or user termination via the API) you may see an operating
     system-defined exit code."""
    container_info: Optional["_models.BatchTaskContainerExecutionInfo"] = rest_field(
        name="containerInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information about the container under which the Task is executing. This property is set only if
     the Task runs in a container context."""
    failure_info: Optional["_models.BatchTaskFailureInfo"] = rest_field(
        name="failureInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information describing the Task failure, if any. This property is set only if the Task is in
     the completed state and encountered a failure."""
    retry_count: int = rest_field(name="retryCount", visibility=["read", "create", "update", "delete", "query"])
    """The number of times the Task has been retried by the Batch service. Task application failures
     (non-zero exit code) are retried, pre-processing errors (the Task could not be run) and file
     upload errors are not retried. The Batch service will retry the Task up to the limit specified
     by the constraints. Required."""
    last_retry_time: Optional[datetime.datetime] = rest_field(
        name="lastRetryTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The most recent time at which a retry of the Task started running. This element is present only
     if the Task was retried (i.e. retryCount is nonzero). If present, this is typically the same as
     startTime, but may be different if the Task has been restarted for reasons other than retry;
     for example, if the Compute Node was rebooted during a retry, then the startTime is updated but
     the lastRetryTime is not."""
    result: Optional[Union[str, "_models.BatchTaskExecutionResult"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The result of the Task execution. If the value is 'failed', then the details of the failure can
     be found in the failureInfo property. Known values are: \"success\" and \"failure\"."""

    @overload
    def __init__(
        self,
        *,
        state: Union[str, "_models.BatchStartTaskState"],
        start_time: datetime.datetime,
        retry_count: int,
        end_time: Optional[datetime.datetime] = None,
        exit_code: Optional[int] = None,
        container_info: Optional["_models.BatchTaskContainerExecutionInfo"] = None,
        failure_info: Optional["_models.BatchTaskFailureInfo"] = None,
        last_retry_time: Optional[datetime.datetime] = None,
        result: Optional[Union[str, "_models.BatchTaskExecutionResult"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchSubtask(_Model):
    """Information about an Azure Batch subtask.

    :ivar id: The ID of the subtask.
    :vartype id: int
    :ivar node_info: Information about the Compute Node on which the subtask ran.
    :vartype node_info: ~azure.batch.models.BatchNodeInfo
    :ivar start_time: The time at which the subtask started running. If the subtask has been
     restarted or retried, this is the most recent time at which the subtask started running.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The time at which the subtask completed. This property is set only if the
     subtask is in the Completed state.
    :vartype end_time: ~datetime.datetime
    :ivar exit_code: The exit code of the program specified on the subtask command line. This
     property is set only if the subtask is in the completed state. In general, the exit code for a
     process reflects the specific convention implemented by the application developer for that
     process. If you use the exit code value to make decisions in your code, be sure that you know
     the exit code convention used by the application process. However, if the Batch service
     terminates the subtask (due to timeout, or user termination via the API) you may see an
     operating system-defined exit code.
    :vartype exit_code: int
    :ivar container_info: Information about the container under which the Task is executing. This
     property is set only if the Task runs in a container context.
    :vartype container_info: ~azure.batch.models.BatchTaskContainerExecutionInfo
    :ivar failure_info: Information describing the Task failure, if any. This property is set only
     if the Task is in the completed state and encountered a failure.
    :vartype failure_info: ~azure.batch.models.BatchTaskFailureInfo
    :ivar state: The current state of the subtask. Known values are: "preparing", "running", and
     "completed".
    :vartype state: str or ~azure.batch.models.BatchSubtaskState
    :ivar state_transition_time: The time at which the subtask entered its current state.
    :vartype state_transition_time: ~datetime.datetime
    :ivar previous_state: The previous state of the subtask. This property is not set if the
     subtask is in its initial running state. Known values are: "preparing", "running", and
     "completed".
    :vartype previous_state: str or ~azure.batch.models.BatchSubtaskState
    :ivar previous_state_transition_time: The time at which the subtask entered its previous state.
     This property is not set if the subtask is in its initial running state.
    :vartype previous_state_transition_time: ~datetime.datetime
    :ivar result: The result of the Task execution. If the value is 'failed', then the details of
     the failure can be found in the failureInfo property. Known values are: "success" and
     "failure".
    :vartype result: str or ~azure.batch.models.BatchTaskExecutionResult
    """

    id: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the subtask."""
    node_info: Optional["_models.BatchNodeInfo"] = rest_field(
        name="nodeInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information about the Compute Node on which the subtask ran."""
    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the subtask started running. If the subtask has been restarted or retried,
     this is the most recent time at which the subtask started running."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the subtask completed. This property is set only if the subtask is in the
     Completed state."""
    exit_code: Optional[int] = rest_field(name="exitCode", visibility=["read", "create", "update", "delete", "query"])
    """The exit code of the program specified on the subtask command line. This property is set only
     if the subtask is in the completed state. In general, the exit code for a process reflects the
     specific convention implemented by the application developer for that process. If you use the
     exit code value to make decisions in your code, be sure that you know the exit code convention
     used by the application process. However, if the Batch service terminates the subtask (due to
     timeout, or user termination via the API) you may see an operating system-defined exit code."""
    container_info: Optional["_models.BatchTaskContainerExecutionInfo"] = rest_field(
        name="containerInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information about the container under which the Task is executing. This property is set only if
     the Task runs in a container context."""
    failure_info: Optional["_models.BatchTaskFailureInfo"] = rest_field(
        name="failureInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information describing the Task failure, if any. This property is set only if the Task is in
     the completed state and encountered a failure."""
    state: Optional[Union[str, "_models.BatchSubtaskState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The current state of the subtask. Known values are: \"preparing\", \"running\", and
     \"completed\"."""
    state_transition_time: Optional[datetime.datetime] = rest_field(
        name="stateTransitionTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the subtask entered its current state."""
    previous_state: Optional[Union[str, "_models.BatchSubtaskState"]] = rest_field(
        name="previousState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The previous state of the subtask. This property is not set if the subtask is in its initial
     running state. Known values are: \"preparing\", \"running\", and \"completed\"."""
    previous_state_transition_time: Optional[datetime.datetime] = rest_field(
        name="previousStateTransitionTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the subtask entered its previous state. This property is not set if the
     subtask is in its initial running state."""
    result: Optional[Union[str, "_models.BatchTaskExecutionResult"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The result of the Task execution. If the value is 'failed', then the details of the failure can
     be found in the failureInfo property. Known values are: \"success\" and \"failure\"."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[int] = None,  # pylint: disable=redefined-builtin
        node_info: Optional["_models.BatchNodeInfo"] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        exit_code: Optional[int] = None,
        container_info: Optional["_models.BatchTaskContainerExecutionInfo"] = None,
        failure_info: Optional["_models.BatchTaskFailureInfo"] = None,
        state: Optional[Union[str, "_models.BatchSubtaskState"]] = None,
        state_transition_time: Optional[datetime.datetime] = None,
        previous_state: Optional[Union[str, "_models.BatchSubtaskState"]] = None,
        previous_state_transition_time: Optional[datetime.datetime] = None,
        result: Optional[Union[str, "_models.BatchTaskExecutionResult"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchSupportedImage(_Model):
    """A reference to the Azure Virtual Machines Marketplace Image and additional
    information about the Image.

    :ivar node_agent_sku_id: The ID of the Compute Node agent SKU which the Image supports.
     Required.
    :vartype node_agent_sku_id: str
    :ivar image_reference: The reference to the Azure Virtual Machine's Marketplace Image.
     Required.
    :vartype image_reference: ~azure.batch.models.BatchVmImageReference
    :ivar os_type: The type of operating system (e.g. Windows or Linux) of the Image. Required.
     Known values are: "linux" and "windows".
    :vartype os_type: str or ~azure.batch.models.OSType
    :ivar capabilities: The capabilities or features which the Image supports. Not every capability
     of the Image is listed. Capabilities in this list are considered of special interest and are
     generally related to integration with other features in the Azure Batch service.
    :vartype capabilities: list[str]
    :ivar batch_support_end_of_life: The time when the Azure Batch service will stop accepting
     create Pool requests for the Image.
    :vartype batch_support_end_of_life: ~datetime.datetime
    :ivar verification_type: Whether the Azure Batch service actively verifies that the Image is
     compatible with the associated Compute Node agent SKU. Required. Known values are: "verified"
     and "unverified".
    :vartype verification_type: str or ~azure.batch.models.ImageVerificationType
    """

    node_agent_sku_id: str = rest_field(
        name="nodeAgentSKUId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ID of the Compute Node agent SKU which the Image supports. Required."""
    image_reference: "_models.BatchVmImageReference" = rest_field(
        name="imageReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference to the Azure Virtual Machine's Marketplace Image. Required."""
    os_type: Union[str, "_models.OSType"] = rest_field(
        name="osType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of operating system (e.g. Windows or Linux) of the Image. Required. Known values are:
     \"linux\" and \"windows\"."""
    capabilities: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The capabilities or features which the Image supports. Not every capability of the Image is
     listed. Capabilities in this list are considered of special interest and are generally related
     to integration with other features in the Azure Batch service."""
    batch_support_end_of_life: Optional[datetime.datetime] = rest_field(
        name="batchSupportEndOfLife", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time when the Azure Batch service will stop accepting create Pool requests for the Image."""
    verification_type: Union[str, "_models.ImageVerificationType"] = rest_field(
        name="verificationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether the Azure Batch service actively verifies that the Image is compatible with the
     associated Compute Node agent SKU. Required. Known values are: \"verified\" and \"unverified\"."""

    @overload
    def __init__(
        self,
        *,
        node_agent_sku_id: str,
        image_reference: "_models.BatchVmImageReference",
        os_type: Union[str, "_models.OSType"],
        verification_type: Union[str, "_models.ImageVerificationType"],
        capabilities: Optional[list[str]] = None,
        batch_support_end_of_life: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTask(_Model):
    """Batch will retry Tasks when a recovery operation is triggered on a Node.
    Examples of recovery operations include (but are not limited to) when an
    unhealthy Node is rebooted or a Compute Node disappeared due to host failure.
    Retries due to recovery operations are independent of and are not counted
    against the maxTaskRetryCount. Even if the maxTaskRetryCount is 0, an internal
    retry due to a recovery operation may occur. Because of this, all Tasks should
    be idempotent. This means Tasks need to tolerate being interrupted and
    restarted without causing any corruption or duplicate data. The best practice
    for long running Tasks is to use some form of checkpointing.

    :ivar id: A string that uniquely identifies the Task within the Job. The ID can contain any
     combination of alphanumeric characters including hyphens and underscores, and cannot contain
     more than 64 characters. Required.
    :vartype id: str
    :ivar display_name: A display name for the Task. The display name need not be unique and can
     contain any Unicode characters up to a maximum length of 1024.
    :vartype display_name: str
    :ivar url: The URL of the Task. Required.
    :vartype url: str
    :ivar e_tag: The ETag of the Task. This is an opaque string. You can use it to detect whether
     the Task has changed between requests. In particular, you can be pass the ETag when updating a
     Task to specify that your changes should take effect only if nobody else has modified the Task
     in the meantime. Required.
    :vartype e_tag: str
    :ivar last_modified: The last modified time of the Task. Required.
    :vartype last_modified: ~datetime.datetime
    :ivar creation_time: The creation time of the Task. Required.
    :vartype creation_time: ~datetime.datetime
    :ivar exit_conditions: How the Batch service should respond when the Task completes.
    :vartype exit_conditions: ~azure.batch.models.ExitConditions
    :ivar state: The current state of the Task. Required. Known values are: "active", "preparing",
     "running", and "completed".
    :vartype state: str or ~azure.batch.models.BatchTaskState
    :ivar state_transition_time: The time at which the Task entered its current state. Required.
    :vartype state_transition_time: ~datetime.datetime
    :ivar previous_state: The previous state of the Task. This property is not set if the Task is
     in its initial Active state. Known values are: "active", "preparing", "running", and
     "completed".
    :vartype previous_state: str or ~azure.batch.models.BatchTaskState
    :ivar previous_state_transition_time: The time at which the Task entered its previous state.
     This property is not set if the Task is in its initial Active state.
    :vartype previous_state_transition_time: ~datetime.datetime
    :ivar command_line: The command line of the Task. For multi-instance Tasks, the command line is
     executed as the primary Task, after the primary Task and all subtasks have finished executing
     the coordination command line. The command line does not run under a shell, and therefore
     cannot take advantage of shell features such as environment variable expansion. If you want to
     take advantage of such features, you should invoke the shell in the command line, for example
     using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. If the command line
     refers to file paths, it should use a relative path (relative to the Task working directory),
     or use the Batch provided environment variable
     (`https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables
     <https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables>`_).
     Required.
    :vartype command_line: str
    :ivar container_settings: The settings for the container under which the Task runs. If the Pool
     that will run this Task has containerConfiguration set, this must be set as well. If the Pool
     that will run this Task doesn't have containerConfiguration set, this must not be set. When
     this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of
     Azure Batch directories on the node) are mapped into the container, all Task environment
     variables are mapped into the container, and the Task command line is executed in the
     container. Files produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be
     reflected to the host disk, meaning that Batch file APIs will not be able to access those
     files.
    :vartype container_settings: ~azure.batch.models.BatchTaskContainerSettings
    :ivar resource_files: A list of files that the Batch service will download to the Compute Node
     before running the command line. For multi-instance Tasks, the resource files will only be
     downloaded to the Compute Node on which the primary Task is executed. There is a maximum size
     for the list of resource files.  When the max size is exceeded, the request will fail and the
     response error code will be RequestEntityTooLarge. If this occurs, the collection of
     ResourceFiles must be reduced in size. This can be achieved using .zip files, Application
     Packages, or Docker Containers.
    :vartype resource_files: list[~azure.batch.models.ResourceFile]
    :ivar output_files: A list of files that the Batch service will upload from the Compute Node
     after running the command line. For multi-instance Tasks, the files will only be uploaded from
     the Compute Node on which the primary Task is executed.
    :vartype output_files: list[~azure.batch.models.OutputFile]
    :ivar environment_settings: A list of environment variable settings for the Task.
    :vartype environment_settings: list[~azure.batch.models.EnvironmentSetting]
    :ivar affinity_info: A locality hint that can be used by the Batch service to select a Compute
     Node on which to start the new Task.
    :vartype affinity_info: ~azure.batch.models.BatchAffinityInfo
    :ivar constraints: The execution constraints that apply to this Task.
    :vartype constraints: ~azure.batch.models.BatchTaskConstraints
    :ivar required_slots: The number of scheduling slots that the Task requires to run. The default
     is 1. A Task can only be scheduled to run on a compute node if the node has enough free
     scheduling slots available. For multi-instance Tasks, this must be 1.
    :vartype required_slots: int
    :ivar user_identity: The user identity under which the Task runs. If omitted, the Task runs as
     a non-administrative user unique to the Task.
    :vartype user_identity: ~azure.batch.models.UserIdentity
    :ivar execution_info: Information about the execution of the Task.
    :vartype execution_info: ~azure.batch.models.BatchTaskExecutionInfo
    :ivar node_info: Information about the Compute Node on which the Task ran.
    :vartype node_info: ~azure.batch.models.BatchNodeInfo
    :ivar multi_instance_settings: An object that indicates that the Task is a multi-instance Task,
     and contains information about how to run the multi-instance Task.
    :vartype multi_instance_settings: ~azure.batch.models.MultiInstanceSettings
    :ivar task_statistics: Resource usage statistics for the Task.
    :vartype task_statistics: ~azure.batch.models.BatchTaskStatistics
    :ivar depends_on: The Tasks that this Task depends on. This Task will not be scheduled until
     all Tasks that it depends on have completed successfully. If any of those Tasks fail and
     exhaust their retry counts, this Task will never be scheduled.
    :vartype depends_on: ~azure.batch.models.BatchTaskDependencies
    :ivar application_package_references: A list of Packages that the Batch service will deploy to
     the Compute Node before running the command line. Application packages are downloaded and
     deployed to a shared directory, not the Task working directory. Therefore, if a referenced
     package is already on the Node, and is up to date, then it is not re-downloaded; the existing
     copy on the Compute Node is used. If a referenced Package cannot be installed, for example
     because the package has been deleted or because download failed, the Task fails.
    :vartype application_package_references:
     list[~azure.batch.models.BatchApplicationPackageReference]
    :ivar authentication_token_settings: The settings for an authentication token that the Task can
     use to perform Batch service operations. If this property is set, the Batch service provides
     the Task with an authentication token which can be used to authenticate Batch service
     operations without requiring an Account access key. The token is provided via the
     AZ_BATCH_AUTHENTICATION_TOKEN environment variable. The operations that the Task can carry out
     using the token depend on the settings. For example, a Task can request Job permissions in
     order to add other Tasks to the Job, or check the status of the Job or of other Tasks under the
     Job.
    :vartype authentication_token_settings: ~azure.batch.models.AuthenticationTokenSettings
    """

    id: str = rest_field(visibility=["read"])
    """A string that uniquely identifies the Task within the Job. The ID can contain any combination
     of alphanumeric characters including hyphens and underscores, and cannot contain more than 64
     characters. Required."""
    display_name: Optional[str] = rest_field(name="displayName", visibility=["read"])
    """A display name for the Task. The display name need not be unique and can contain any Unicode
     characters up to a maximum length of 1024."""
    url: str = rest_field(visibility=["read"])
    """The URL of the Task. Required."""
    e_tag: str = rest_field(name="eTag", visibility=["read"])
    """The ETag of the Task. This is an opaque string. You can use it to detect whether the Task has
     changed between requests. In particular, you can be pass the ETag when updating a Task to
     specify that your changes should take effect only if nobody else has modified the Task in the
     meantime. Required."""
    last_modified: datetime.datetime = rest_field(name="lastModified", visibility=["read"], format="rfc3339")
    """The last modified time of the Task. Required."""
    creation_time: datetime.datetime = rest_field(name="creationTime", visibility=["read"], format="rfc3339")
    """The creation time of the Task. Required."""
    exit_conditions: Optional["_models.ExitConditions"] = rest_field(name="exitConditions", visibility=["read"])
    """How the Batch service should respond when the Task completes."""
    state: Union[str, "_models.BatchTaskState"] = rest_field(visibility=["read"])
    """The current state of the Task. Required. Known values are: \"active\", \"preparing\",
     \"running\", and \"completed\"."""
    state_transition_time: datetime.datetime = rest_field(
        name="stateTransitionTime", visibility=["read"], format="rfc3339"
    )
    """The time at which the Task entered its current state. Required."""
    previous_state: Optional[Union[str, "_models.BatchTaskState"]] = rest_field(
        name="previousState", visibility=["read"]
    )
    """The previous state of the Task. This property is not set if the Task is in its initial Active
     state. Known values are: \"active\", \"preparing\", \"running\", and \"completed\"."""
    previous_state_transition_time: Optional[datetime.datetime] = rest_field(
        name="previousStateTransitionTime", visibility=["read"], format="rfc3339"
    )
    """The time at which the Task entered its previous state. This property is not set if the Task is
     in its initial Active state."""
    command_line: str = rest_field(name="commandLine", visibility=["read"])
    """The command line of the Task. For multi-instance Tasks, the command line is executed as the
     primary Task, after the primary Task and all subtasks have finished executing the coordination
     command line. The command line does not run under a shell, and therefore cannot take advantage
     of shell features such as environment variable expansion. If you want to take advantage of such
     features, you should invoke the shell in the command line, for example using \"cmd /c
     MyCommand\" in Windows or \"/bin/sh -c MyCommand\" in Linux. If the command line refers to file
     paths, it should use a relative path (relative to the Task working directory), or use the Batch
     provided environment variable
     (`https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables
     <https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables>`_).
     Required."""
    container_settings: Optional["_models.BatchTaskContainerSettings"] = rest_field(
        name="containerSettings", visibility=["read"]
    )
    """The settings for the container under which the Task runs. If the Pool that will run this Task
     has containerConfiguration set, this must be set as well. If the Pool that will run this Task
     doesn't have containerConfiguration set, this must not be set. When this is specified, all
     directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories
     on the node) are mapped into the container, all Task environment variables are mapped into the
     container, and the Task command line is executed in the container. Files produced in the
     container outside of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host disk, meaning
     that Batch file APIs will not be able to access those files."""
    resource_files: Optional[list["_models.ResourceFile"]] = rest_field(name="resourceFiles", visibility=["read"])
    """A list of files that the Batch service will download to the Compute Node before running the
     command line. For multi-instance Tasks, the resource files will only be downloaded to the
     Compute Node on which the primary Task is executed. There is a maximum size for the list of
     resource files.  When the max size is exceeded, the request will fail and the response error
     code will be RequestEntityTooLarge. If this occurs, the collection of ResourceFiles must be
     reduced in size. This can be achieved using .zip files, Application Packages, or Docker
     Containers."""
    output_files: Optional[list["_models.OutputFile"]] = rest_field(name="outputFiles", visibility=["read"])
    """A list of files that the Batch service will upload from the Compute Node after running the
     command line. For multi-instance Tasks, the files will only be uploaded from the Compute Node
     on which the primary Task is executed."""
    environment_settings: Optional[list["_models.EnvironmentSetting"]] = rest_field(
        name="environmentSettings", visibility=["read"]
    )
    """A list of environment variable settings for the Task."""
    affinity_info: Optional["_models.BatchAffinityInfo"] = rest_field(name="affinityInfo", visibility=["read"])
    """A locality hint that can be used by the Batch service to select a Compute Node on which to
     start the new Task."""
    constraints: Optional["_models.BatchTaskConstraints"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The execution constraints that apply to this Task."""
    required_slots: Optional[int] = rest_field(name="requiredSlots", visibility=["read"])
    """The number of scheduling slots that the Task requires to run. The default is 1. A Task can only
     be scheduled to run on a compute node if the node has enough free scheduling slots available.
     For multi-instance Tasks, this must be 1."""
    user_identity: Optional["_models.UserIdentity"] = rest_field(name="userIdentity", visibility=["read"])
    """The user identity under which the Task runs. If omitted, the Task runs as a non-administrative
     user unique to the Task."""
    execution_info: Optional["_models.BatchTaskExecutionInfo"] = rest_field(name="executionInfo", visibility=["read"])
    """Information about the execution of the Task."""
    node_info: Optional["_models.BatchNodeInfo"] = rest_field(name="nodeInfo", visibility=["read"])
    """Information about the Compute Node on which the Task ran."""
    multi_instance_settings: Optional["_models.MultiInstanceSettings"] = rest_field(
        name="multiInstanceSettings", visibility=["read"]
    )
    """An object that indicates that the Task is a multi-instance Task, and contains information about
     how to run the multi-instance Task."""
    task_statistics: Optional["_models.BatchTaskStatistics"] = rest_field(name="stats", visibility=["read"])
    """Resource usage statistics for the Task."""
    depends_on: Optional["_models.BatchTaskDependencies"] = rest_field(name="dependsOn", visibility=["read"])
    """The Tasks that this Task depends on. This Task will not be scheduled until all Tasks that it
     depends on have completed successfully. If any of those Tasks fail and exhaust their retry
     counts, this Task will never be scheduled."""
    application_package_references: Optional[list["_models.BatchApplicationPackageReference"]] = rest_field(
        name="applicationPackageReferences", visibility=["read"]
    )
    """A list of Packages that the Batch service will deploy to the Compute Node before running the
     command line. Application packages are downloaded and deployed to a shared directory, not the
     Task working directory. Therefore, if a referenced package is already on the Node, and is up to
     date, then it is not re-downloaded; the existing copy on the Compute Node is used. If a
     referenced Package cannot be installed, for example because the package has been deleted or
     because download failed, the Task fails."""
    authentication_token_settings: Optional["_models.AuthenticationTokenSettings"] = rest_field(
        name="authenticationTokenSettings", visibility=["read"]
    )
    """The settings for an authentication token that the Task can use to perform Batch service
     operations. If this property is set, the Batch service provides the Task with an authentication
     token which can be used to authenticate Batch service operations without requiring an Account
     access key. The token is provided via the AZ_BATCH_AUTHENTICATION_TOKEN environment variable.
     The operations that the Task can carry out using the token depend on the settings. For example,
     a Task can request Job permissions in order to add other Tasks to the Job, or check the status
     of the Job or of other Tasks under the Job."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        constraints: Optional["_models.BatchTaskConstraints"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTaskConstraints(_Model):
    """Execution constraints to apply to a Task.

    :ivar max_wall_clock_time: The maximum elapsed time that the Task may run, measured from the
     time the Task starts. If the Task does not complete within the time limit, the Batch service
     terminates it. If this is not specified, there is no time limit on how long the Task may run.
    :vartype max_wall_clock_time: ~datetime.timedelta
    :ivar retention_time: The minimum time to retain the Task directory on the Compute Node where
     it ran, from the time it completes execution. After this time, the Batch service may delete the
     Task directory and all its contents. The default is 7 days, i.e. the Task directory will be
     retained for 7 days unless the Compute Node is removed or the Job is deleted.
    :vartype retention_time: ~datetime.timedelta
    :ivar max_task_retry_count: The maximum number of times the Task may be retried. The Batch
     service retries a Task if its exit code is nonzero. Note that this value specifically controls
     the number of retries for the Task executable due to a nonzero exit code. The Batch service
     will try the Task once, and may then retry up to this limit. For example, if the maximum retry
     count is 3, Batch tries the Task up to 4 times (one initial try and 3 retries). If the maximum
     retry count is 0, the Batch service does not retry the Task after the first attempt. If the
     maximum retry count is -1, the Batch service retries the Task without limit, however this is
     not recommended for a start task or any task. The default value is 0 (no retries).
    :vartype max_task_retry_count: int
    """

    max_wall_clock_time: Optional[datetime.timedelta] = rest_field(
        name="maxWallClockTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum elapsed time that the Task may run, measured from the time the Task starts. If the
     Task does not complete within the time limit, the Batch service terminates it. If this is not
     specified, there is no time limit on how long the Task may run."""
    retention_time: Optional[datetime.timedelta] = rest_field(
        name="retentionTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The minimum time to retain the Task directory on the Compute Node where it ran, from the time
     it completes execution. After this time, the Batch service may delete the Task directory and
     all its contents. The default is 7 days, i.e. the Task directory will be retained for 7 days
     unless the Compute Node is removed or the Job is deleted."""
    max_task_retry_count: Optional[int] = rest_field(
        name="maxTaskRetryCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum number of times the Task may be retried. The Batch service retries a Task if its
     exit code is nonzero. Note that this value specifically controls the number of retries for the
     Task executable due to a nonzero exit code. The Batch service will try the Task once, and may
     then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the Task
     up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch
     service does not retry the Task after the first attempt. If the maximum retry count is -1, the
     Batch service retries the Task without limit, however this is not recommended for a start task
     or any task. The default value is 0 (no retries)."""

    @overload
    def __init__(
        self,
        *,
        max_wall_clock_time: Optional[datetime.timedelta] = None,
        retention_time: Optional[datetime.timedelta] = None,
        max_task_retry_count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTaskContainerExecutionInfo(_Model):
    """Contains information about the container which a Task is executing.

    :ivar container_id: The ID of the container.
    :vartype container_id: str
    :ivar state: The state of the container. This is the state of the container according to the
     Docker service. It is equivalent to the status field returned by "docker inspect".
    :vartype state: str
    :ivar error: Detailed error information about the container. This is the detailed error string
     from the Docker service, if available. It is equivalent to the error field returned by "docker
     inspect".
    :vartype error: str
    """

    container_id: Optional[str] = rest_field(
        name="containerId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ID of the container."""
    state: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The state of the container. This is the state of the container according to the Docker service.
     It is equivalent to the status field returned by \"docker inspect\"."""
    error: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Detailed error information about the container. This is the detailed error string from the
     Docker service, if available. It is equivalent to the error field returned by \"docker
     inspect\"."""

    @overload
    def __init__(
        self,
        *,
        container_id: Optional[str] = None,
        state: Optional[str] = None,
        error: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTaskContainerSettings(_Model):
    """The container settings for a Task.

    :ivar container_run_options: Additional options to the container create command. These
     additional options are supplied as arguments to the "docker create" command, in addition to
     those controlled by the Batch Service.
    :vartype container_run_options: str
    :ivar image_name: The Image to use to create the container in which the Task will run. This is
     the full Image reference, as would be specified to "docker pull". If no tag is provided as part
     of the Image name, the tag ":latest" is used as a default. Required.
    :vartype image_name: str
    :ivar registry: The private registry which contains the container Image. This setting can be
     omitted if was already provided at Pool creation.
    :vartype registry: ~azure.batch.models.ContainerRegistryReference
    :ivar working_directory: The location of the container Task working directory. The default is
     'taskWorkingDirectory'. Known values are: "taskWorkingDirectory" and "containerImageDefault".
    :vartype working_directory: str or ~azure.batch.models.ContainerWorkingDirectory
    :ivar container_host_batch_bind_mounts: The paths you want to mounted to container task. If
     this array is null or be not present, container task will mount entire temporary disk drive in
     windows (or AZ_BATCH_NODE_ROOT_DIR in Linux). It won't' mount any data paths into container if
     this array is set as empty.
    :vartype container_host_batch_bind_mounts:
     list[~azure.batch.models.ContainerHostBatchBindMountEntry]
    """

    container_run_options: Optional[str] = rest_field(
        name="containerRunOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional options to the container create command. These additional options are supplied as
     arguments to the \"docker create\" command, in addition to those controlled by the Batch
     Service."""
    image_name: str = rest_field(name="imageName", visibility=["read", "create", "update", "delete", "query"])
    """The Image to use to create the container in which the Task will run. This is the full Image
     reference, as would be specified to \"docker pull\". If no tag is provided as part of the Image
     name, the tag \":latest\" is used as a default. Required."""
    registry: Optional["_models.ContainerRegistryReference"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The private registry which contains the container Image. This setting can be omitted if was
     already provided at Pool creation."""
    working_directory: Optional[Union[str, "_models.ContainerWorkingDirectory"]] = rest_field(
        name="workingDirectory", visibility=["read", "create", "update", "delete", "query"]
    )
    """The location of the container Task working directory. The default is 'taskWorkingDirectory'.
     Known values are: \"taskWorkingDirectory\" and \"containerImageDefault\"."""
    container_host_batch_bind_mounts: Optional[list["_models.ContainerHostBatchBindMountEntry"]] = rest_field(
        name="containerHostBatchBindMounts", visibility=["read", "create", "update", "delete", "query"]
    )
    """The paths you want to mounted to container task. If this array is null or be not present,
     container task will mount entire temporary disk drive in windows (or AZ_BATCH_NODE_ROOT_DIR in
     Linux). It won't' mount any data paths into container if this array is set as empty."""

    @overload
    def __init__(
        self,
        *,
        image_name: str,
        container_run_options: Optional[str] = None,
        registry: Optional["_models.ContainerRegistryReference"] = None,
        working_directory: Optional[Union[str, "_models.ContainerWorkingDirectory"]] = None,
        container_host_batch_bind_mounts: Optional[list["_models.ContainerHostBatchBindMountEntry"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTaskCounts(_Model):
    """The Task counts for a Job.

    :ivar active: The number of Tasks in the active state. Required.
    :vartype active: int
    :ivar running: The number of Tasks in the running or preparing state. Required.
    :vartype running: int
    :ivar completed: The number of Tasks in the completed state. Required.
    :vartype completed: int
    :ivar succeeded: The number of Tasks which succeeded. A Task succeeds if its result (found in
     the executionInfo property) is 'success'. Required.
    :vartype succeeded: int
    :ivar failed: The number of Tasks which failed. A Task fails if its result (found in the
     executionInfo property) is 'failure'. Required.
    :vartype failed: int
    """

    active: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of Tasks in the active state. Required."""
    running: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of Tasks in the running or preparing state. Required."""
    completed: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of Tasks in the completed state. Required."""
    succeeded: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of Tasks which succeeded. A Task succeeds if its result (found in the executionInfo
     property) is 'success'. Required."""
    failed: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of Tasks which failed. A Task fails if its result (found in the executionInfo
     property) is 'failure'. Required."""

    @overload
    def __init__(
        self,
        *,
        active: int,
        running: int,
        completed: int,
        succeeded: int,
        failed: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTaskCountsResult(_Model):
    """The Task and TaskSlot counts for a Job.

    :ivar task_counts: The number of Tasks per state. Required.
    :vartype task_counts: ~azure.batch.models.BatchTaskCounts
    :ivar task_slot_counts: The number of TaskSlots required by Tasks per state. Required.
    :vartype task_slot_counts: ~azure.batch.models.BatchTaskSlotCounts
    """

    task_counts: "_models.BatchTaskCounts" = rest_field(
        name="taskCounts", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of Tasks per state. Required."""
    task_slot_counts: "_models.BatchTaskSlotCounts" = rest_field(
        name="taskSlotCounts", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of TaskSlots required by Tasks per state. Required."""

    @overload
    def __init__(
        self,
        *,
        task_counts: "_models.BatchTaskCounts",
        task_slot_counts: "_models.BatchTaskSlotCounts",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTaskCreateOptions(_Model):
    """Parameters for creating an Azure Batch Task.

    :ivar id: A string that uniquely identifies the Task within the Job. The ID can contain any
     combination of alphanumeric characters including hyphens and underscores, and cannot contain
     more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not
     have two IDs within a Job that differ only by case). Required.
    :vartype id: str
    :ivar display_name: A display name for the Task. The display name need not be unique and can
     contain any Unicode characters up to a maximum length of 1024.
    :vartype display_name: str
    :ivar exit_conditions: How the Batch service should respond when the Task completes.
    :vartype exit_conditions: ~azure.batch.models.ExitConditions
    :ivar command_line: The command line of the Task. For multi-instance Tasks, the command line is
     executed as the primary Task, after the primary Task and all subtasks have finished executing
     the coordination command line. The command line does not run under a shell, and therefore
     cannot take advantage of shell features such as environment variable expansion. If you want to
     take advantage of such features, you should invoke the shell in the command line, for example
     using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. If the command line
     refers to file paths, it should use a relative path (relative to the Task working directory),
     or use the Batch provided environment variable
     (`https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables
     <https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables>`_).
     Required.
    :vartype command_line: str
    :ivar container_settings: The settings for the container under which the Task runs. If the Pool
     that will run this Task has containerConfiguration set, this must be set as well. If the Pool
     that will run this Task doesn't have containerConfiguration set, this must not be set. When
     this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of
     Azure Batch directories on the node) are mapped into the container, all Task environment
     variables are mapped into the container, and the Task command line is executed in the
     container. Files produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be
     reflected to the host disk, meaning that Batch file APIs will not be able to access those
     files.
    :vartype container_settings: ~azure.batch.models.BatchTaskContainerSettings
    :ivar resource_files: A list of files that the Batch service will download to the Compute Node
     before running the command line. For multi-instance Tasks, the resource files will only be
     downloaded to the Compute Node on which the primary Task is executed. There is a maximum size
     for the list of resource files.  When the max size is exceeded, the request will fail and the
     response error code will be RequestEntityTooLarge. If this occurs, the collection of
     ResourceFiles must be reduced in size. This can be achieved using .zip files, Application
     Packages, or Docker Containers.
    :vartype resource_files: list[~azure.batch.models.ResourceFile]
    :ivar output_files: A list of files that the Batch service will upload from the Compute Node
     after running the command line. For multi-instance Tasks, the files will only be uploaded from
     the Compute Node on which the primary Task is executed.
    :vartype output_files: list[~azure.batch.models.OutputFile]
    :ivar environment_settings: A list of environment variable settings for the Task.
    :vartype environment_settings: list[~azure.batch.models.EnvironmentSetting]
    :ivar affinity_info: A locality hint that can be used by the Batch service to select a Compute
     Node on which to start the new Task.
    :vartype affinity_info: ~azure.batch.models.BatchAffinityInfo
    :ivar constraints: The execution constraints that apply to this Task. If you do not specify
     constraints, the maxTaskRetryCount is the maxTaskRetryCount specified for the Job, the
     maxWallClockTime is infinite, and the retentionTime is 7 days.
    :vartype constraints: ~azure.batch.models.BatchTaskConstraints
    :ivar required_slots: The number of scheduling slots that the Task required to run. The default
     is 1. A Task can only be scheduled to run on a compute node if the node has enough free
     scheduling slots available. For multi-instance Tasks, this must be 1.
    :vartype required_slots: int
    :ivar user_identity: The user identity under which the Task runs. If omitted, the Task runs as
     a non-administrative user unique to the Task.
    :vartype user_identity: ~azure.batch.models.UserIdentity
    :ivar multi_instance_settings: An object that indicates that the Task is a multi-instance Task,
     and contains information about how to run the multi-instance Task.
    :vartype multi_instance_settings: ~azure.batch.models.MultiInstanceSettings
    :ivar depends_on: The Tasks that this Task depends on. This Task will not be scheduled until
     all Tasks that it depends on have completed successfully. If any of those Tasks fail and
     exhaust their retry counts, this Task will never be scheduled. If the Job does not have
     usesTaskDependencies set to true, and this element is present, the request fails with error
     code TaskDependenciesNotSpecifiedOnJob.
    :vartype depends_on: ~azure.batch.models.BatchTaskDependencies
    :ivar application_package_references: A list of Packages that the Batch service will deploy to
     the Compute Node before running the command line. Application packages are downloaded and
     deployed to a shared directory, not the Task working directory. Therefore, if a referenced
     package is already on the Node, and is up to date, then it is not re-downloaded; the existing
     copy on the Compute Node is used. If a referenced Package cannot be installed, for example
     because the package has been deleted or because download failed, the Task fails.
    :vartype application_package_references:
     list[~azure.batch.models.BatchApplicationPackageReference]
    :ivar authentication_token_settings: The settings for an authentication token that the Task can
     use to perform Batch service operations. If this property is set, the Batch service provides
     the Task with an authentication token which can be used to authenticate Batch service
     operations without requiring an Account access key. The token is provided via the
     AZ_BATCH_AUTHENTICATION_TOKEN environment variable. The operations that the Task can carry out
     using the token depend on the settings. For example, a Task can request Job permissions in
     order to add other Tasks to the Job, or check the status of the Job or of other Tasks under the
     Job.
    :vartype authentication_token_settings: ~azure.batch.models.AuthenticationTokenSettings
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A string that uniquely identifies the Task within the Job. The ID can contain any combination
     of alphanumeric characters including hyphens and underscores, and cannot contain more than 64
     characters. The ID is case-preserving and case-insensitive (that is, you may not have two IDs
     within a Job that differ only by case). Required."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """A display name for the Task. The display name need not be unique and can contain any Unicode
     characters up to a maximum length of 1024."""
    exit_conditions: Optional["_models.ExitConditions"] = rest_field(
        name="exitConditions", visibility=["read", "create", "update", "delete", "query"]
    )
    """How the Batch service should respond when the Task completes."""
    command_line: str = rest_field(name="commandLine", visibility=["read", "create", "update", "delete", "query"])
    """The command line of the Task. For multi-instance Tasks, the command line is executed as the
     primary Task, after the primary Task and all subtasks have finished executing the coordination
     command line. The command line does not run under a shell, and therefore cannot take advantage
     of shell features such as environment variable expansion. If you want to take advantage of such
     features, you should invoke the shell in the command line, for example using \"cmd /c
     MyCommand\" in Windows or \"/bin/sh -c MyCommand\" in Linux. If the command line refers to file
     paths, it should use a relative path (relative to the Task working directory), or use the Batch
     provided environment variable
     (`https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables
     <https://learn.microsoft.com/azure/batch/batch-compute-node-environment-variables>`_).
     Required."""
    container_settings: Optional["_models.BatchTaskContainerSettings"] = rest_field(
        name="containerSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The settings for the container under which the Task runs. If the Pool that will run this Task
     has containerConfiguration set, this must be set as well. If the Pool that will run this Task
     doesn't have containerConfiguration set, this must not be set. When this is specified, all
     directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories
     on the node) are mapped into the container, all Task environment variables are mapped into the
     container, and the Task command line is executed in the container. Files produced in the
     container outside of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host disk, meaning
     that Batch file APIs will not be able to access those files."""
    resource_files: Optional[list["_models.ResourceFile"]] = rest_field(
        name="resourceFiles", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of files that the Batch service will download to the Compute Node before running the
     command line. For multi-instance Tasks, the resource files will only be downloaded to the
     Compute Node on which the primary Task is executed. There is a maximum size for the list of
     resource files.  When the max size is exceeded, the request will fail and the response error
     code will be RequestEntityTooLarge. If this occurs, the collection of ResourceFiles must be
     reduced in size. This can be achieved using .zip files, Application Packages, or Docker
     Containers."""
    output_files: Optional[list["_models.OutputFile"]] = rest_field(
        name="outputFiles", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of files that the Batch service will upload from the Compute Node after running the
     command line. For multi-instance Tasks, the files will only be uploaded from the Compute Node
     on which the primary Task is executed."""
    environment_settings: Optional[list["_models.EnvironmentSetting"]] = rest_field(
        name="environmentSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of environment variable settings for the Task."""
    affinity_info: Optional["_models.BatchAffinityInfo"] = rest_field(
        name="affinityInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """A locality hint that can be used by the Batch service to select a Compute Node on which to
     start the new Task."""
    constraints: Optional["_models.BatchTaskConstraints"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The execution constraints that apply to this Task. If you do not specify constraints, the
     maxTaskRetryCount is the maxTaskRetryCount specified for the Job, the maxWallClockTime is
     infinite, and the retentionTime is 7 days."""
    required_slots: Optional[int] = rest_field(
        name="requiredSlots", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of scheduling slots that the Task required to run. The default is 1. A Task can only
     be scheduled to run on a compute node if the node has enough free scheduling slots available.
     For multi-instance Tasks, this must be 1."""
    user_identity: Optional["_models.UserIdentity"] = rest_field(
        name="userIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The user identity under which the Task runs. If omitted, the Task runs as a non-administrative
     user unique to the Task."""
    multi_instance_settings: Optional["_models.MultiInstanceSettings"] = rest_field(
        name="multiInstanceSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """An object that indicates that the Task is a multi-instance Task, and contains information about
     how to run the multi-instance Task."""
    depends_on: Optional["_models.BatchTaskDependencies"] = rest_field(
        name="dependsOn", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Tasks that this Task depends on. This Task will not be scheduled until all Tasks that it
     depends on have completed successfully. If any of those Tasks fail and exhaust their retry
     counts, this Task will never be scheduled. If the Job does not have usesTaskDependencies set to
     true, and this element is present, the request fails with error code
     TaskDependenciesNotSpecifiedOnJob."""
    application_package_references: Optional[list["_models.BatchApplicationPackageReference"]] = rest_field(
        name="applicationPackageReferences", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of Packages that the Batch service will deploy to the Compute Node before running the
     command line. Application packages are downloaded and deployed to a shared directory, not the
     Task working directory. Therefore, if a referenced package is already on the Node, and is up to
     date, then it is not re-downloaded; the existing copy on the Compute Node is used. If a
     referenced Package cannot be installed, for example because the package has been deleted or
     because download failed, the Task fails."""
    authentication_token_settings: Optional["_models.AuthenticationTokenSettings"] = rest_field(
        name="authenticationTokenSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The settings for an authentication token that the Task can use to perform Batch service
     operations. If this property is set, the Batch service provides the Task with an authentication
     token which can be used to authenticate Batch service operations without requiring an Account
     access key. The token is provided via the AZ_BATCH_AUTHENTICATION_TOKEN environment variable.
     The operations that the Task can carry out using the token depend on the settings. For example,
     a Task can request Job permissions in order to add other Tasks to the Job, or check the status
     of the Job or of other Tasks under the Job."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        command_line: str,
        display_name: Optional[str] = None,
        exit_conditions: Optional["_models.ExitConditions"] = None,
        container_settings: Optional["_models.BatchTaskContainerSettings"] = None,
        resource_files: Optional[list["_models.ResourceFile"]] = None,
        output_files: Optional[list["_models.OutputFile"]] = None,
        environment_settings: Optional[list["_models.EnvironmentSetting"]] = None,
        affinity_info: Optional["_models.BatchAffinityInfo"] = None,
        constraints: Optional["_models.BatchTaskConstraints"] = None,
        required_slots: Optional[int] = None,
        user_identity: Optional["_models.UserIdentity"] = None,
        multi_instance_settings: Optional["_models.MultiInstanceSettings"] = None,
        depends_on: Optional["_models.BatchTaskDependencies"] = None,
        application_package_references: Optional[list["_models.BatchApplicationPackageReference"]] = None,
        authentication_token_settings: Optional["_models.AuthenticationTokenSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTaskCreateResult(_Model):
    """Result for a single Task created as part of an add Task collection operation.

    :ivar status: The status of the add Task request. Required. Known values are: "success",
     "clienterror", and "servererror".
    :vartype status: str or ~azure.batch.models.BatchTaskAddStatus
    :ivar task_id: The ID of the Task for which this is the result. Required.
    :vartype task_id: str
    :ivar e_tag: The ETag of the Task, if the Task was successfully added. You can use this to
     detect whether the Task has changed between requests. In particular, you can be pass the ETag
     with an Update Task request to specify that your changes should take effect only if nobody else
     has modified the Job in the meantime.
    :vartype e_tag: str
    :ivar last_modified: The last modified time of the Task.
    :vartype last_modified: ~datetime.datetime
    :ivar location: The URL of the Task, if the Task was successfully added.
    :vartype location: str
    :ivar error: The error encountered while attempting to add the Task.
    :vartype error: ~azure.batch.models.BatchError
    """

    status: Union[str, "_models.BatchTaskAddStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the add Task request. Required. Known values are: \"success\", \"clienterror\",
     and \"servererror\"."""
    task_id: str = rest_field(name="taskId", visibility=["read", "create", "update", "delete", "query"])
    """The ID of the Task for which this is the result. Required."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read", "create", "update", "delete", "query"])
    """The ETag of the Task, if the Task was successfully added. You can use this to detect whether
     the Task has changed between requests. In particular, you can be pass the ETag with an Update
     Task request to specify that your changes should take effect only if nobody else has modified
     the Job in the meantime."""
    last_modified: Optional[datetime.datetime] = rest_field(
        name="lastModified", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last modified time of the Task."""
    location: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL of the Task, if the Task was successfully added."""
    error: Optional["_models.BatchError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error encountered while attempting to add the Task."""

    @overload
    def __init__(
        self,
        *,
        status: Union[str, "_models.BatchTaskAddStatus"],
        task_id: str,
        e_tag: Optional[str] = None,
        last_modified: Optional[datetime.datetime] = None,
        location: Optional[str] = None,
        error: Optional["_models.BatchError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTaskDependencies(_Model):
    """Specifies any dependencies of a Task. Any Task that is explicitly specified or
    within a dependency range must complete before the dependant Task will be
    scheduled.

    :ivar task_ids: The list of Task IDs that this Task depends on. All Tasks in this list must
     complete successfully before the dependent Task can be scheduled. The taskIds collection is
     limited to 64000 characters total (i.e. the combined length of all Task IDs). If the taskIds
     collection exceeds the maximum length, the Add Task request fails with error code
     TaskDependencyListTooLong. In this case consider using Task ID ranges instead.
    :vartype task_ids: list[str]
    :ivar task_id_ranges: The list of Task ID ranges that this Task depends on. All Tasks in all
     ranges must complete successfully before the dependent Task can be scheduled.
    :vartype task_id_ranges: list[~azure.batch.models.BatchTaskIdRange]
    """

    task_ids: Optional[list[str]] = rest_field(
        name="taskIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of Task IDs that this Task depends on. All Tasks in this list must complete
     successfully before the dependent Task can be scheduled. The taskIds collection is limited to
     64000 characters total (i.e. the combined length of all Task IDs). If the taskIds collection
     exceeds the maximum length, the Add Task request fails with error code
     TaskDependencyListTooLong. In this case consider using Task ID ranges instead."""
    task_id_ranges: Optional[list["_models.BatchTaskIdRange"]] = rest_field(
        name="taskIdRanges", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of Task ID ranges that this Task depends on. All Tasks in all ranges must complete
     successfully before the dependent Task can be scheduled."""

    @overload
    def __init__(
        self,
        *,
        task_ids: Optional[list[str]] = None,
        task_id_ranges: Optional[list["_models.BatchTaskIdRange"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTaskExecutionInfo(_Model):
    """Information about the execution of a Task.

    :ivar start_time: The time at which the Task started running. 'Running' corresponds to the
     running state, so if the Task specifies resource files or Packages, then the start time
     reflects the time at which the Task started downloading or deploying these. If the Task has
     been restarted or retried, this is the most recent time at which the Task started running. This
     property is present only for Tasks that are in the running or completed state.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The time at which the Task completed. This property is set only if the Task is
     in the Completed state.
    :vartype end_time: ~datetime.datetime
    :ivar exit_code: The exit code of the program specified on the Task command line. This property
     is set only if the Task is in the completed state. In general, the exit code for a process
     reflects the specific convention implemented by the application developer for that process. If
     you use the exit code value to make decisions in your code, be sure that you know the exit code
     convention used by the application process. However, if the Batch service terminates the Task
     (due to timeout, or user termination via the API) you may see an operating system-defined exit
     code.
    :vartype exit_code: int
    :ivar container_info: Information about the container under which the Task is executing. This
     property is set only if the Task runs in a container context.
    :vartype container_info: ~azure.batch.models.BatchTaskContainerExecutionInfo
    :ivar failure_info: Information describing the Task failure, if any. This property is set only
     if the Task is in the completed state and encountered a failure.
    :vartype failure_info: ~azure.batch.models.BatchTaskFailureInfo
    :ivar retry_count: The number of times the Task has been retried by the Batch service. Task
     application failures (non-zero exit code) are retried, pre-processing errors (the Task could
     not be run) and file upload errors are not retried. The Batch service will retry the Task up to
     the limit specified by the constraints. Required.
    :vartype retry_count: int
    :ivar last_retry_time: The most recent time at which a retry of the Task started running. This
     element is present only if the Task was retried (i.e. retryCount is nonzero). If present, this
     is typically the same as startTime, but may be different if the Task has been restarted for
     reasons other than retry; for example, if the Compute Node was rebooted during a retry, then
     the startTime is updated but the lastRetryTime is not.
    :vartype last_retry_time: ~datetime.datetime
    :ivar requeue_count: The number of times the Task has been requeued by the Batch service as the
     result of a user request. When the user removes Compute Nodes from a Pool (by
     resizing/shrinking the pool) or when the Job is being disabled, the user can specify that
     running Tasks on the Compute Nodes be requeued for execution. This count tracks how many times
     the Task has been requeued for these reasons. Required.
    :vartype requeue_count: int
    :ivar last_requeue_time: The most recent time at which the Task has been requeued by the Batch
     service as the result of a user request. This property is set only if the requeueCount is
     nonzero.
    :vartype last_requeue_time: ~datetime.datetime
    :ivar result: The result of the Task execution. If the value is 'failed', then the details of
     the failure can be found in the failureInfo property. Known values are: "success" and
     "failure".
    :vartype result: str or ~azure.batch.models.BatchTaskExecutionResult
    """

    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the Task started running. 'Running' corresponds to the running state, so if
     the Task specifies resource files or Packages, then the start time reflects the time at which
     the Task started downloading or deploying these. If the Task has been restarted or retried,
     this is the most recent time at which the Task started running. This property is present only
     for Tasks that are in the running or completed state."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the Task completed. This property is set only if the Task is in the Completed
     state."""
    exit_code: Optional[int] = rest_field(name="exitCode", visibility=["read", "create", "update", "delete", "query"])
    """The exit code of the program specified on the Task command line. This property is set only if
     the Task is in the completed state. In general, the exit code for a process reflects the
     specific convention implemented by the application developer for that process. If you use the
     exit code value to make decisions in your code, be sure that you know the exit code convention
     used by the application process. However, if the Batch service terminates the Task (due to
     timeout, or user termination via the API) you may see an operating system-defined exit code."""
    container_info: Optional["_models.BatchTaskContainerExecutionInfo"] = rest_field(
        name="containerInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information about the container under which the Task is executing. This property is set only if
     the Task runs in a container context."""
    failure_info: Optional["_models.BatchTaskFailureInfo"] = rest_field(
        name="failureInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information describing the Task failure, if any. This property is set only if the Task is in
     the completed state and encountered a failure."""
    retry_count: int = rest_field(name="retryCount", visibility=["read", "create", "update", "delete", "query"])
    """The number of times the Task has been retried by the Batch service. Task application failures
     (non-zero exit code) are retried, pre-processing errors (the Task could not be run) and file
     upload errors are not retried. The Batch service will retry the Task up to the limit specified
     by the constraints. Required."""
    last_retry_time: Optional[datetime.datetime] = rest_field(
        name="lastRetryTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The most recent time at which a retry of the Task started running. This element is present only
     if the Task was retried (i.e. retryCount is nonzero). If present, this is typically the same as
     startTime, but may be different if the Task has been restarted for reasons other than retry;
     for example, if the Compute Node was rebooted during a retry, then the startTime is updated but
     the lastRetryTime is not."""
    requeue_count: int = rest_field(name="requeueCount", visibility=["read", "create", "update", "delete", "query"])
    """The number of times the Task has been requeued by the Batch service as the result of a user
     request. When the user removes Compute Nodes from a Pool (by resizing/shrinking the pool) or
     when the Job is being disabled, the user can specify that running Tasks on the Compute Nodes be
     requeued for execution. This count tracks how many times the Task has been requeued for these
     reasons. Required."""
    last_requeue_time: Optional[datetime.datetime] = rest_field(
        name="lastRequeueTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The most recent time at which the Task has been requeued by the Batch service as the result of
     a user request. This property is set only if the requeueCount is nonzero."""
    result: Optional[Union[str, "_models.BatchTaskExecutionResult"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The result of the Task execution. If the value is 'failed', then the details of the failure can
     be found in the failureInfo property. Known values are: \"success\" and \"failure\"."""

    @overload
    def __init__(
        self,
        *,
        retry_count: int,
        requeue_count: int,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        exit_code: Optional[int] = None,
        container_info: Optional["_models.BatchTaskContainerExecutionInfo"] = None,
        failure_info: Optional["_models.BatchTaskFailureInfo"] = None,
        last_retry_time: Optional[datetime.datetime] = None,
        last_requeue_time: Optional[datetime.datetime] = None,
        result: Optional[Union[str, "_models.BatchTaskExecutionResult"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTaskFailureInfo(_Model):
    """Information about a Task failure.

    :ivar category: The category of the Task error. Required. Known values are: "usererror" and
     "servererror".
    :vartype category: str or ~azure.batch.models.BatchErrorSourceCategory
    :ivar code: An identifier for the Task error. Codes are invariant and are intended to be
     consumed programmatically.
    :vartype code: str
    :ivar message: A message describing the Task error, intended to be suitable for display in a
     user interface.
    :vartype message: str
    :ivar details: A list of additional details related to the error.
    :vartype details: list[~azure.batch.models.NameValuePair]
    """

    category: Union[str, "_models.BatchErrorSourceCategory"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The category of the Task error. Required. Known values are: \"usererror\" and \"servererror\"."""
    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An identifier for the Task error. Codes are invariant and are intended to be consumed
     programmatically."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A message describing the Task error, intended to be suitable for display in a user interface."""
    details: Optional[list["_models.NameValuePair"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of additional details related to the error."""

    @overload
    def __init__(
        self,
        *,
        category: Union[str, "_models.BatchErrorSourceCategory"],
        code: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[list["_models.NameValuePair"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTaskGroup(_Model):
    """A collection of Azure Batch Tasks to add.

    :ivar values_property: The collection of Tasks to add. The maximum count of Tasks is 100. The
     total serialized size of this collection must be less than 1MB. If it is greater than 1MB (for
     example if each Task has 100's of resource files or environment variables), the request will
     fail with code 'RequestBodyTooLarge' and should be retried again with fewer Tasks. Required.
    :vartype values_property: list[~azure.batch.models.BatchTaskCreateOptions]
    """

    values_property: list["_models.BatchTaskCreateOptions"] = rest_field(
        name="value", visibility=["read", "create", "update", "delete", "query"], original_tsp_name="values"
    )
    """The collection of Tasks to add. The maximum count of Tasks is 100. The total serialized size of
     this collection must be less than 1MB. If it is greater than 1MB (for example if each Task has
     100's of resource files or environment variables), the request will fail with code
     'RequestBodyTooLarge' and should be retried again with fewer Tasks. Required."""

    @overload
    def __init__(
        self,
        *,
        values_property: list["_models.BatchTaskCreateOptions"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTaskIdRange(_Model):
    """The start and end of the range are inclusive. For example, if a range has start
    9 and end 12, then it represents Tasks '9', '10', '11' and '12'.

    :ivar start: The first Task ID in the range. Required.
    :vartype start: int
    :ivar end: The last Task ID in the range. Required.
    :vartype end: int
    """

    start: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The first Task ID in the range. Required."""
    end: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The last Task ID in the range. Required."""

    @overload
    def __init__(
        self,
        *,
        start: int,
        end: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTaskInfo(_Model):
    """Information about a Task running on a Compute Node.

    :ivar task_url: The URL of the Task.
    :vartype task_url: str
    :ivar job_id: The ID of the Job to which the Task belongs.
    :vartype job_id: str
    :ivar task_id: The ID of the Task.
    :vartype task_id: str
    :ivar subtask_id: The ID of the subtask if the Task is a multi-instance Task.
    :vartype subtask_id: int
    :ivar task_state: The current state of the Task. Required. Known values are: "active",
     "preparing", "running", and "completed".
    :vartype task_state: str or ~azure.batch.models.BatchTaskState
    :ivar execution_info: Information about the execution of the Task.
    :vartype execution_info: ~azure.batch.models.BatchTaskExecutionInfo
    """

    task_url: Optional[str] = rest_field(name="taskUrl", visibility=["read", "create", "update", "delete", "query"])
    """The URL of the Task."""
    job_id: Optional[str] = rest_field(name="jobId", visibility=["read", "create", "update", "delete", "query"])
    """The ID of the Job to which the Task belongs."""
    task_id: Optional[str] = rest_field(name="taskId", visibility=["read", "create", "update", "delete", "query"])
    """The ID of the Task."""
    subtask_id: Optional[int] = rest_field(name="subtaskId", visibility=["read", "create", "update", "delete", "query"])
    """The ID of the subtask if the Task is a multi-instance Task."""
    task_state: Union[str, "_models.BatchTaskState"] = rest_field(
        name="taskState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The current state of the Task. Required. Known values are: \"active\", \"preparing\",
     \"running\", and \"completed\"."""
    execution_info: Optional["_models.BatchTaskExecutionInfo"] = rest_field(
        name="executionInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information about the execution of the Task."""

    @overload
    def __init__(
        self,
        *,
        task_state: Union[str, "_models.BatchTaskState"],
        task_url: Optional[str] = None,
        job_id: Optional[str] = None,
        task_id: Optional[str] = None,
        subtask_id: Optional[int] = None,
        execution_info: Optional["_models.BatchTaskExecutionInfo"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTaskSchedulingPolicy(_Model):
    """Specifies how Tasks should be distributed across Compute Nodes.

    :ivar job_default_order: The order for scheduling tasks from different jobs with the same
     priority. If not specified, the default is none. Known values are: "none" and "creationtime".
    :vartype job_default_order: str or ~azure.batch.models.BatchJobDefaultOrder
    :ivar node_fill_type: How Tasks are distributed across Compute Nodes in a Pool. If not
     specified, the default is spread. Required. Known values are: "spread" and "pack".
    :vartype node_fill_type: str or ~azure.batch.models.BatchNodeFillType
    """

    job_default_order: Optional[Union[str, "_models.BatchJobDefaultOrder"]] = rest_field(
        name="jobDefaultOrder", visibility=["read", "create", "update", "delete", "query"]
    )
    """The order for scheduling tasks from different jobs with the same priority. If not specified,
     the default is none. Known values are: \"none\" and \"creationtime\"."""
    node_fill_type: Union[str, "_models.BatchNodeFillType"] = rest_field(
        name="nodeFillType", visibility=["read", "create", "update", "delete", "query"]
    )
    """How Tasks are distributed across Compute Nodes in a Pool. If not specified, the default is
     spread. Required. Known values are: \"spread\" and \"pack\"."""

    @overload
    def __init__(
        self,
        *,
        node_fill_type: Union[str, "_models.BatchNodeFillType"],
        job_default_order: Optional[Union[str, "_models.BatchJobDefaultOrder"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTaskSlotCounts(_Model):
    """The TaskSlot counts for a Job.

    :ivar active: The number of TaskSlots for active Tasks. Required.
    :vartype active: int
    :ivar running: The number of TaskSlots for running Tasks. Required.
    :vartype running: int
    :ivar completed: The number of TaskSlots for completed Tasks. Required.
    :vartype completed: int
    :ivar succeeded: The number of TaskSlots for succeeded Tasks. Required.
    :vartype succeeded: int
    :ivar failed: The number of TaskSlots for failed Tasks. Required.
    :vartype failed: int
    """

    active: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of TaskSlots for active Tasks. Required."""
    running: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of TaskSlots for running Tasks. Required."""
    completed: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of TaskSlots for completed Tasks. Required."""
    succeeded: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of TaskSlots for succeeded Tasks. Required."""
    failed: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of TaskSlots for failed Tasks. Required."""

    @overload
    def __init__(
        self,
        *,
        active: int,
        running: int,
        completed: int,
        succeeded: int,
        failed: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchTaskStatistics(_Model):
    """Resource usage statistics for a Task.

    :ivar url: The URL of the statistics. Required.
    :vartype url: str
    :ivar start_time: The start time of the time range covered by the statistics. Required.
    :vartype start_time: ~datetime.datetime
    :ivar last_update_time: The time at which the statistics were last updated. All statistics are
     limited to the range between startTime and lastUpdateTime. Required.
    :vartype last_update_time: ~datetime.datetime
    :ivar user_cpu_time: The total user mode CPU time (summed across all cores and all Compute
     Nodes) consumed by the Task. Required.
    :vartype user_cpu_time: ~datetime.timedelta
    :ivar kernel_cpu_time: The total kernel mode CPU time (summed across all cores and all Compute
     Nodes) consumed by the Task. Required.
    :vartype kernel_cpu_time: ~datetime.timedelta
    :ivar wall_clock_time: The total wall clock time of the Task. The wall clock time is the
     elapsed time from when the Task started running on a Compute Node to when it finished (or to
     the last time the statistics were updated, if the Task had not finished by then). If the Task
     was retried, this includes the wall clock time of all the Task retries. Required.
    :vartype wall_clock_time: ~datetime.timedelta
    :ivar read_iops: The total number of disk read operations made by the Task. Required.
    :vartype read_iops: int
    :ivar write_iops: The total number of disk write operations made by the Task. Required.
    :vartype write_iops: int
    :ivar read_io_gib: The total gibibytes read from disk by the Task. Required.
    :vartype read_io_gib: float
    :ivar write_io_gib: The total gibibytes written to disk by the Task. Required.
    :vartype write_io_gib: float
    :ivar wait_time: The total wait time of the Task. The wait time for a Task is defined as the
     elapsed time between the creation of the Task and the start of Task execution. (If the Task is
     retried due to failures, the wait time is the time to the most recent Task execution.).
     Required.
    :vartype wait_time: ~datetime.timedelta
    """

    url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL of the statistics. Required."""
    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The start time of the time range covered by the statistics. Required."""
    last_update_time: datetime.datetime = rest_field(
        name="lastUpdateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the statistics were last updated. All statistics are limited to the range
     between startTime and lastUpdateTime. Required."""
    user_cpu_time: datetime.timedelta = rest_field(
        name="userCPUTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total user mode CPU time (summed across all cores and all Compute Nodes) consumed by the
     Task. Required."""
    kernel_cpu_time: datetime.timedelta = rest_field(
        name="kernelCPUTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total kernel mode CPU time (summed across all cores and all Compute Nodes) consumed by the
     Task. Required."""
    wall_clock_time: datetime.timedelta = rest_field(
        name="wallClockTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total wall clock time of the Task. The wall clock time is the elapsed time from when the
     Task started running on a Compute Node to when it finished (or to the last time the statistics
     were updated, if the Task had not finished by then). If the Task was retried, this includes the
     wall clock time of all the Task retries. Required."""
    read_iops: int = rest_field(
        name="readIOps", visibility=["read", "create", "update", "delete", "query"], format="str"
    )
    """The total number of disk read operations made by the Task. Required."""
    write_iops: int = rest_field(
        name="writeIOps", visibility=["read", "create", "update", "delete", "query"], format="str"
    )
    """The total number of disk write operations made by the Task. Required."""
    read_io_gib: float = rest_field(name="readIOGiB", visibility=["read", "create", "update", "delete", "query"])
    """The total gibibytes read from disk by the Task. Required."""
    write_io_gib: float = rest_field(name="writeIOGiB", visibility=["read", "create", "update", "delete", "query"])
    """The total gibibytes written to disk by the Task. Required."""
    wait_time: datetime.timedelta = rest_field(
        name="waitTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total wait time of the Task. The wait time for a Task is defined as the elapsed time
     between the creation of the Task and the start of Task execution. (If the Task is retried due
     to failures, the wait time is the time to the most recent Task execution.). Required."""

    @overload
    def __init__(
        self,
        *,
        url: str,
        start_time: datetime.datetime,
        last_update_time: datetime.datetime,
        user_cpu_time: datetime.timedelta,
        kernel_cpu_time: datetime.timedelta,
        wall_clock_time: datetime.timedelta,
        read_iops: int,
        write_iops: int,
        read_io_gib: float,
        write_io_gib: float,
        wait_time: datetime.timedelta,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchUefiSettings(_Model):
    """Specifies the security settings like secure boot and vTPM used while creating the virtual
    machine.

    :ivar secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual
     machine.
    :vartype secure_boot_enabled: bool
    :ivar vtpm_enabled: Specifies whether vTPM should be enabled on the virtual machine.
    :vartype vtpm_enabled: bool
    """

    secure_boot_enabled: Optional[bool] = rest_field(
        name="secureBootEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether secure boot should be enabled on the virtual machine."""
    vtpm_enabled: Optional[bool] = rest_field(
        name="vTpmEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether vTPM should be enabled on the virtual machine."""

    @overload
    def __init__(
        self,
        *,
        secure_boot_enabled: Optional[bool] = None,
        vtpm_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchUserAssignedIdentity(_Model):
    """The user assigned Identity.

    :ivar resource_id: The ARM resource id of the user assigned identity. Required.
    :vartype resource_id: str
    :ivar client_id: The client id of the user assigned identity.
    :vartype client_id: str
    :ivar principal_id: The principal id of the user assigned identity.
    :vartype principal_id: str
    """

    resource_id: str = rest_field(name="resourceId", visibility=["read", "create", "update", "delete", "query"])
    """The ARM resource id of the user assigned identity. Required."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client id of the user assigned identity."""
    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal id of the user assigned identity."""

    @overload
    def __init__(
        self,
        *,
        resource_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchVmDiskSecurityProfile(_Model):
    """Specifies the security profile settings for the managed disk. **Note**: It can only be set for
    Confidential VMs and required when using Confidential VMs.

    :ivar security_encryption_type: Specifies the EncryptionType of the managed disk. It is set to
     VMGuestStateOnly for encryption of just the VMGuestState blob, and NonPersistedTPM for not
     persisting firmware state in the VMGuestState blob. **Note**: It can be set for only
     Confidential VMs and is required when using Confidential VMs. Known values are:
     "DiskWithVMGuestState", "NonPersistedTPM", and "VMGuestStateOnly".
    :vartype security_encryption_type: str or ~azure.batch.models.SecurityEncryptionTypes
    """

    security_encryption_type: Optional[Union[str, "_models.SecurityEncryptionTypes"]] = rest_field(
        name="securityEncryptionType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the EncryptionType of the managed disk. It is set to VMGuestStateOnly for encryption
     of just the VMGuestState blob, and NonPersistedTPM for not persisting firmware state in the
     VMGuestState blob. **Note**: It can be set for only Confidential VMs and is required when using
     Confidential VMs. Known values are: \"DiskWithVMGuestState\", \"NonPersistedTPM\", and
     \"VMGuestStateOnly\"."""

    @overload
    def __init__(
        self,
        *,
        security_encryption_type: Optional[Union[str, "_models.SecurityEncryptionTypes"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchVmImageReference(_Model):
    """A reference to an Azure Virtual Machines Marketplace Image or a Azure Compute Gallery Image.
    To get the list of all Azure Marketplace Image references verified by Azure Batch, see the
    ' List Supported Images ' operation.

    :ivar publisher: The publisher of the Azure Virtual Machines Marketplace Image. For example,
     Canonical or MicrosoftWindowsServer.
    :vartype publisher: str
    :ivar offer: The offer type of the Azure Virtual Machines Marketplace Image. For example,
     UbuntuServer or WindowsServer.
    :vartype offer: str
    :ivar sku: The SKU of the Azure Virtual Machines Marketplace Image. For example, 18.04-LTS or
     2019-Datacenter.
    :vartype sku: str
    :ivar version: The version of the Azure Virtual Machines Marketplace Image. A value of 'latest'
     can be specified to select the latest version of an Image. If omitted, the default is 'latest'.
    :vartype version: str
    :ivar virtual_machine_image_id: The ARM resource identifier of the Azure Compute Gallery Image.
     Compute Nodes in the Pool will be created using this Image Id. This is of the form
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{VersionId}
     or
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}
     for always defaulting to the latest image version. This property is mutually exclusive with
     other ImageReference properties. The Azure Compute Gallery Image must have replicas in the same
     region and must be in the same subscription as the Azure Batch account. If the image version is
     not specified in the imageId, the latest version will be used. For information about the
     firewall settings for the Batch Compute Node agent to communicate with the Batch service see
     `https://learn.microsoft.com/azure/batch/nodes-and-pools#virtual-network-vnet-and-firewall-configuration
     <https://learn.microsoft.com/azure/batch/nodes-and-pools#virtual-network-vnet-and-firewall-configuration>`_.
    :vartype virtual_machine_image_id: str
    :ivar exact_version: The specific version of the platform image or marketplace image used to
     create the node. This read-only field differs from 'version' only if the value specified for
     'version' when the pool was created was 'latest'.
    :vartype exact_version: str
    :ivar shared_gallery_image_id: The shared gallery image unique identifier. This property is
     mutually exclusive with other properties and can be fetched from shared gallery image GET call.
    :vartype shared_gallery_image_id: str
    :ivar community_gallery_image_id: The community gallery image unique identifier. This property
     is mutually exclusive with other properties and can be fetched from community gallery image GET
     call.
    :vartype community_gallery_image_id: str
    """

    publisher: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The publisher of the Azure Virtual Machines Marketplace Image. For example, Canonical or
     MicrosoftWindowsServer."""
    offer: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The offer type of the Azure Virtual Machines Marketplace Image. For example, UbuntuServer or
     WindowsServer."""
    sku: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SKU of the Azure Virtual Machines Marketplace Image. For example, 18.04-LTS or
     2019-Datacenter."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version of the Azure Virtual Machines Marketplace Image. A value of 'latest' can be
     specified to select the latest version of an Image. If omitted, the default is 'latest'."""
    virtual_machine_image_id: Optional[str] = rest_field(
        name="virtualMachineImageId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ARM resource identifier of the Azure Compute Gallery Image. Compute Nodes in the Pool will
     be created using this Image Id. This is of the form
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{VersionId}
     or
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}
     for always defaulting to the latest image version. This property is mutually exclusive with
     other ImageReference properties. The Azure Compute Gallery Image must have replicas in the same
     region and must be in the same subscription as the Azure Batch account. If the image version is
     not specified in the imageId, the latest version will be used. For information about the
     firewall settings for the Batch Compute Node agent to communicate with the Batch service see
     `https://learn.microsoft.com/azure/batch/nodes-and-pools#virtual-network-vnet-and-firewall-configuration
     <https://learn.microsoft.com/azure/batch/nodes-and-pools#virtual-network-vnet-and-firewall-configuration>`_."""
    exact_version: Optional[str] = rest_field(name="exactVersion", visibility=["read"])
    """The specific version of the platform image or marketplace image used to create the node. This
     read-only field differs from 'version' only if the value specified for 'version' when the pool
     was created was 'latest'."""
    shared_gallery_image_id: Optional[str] = rest_field(
        name="sharedGalleryImageId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The shared gallery image unique identifier. This property is mutually exclusive with other
     properties and can be fetched from shared gallery image GET call."""
    community_gallery_image_id: Optional[str] = rest_field(
        name="communityGalleryImageId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The community gallery image unique identifier. This property is mutually exclusive with other
     properties and can be fetched from community gallery image GET call."""

    @overload
    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        virtual_machine_image_id: Optional[str] = None,
        shared_gallery_image_id: Optional[str] = None,
        community_gallery_image_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CifsMountConfiguration(_Model):
    """Information used to connect to a CIFS file system.

    :ivar username: The user to use for authentication against the CIFS file system. Required.
    :vartype username: str
    :ivar source: The URI of the file system to mount. Required.
    :vartype source: str
    :ivar relative_mount_path: The relative path on the compute node where the file system will be
     mounted. All file systems are mounted relative to the Batch mounts directory, accessible via
     the AZ_BATCH_NODE_MOUNTS_DIR environment variable. Required.
    :vartype relative_mount_path: str
    :ivar mount_options: Additional command line options to pass to the mount command. These are
     'net use' options in Windows and 'mount' options in Linux.
    :vartype mount_options: str
    :ivar password: The password to use for authentication against the CIFS file system. Required.
    :vartype password: str
    """

    username: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The user to use for authentication against the CIFS file system. Required."""
    source: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URI of the file system to mount. Required."""
    relative_mount_path: str = rest_field(
        name="relativeMountPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The relative path on the compute node where the file system will be mounted. All file systems
     are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR
     environment variable. Required."""
    mount_options: Optional[str] = rest_field(
        name="mountOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional command line options to pass to the mount command. These are 'net use' options in
     Windows and 'mount' options in Linux."""
    password: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The password to use for authentication against the CIFS file system. Required."""

    @overload
    def __init__(
        self,
        *,
        username: str,
        source: str,
        relative_mount_path: str,
        password: str,
        mount_options: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContainerHostBatchBindMountEntry(_Model):
    """The entry of path and mount mode you want to mount into task container.

    :ivar source: The path which be mounted to container customer can select. Known values are:
     "Shared", "Startup", "VfsMounts", "Task", "JobPrep", and "Applications".
    :vartype source: str or ~azure.batch.models.ContainerHostDataPath
    :ivar is_read_only: Mount this source path as read-only mode or not. Default value is false
     (read/write mode). For Linux, if you mount this path as a read/write mode, this does not mean
     that all users in container have the read/write access for the path, it depends on the access
     in host VM. If this path is mounted read-only, all users within the container will not be able
     to modify the path.
    :vartype is_read_only: bool
    """

    source: Optional[Union[str, "_models.ContainerHostDataPath"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The path which be mounted to container customer can select. Known values are: \"Shared\",
     \"Startup\", \"VfsMounts\", \"Task\", \"JobPrep\", and \"Applications\"."""
    is_read_only: Optional[bool] = rest_field(
        name="isReadOnly", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mount this source path as read-only mode or not. Default value is false (read/write mode). For
     Linux, if you mount this path as a read/write mode, this does not mean that all users in
     container have the read/write access for the path, it depends on the access in host VM. If this
     path is mounted read-only, all users within the container will not be able to modify the path."""

    @overload
    def __init__(
        self,
        *,
        source: Optional[Union[str, "_models.ContainerHostDataPath"]] = None,
        is_read_only: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContainerRegistryReference(_Model):
    """A private container registry.

    :ivar username: The user name to log into the registry server.
    :vartype username: str
    :ivar password: The password to log into the registry server.
    :vartype password: str
    :ivar registry_server: The registry URL. If omitted, the default is "docker.io".
    :vartype registry_server: str
    :ivar identity_reference: The reference to the user assigned identity to use to access an Azure
     Container Registry instead of username and password.
    :vartype identity_reference: ~azure.batch.models.BatchNodeIdentityReference
    """

    username: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The user name to log into the registry server."""
    password: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The password to log into the registry server."""
    registry_server: Optional[str] = rest_field(
        name="registryServer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The registry URL. If omitted, the default is \"docker.io\"."""
    identity_reference: Optional["_models.BatchNodeIdentityReference"] = rest_field(
        name="identityReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference to the user assigned identity to use to access an Azure Container Registry
     instead of username and password."""

    @overload
    def __init__(
        self,
        *,
        username: Optional[str] = None,
        password: Optional[str] = None,
        registry_server: Optional[str] = None,
        identity_reference: Optional["_models.BatchNodeIdentityReference"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DataDisk(_Model):
    """Settings which will be used by the data disks associated to Compute Nodes in
    the Pool. When using attached data disks, you need to mount and format the
    disks from within a VM to use them.

    :ivar logical_unit_number: The logical unit number. The logicalUnitNumber is used to uniquely
     identify each data disk. If attaching multiple disks, each should have a distinct
     logicalUnitNumber. The value must be between 0 and 63, inclusive. Required.
    :vartype logical_unit_number: int
    :ivar caching: The type of caching to be enabled for the data disks. The default value for
     caching is readwrite. For information about the caching options see:
     `https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/
     <https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/>`_.
     Known values are: "none", "readonly", and "readwrite".
    :vartype caching: str or ~azure.batch.models.CachingType
    :ivar disk_size_gb: The initial disk size in gigabytes. Required.
    :vartype disk_size_gb: int
    :ivar managed_disk: The managed disk parameters.
    :vartype managed_disk: ~azure.batch.models.ManagedDisk
    """

    logical_unit_number: int = rest_field(name="lun", visibility=["read", "create", "update", "delete", "query"])
    """The logical unit number. The logicalUnitNumber is used to uniquely identify each data disk. If
     attaching multiple disks, each should have a distinct logicalUnitNumber. The value must be
     between 0 and 63, inclusive. Required."""
    caching: Optional[Union[str, "_models.CachingType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of caching to be enabled for the data disks. The default value for caching is
     readwrite. For information about the caching options see:
     `https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/
     <https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/>`_.
     Known values are: \"none\", \"readonly\", and \"readwrite\"."""
    disk_size_gb: int = rest_field(name="diskSizeGB", visibility=["read", "create", "update", "delete", "query"])
    """The initial disk size in gigabytes. Required."""
    managed_disk: Optional["_models.ManagedDisk"] = rest_field(
        name="managedDisk", visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed disk parameters."""

    @overload
    def __init__(
        self,
        *,
        logical_unit_number: int,
        disk_size_gb: int,
        caching: Optional[Union[str, "_models.CachingType"]] = None,
        managed_disk: Optional["_models.ManagedDisk"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiskCustomerManagedKey(_Model):
    """The Customer Managed Key reference to encrypt the Disk.

    :ivar identity_reference: The reference of one of the pool identities to encrypt Disk. This
     identity will be used to access the KeyVault.
    :vartype identity_reference: ~azure.batch.models.BatchPoolIdentityReference
    :ivar key_url: Fully versioned Key Url pointing to a key in KeyVault. Version segment of the
     Url is required regardless of rotationToLatestKeyVersionEnabled value.
    :vartype key_url: str
    :ivar rotation_to_latest_key_version_enabled: Set this flag to true to enable auto-updating of
     the Disk Encryption to the latest key version. Default is false.
    :vartype rotation_to_latest_key_version_enabled: bool
    """

    identity_reference: Optional["_models.BatchPoolIdentityReference"] = rest_field(
        name="identityReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference of one of the pool identities to encrypt Disk. This identity will be used to
     access the KeyVault."""
    key_url: Optional[str] = rest_field(name="keyUrl", visibility=["read", "create", "update", "delete", "query"])
    """Fully versioned Key Url pointing to a key in KeyVault. Version segment of the Url is required
     regardless of rotationToLatestKeyVersionEnabled value."""
    rotation_to_latest_key_version_enabled: Optional[bool] = rest_field(
        name="rotationToLatestKeyVersionEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Set this flag to true to enable auto-updating of the Disk Encryption to the latest key version.
     Default is false."""

    @overload
    def __init__(
        self,
        *,
        identity_reference: Optional["_models.BatchPoolIdentityReference"] = None,
        key_url: Optional[str] = None,
        rotation_to_latest_key_version_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiskEncryptionConfiguration(_Model):
    """The disk encryption configuration applied on compute nodes in the pool.
    Disk encryption configuration is not supported on Linux pool created with
    Azure Compute Gallery Image.

    :ivar customer_managed_key: The Customer Managed Key reference to encrypt the OS Disk. Customer
     Managed Key will encrypt OS Disk by EncryptionAtRest, and by default we will encrypt the data
     disk as well. It can be used only when the pool is configured with an identity and OsDisk is
     set as one of the targets of DiskEncryption.
    :vartype customer_managed_key: ~azure.batch.models.DiskCustomerManagedKey
    :ivar targets: The list of disk targets Batch Service will encrypt on the compute node. The
     list of disk targets Batch Service will encrypt on the compute node.
    :vartype targets: list[str or ~azure.batch.models.DiskEncryptionTarget]
    """

    customer_managed_key: Optional["_models.DiskCustomerManagedKey"] = rest_field(
        name="customerManagedKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Customer Managed Key reference to encrypt the OS Disk. Customer Managed Key will encrypt OS
     Disk by EncryptionAtRest, and by default we will encrypt the data disk as well. It can be used
     only when the pool is configured with an identity and OsDisk is set as one of the targets of
     DiskEncryption."""
    targets: Optional[list[Union[str, "_models.DiskEncryptionTarget"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of disk targets Batch Service will encrypt on the compute node. The list of disk
     targets Batch Service will encrypt on the compute node."""

    @overload
    def __init__(
        self,
        *,
        customer_managed_key: Optional["_models.DiskCustomerManagedKey"] = None,
        targets: Optional[list[Union[str, "_models.DiskEncryptionTarget"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DiskEncryptionSetParameters(_Model):
    """The ARM resource id of the disk encryption set.

    :ivar id: The ARM resource id of the disk encryption set. The resource must be in the same
     subscription as the Batch account.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ARM resource id of the disk encryption set. The resource must be in the same subscription
     as the Batch account."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnvironmentSetting(_Model):
    """An environment variable to be set on a Task process.

    :ivar name: The name of the environment variable. Required.
    :vartype name: str
    :ivar value: The value of the environment variable.
    :vartype value: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the environment variable. Required."""
    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the environment variable."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExitCodeMapping(_Model):
    """How the Batch service should respond if a Task exits with a particular exit
    code.

    :ivar code: A process exit code. Required.
    :vartype code: int
    :ivar exit_options: How the Batch service should respond if the Task exits with this exit code.
     Required.
    :vartype exit_options: ~azure.batch.models.ExitOptions
    """

    code: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A process exit code. Required."""
    exit_options: "_models.ExitOptions" = rest_field(
        name="exitOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """How the Batch service should respond if the Task exits with this exit code. Required."""

    @overload
    def __init__(
        self,
        *,
        code: int,
        exit_options: "_models.ExitOptions",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExitCodeRangeMapping(_Model):
    """A range of exit codes and how the Batch service should respond to exit codes
    within that range.

    :ivar start: The first exit code in the range. Required.
    :vartype start: int
    :ivar end: The last exit code in the range. Required.
    :vartype end: int
    :ivar exit_options: How the Batch service should respond if the Task exits with an exit code in
     the range start to end (inclusive). Required.
    :vartype exit_options: ~azure.batch.models.ExitOptions
    """

    start: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The first exit code in the range. Required."""
    end: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The last exit code in the range. Required."""
    exit_options: "_models.ExitOptions" = rest_field(
        name="exitOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """How the Batch service should respond if the Task exits with an exit code in the range start to
     end (inclusive). Required."""

    @overload
    def __init__(
        self,
        *,
        start: int,
        end: int,
        exit_options: "_models.ExitOptions",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExitConditions(_Model):
    """Specifies how the Batch service should respond when the Task completes.

    :ivar exit_codes: A list of individual Task exit codes and how the Batch service should respond
     to them.
    :vartype exit_codes: list[~azure.batch.models.ExitCodeMapping]
    :ivar exit_code_ranges: A list of Task exit code ranges and how the Batch service should
     respond to them.
    :vartype exit_code_ranges: list[~azure.batch.models.ExitCodeRangeMapping]
    :ivar pre_processing_error: How the Batch service should respond if the Task fails to start due
     to an error.
    :vartype pre_processing_error: ~azure.batch.models.ExitOptions
    :ivar file_upload_error: How the Batch service should respond if a file upload error occurs. If
     the Task exited with an exit code that was specified via exitCodes or exitCodeRanges, and then
     encountered a file upload error, then the action specified by the exit code takes precedence.
    :vartype file_upload_error: ~azure.batch.models.ExitOptions
    :ivar default: How the Batch service should respond if the Task fails with an exit condition
     not covered by any of the other properties. This value is used if the Task exits with any
     nonzero exit code not listed in the exitCodes or exitCodeRanges collection, with a
     pre-processing error if the preProcessingError property is not present, or with a file upload
     error if the fileUploadError property is not present. If you want non-default behavior on exit
     code 0, you must list it explicitly using the exitCodes or exitCodeRanges collection.
    :vartype default: ~azure.batch.models.ExitOptions
    """

    exit_codes: Optional[list["_models.ExitCodeMapping"]] = rest_field(
        name="exitCodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of individual Task exit codes and how the Batch service should respond to them."""
    exit_code_ranges: Optional[list["_models.ExitCodeRangeMapping"]] = rest_field(
        name="exitCodeRanges", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of Task exit code ranges and how the Batch service should respond to them."""
    pre_processing_error: Optional["_models.ExitOptions"] = rest_field(
        name="preProcessingError", visibility=["read", "create", "update", "delete", "query"]
    )
    """How the Batch service should respond if the Task fails to start due to an error."""
    file_upload_error: Optional["_models.ExitOptions"] = rest_field(
        name="fileUploadError", visibility=["read", "create", "update", "delete", "query"]
    )
    """How the Batch service should respond if a file upload error occurs. If the Task exited with an
     exit code that was specified via exitCodes or exitCodeRanges, and then encountered a file
     upload error, then the action specified by the exit code takes precedence."""
    default: Optional["_models.ExitOptions"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """How the Batch service should respond if the Task fails with an exit condition not covered by
     any of the other properties. This value is used if the Task exits with any nonzero exit code
     not listed in the exitCodes or exitCodeRanges collection, with a pre-processing error if the
     preProcessingError property is not present, or with a file upload error if the fileUploadError
     property is not present. If you want non-default behavior on exit code 0, you must list it
     explicitly using the exitCodes or exitCodeRanges collection."""

    @overload
    def __init__(
        self,
        *,
        exit_codes: Optional[list["_models.ExitCodeMapping"]] = None,
        exit_code_ranges: Optional[list["_models.ExitCodeRangeMapping"]] = None,
        pre_processing_error: Optional["_models.ExitOptions"] = None,
        file_upload_error: Optional["_models.ExitOptions"] = None,
        default: Optional["_models.ExitOptions"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExitOptions(_Model):
    """Specifies how the Batch service responds to a particular exit condition.

    :ivar job_action: An action to take on the Job containing the Task, if the Task completes with
     the given exit condition and the Job's onTaskFailed property is 'performExitOptionsJobAction'.
     The default is none for exit code 0 and terminate for all other exit conditions. If the Job's
     onTaskFailed property is noaction, then specifying this property returns an error and the add
     Task request fails with an invalid property value error; if you are calling the REST API
     directly, the HTTP status code is 400 (Bad Request). Known values are: "none", "disable", and
     "terminate".
    :vartype job_action: str or ~azure.batch.models.BatchJobActionKind
    :ivar dependency_action: An action that the Batch service performs on Tasks that depend on this
     Task. Possible values are 'satisfy' (allowing dependent tasks to progress) and 'block'
     (dependent tasks continue to wait). Batch does not yet support cancellation of dependent tasks.
     Known values are: "satisfy" and "block".
    :vartype dependency_action: str or ~azure.batch.models.DependencyAction
    """

    job_action: Optional[Union[str, "_models.BatchJobActionKind"]] = rest_field(
        name="jobAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """An action to take on the Job containing the Task, if the Task completes with the given exit
     condition and the Job's onTaskFailed property is 'performExitOptionsJobAction'. The default is
     none for exit code 0 and terminate for all other exit conditions. If the Job's onTaskFailed
     property is noaction, then specifying this property returns an error and the add Task request
     fails with an invalid property value error; if you are calling the REST API directly, the HTTP
     status code is 400 (Bad Request). Known values are: \"none\", \"disable\", and \"terminate\"."""
    dependency_action: Optional[Union[str, "_models.DependencyAction"]] = rest_field(
        name="dependencyAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """An action that the Batch service performs on Tasks that depend on this Task. Possible values
     are 'satisfy' (allowing dependent tasks to progress) and 'block' (dependent tasks continue to
     wait). Batch does not yet support cancellation of dependent tasks. Known values are:
     \"satisfy\" and \"block\"."""

    @overload
    def __init__(
        self,
        *,
        job_action: Optional[Union[str, "_models.BatchJobActionKind"]] = None,
        dependency_action: Optional[Union[str, "_models.DependencyAction"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FileProperties(_Model):
    """The properties of a file on a Compute Node.

    :ivar creation_time: The file creation time. The creation time is not returned for files on
     Linux Compute Nodes.
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified: The time at which the file was last modified. Required.
    :vartype last_modified: ~datetime.datetime
    :ivar content_length: The length of the file. Required.
    :vartype content_length: int
    :ivar content_type: The content type of the file.
    :vartype content_type: str
    :ivar file_mode: The file mode attribute in octal format. The file mode is returned only for
     files on Linux Compute Nodes.
    :vartype file_mode: str
    """

    creation_time: Optional[datetime.datetime] = rest_field(
        name="creationTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The file creation time. The creation time is not returned for files on Linux Compute Nodes."""
    last_modified: datetime.datetime = rest_field(
        name="lastModified", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time at which the file was last modified. Required."""
    content_length: int = rest_field(
        name="contentLength", visibility=["read", "create", "update", "delete", "query"], format="str"
    )
    """The length of the file. Required."""
    content_type: Optional[str] = rest_field(
        name="contentType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The content type of the file."""
    file_mode: Optional[str] = rest_field(name="fileMode", visibility=["read", "create", "update", "delete", "query"])
    """The file mode attribute in octal format. The file mode is returned only for files on Linux
     Compute Nodes."""

    @overload
    def __init__(
        self,
        *,
        last_modified: datetime.datetime,
        content_length: int,
        creation_time: Optional[datetime.datetime] = None,
        content_type: Optional[str] = None,
        file_mode: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HostEndpointSettings(_Model):
    """Specifies particular host endpoint settings.

    :ivar in_vm_access_control_profile_reference_id: Specifies the reference to the
     InVMAccessControlProfileVersion resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{profile}/versions/{version}.
    :vartype in_vm_access_control_profile_reference_id: str
    :ivar mode: Specifies the access control policy execution mode. Known values are: "Audit" and
     "Enforce".
    :vartype mode: str or ~azure.batch.models.HostEndpointSettingsModeTypes
    """

    in_vm_access_control_profile_reference_id: Optional[str] = rest_field(
        name="inVMAccessControlProfileReferenceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the reference to the InVMAccessControlProfileVersion resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{profile}/versions/{version}."""
    mode: Optional[Union[str, "_models.HostEndpointSettingsModeTypes"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the access control policy execution mode. Known values are: \"Audit\" and
     \"Enforce\"."""

    @overload
    def __init__(
        self,
        *,
        in_vm_access_control_profile_reference_id: Optional[str] = None,
        mode: Optional[Union[str, "_models.HostEndpointSettingsModeTypes"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InboundEndpoint(_Model):
    """An inbound endpoint on a Compute Node.

    :ivar name: The name of the endpoint. Required.
    :vartype name: str
    :ivar protocol: The protocol of the endpoint. Required. Known values are: "tcp" and "udp".
    :vartype protocol: str or ~azure.batch.models.InboundEndpointProtocol
    :ivar public_ip_address: The public IP address of the Compute Node. Required.
    :vartype public_ip_address: str
    :ivar public_fqdn: The public fully qualified domain name for the Compute Node. Required.
    :vartype public_fqdn: str
    :ivar frontend_port: The public port number of the endpoint. Required.
    :vartype frontend_port: int
    :ivar backend_port: The backend port number of the endpoint. Required.
    :vartype backend_port: int
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the endpoint. Required."""
    protocol: Union[str, "_models.InboundEndpointProtocol"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The protocol of the endpoint. Required. Known values are: \"tcp\" and \"udp\"."""
    public_ip_address: str = rest_field(
        name="publicIPAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """The public IP address of the Compute Node. Required."""
    public_fqdn: str = rest_field(name="publicFQDN", visibility=["read", "create", "update", "delete", "query"])
    """The public fully qualified domain name for the Compute Node. Required."""
    frontend_port: int = rest_field(name="frontendPort", visibility=["read", "create", "update", "delete", "query"])
    """The public port number of the endpoint. Required."""
    backend_port: int = rest_field(name="backendPort", visibility=["read", "create", "update", "delete", "query"])
    """The backend port number of the endpoint. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        protocol: Union[str, "_models.InboundEndpointProtocol"],
        public_ip_address: str,
        public_fqdn: str,
        frontend_port: int,
        backend_port: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InstanceViewStatus(_Model):
    """The instance view status.

    :ivar code: The status code.
    :vartype code: str
    :ivar display_status: The localized label for the status.
    :vartype display_status: str
    :ivar level: Level code. Known values are: "Error", "Info", and "Warning".
    :vartype level: str or ~azure.batch.models.StatusLevelTypes
    :ivar message: The detailed status message.
    :vartype message: str
    :ivar time: The time of the status.
    :vartype time: ~datetime.datetime
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The status code."""
    display_status: Optional[str] = rest_field(
        name="displayStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """The localized label for the status."""
    level: Optional[Union[str, "_models.StatusLevelTypes"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Level code. Known values are: \"Error\", \"Info\", and \"Warning\"."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The detailed status message."""
    time: Optional[datetime.datetime] = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The time of the status."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        display_status: Optional[str] = None,
        level: Optional[Union[str, "_models.StatusLevelTypes"]] = None,
        message: Optional[str] = None,
        time: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IPTag(_Model):
    """Contains the IP tag associated with the public IP address.

    :ivar ip_tag_type: The IP Tag type. Example: FirstPartyUsage.
    :vartype ip_tag_type: str
    :ivar tag: The value of the IP tag associated with the public IP. Example: SQL.
    :vartype tag: str
    """

    ip_tag_type: Optional[str] = rest_field(
        name="ipTagType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The IP Tag type. Example: FirstPartyUsage."""
    tag: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the IP tag associated with the public IP. Example: SQL."""

    @overload
    def __init__(
        self,
        *,
        ip_tag_type: Optional[str] = None,
        tag: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LinuxUserConfiguration(_Model):
    """Properties used to create a user Account on a Linux Compute Node.

    :ivar uid: The user ID of the user Account. The uid and gid properties must be specified
     together or not at all. If not specified the underlying operating system picks the uid.
    :vartype uid: int
    :ivar gid: The group ID for the user Account. The uid and gid properties must be specified
     together or not at all. If not specified the underlying operating system picks the gid.
    :vartype gid: int
    :ivar ssh_private_key: The SSH private key for the user Account. The private key must not be
     password protected. The private key is used to automatically configure asymmetric-key based
     authentication for SSH between Compute Nodes in a Linux Pool when the Pool's
     enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is
     false). It does this by placing the key pair into the user's .ssh directory. If not specified,
     password-less SSH is not configured between Compute Nodes (no modification of the user's .ssh
     directory is done).
    :vartype ssh_private_key: str
    """

    uid: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The user ID of the user Account. The uid and gid properties must be specified together or not
     at all. If not specified the underlying operating system picks the uid."""
    gid: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The group ID for the user Account. The uid and gid properties must be specified together or not
     at all. If not specified the underlying operating system picks the gid."""
    ssh_private_key: Optional[str] = rest_field(
        name="sshPrivateKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """The SSH private key for the user Account. The private key must not be password protected. The
     private key is used to automatically configure asymmetric-key based authentication for SSH
     between Compute Nodes in a Linux Pool when the Pool's enableInterNodeCommunication property is
     true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key
     pair into the user's .ssh directory. If not specified, password-less SSH is not configured
     between Compute Nodes (no modification of the user's .ssh directory is done)."""

    @overload
    def __init__(
        self,
        *,
        uid: Optional[int] = None,
        gid: Optional[int] = None,
        ssh_private_key: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedDisk(_Model):
    """The managed disk parameters.

    :ivar disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed disk. It can be set only in UserSubscription mode.
    :vartype disk_encryption_set: ~azure.batch.models.DiskEncryptionSetParameters
    :ivar storage_account_type: The storage account type for managed disk. Known values are:
     "standard_lrs", "premium_lrs", and "standardssd_lrs".
    :vartype storage_account_type: str or ~azure.batch.models.StorageAccountType
    :ivar security_profile: Specifies the security profile settings for the managed disk.
    :vartype security_profile: ~azure.batch.models.BatchVmDiskSecurityProfile
    """

    disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = rest_field(
        name="diskEncryptionSet", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the customer managed disk encryption set resource id for the managed disk. It can be
     set only in UserSubscription mode."""
    storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = rest_field(
        name="storageAccountType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The storage account type for managed disk. Known values are: \"standard_lrs\", \"premium_lrs\",
     and \"standardssd_lrs\"."""
    security_profile: Optional["_models.BatchVmDiskSecurityProfile"] = rest_field(
        name="securityProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the security profile settings for the managed disk."""

    @overload
    def __init__(
        self,
        *,
        disk_encryption_set: Optional["_models.DiskEncryptionSetParameters"] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        security_profile: Optional["_models.BatchVmDiskSecurityProfile"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MountConfiguration(_Model):
    """The file system to mount on each node.

    :ivar azure_blob_file_system_configuration: The Azure Storage Container to mount using blob
     FUSE on each node. This property is mutually exclusive with all other properties.
    :vartype azure_blob_file_system_configuration:
     ~azure.batch.models.AzureBlobFileSystemConfiguration
    :ivar nfs_mount_configuration: The NFS file system to mount on each node. This property is
     mutually exclusive with all other properties.
    :vartype nfs_mount_configuration: ~azure.batch.models.NfsMountConfiguration
    :ivar cifs_mount_configuration: The CIFS/SMB file system to mount on each node. This property
     is mutually exclusive with all other properties.
    :vartype cifs_mount_configuration: ~azure.batch.models.CifsMountConfiguration
    :ivar azure_file_share_configuration: The Azure File Share to mount on each node. This property
     is mutually exclusive with all other properties.
    :vartype azure_file_share_configuration: ~azure.batch.models.AzureFileShareConfiguration
    """

    azure_blob_file_system_configuration: Optional["_models.AzureBlobFileSystemConfiguration"] = rest_field(
        name="azureBlobFileSystemConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Azure Storage Container to mount using blob FUSE on each node. This property is mutually
     exclusive with all other properties."""
    nfs_mount_configuration: Optional["_models.NfsMountConfiguration"] = rest_field(
        name="nfsMountConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The NFS file system to mount on each node. This property is mutually exclusive with all other
     properties."""
    cifs_mount_configuration: Optional["_models.CifsMountConfiguration"] = rest_field(
        name="cifsMountConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The CIFS/SMB file system to mount on each node. This property is mutually exclusive with all
     other properties."""
    azure_file_share_configuration: Optional["_models.AzureFileShareConfiguration"] = rest_field(
        name="azureFileShareConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Azure File Share to mount on each node. This property is mutually exclusive with all other
     properties."""

    @overload
    def __init__(
        self,
        *,
        azure_blob_file_system_configuration: Optional["_models.AzureBlobFileSystemConfiguration"] = None,
        nfs_mount_configuration: Optional["_models.NfsMountConfiguration"] = None,
        cifs_mount_configuration: Optional["_models.CifsMountConfiguration"] = None,
        azure_file_share_configuration: Optional["_models.AzureFileShareConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MultiInstanceSettings(_Model):
    """Multi-instance Tasks are commonly used to support MPI Tasks. In the MPI case,
    if any of the subtasks fail (for example due to exiting with a non-zero exit
    code) the entire multi-instance Task fails. The multi-instance Task is then
    terminated and retried, up to its retry limit.

    :ivar number_of_instances: The number of Compute Nodes required by the Task. If omitted, the
     default is 1.
    :vartype number_of_instances: int
    :ivar coordination_command_line: The command line to run on all the Compute Nodes to enable
     them to coordinate when the primary runs the main Task command. A typical coordination command
     line launches a background service and verifies that the service is ready to process inter-node
     messages. Required.
    :vartype coordination_command_line: str
    :ivar common_resource_files: A list of files that the Batch service will download before
     running the coordination command line. The difference between common resource files and Task
     resource files is that common resource files are downloaded for all subtasks including the
     primary, whereas Task resource files are downloaded only for the primary. Also note that these
     resource files are not downloaded to the Task working directory, but instead are downloaded to
     the Task root directory (one directory above the working directory).  There is a maximum size
     for the list of resource files.  When the max size is exceeded, the request will fail and the
     response error code will be RequestEntityTooLarge. If this occurs, the collection of
     ResourceFiles must be reduced in size. This can be achieved using .zip files, Application
     Packages, or Docker Containers.
    :vartype common_resource_files: list[~azure.batch.models.ResourceFile]
    """

    number_of_instances: Optional[int] = rest_field(
        name="numberOfInstances", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of Compute Nodes required by the Task. If omitted, the default is 1."""
    coordination_command_line: str = rest_field(
        name="coordinationCommandLine", visibility=["read", "create", "update", "delete", "query"]
    )
    """The command line to run on all the Compute Nodes to enable them to coordinate when the primary
     runs the main Task command. A typical coordination command line launches a background service
     and verifies that the service is ready to process inter-node messages. Required."""
    common_resource_files: Optional[list["_models.ResourceFile"]] = rest_field(
        name="commonResourceFiles", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of files that the Batch service will download before running the coordination command
     line. The difference between common resource files and Task resource files is that common
     resource files are downloaded for all subtasks including the primary, whereas Task resource
     files are downloaded only for the primary. Also note that these resource files are not
     downloaded to the Task working directory, but instead are downloaded to the Task root directory
     (one directory above the working directory).  There is a maximum size for the list of resource
     files.  When the max size is exceeded, the request will fail and the response error code will
     be RequestEntityTooLarge. If this occurs, the collection of ResourceFiles must be reduced in
     size. This can be achieved using .zip files, Application Packages, or Docker Containers."""

    @overload
    def __init__(
        self,
        *,
        coordination_command_line: str,
        number_of_instances: Optional[int] = None,
        common_resource_files: Optional[list["_models.ResourceFile"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NameValuePair(_Model):
    """Represents a name-value pair.

    :ivar name: The name in the name-value pair.
    :vartype name: str
    :ivar value: The value in the name-value pair.
    :vartype value: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name in the name-value pair."""
    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value in the name-value pair."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkConfiguration(_Model):
    """The network configuration for a Pool.

    :ivar subnet_id: The ARM resource identifier of the virtual network subnet which the Compute
     Nodes of the Pool will join. This is of the form
     /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
     The virtual network must be in the same region and subscription as the Azure Batch Account. The
     specified subnet should have enough free IP addresses to accommodate the number of Compute
     Nodes in the Pool. If the subnet doesn't have enough free IP addresses, the Pool will partially
     allocate Nodes and a resize error will occur. The 'MicrosoftAzureBatch' service principal must
     have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the
     specified VNet. The specified subnet must allow communication from the Azure Batch service to
     be able to schedule Tasks on the Nodes. This can be verified by checking if the specified VNet
     has any associated Network Security Groups (NSG). If communication to the Nodes in the
     specified subnet is denied by an NSG, then the Batch service will set the state of the Compute
     Nodes to unusable. Only ARM virtual networks ('Microsoft.Network/virtualNetworks') are
     supported. If the specified VNet has any associated Network Security Groups (NSG), then a few
     reserved system ports must be enabled for inbound communication, including ports 29876 and
     29877. Also enable outbound connections to Azure Storage on port 443. For more details see:
     `https://learn.microsoft.com/azure/batch/nodes-and-pools#virtual-network-vnet-and-firewall-configuration
     <https://learn.microsoft.com/azure/batch/nodes-and-pools#virtual-network-vnet-and-firewall-configuration>`_.
    :vartype subnet_id: str
    :ivar dynamic_vnet_assignment_scope: The scope of dynamic vnet assignment. Known values are:
     "none" and "job".
    :vartype dynamic_vnet_assignment_scope: str or ~azure.batch.models.DynamicVNetAssignmentScope
    :ivar endpoint_configuration: The configuration for endpoints on Compute Nodes in the Batch
     Pool.
    :vartype endpoint_configuration: ~azure.batch.models.BatchPoolEndpointConfiguration
    :ivar public_ip_address_configuration: The Public IPAddress configuration for Compute Nodes in
     the Batch Pool.
    :vartype public_ip_address_configuration: ~azure.batch.models.BatchPublicIpAddressConfiguration
    :ivar enable_accelerated_networking: Whether this pool should enable accelerated networking.
     Accelerated networking enables single root I/O virtualization (SR-IOV) to a VM, which may lead
     to improved networking performance. For more details, see:
     `https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview
     <https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview>`_.
    :vartype enable_accelerated_networking: bool
    """

    subnet_id: Optional[str] = rest_field(name="subnetId", visibility=["read", "create", "update", "delete", "query"])
    """The ARM resource identifier of the virtual network subnet which the Compute Nodes of the Pool
     will join. This is of the form
     /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
     The virtual network must be in the same region and subscription as the Azure Batch Account. The
     specified subnet should have enough free IP addresses to accommodate the number of Compute
     Nodes in the Pool. If the subnet doesn't have enough free IP addresses, the Pool will partially
     allocate Nodes and a resize error will occur. The 'MicrosoftAzureBatch' service principal must
     have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the
     specified VNet. The specified subnet must allow communication from the Azure Batch service to
     be able to schedule Tasks on the Nodes. This can be verified by checking if the specified VNet
     has any associated Network Security Groups (NSG). If communication to the Nodes in the
     specified subnet is denied by an NSG, then the Batch service will set the state of the Compute
     Nodes to unusable. Only ARM virtual networks ('Microsoft.Network/virtualNetworks') are
     supported. If the specified VNet has any associated Network Security Groups (NSG), then a few
     reserved system ports must be enabled for inbound communication, including ports 29876 and
     29877. Also enable outbound connections to Azure Storage on port 443. For more details see:
     `https://learn.microsoft.com/azure/batch/nodes-and-pools#virtual-network-vnet-and-firewall-configuration
     <https://learn.microsoft.com/azure/batch/nodes-and-pools#virtual-network-vnet-and-firewall-configuration>`_."""
    dynamic_vnet_assignment_scope: Optional[Union[str, "_models.DynamicVNetAssignmentScope"]] = rest_field(
        name="dynamicVNetAssignmentScope", visibility=["read", "create", "update", "delete", "query"]
    )
    """The scope of dynamic vnet assignment. Known values are: \"none\" and \"job\"."""
    endpoint_configuration: Optional["_models.BatchPoolEndpointConfiguration"] = rest_field(
        name="endpointConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The configuration for endpoints on Compute Nodes in the Batch Pool."""
    public_ip_address_configuration: Optional["_models.BatchPublicIpAddressConfiguration"] = rest_field(
        name="publicIPAddressConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Public IPAddress configuration for Compute Nodes in the Batch Pool."""
    enable_accelerated_networking: Optional[bool] = rest_field(
        name="enableAcceleratedNetworking", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether this pool should enable accelerated networking. Accelerated networking enables single
     root I/O virtualization (SR-IOV) to a VM, which may lead to improved networking performance.
     For more details, see:
     `https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview
     <https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview>`_."""

    @overload
    def __init__(
        self,
        *,
        subnet_id: Optional[str] = None,
        dynamic_vnet_assignment_scope: Optional[Union[str, "_models.DynamicVNetAssignmentScope"]] = None,
        endpoint_configuration: Optional["_models.BatchPoolEndpointConfiguration"] = None,
        public_ip_address_configuration: Optional["_models.BatchPublicIpAddressConfiguration"] = None,
        enable_accelerated_networking: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NetworkSecurityGroupRule(_Model):
    """A network security group rule to apply to an inbound endpoint.

    :ivar priority: The priority for this rule. Priorities within a Pool must be unique and are
     evaluated in order of priority. The lower the number the higher the priority. For example,
     rules could be specified with order numbers of 150, 250, and 350. The rule with the order
     number of 150 takes precedence over the rule that has an order of 250. Allowed priorities are
     150 to 4096. If any reserved or duplicate values are provided the request fails with HTTP
     status code 400. Required.
    :vartype priority: int
    :ivar access: The action that should be taken for a specified IP address, subnet range or tag.
     Required. Known values are: "allow" and "deny".
    :vartype access: str or ~azure.batch.models.NetworkSecurityGroupRuleAccess
    :ivar source_address_prefix: The source address prefix or tag to match for the rule. Valid
     values are a single IP address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default
     tag, or * (for all addresses).  If any other values are provided the request fails with HTTP
     status code 400. Required.
    :vartype source_address_prefix: str
    :ivar source_port_ranges: The source port ranges to match for the rule. Valid values are '*'
     (for all ports 0 - 65535), a specific port (i.e. 22), or a port range (i.e. 100-200). The ports
     must be in the range of 0 to 65535. Each entry in this collection must not overlap any other
     entry (either a range or an individual port). If any other values are provided the request
     fails with HTTP status code 400. The default value is '*'.
    :vartype source_port_ranges: list[str]
    """

    priority: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The priority for this rule. Priorities within a Pool must be unique and are evaluated in order
     of priority. The lower the number the higher the priority. For example, rules could be
     specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes
     precedence over the rule that has an order of 250. Allowed priorities are 150 to 4096. If any
     reserved or duplicate values are provided the request fails with HTTP status code 400.
     Required."""
    access: Union[str, "_models.NetworkSecurityGroupRuleAccess"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The action that should be taken for a specified IP address, subnet range or tag. Required.
     Known values are: \"allow\" and \"deny\"."""
    source_address_prefix: str = rest_field(
        name="sourceAddressPrefix", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source address prefix or tag to match for the rule. Valid values are a single IP address
     (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If
     any other values are provided the request fails with HTTP status code 400. Required."""
    source_port_ranges: Optional[list[str]] = rest_field(
        name="sourcePortRanges", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source port ranges to match for the rule. Valid values are '*' (for all ports 0 - 65535), a
     specific port (i.e. 22), or a port range (i.e. 100-200). The ports must be in the range of 0 to
     65535. Each entry in this collection must not overlap any other entry (either a range or an
     individual port). If any other values are provided the request fails with HTTP status code 400.
     The default value is '*'."""

    @overload
    def __init__(
        self,
        *,
        priority: int,
        access: Union[str, "_models.NetworkSecurityGroupRuleAccess"],
        source_address_prefix: str,
        source_port_ranges: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NfsMountConfiguration(_Model):
    """Information used to connect to an NFS file system.

    :ivar source: The URI of the file system to mount. Required.
    :vartype source: str
    :ivar relative_mount_path: The relative path on the compute node where the file system will be
     mounted. All file systems are mounted relative to the Batch mounts directory, accessible via
     the AZ_BATCH_NODE_MOUNTS_DIR environment variable. Required.
    :vartype relative_mount_path: str
    :ivar mount_options: Additional command line options to pass to the mount command. These are
     'net use' options in Windows and 'mount' options in Linux.
    :vartype mount_options: str
    """

    source: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URI of the file system to mount. Required."""
    relative_mount_path: str = rest_field(
        name="relativeMountPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The relative path on the compute node where the file system will be mounted. All file systems
     are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR
     environment variable. Required."""
    mount_options: Optional[str] = rest_field(
        name="mountOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional command line options to pass to the mount command. These are 'net use' options in
     Windows and 'mount' options in Linux."""

    @overload
    def __init__(
        self,
        *,
        source: str,
        relative_mount_path: str,
        mount_options: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


# TODO: Open Sphinx issue that needs to be addressed through TypeSpec.
# See: https://github.com/microsoft/typespec/issues/8654
# Revert any changes made here with `*` and `\`.
class OutputFile(_Model):
    """On every file uploads, Batch service writes two log files to the compute node,
    'fileuploadout.txt' and 'fileuploaderr.txt'. These log files are used to learn more about a
    specific failure.

    :ivar file_pattern: A pattern indicating which file(s) to upload. Both relative and absolute
     paths are supported. Relative paths are relative to the Task working directory. The following
     wildcards are supported: * matches 0 or more characters (for example pattern abc* would match
     abc or abcdef), \\*\\* matches any directory, ? matches any single character, [abc] matches one
     character in the brackets, and [a-c] matches one character in the range. Brackets can include a
     negation to match any character not specified (for example [!abc] matches any character but a,
     b, or c). If a file name starts with "." it is ignored by default but may be matched by
     specifying it explicitly (for example *.gif will not match .a.gif, but .*.gif will). A simple
     example: \\*\\*\\\\*.txt matches any file that does not start in '.' and ends with .txt in the Task
     working directory or any subdirectory. If the filename contains a wildcard character it can be
     escaped using brackets (for example abc[*] would match a file named abc*). Note that both \\\\
     and / are treated as directory separators on Windows, but only / is on Linux. Environment
     variables (%var% on Windows or $var on Linux) are expanded prior to the pattern being applied.
     Required.
    :vartype file_pattern: str
    :ivar destination: The destination for the output file(s). Required.
    :vartype destination: ~azure.batch.models.OutputFileDestination
    :ivar upload_options: Additional options for the upload operation, including under what
     conditions to perform the upload. Required.
    :vartype upload_options: ~azure.batch.models.OutputFileUploadConfig
    """

    file_pattern: str = rest_field(name="filePattern", visibility=["read", "create", "update", "delete", "query"])
    """A pattern indicating which file(s) to upload. Both relative and absolute paths are supported.
     Relative paths are relative to the Task working directory. The following wildcards are
     supported: * matches 0 or more characters (for example pattern abc* would match abc or abcdef),
     \\*\\* matches any directory, ? matches any single character, [abc] matches one character in the
     brackets, and [a-c] matches one character in the range. Brackets can include a negation to
     match any character not specified (for example [!abc] matches any character but a, b, or c). If
     a file name starts with \".\" it is ignored by default but may be matched by specifying it
     explicitly (for example *.gif will not match .a.gif, but .*.gif will). A simple example:
     \\*\\*\\\\*.txt matches any file that does not start in '.' and ends with .txt in the Task working
     directory or any subdirectory. If the filename contains a wildcard character it can be escaped
     using brackets (for example abc[*] would match a file named abc*). Note that both \\\\ and / are
     treated as directory separators on Windows, but only / is on Linux. Environment variables
     (%var% on Windows or $var on Linux) are expanded prior to the pattern being applied. Required."""
    destination: "_models.OutputFileDestination" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The destination for the output file(s). Required."""
    upload_options: "_models.OutputFileUploadConfig" = rest_field(
        name="uploadOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional options for the upload operation, including under what conditions to perform the
     upload. Required."""

    @overload
    def __init__(
        self,
        *,
        file_pattern: str,
        destination: "_models.OutputFileDestination",
        upload_options: "_models.OutputFileUploadConfig",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OutputFileBlobContainerDestination(_Model):
    """Specifies a file upload destination within an Azure blob storage container.

    :ivar path: The destination blob or virtual directory within the Azure Storage container. If
     filePattern refers to a specific file (i.e. contains no wildcards), then path is the name of
     the blob to which to upload that file. If filePattern contains one or more wildcards (and
     therefore may match multiple files), then path is the name of the blob virtual directory (which
     is prepended to each blob name) to which to upload the file(s). If omitted, file(s) are
     uploaded to the root of the container with a blob name matching their file name.
    :vartype path: str
    :ivar container_url: The URL of the container within Azure Blob Storage to which to upload the
     file(s). If not using a managed identity, the URL must include a Shared Access Signature (SAS)
     granting write permissions to the container. Required.
    :vartype container_url: str
    :ivar identity_reference: The reference to the user assigned identity to use to access Azure
     Blob Storage specified by containerUrl. The identity must have write access to the Azure Blob
     Storage container.
    :vartype identity_reference: ~azure.batch.models.BatchNodeIdentityReference
    :ivar upload_headers: A list of name-value pairs for headers to be used in uploading output
     files. These headers will be specified when uploading files to Azure Storage. Official document
     on allowed headers when uploading blobs:
     `https://learn.microsoft.com/rest/api/storageservices/put-blob#request-headers-all-blob-types
     <https://learn.microsoft.com/rest/api/storageservices/put-blob#request-headers-all-blob-types>`_.
    :vartype upload_headers: list[~azure.batch.models.OutputFileUploadHeader]
    """

    path: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The destination blob or virtual directory within the Azure Storage container. If filePattern
     refers to a specific file (i.e. contains no wildcards), then path is the name of the blob to
     which to upload that file. If filePattern contains one or more wildcards (and therefore may
     match multiple files), then path is the name of the blob virtual directory (which is prepended
     to each blob name) to which to upload the file(s). If omitted, file(s) are uploaded to the root
     of the container with a blob name matching their file name."""
    container_url: str = rest_field(name="containerUrl", visibility=["read", "create", "update", "delete", "query"])
    """The URL of the container within Azure Blob Storage to which to upload the file(s). If not using
     a managed identity, the URL must include a Shared Access Signature (SAS) granting write
     permissions to the container. Required."""
    identity_reference: Optional["_models.BatchNodeIdentityReference"] = rest_field(
        name="identityReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference to the user assigned identity to use to access Azure Blob Storage specified by
     containerUrl. The identity must have write access to the Azure Blob Storage container."""
    upload_headers: Optional[list["_models.OutputFileUploadHeader"]] = rest_field(
        name="uploadHeaders", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of name-value pairs for headers to be used in uploading output files. These headers will
     be specified when uploading files to Azure Storage. Official document on allowed headers when
     uploading blobs:
     `https://learn.microsoft.com/rest/api/storageservices/put-blob#request-headers-all-blob-types
     <https://learn.microsoft.com/rest/api/storageservices/put-blob#request-headers-all-blob-types>`_."""

    @overload
    def __init__(
        self,
        *,
        container_url: str,
        path: Optional[str] = None,
        identity_reference: Optional["_models.BatchNodeIdentityReference"] = None,
        upload_headers: Optional[list["_models.OutputFileUploadHeader"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OutputFileDestination(_Model):
    """The destination to which a file should be uploaded.

    :ivar container: A location in Azure blob storage to which files are uploaded.
    :vartype container: ~azure.batch.models.OutputFileBlobContainerDestination
    """

    container: Optional["_models.OutputFileBlobContainerDestination"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A location in Azure blob storage to which files are uploaded."""

    @overload
    def __init__(
        self,
        *,
        container: Optional["_models.OutputFileBlobContainerDestination"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OutputFileUploadConfig(_Model):
    """Options for an output file upload operation, including under what conditions
    to perform the upload.

    :ivar upload_condition: The conditions under which the Task output file or set of files should
     be uploaded. The default is taskcompletion. Required. Known values are: "tasksuccess",
     "taskfailure", and "taskcompletion".
    :vartype upload_condition: str or ~azure.batch.models.OutputFileUploadCondition
    """

    upload_condition: Union[str, "_models.OutputFileUploadCondition"] = rest_field(
        name="uploadCondition", visibility=["read", "create", "update", "delete", "query"]
    )
    """The conditions under which the Task output file or set of files should be uploaded. The default
     is taskcompletion. Required. Known values are: \"tasksuccess\", \"taskfailure\", and
     \"taskcompletion\"."""

    @overload
    def __init__(
        self,
        *,
        upload_condition: Union[str, "_models.OutputFileUploadCondition"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OutputFileUploadHeader(_Model):
    """An HTTP header name-value pair.

    :ivar name: The case-insensitive name of the header to be used while uploading output files.
     Required.
    :vartype name: str
    :ivar value: The value of the header to be used while uploading output files.
    :vartype value: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The case-insensitive name of the header to be used while uploading output files. Required."""
    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the header to be used while uploading output files."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        value: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProxyAgentSettings(_Model):
    """Specifies ProxyAgent settings while creating the virtual machine.

    :ivar enabled: Specifies whether Metadata Security Protocol feature should be enabled on the
     virtual machine or virtual machine scale set. Default is False.
    :vartype enabled: bool
    :ivar imds: Settings for the IMDS endpoint.
    :vartype imds: ~azure.batch.models.HostEndpointSettings
    :ivar wire_server: Settings for the WireServer endpoint.
    :vartype wire_server: ~azure.batch.models.HostEndpointSettings
    """

    enabled: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies whether Metadata Security Protocol feature should be enabled on the virtual machine
     or virtual machine scale set. Default is False."""
    imds: Optional["_models.HostEndpointSettings"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Settings for the IMDS endpoint."""
    wire_server: Optional["_models.HostEndpointSettings"] = rest_field(
        name="wireServer", visibility=["read", "create", "update", "delete", "query"]
    )
    """Settings for the WireServer endpoint."""

    @overload
    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        imds: Optional["_models.HostEndpointSettings"] = None,
        wire_server: Optional["_models.HostEndpointSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RecentBatchJob(_Model):
    """Information about the most recent Job to run under the Job Schedule.

    :ivar id: The ID of the Job.
    :vartype id: str
    :ivar url: The URL of the Job.
    :vartype url: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the Job."""
    url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL of the Job."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResizeError(_Model):
    """An error that occurred when resizing a Pool.

    :ivar code: An identifier for the Pool resize error. Codes are invariant and are intended to be
     consumed programmatically.
    :vartype code: str
    :ivar message: A message describing the Pool resize error, intended to be suitable for display
     in a user interface.
    :vartype message: str
    :ivar values_property: A list of additional error details related to the Pool resize error.
    :vartype values_property: list[~azure.batch.models.NameValuePair]
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An identifier for the Pool resize error. Codes are invariant and are intended to be consumed
     programmatically."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A message describing the Pool resize error, intended to be suitable for display in a user
     interface."""
    values_property: Optional[list["_models.NameValuePair"]] = rest_field(
        name="values", visibility=["read", "create", "update", "delete", "query"], original_tsp_name="values"
    )
    """A list of additional error details related to the Pool resize error."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        values_property: Optional[list["_models.NameValuePair"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResourceFile(_Model):
    """A single file or multiple files to be downloaded to a Compute Node.

    :ivar auto_storage_container_name: The storage container name in the auto storage Account. The
     autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and
     one of them must be specified.
    :vartype auto_storage_container_name: str
    :ivar storage_container_url: The URL of the blob container within Azure Blob Storage. The
     autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and
     one of them must be specified. This URL must be readable and listable from compute nodes. There
     are three ways to get such a URL for a container in Azure storage: include a Shared Access
     Signature (SAS) granting read and list permissions on the container, use a managed identity
     with read and list permissions, or set the ACL for the container to allow public access.
    :vartype storage_container_url: str
    :ivar http_url: The URL of the file to download. The autoStorageContainerName,
     storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be
     specified. If the URL points to Azure Blob Storage, it must be readable from compute nodes.
     There are three ways to get such a URL for a blob in Azure storage: include a Shared Access
     Signature (SAS) granting read permissions on the blob, use a managed identity with read
     permission, or set the ACL for the blob or its container to allow public access.
    :vartype http_url: str
    :ivar blob_prefix: The blob prefix to use when downloading blobs from an Azure Storage
     container. Only the blobs whose names begin with the specified prefix will be downloaded. The
     property is valid only when autoStorageContainerName or storageContainerUrl is used. This
     prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files
     in the container will be downloaded.
    :vartype blob_prefix: str
    :ivar file_path: The location on the Compute Node to which to download the file(s), relative to
     the Task's working directory. If the httpUrl property is specified, the filePath is required
     and describes the path which the file will be downloaded to, including the filename. Otherwise,
     if the autoStorageContainerName or storageContainerUrl property is specified, filePath is
     optional and is the directory to download the files to. In the case where filePath is used as a
     directory, any directory structure already associated with the input data will be retained in
     full and appended to the specified filePath directory. The specified relative path cannot break
     out of the Task's working directory (for example by using '..').
    :vartype file_path: str
    :ivar file_mode: The file permission mode attribute in octal format. This property applies only
     to files being downloaded to Linux Compute Nodes. It will be ignored if it is specified for a
     resourceFile which will be downloaded to a Windows Compute Node. If this property is not
     specified for a Linux Compute Node, then a default value of 0770 is applied to the file.
    :vartype file_mode: str
    :ivar identity_reference: The reference to the user assigned identity to use to access Azure
     Blob Storage specified by storageContainerUrl or httpUrl.
    :vartype identity_reference: ~azure.batch.models.BatchNodeIdentityReference
    """

    auto_storage_container_name: Optional[str] = rest_field(
        name="autoStorageContainerName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The storage container name in the auto storage Account. The autoStorageContainerName,
     storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be
     specified."""
    storage_container_url: Optional[str] = rest_field(
        name="storageContainerUrl", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URL of the blob container within Azure Blob Storage. The autoStorageContainerName,
     storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be
     specified. This URL must be readable and listable from compute nodes. There are three ways to
     get such a URL for a container in Azure storage: include a Shared Access Signature (SAS)
     granting read and list permissions on the container, use a managed identity with read and list
     permissions, or set the ACL for the container to allow public access."""
    http_url: Optional[str] = rest_field(name="httpUrl", visibility=["read", "create", "update", "delete", "query"])
    """The URL of the file to download. The autoStorageContainerName, storageContainerUrl and httpUrl
     properties are mutually exclusive and one of them must be specified. If the URL points to Azure
     Blob Storage, it must be readable from compute nodes. There are three ways to get such a URL
     for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions
     on the blob, use a managed identity with read permission, or set the ACL for the blob or its
     container to allow public access."""
    blob_prefix: Optional[str] = rest_field(
        name="blobPrefix", visibility=["read", "create", "update", "delete", "query"]
    )
    """The blob prefix to use when downloading blobs from an Azure Storage container. Only the blobs
     whose names begin with the specified prefix will be downloaded. The property is valid only when
     autoStorageContainerName or storageContainerUrl is used. This prefix can be a partial filename
     or a subdirectory. If a prefix is not specified, all the files in the container will be
     downloaded."""
    file_path: Optional[str] = rest_field(name="filePath", visibility=["read", "create", "update", "delete", "query"])
    """The location on the Compute Node to which to download the file(s), relative to the Task's
     working directory. If the httpUrl property is specified, the filePath is required and describes
     the path which the file will be downloaded to, including the filename. Otherwise, if the
     autoStorageContainerName or storageContainerUrl property is specified, filePath is optional and
     is the directory to download the files to. In the case where filePath is used as a directory,
     any directory structure already associated with the input data will be retained in full and
     appended to the specified filePath directory. The specified relative path cannot break out of
     the Task's working directory (for example by using '..')."""
    file_mode: Optional[str] = rest_field(name="fileMode", visibility=["read", "create", "update", "delete", "query"])
    """The file permission mode attribute in octal format. This property applies only to files being
     downloaded to Linux Compute Nodes. It will be ignored if it is specified for a resourceFile
     which will be downloaded to a Windows Compute Node. If this property is not specified for a
     Linux Compute Node, then a default value of 0770 is applied to the file."""
    identity_reference: Optional["_models.BatchNodeIdentityReference"] = rest_field(
        name="identityReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference to the user assigned identity to use to access Azure Blob Storage specified by
     storageContainerUrl or httpUrl."""

    @overload
    def __init__(
        self,
        *,
        auto_storage_container_name: Optional[str] = None,
        storage_container_url: Optional[str] = None,
        http_url: Optional[str] = None,
        blob_prefix: Optional[str] = None,
        file_path: Optional[str] = None,
        file_mode: Optional[str] = None,
        identity_reference: Optional["_models.BatchNodeIdentityReference"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RollingUpgradePolicy(_Model):
    """The configuration parameters used while performing a rolling upgrade.

    :ivar enable_cross_zone_upgrade: Allow VMSS to ignore AZ boundaries when constructing upgrade
     batches. Take into consideration the Update Domain and maxBatchInstancePercent to determine the
     batch size. This field is able to be set to true or false only when using
     NodePlacementConfiguration as Zonal.
    :vartype enable_cross_zone_upgrade: bool
    :ivar max_batch_instance_percent: The maximum percent of total virtual machine instances that
     will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum,
     unhealthy instances in previous or future batches can cause the percentage of instances in a
     batch to decrease to ensure higher reliability. The value of this field should be between 5 and
     100, inclusive. If both maxBatchInstancePercent and maxUnhealthyInstancePercent are assigned
     with value, the value of maxBatchInstancePercent should not be more than
     maxUnhealthyInstancePercent.
    :vartype max_batch_instance_percent: int
    :ivar max_unhealthy_instance_percent: The maximum percentage of the total virtual machine
     instances in the scale set that can be simultaneously unhealthy, either as a result of being
     upgraded, or by being found in an unhealthy state by the virtual machine health checks before
     the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The
     value of this field should be between 5 and 100, inclusive. If both maxBatchInstancePercent and
     maxUnhealthyInstancePercent are assigned with value, the value of maxBatchInstancePercent
     should not be more than maxUnhealthyInstancePercent.
    :vartype max_unhealthy_instance_percent: int
    :ivar max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual
     machine instances that can be found to be in an unhealthy state. This check will happen after
     each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The
     value of this field should be between 0 and 100, inclusive.
    :vartype max_unhealthy_upgraded_instance_percent: int
    :ivar pause_time_between_batches: The wait time between completing the update for all virtual
     machines in one batch and starting the next batch. The time duration should be specified in ISO
     8601 format..
    :vartype pause_time_between_batches: ~datetime.timedelta
    :ivar prioritize_unhealthy_instances: Upgrade all unhealthy instances in a scale set before any
     healthy instances.
    :vartype prioritize_unhealthy_instances: bool
    :ivar rollback_failed_instances_on_policy_breach: Rollback failed instances to previous model
     if the Rolling Upgrade policy is violated.
    :vartype rollback_failed_instances_on_policy_breach: bool
    """

    enable_cross_zone_upgrade: Optional[bool] = rest_field(
        name="enableCrossZoneUpgrade", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allow VMSS to ignore AZ boundaries when constructing upgrade batches. Take into consideration
     the Update Domain and maxBatchInstancePercent to determine the batch size. This field is able
     to be set to true or false only when using NodePlacementConfiguration as Zonal."""
    max_batch_instance_percent: Optional[int] = rest_field(
        name="maxBatchInstancePercent", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum percent of total virtual machine instances that will be upgraded simultaneously by
     the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or
     future batches can cause the percentage of instances in a batch to decrease to ensure higher
     reliability. The value of this field should be between 5 and 100, inclusive. If both
     maxBatchInstancePercent and maxUnhealthyInstancePercent are assigned with value, the value of
     maxBatchInstancePercent should not be more than maxUnhealthyInstancePercent."""
    max_unhealthy_instance_percent: Optional[int] = rest_field(
        name="maxUnhealthyInstancePercent", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum percentage of the total virtual machine instances in the scale set that can be
     simultaneously unhealthy, either as a result of being upgraded, or by being found in an
     unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This
     constraint will be checked prior to starting any batch. The value of this field should be
     between 5 and 100, inclusive. If both maxBatchInstancePercent and maxUnhealthyInstancePercent
     are assigned with value, the value of maxBatchInstancePercent should not be more than
     maxUnhealthyInstancePercent."""
    max_unhealthy_upgraded_instance_percent: Optional[int] = rest_field(
        name="maxUnhealthyUpgradedInstancePercent", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum percentage of upgraded virtual machine instances that can be found to be in an
     unhealthy state. This check will happen after each batch is upgraded. If this percentage is
     ever exceeded, the rolling update aborts. The value of this field should be between 0 and 100,
     inclusive."""
    pause_time_between_batches: Optional[datetime.timedelta] = rest_field(
        name="pauseTimeBetweenBatches", visibility=["read", "create", "update", "delete", "query"]
    )
    """The wait time between completing the update for all virtual machines in one batch and starting
     the next batch. The time duration should be specified in ISO 8601 format.."""
    prioritize_unhealthy_instances: Optional[bool] = rest_field(
        name="prioritizeUnhealthyInstances", visibility=["read", "create", "update", "delete", "query"]
    )
    """Upgrade all unhealthy instances in a scale set before any healthy instances."""
    rollback_failed_instances_on_policy_breach: Optional[bool] = rest_field(
        name="rollbackFailedInstancesOnPolicyBreach", visibility=["read", "create", "update", "delete", "query"]
    )
    """Rollback failed instances to previous model if the Rolling Upgrade policy is violated."""

    @overload
    def __init__(
        self,
        *,
        enable_cross_zone_upgrade: Optional[bool] = None,
        max_batch_instance_percent: Optional[int] = None,
        max_unhealthy_instance_percent: Optional[int] = None,
        max_unhealthy_upgraded_instance_percent: Optional[int] = None,
        pause_time_between_batches: Optional[datetime.timedelta] = None,
        prioritize_unhealthy_instances: Optional[bool] = None,
        rollback_failed_instances_on_policy_breach: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SecurityProfile(_Model):
    """Specifies the security profile settings for the virtual machine or virtual machine scale set.

    :ivar encryption_at_host: This property can be used by user in the request to enable or disable
     the Host Encryption for the virtual machine or virtual machine scale set. This will enable the
     encryption for all the disks including Resource/Temp disk at host itself. For more information
     on encryption at host requirements, please refer to
     `https://learn.microsoft.com/azure/virtual-machines/disk-encryption#supported-vm-sizes
     <https://learn.microsoft.com/azure/virtual-machines/disk-encryption#supported-vm-sizes>`_.
    :vartype encryption_at_host: bool
    :ivar proxy_agent_settings: Specifies ProxyAgent settings while creating the virtual machine.
    :vartype proxy_agent_settings: ~azure.batch.models.ProxyAgentSettings
    :ivar security_type: Specifies the SecurityType of the virtual machine. It has to be set to any
     specified value to enable UefiSettings. Known values are: "trustedLaunch" and "confidentialvm".
    :vartype security_type: str or ~azure.batch.models.SecurityTypes
    :ivar uefi_settings: Specifies the security settings like secure boot and vTPM used while
     creating the virtual machine. Specifies the security settings like secure boot and vTPM used
     while creating the virtual machine.
    :vartype uefi_settings: ~azure.batch.models.BatchUefiSettings
    """

    encryption_at_host: Optional[bool] = rest_field(
        name="encryptionAtHost", visibility=["read", "create", "update", "delete", "query"]
    )
    """This property can be used by user in the request to enable or disable the Host Encryption for
     the virtual machine or virtual machine scale set. This will enable the encryption for all the
     disks including Resource/Temp disk at host itself. For more information on encryption at host
     requirements, please refer to
     `https://learn.microsoft.com/azure/virtual-machines/disk-encryption#supported-vm-sizes
     <https://learn.microsoft.com/azure/virtual-machines/disk-encryption#supported-vm-sizes>`_."""
    proxy_agent_settings: Optional["_models.ProxyAgentSettings"] = rest_field(
        name="proxyAgentSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies ProxyAgent settings while creating the virtual machine."""
    security_type: Optional[Union[str, "_models.SecurityTypes"]] = rest_field(
        name="securityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the SecurityType of the virtual machine. It has to be set to any specified value to
     enable UefiSettings. Known values are: \"trustedLaunch\" and \"confidentialvm\"."""
    uefi_settings: Optional["_models.BatchUefiSettings"] = rest_field(
        name="uefiSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the security settings like secure boot and vTPM used while creating the virtual
     machine. Specifies the security settings like secure boot and vTPM used while creating the
     virtual machine."""

    @overload
    def __init__(
        self,
        *,
        encryption_at_host: Optional[bool] = None,
        proxy_agent_settings: Optional["_models.ProxyAgentSettings"] = None,
        security_type: Optional[Union[str, "_models.SecurityTypes"]] = None,
        uefi_settings: Optional["_models.BatchUefiSettings"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceArtifactReference(_Model):
    """Specifies the service artifact reference id used to set same image version
    for all virtual machines in the scale set when using 'latest' image version.

    :ivar id: The service artifact reference id of ServiceArtifactReference. The service artifact
     reference id in the form of
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}.
     Required.
    :vartype id: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The service artifact reference id of ServiceArtifactReference. The service artifact reference
     id in the form of
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}.
     Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UpgradePolicy(_Model):
    """Describes an upgrade policy - automatic, manual, or rolling.

    :ivar mode: Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br />
     Possible values are:<br /><br /> **Manual** - You  control the application of updates to
     virtual machines in the scale set. You do this by using the manualUpgrade action.<br /><br />
     **Automatic** - All virtual machines in the scale set are automatically updated at the same
     time.<br /><br /> **Rolling** - Scale set performs updates in batches with an optional pause
     time in between. Required. Known values are: "automatic", "manual", and "rolling".
    :vartype mode: str or ~azure.batch.models.UpgradeMode
    :ivar automatic_os_upgrade_policy: Configuration parameters used for performing automatic OS
     Upgrade. The configuration parameters used for performing automatic OS upgrade.
    :vartype automatic_os_upgrade_policy: ~azure.batch.models.AutomaticOsUpgradePolicy
    :ivar rolling_upgrade_policy: The configuration parameters used while performing a rolling
     upgrade.
    :vartype rolling_upgrade_policy: ~azure.batch.models.RollingUpgradePolicy
    """

    mode: Union[str, "_models.UpgradeMode"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the mode of an upgrade to virtual machines in the scale set.<br /><br /> Possible
     values are:<br /><br /> **Manual** - You  control the application of updates to virtual
     machines in the scale set. You do this by using the manualUpgrade action.<br /><br />
     **Automatic** - All virtual machines in the scale set are automatically updated at the same
     time.<br /><br /> **Rolling** - Scale set performs updates in batches with an optional pause
     time in between. Required. Known values are: \"automatic\", \"manual\", and \"rolling\"."""
    automatic_os_upgrade_policy: Optional["_models.AutomaticOsUpgradePolicy"] = rest_field(
        name="automaticOSUpgradePolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Configuration parameters used for performing automatic OS Upgrade. The configuration parameters
     used for performing automatic OS upgrade."""
    rolling_upgrade_policy: Optional["_models.RollingUpgradePolicy"] = rest_field(
        name="rollingUpgradePolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The configuration parameters used while performing a rolling upgrade."""

    @overload
    def __init__(
        self,
        *,
        mode: Union[str, "_models.UpgradeMode"],
        automatic_os_upgrade_policy: Optional["_models.AutomaticOsUpgradePolicy"] = None,
        rolling_upgrade_policy: Optional["_models.RollingUpgradePolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UploadBatchServiceLogsOptions(_Model):
    """The Azure Batch service log files upload parameters for a Compute Node.

    :ivar container_url: The URL of the container within Azure Blob Storage to which to upload the
     Batch Service log file(s). If a user assigned managed identity is not being used, the URL must
     include a Shared Access Signature (SAS) granting write permissions to the container. The SAS
     duration must allow enough time for the upload to finish. The start time for SAS is optional
     and recommended to not be specified. Required.
    :vartype container_url: str
    :ivar start_time: The start of the time range from which to upload Batch Service log file(s).
     Any log file containing a log message in the time range will be uploaded. This means that the
     operation might retrieve more logs than have been requested since the entire log file is always
     uploaded, but the operation should not retrieve fewer logs than have been requested. Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end of the time range from which to upload Batch Service log file(s). Any
     log file containing a log message in the time range will be uploaded. This means that the
     operation might retrieve more logs than have been requested since the entire log file is always
     uploaded, but the operation should not retrieve fewer logs than have been requested. If
     omitted, the default is to upload all logs available after the startTime.
    :vartype end_time: ~datetime.datetime
    :ivar identity_reference: The reference to the user assigned identity to use to access Azure
     Blob Storage specified by containerUrl. The identity must have write access to the Azure Blob
     Storage container.
    :vartype identity_reference: ~azure.batch.models.BatchNodeIdentityReference
    """

    container_url: str = rest_field(name="containerUrl", visibility=["read", "create", "update", "delete", "query"])
    """The URL of the container within Azure Blob Storage to which to upload the Batch Service log
     file(s). If a user assigned managed identity is not being used, the URL must include a Shared
     Access Signature (SAS) granting write permissions to the container. The SAS duration must allow
     enough time for the upload to finish. The start time for SAS is optional and recommended to not
     be specified. Required."""
    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The start of the time range from which to upload Batch Service log file(s). Any log file
     containing a log message in the time range will be uploaded. This means that the operation
     might retrieve more logs than have been requested since the entire log file is always uploaded,
     but the operation should not retrieve fewer logs than have been requested. Required."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The end of the time range from which to upload Batch Service log file(s). Any log file
     containing a log message in the time range will be uploaded. This means that the operation
     might retrieve more logs than have been requested since the entire log file is always uploaded,
     but the operation should not retrieve fewer logs than have been requested. If omitted, the
     default is to upload all logs available after the startTime."""
    identity_reference: Optional["_models.BatchNodeIdentityReference"] = rest_field(
        name="identityReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference to the user assigned identity to use to access Azure Blob Storage specified by
     containerUrl. The identity must have write access to the Azure Blob Storage container."""

    @overload
    def __init__(
        self,
        *,
        container_url: str,
        start_time: datetime.datetime,
        end_time: Optional[datetime.datetime] = None,
        identity_reference: Optional["_models.BatchNodeIdentityReference"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UploadBatchServiceLogsResult(_Model):
    """The result of uploading Batch service log files from a specific Compute Node.

    :ivar virtual_directory_name: The virtual directory within Azure Blob Storage container to
     which the Batch Service log file(s) will be uploaded. The virtual directory name is part of the
     blob name for each log file uploaded, and it is built based poolId, nodeId and a unique
     identifier. Required.
    :vartype virtual_directory_name: str
    :ivar number_of_files_uploaded: The number of log files which will be uploaded. Required.
    :vartype number_of_files_uploaded: int
    """

    virtual_directory_name: str = rest_field(
        name="virtualDirectoryName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The virtual directory within Azure Blob Storage container to which the Batch Service log
     file(s) will be uploaded. The virtual directory name is part of the blob name for each log file
     uploaded, and it is built based poolId, nodeId and a unique identifier. Required."""
    number_of_files_uploaded: int = rest_field(
        name="numberOfFilesUploaded", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of log files which will be uploaded. Required."""

    @overload
    def __init__(
        self,
        *,
        virtual_directory_name: str,
        number_of_files_uploaded: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAccount(_Model):
    """Properties used to create a user used to execute Tasks on an Azure Batch
    Compute Node.

    :ivar name: The name of the user Account. Names can contain any Unicode characters up to a
     maximum length of 20. Required.
    :vartype name: str
    :ivar password: The password for the user Account. Required.
    :vartype password: str
    :ivar elevation_level: The elevation level of the user Account. The default value is nonAdmin.
     Known values are: "nonadmin" and "admin".
    :vartype elevation_level: str or ~azure.batch.models.ElevationLevel
    :ivar linux_user_configuration: The Linux-specific user configuration for the user Account.
     This property is ignored if specified on a Windows Pool. If not specified, the user is created
     with the default options.
    :vartype linux_user_configuration: ~azure.batch.models.LinuxUserConfiguration
    :ivar windows_user_configuration: The Windows-specific user configuration for the user Account.
     This property can only be specified if the user is on a Windows Pool. If not specified and on a
     Windows Pool, the user is created with the default options.
    :vartype windows_user_configuration: ~azure.batch.models.WindowsUserConfiguration
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the user Account. Names can contain any Unicode characters up to a maximum length
     of 20. Required."""
    password: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The password for the user Account. Required."""
    elevation_level: Optional[Union[str, "_models.ElevationLevel"]] = rest_field(
        name="elevationLevel", visibility=["read", "create", "update", "delete", "query"]
    )
    """The elevation level of the user Account. The default value is nonAdmin. Known values are:
     \"nonadmin\" and \"admin\"."""
    linux_user_configuration: Optional["_models.LinuxUserConfiguration"] = rest_field(
        name="linuxUserConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Linux-specific user configuration for the user Account. This property is ignored if
     specified on a Windows Pool. If not specified, the user is created with the default options."""
    windows_user_configuration: Optional["_models.WindowsUserConfiguration"] = rest_field(
        name="windowsUserConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Windows-specific user configuration for the user Account. This property can only be
     specified if the user is on a Windows Pool. If not specified and on a Windows Pool, the user is
     created with the default options."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        password: str,
        elevation_level: Optional[Union[str, "_models.ElevationLevel"]] = None,
        linux_user_configuration: Optional["_models.LinuxUserConfiguration"] = None,
        windows_user_configuration: Optional["_models.WindowsUserConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserIdentity(_Model):
    """The definition of the user identity under which the Task is run. Specify either the userName or
    autoUser property, but not both.

    :ivar username: The name of the user identity under which the Task is run. The userName and
     autoUser properties are mutually exclusive; you must specify one but not both.
    :vartype username: str
    :ivar auto_user: The auto user under which the Task is run. The userName and autoUser
     properties are mutually exclusive; you must specify one but not both.
    :vartype auto_user: ~azure.batch.models.AutoUserSpecification
    """

    username: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the user identity under which the Task is run. The userName and autoUser properties
     are mutually exclusive; you must specify one but not both."""
    auto_user: Optional["_models.AutoUserSpecification"] = rest_field(
        name="autoUser", visibility=["read", "create", "update", "delete", "query"]
    )
    """The auto user under which the Task is run. The userName and autoUser properties are mutually
     exclusive; you must specify one but not both."""

    @overload
    def __init__(
        self,
        *,
        username: Optional[str] = None,
        auto_user: Optional["_models.AutoUserSpecification"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineConfiguration(_Model):
    """The configuration for Compute Nodes in a Pool based on the Azure Virtual
    Machines infrastructure.

    :ivar image_reference: A reference to the Azure Virtual Machines Marketplace Image or the
     custom Virtual Machine Image to use. Required.
    :vartype image_reference: ~azure.batch.models.BatchVmImageReference
    :ivar node_agent_sku_id: The SKU of the Batch Compute Node agent to be provisioned on Compute
     Nodes in the Pool. The Batch Compute Node agent is a program that runs on each Compute Node in
     the Pool, and provides the command-and-control interface between the Compute Node and the Batch
     service. There are different implementations of the Compute Node agent, known as SKUs, for
     different operating systems. You must specify a Compute Node agent SKU which matches the
     selected Image reference. To get the list of supported Compute Node agent SKUs along with their
     list of verified Image references, see the 'List supported Compute Node agent SKUs' operation.
     Required.
    :vartype node_agent_sku_id: str
    :ivar windows_configuration: Windows operating system settings on the virtual machine. This
     property must not be specified if the imageReference property specifies a Linux OS Image.
    :vartype windows_configuration: ~azure.batch.models.WindowsConfiguration
    :ivar data_disks: The configuration for data disks attached to the Compute Nodes in the Pool.
     This property must be specified if the Compute Nodes in the Pool need to have empty data disks
     attached to them. This cannot be updated. Each Compute Node gets its own disk (the disk is not
     a file share). Existing disks cannot be attached, each attached disk is empty. When the Compute
     Node is removed from the Pool, the disk and all data associated with it is also deleted. The
     disk is not formatted after being attached, it must be formatted before use - for more
     information see
     `https://learn.microsoft.com/azure/virtual-machines/linux/classic/attach-disk#initialize-a-new-data-disk-in-linux
     <https://learn.microsoft.com/azure/virtual-machines/linux/classic/attach-disk#initialize-a-new-data-disk-in-linux>`_
     and
     `https://learn.microsoft.com/azure/virtual-machines/windows/attach-disk-ps#add-an-empty-data-disk-to-a-virtual-machine
     <https://learn.microsoft.com/azure/virtual-machines/windows/attach-disk-ps#add-an-empty-data-disk-to-a-virtual-machine>`_.
    :vartype data_disks: list[~azure.batch.models.DataDisk]
    :ivar license_type: This only applies to Images that contain the Windows operating system, and
     should only be used when you hold valid on-premises licenses for the Compute Nodes which will
     be deployed. If omitted, no on-premises licensing discount is applied. Values are:
     Windows_Server - The on-premises license is for Windows Server.
     Windows_Client - The on-premises license is for Windows Client.
    :vartype license_type: str
    :ivar container_configuration: The container configuration for the Pool. If specified, setup is
     performed on each Compute Node in the Pool to allow Tasks to run in containers. All regular
     Tasks and Job manager Tasks run on this Pool must specify the containerSettings property, and
     all other Tasks may specify it.
    :vartype container_configuration: ~azure.batch.models.BatchContainerConfiguration
    :ivar disk_encryption_configuration: The disk encryption configuration for the pool. If
     specified, encryption is performed on each node in the pool during node provisioning.
    :vartype disk_encryption_configuration: ~azure.batch.models.DiskEncryptionConfiguration
    :ivar node_placement_configuration: The node placement configuration for the pool. This
     configuration will specify rules on how nodes in the pool will be physically allocated.
    :vartype node_placement_configuration: ~azure.batch.models.BatchNodePlacementConfiguration
    :ivar extensions: The virtual machine extension for the pool. If specified, the extensions
     mentioned in this configuration will be installed on each node.
    :vartype extensions: list[~azure.batch.models.VMExtension]
    :ivar os_disk: Settings for the operating system disk of the Virtual Machine.
    :vartype os_disk: ~azure.batch.models.BatchOsDisk
    :ivar security_profile: Specifies the security profile settings for the virtual machine or
     virtual machine scale set.
    :vartype security_profile: ~azure.batch.models.SecurityProfile
    :ivar service_artifact_reference: Specifies the service artifact reference id used to set same
     image version for all virtual machines in the scale set when using 'latest' image version. The
     service artifact reference id in the form of
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}.
    :vartype service_artifact_reference: ~azure.batch.models.ServiceArtifactReference
    """

    image_reference: "_models.BatchVmImageReference" = rest_field(
        name="imageReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """A reference to the Azure Virtual Machines Marketplace Image or the custom Virtual Machine Image
     to use. Required."""
    node_agent_sku_id: str = rest_field(
        name="nodeAgentSKUId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The SKU of the Batch Compute Node agent to be provisioned on Compute Nodes in the Pool. The
     Batch Compute Node agent is a program that runs on each Compute Node in the Pool, and provides
     the command-and-control interface between the Compute Node and the Batch service. There are
     different implementations of the Compute Node agent, known as SKUs, for different operating
     systems. You must specify a Compute Node agent SKU which matches the selected Image reference.
     To get the list of supported Compute Node agent SKUs along with their list of verified Image
     references, see the 'List supported Compute Node agent SKUs' operation. Required."""
    windows_configuration: Optional["_models.WindowsConfiguration"] = rest_field(
        name="windowsConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Windows operating system settings on the virtual machine. This property must not be specified
     if the imageReference property specifies a Linux OS Image."""
    data_disks: Optional[list["_models.DataDisk"]] = rest_field(
        name="dataDisks", visibility=["read", "create", "update", "delete", "query"]
    )
    """The configuration for data disks attached to the Compute Nodes in the Pool. This property must
     be specified if the Compute Nodes in the Pool need to have empty data disks attached to them.
     This cannot be updated. Each Compute Node gets its own disk (the disk is not a file share).
     Existing disks cannot be attached, each attached disk is empty. When the Compute Node is
     removed from the Pool, the disk and all data associated with it is also deleted. The disk is
     not formatted after being attached, it must be formatted before use - for more information see
     `https://learn.microsoft.com/azure/virtual-machines/linux/classic/attach-disk#initialize-a-new-data-disk-in-linux
     <https://learn.microsoft.com/azure/virtual-machines/linux/classic/attach-disk#initialize-a-new-data-disk-in-linux>`_
     and
     `https://learn.microsoft.com/azure/virtual-machines/windows/attach-disk-ps#add-an-empty-data-disk-to-a-virtual-machine
     <https://learn.microsoft.com/azure/virtual-machines/windows/attach-disk-ps#add-an-empty-data-disk-to-a-virtual-machine>`_."""
    license_type: Optional[str] = rest_field(
        name="licenseType", visibility=["read", "create", "update", "delete", "query"]
    )
    """This only applies to Images that contain the Windows operating system, and should only be
     used when you hold valid on-premises licenses for the Compute Nodes which will be deployed. If
     omitted, no on-premises licensing discount is applied. Values are: Windows_Server - The
     on-premises license is for Windows Server. Windows_Client - The on-premises license is for
     Windows Client."""
    container_configuration: Optional["_models.BatchContainerConfiguration"] = rest_field(
        name="containerConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The container configuration for the Pool. If specified, setup is performed on each Compute Node
     in the Pool to allow Tasks to run in containers. All regular Tasks and Job manager Tasks run on
     this Pool must specify the containerSettings property, and all other Tasks may specify it."""
    disk_encryption_configuration: Optional["_models.DiskEncryptionConfiguration"] = rest_field(
        name="diskEncryptionConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The disk encryption configuration for the pool. If specified, encryption is performed on each
     node in the pool during node provisioning."""
    node_placement_configuration: Optional["_models.BatchNodePlacementConfiguration"] = rest_field(
        name="nodePlacementConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The node placement configuration for the pool. This configuration will specify rules on how
     nodes in the pool will be physically allocated."""
    extensions: Optional[list["_models.VMExtension"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The virtual machine extension for the pool. If specified, the extensions mentioned in this
     configuration will be installed on each node."""
    os_disk: Optional["_models.BatchOsDisk"] = rest_field(
        name="osDisk", visibility=["read", "create", "update", "delete", "query"]
    )
    """Settings for the operating system disk of the Virtual Machine."""
    security_profile: Optional["_models.SecurityProfile"] = rest_field(
        name="securityProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the security profile settings for the virtual machine or virtual machine scale set."""
    service_artifact_reference: Optional["_models.ServiceArtifactReference"] = rest_field(
        name="serviceArtifactReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the service artifact reference id used to set same image version for all virtual
     machines in the scale set when using 'latest' image version. The service artifact reference id
     in the form of
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactName}/vmArtifactsProfiles/{vmArtifactsProfilesName}."""

    @overload
    def __init__(
        self,
        *,
        image_reference: "_models.BatchVmImageReference",
        node_agent_sku_id: str,
        windows_configuration: Optional["_models.WindowsConfiguration"] = None,
        data_disks: Optional[list["_models.DataDisk"]] = None,
        license_type: Optional[str] = None,
        container_configuration: Optional["_models.BatchContainerConfiguration"] = None,
        disk_encryption_configuration: Optional["_models.DiskEncryptionConfiguration"] = None,
        node_placement_configuration: Optional["_models.BatchNodePlacementConfiguration"] = None,
        extensions: Optional[list["_models.VMExtension"]] = None,
        os_disk: Optional["_models.BatchOsDisk"] = None,
        security_profile: Optional["_models.SecurityProfile"] = None,
        service_artifact_reference: Optional["_models.ServiceArtifactReference"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInfo(_Model):
    """Info about the current state of the virtual machine.

    :ivar image_reference: The reference to the Azure Virtual Machine's Marketplace Image.
    :vartype image_reference: ~azure.batch.models.BatchVmImageReference
    :ivar scale_set_vm_resource_id: The resource ID of the Compute Node's current Virtual Machine
     Scale Set VM. Only defined if the Batch Account was created with its poolAllocationMode
     property set to 'UserSubscription'.
    :vartype scale_set_vm_resource_id: str
    """

    image_reference: Optional["_models.BatchVmImageReference"] = rest_field(
        name="imageReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference to the Azure Virtual Machine's Marketplace Image."""
    scale_set_vm_resource_id: Optional[str] = rest_field(
        name="scaleSetVmResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource ID of the Compute Node's current Virtual Machine Scale Set VM. Only defined if the
     Batch Account was created with its poolAllocationMode property set to 'UserSubscription'."""

    @overload
    def __init__(
        self,
        *,
        image_reference: Optional["_models.BatchVmImageReference"] = None,
        scale_set_vm_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VMExtension(_Model):
    """The configuration for virtual machine extensions.

    :ivar name: The name of the virtual machine extension. Required.
    :vartype name: str
    :ivar publisher: The name of the extension handler publisher. Required.
    :vartype publisher: str
    :ivar type: The type of the extension. Required.
    :vartype type: str
    :ivar type_handler_version: The version of script handler.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar settings: JSON formatted public settings for the extension.
    :vartype settings: dict[str, str]
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: dict[str, str]
    :ivar provision_after_extensions: The collection of extension names. Collection of extension
     names after which this extension needs to be provisioned.
    :vartype provision_after_extensions: list[str]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the virtual machine extension. Required."""
    publisher: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the extension handler publisher. Required."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of the extension. Required."""
    type_handler_version: Optional[str] = rest_field(
        name="typeHandlerVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The version of script handler."""
    auto_upgrade_minor_version: Optional[bool] = rest_field(
        name="autoUpgradeMinorVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the extension should use a newer minor version if one is available at
     deployment time. Once deployed, however, the extension will not upgrade minor versions unless
     redeployed, even with this property set to true."""
    enable_automatic_upgrade: Optional[bool] = rest_field(
        name="enableAutomaticUpgrade", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the extension should be automatically upgraded by the platform if there is a
     newer version of the extension available."""
    settings: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """JSON formatted public settings for the extension."""
    protected_settings: Optional[dict[str, str]] = rest_field(
        name="protectedSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no
     protected settings at all."""
    provision_after_extensions: Optional[list[str]] = rest_field(
        name="provisionAfterExtensions", visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of extension names. Collection of extension names after which this extension
     needs to be provisioned."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        publisher: str,
        type: str,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[dict[str, str]] = None,
        protected_settings: Optional[dict[str, str]] = None,
        provision_after_extensions: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VMExtensionInstanceView(_Model):
    """The vm extension instance view.

    :ivar name: The name of the vm extension instance view.
    :vartype name: str
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.batch.models.InstanceViewStatus]
    :ivar sub_statuses: The resource status information.
    :vartype sub_statuses: list[~azure.batch.models.InstanceViewStatus]
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the vm extension instance view."""
    statuses: Optional[list["_models.InstanceViewStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource status information."""
    sub_statuses: Optional[list["_models.InstanceViewStatus"]] = rest_field(
        name="subStatuses", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource status information."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        statuses: Optional[list["_models.InstanceViewStatus"]] = None,
        sub_statuses: Optional[list["_models.InstanceViewStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WindowsConfiguration(_Model):
    """Windows operating system settings to apply to the virtual machine.

    :ivar enable_automatic_updates: Whether automatic updates are enabled on the virtual machine.
     If omitted, the default value is true.
    :vartype enable_automatic_updates: bool
    """

    enable_automatic_updates: Optional[bool] = rest_field(
        name="enableAutomaticUpdates", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether automatic updates are enabled on the virtual machine. If omitted, the default value is
     true."""

    @overload
    def __init__(
        self,
        *,
        enable_automatic_updates: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WindowsUserConfiguration(_Model):
    """Properties used to create a user Account on a Windows Compute Node.

    :ivar login_mode: The login mode for the user. The default is 'batch'. Known values are:
     "batch" and "interactive".
    :vartype login_mode: str or ~azure.batch.models.LoginMode
    """

    login_mode: Optional[Union[str, "_models.LoginMode"]] = rest_field(
        name="loginMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The login mode for the user. The default is 'batch'. Known values are: \"batch\" and
     \"interactive\"."""

    @overload
    def __init__(
        self,
        *,
        login_mode: Optional[Union[str, "_models.LoginMode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
