# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class AuthCredentialsKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Types of different kind of Data connector auth credentials supported."""

    O_AUTH_CLIENT_CREDENTIALS = "OAuthClientCredentials"
    """OAuth Client Credential type."""
    API_KEY_AUTH_CREDENTIALS = "ApiKeyAuthCredentials"
    """API Key Auth Credential type."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"
    """System and user assigned managed identity."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the current operation."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    PROVISIONING = "Provisioning"
    """The resource is being provisioned."""
    UPDATING = "Updating"
    """The resource is updating."""
    DELETING = "Deleting"
    """The resource is being deleted."""
    ACCEPTED = "Accepted"
    """The resource create request has been accepted."""


class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This field is required to be implemented by the Resource Provider if the service has more than
    one tier, but is not required on a PUT.
    """

    FREE = "Free"
    """The Free service tier."""
    BASIC = "Basic"
    """The Basic service tier."""
    STANDARD = "Standard"
    """The Standard service tier."""
    PREMIUM = "Premium"
    """The Premium service tier."""
