# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DriveState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The drive's current state."""

    SPECIFIED = "Specified"
    RECEIVED = "Received"
    NEVER_RECEIVED = "NeverReceived"
    TRANSFERRING = "Transferring"
    COMPLETED = "Completed"
    COMPLETED_MORE_INFO = "CompletedMoreInfo"
    SHIPPED_BACK = "ShippedBack"


class EncryptionKekType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of kek encryption key."""

    MICROSOFT_MANAGED = "MicrosoftManaged"
    CUSTOMER_MANAGED = "CustomerManaged"


class IdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity."""

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
