#include <iterator>
#include <memory>
#include <mrpt/hwdrivers/CVelodyneScanner.h>
#include <mrpt/maps/CColouredPointsMap.h>
#include <mrpt/maps/CHeightGridMap2D.h>
#include <mrpt/maps/CRandomFieldGridMap2D.h>
#include <mrpt/typemeta/TEnumType.h>
#include <sstream> // __str__
#include <string>

#include <functional>
#include <pybind11/pybind11.h>
#include <string>
#include <pybind11/stl.h>


#ifndef BINDER_PYBIND11_TYPE_CASTER
	#define BINDER_PYBIND11_TYPE_CASTER
	PYBIND11_DECLARE_HOLDER_TYPE(T, std::shared_ptr<T>)
	PYBIND11_DECLARE_HOLDER_TYPE(T, T*)
	PYBIND11_MAKE_OPAQUE(std::shared_ptr<void>)
#endif

void bind_mrpt_typemeta_TEnumType_3(std::function< pybind11::module &(std::string const &namespace_) > &M)
{
	{ // mrpt::typemeta::internal::bimap file:mrpt/typemeta/TEnumType.h line:22
		pybind11::class_<mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t,std::string>, std::shared_ptr<mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t,std::string>>> cl(M("mrpt::typemeta::internal"), "bimap_mrpt_hwdrivers_CVelodyneScanner_model_t_std_string_t", "");
		cl.def( pybind11::init( [](){ return new mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t,std::string>(); } ) );
		cl.def( pybind11::init( [](mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t,std::string> const &o){ return new mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t,std::string>(o); } ) );
		cl.def_readwrite("m_k2v", &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t,std::string>::m_k2v);
		cl.def_readwrite("m_v2k", &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t,std::string>::m_v2k);
		cl.def("direct", (bool (mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t,std::string>::*)(const enum mrpt::hwdrivers::CVelodyneScanner::model_t &, std::string &) const) &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t, std::string>::direct, "C++: mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t, std::string>::direct(const enum mrpt::hwdrivers::CVelodyneScanner::model_t &, std::string &) const --> bool", pybind11::arg("k"), pybind11::arg("out_v"));
		cl.def("inverse", (bool (mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t,std::string>::*)(const std::string &, enum mrpt::hwdrivers::CVelodyneScanner::model_t &) const) &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t, std::string>::inverse, "C++: mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t, std::string>::inverse(const std::string &, enum mrpt::hwdrivers::CVelodyneScanner::model_t &) const --> bool", pybind11::arg("v"), pybind11::arg("out_k"));
		cl.def("insert", (void (mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t,std::string>::*)(const enum mrpt::hwdrivers::CVelodyneScanner::model_t &, const std::string &)) &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t, std::string>::insert, "C++: mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t, std::string>::insert(const enum mrpt::hwdrivers::CVelodyneScanner::model_t &, const std::string &) --> void", pybind11::arg("k"), pybind11::arg("v"));
		cl.def("assign", (struct mrpt::typemeta::internal::bimap<enum mrpt::hwdrivers::CVelodyneScanner::model_t, std::string > & (mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t,std::string>::*)(const struct mrpt::typemeta::internal::bimap<enum mrpt::hwdrivers::CVelodyneScanner::model_t, std::string > &)) &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t, std::string>::operator=, "C++: mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::model_t, std::string>::operator=(const struct mrpt::typemeta::internal::bimap<enum mrpt::hwdrivers::CVelodyneScanner::model_t, std::string > &) --> struct mrpt::typemeta::internal::bimap<enum mrpt::hwdrivers::CVelodyneScanner::model_t, std::string > &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // mrpt::typemeta::internal::bimap file:mrpt/typemeta/TEnumType.h line:22
		pybind11::class_<mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t,std::string>, std::shared_ptr<mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t,std::string>>> cl(M("mrpt::typemeta::internal"), "bimap_mrpt_hwdrivers_CVelodyneScanner_return_type_t_std_string_t", "");
		cl.def( pybind11::init( [](){ return new mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t,std::string>(); } ) );
		cl.def( pybind11::init( [](mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t,std::string> const &o){ return new mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t,std::string>(o); } ) );
		cl.def_readwrite("m_k2v", &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t,std::string>::m_k2v);
		cl.def_readwrite("m_v2k", &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t,std::string>::m_v2k);
		cl.def("direct", (bool (mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t,std::string>::*)(const enum mrpt::hwdrivers::CVelodyneScanner::return_type_t &, std::string &) const) &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t, std::string>::direct, "C++: mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t, std::string>::direct(const enum mrpt::hwdrivers::CVelodyneScanner::return_type_t &, std::string &) const --> bool", pybind11::arg("k"), pybind11::arg("out_v"));
		cl.def("inverse", (bool (mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t,std::string>::*)(const std::string &, enum mrpt::hwdrivers::CVelodyneScanner::return_type_t &) const) &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t, std::string>::inverse, "C++: mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t, std::string>::inverse(const std::string &, enum mrpt::hwdrivers::CVelodyneScanner::return_type_t &) const --> bool", pybind11::arg("v"), pybind11::arg("out_k"));
		cl.def("insert", (void (mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t,std::string>::*)(const enum mrpt::hwdrivers::CVelodyneScanner::return_type_t &, const std::string &)) &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t, std::string>::insert, "C++: mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t, std::string>::insert(const enum mrpt::hwdrivers::CVelodyneScanner::return_type_t &, const std::string &) --> void", pybind11::arg("k"), pybind11::arg("v"));
		cl.def("assign", (struct mrpt::typemeta::internal::bimap<enum mrpt::hwdrivers::CVelodyneScanner::return_type_t, std::string > & (mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t,std::string>::*)(const struct mrpt::typemeta::internal::bimap<enum mrpt::hwdrivers::CVelodyneScanner::return_type_t, std::string > &)) &mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t, std::string>::operator=, "C++: mrpt::typemeta::internal::bimap<mrpt::hwdrivers::CVelodyneScanner::return_type_t, std::string>::operator=(const struct mrpt::typemeta::internal::bimap<enum mrpt::hwdrivers::CVelodyneScanner::return_type_t, std::string > &) --> struct mrpt::typemeta::internal::bimap<enum mrpt::hwdrivers::CVelodyneScanner::return_type_t, std::string > &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // mrpt::typemeta::internal::bimap file:mrpt/typemeta/TEnumType.h line:22
		pybind11::class_<mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod,std::string>, std::shared_ptr<mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod,std::string>>> cl(M("mrpt::typemeta::internal"), "bimap_mrpt_maps_CColouredPointsMap_TColouringMethod_std_string_t", "");
		cl.def( pybind11::init( [](){ return new mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod,std::string>(); } ) );
		cl.def( pybind11::init( [](mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod,std::string> const &o){ return new mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod,std::string>(o); } ) );
		cl.def_readwrite("m_k2v", &mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod,std::string>::m_k2v);
		cl.def_readwrite("m_v2k", &mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod,std::string>::m_v2k);
		cl.def("direct", (bool (mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod,std::string>::*)(const enum mrpt::maps::CColouredPointsMap::TColouringMethod &, std::string &) const) &mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod, std::string>::direct, "C++: mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod, std::string>::direct(const enum mrpt::maps::CColouredPointsMap::TColouringMethod &, std::string &) const --> bool", pybind11::arg("k"), pybind11::arg("out_v"));
		cl.def("inverse", (bool (mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod,std::string>::*)(const std::string &, enum mrpt::maps::CColouredPointsMap::TColouringMethod &) const) &mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod, std::string>::inverse, "C++: mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod, std::string>::inverse(const std::string &, enum mrpt::maps::CColouredPointsMap::TColouringMethod &) const --> bool", pybind11::arg("v"), pybind11::arg("out_k"));
		cl.def("insert", (void (mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod,std::string>::*)(const enum mrpt::maps::CColouredPointsMap::TColouringMethod &, const std::string &)) &mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod, std::string>::insert, "C++: mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod, std::string>::insert(const enum mrpt::maps::CColouredPointsMap::TColouringMethod &, const std::string &) --> void", pybind11::arg("k"), pybind11::arg("v"));
		cl.def("assign", (struct mrpt::typemeta::internal::bimap<enum mrpt::maps::CColouredPointsMap::TColouringMethod, std::string > & (mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod,std::string>::*)(const struct mrpt::typemeta::internal::bimap<enum mrpt::maps::CColouredPointsMap::TColouringMethod, std::string > &)) &mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod, std::string>::operator=, "C++: mrpt::typemeta::internal::bimap<mrpt::maps::CColouredPointsMap::TColouringMethod, std::string>::operator=(const struct mrpt::typemeta::internal::bimap<enum mrpt::maps::CColouredPointsMap::TColouringMethod, std::string > &) --> struct mrpt::typemeta::internal::bimap<enum mrpt::maps::CColouredPointsMap::TColouringMethod, std::string > &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // mrpt::typemeta::internal::bimap file:mrpt/typemeta/TEnumType.h line:22
		pybind11::class_<mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation,std::string>, std::shared_ptr<mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation,std::string>>> cl(M("mrpt::typemeta::internal"), "bimap_mrpt_maps_CRandomFieldGridMap2D_TMapRepresentation_std_string_t", "");
		cl.def( pybind11::init( [](){ return new mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation,std::string>(); } ) );
		cl.def( pybind11::init( [](mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation,std::string> const &o){ return new mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation,std::string>(o); } ) );
		cl.def_readwrite("m_k2v", &mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation,std::string>::m_k2v);
		cl.def_readwrite("m_v2k", &mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation,std::string>::m_v2k);
		cl.def("direct", (bool (mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation,std::string>::*)(const enum mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation &, std::string &) const) &mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation, std::string>::direct, "C++: mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation, std::string>::direct(const enum mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation &, std::string &) const --> bool", pybind11::arg("k"), pybind11::arg("out_v"));
		cl.def("inverse", (bool (mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation,std::string>::*)(const std::string &, enum mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation &) const) &mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation, std::string>::inverse, "C++: mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation, std::string>::inverse(const std::string &, enum mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation &) const --> bool", pybind11::arg("v"), pybind11::arg("out_k"));
		cl.def("insert", (void (mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation,std::string>::*)(const enum mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation &, const std::string &)) &mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation, std::string>::insert, "C++: mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation, std::string>::insert(const enum mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation &, const std::string &) --> void", pybind11::arg("k"), pybind11::arg("v"));
		cl.def("assign", (struct mrpt::typemeta::internal::bimap<enum mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation, std::string > & (mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation,std::string>::*)(const struct mrpt::typemeta::internal::bimap<enum mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation, std::string > &)) &mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation, std::string>::operator=, "C++: mrpt::typemeta::internal::bimap<mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation, std::string>::operator=(const struct mrpt::typemeta::internal::bimap<enum mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation, std::string > &) --> struct mrpt::typemeta::internal::bimap<enum mrpt::maps::CRandomFieldGridMap2D::TMapRepresentation, std::string > &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // mrpt::typemeta::internal::bimap file:mrpt/typemeta/TEnumType.h line:22
		pybind11::class_<mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation,std::string>, std::shared_ptr<mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation,std::string>>> cl(M("mrpt::typemeta::internal"), "bimap_mrpt_maps_CHeightGridMap2D_TMapRepresentation_std_string_t", "");
		cl.def( pybind11::init( [](){ return new mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation,std::string>(); } ) );
		cl.def( pybind11::init( [](mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation,std::string> const &o){ return new mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation,std::string>(o); } ) );
		cl.def_readwrite("m_k2v", &mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation,std::string>::m_k2v);
		cl.def_readwrite("m_v2k", &mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation,std::string>::m_v2k);
		cl.def("direct", (bool (mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation,std::string>::*)(const enum mrpt::maps::CHeightGridMap2D::TMapRepresentation &, std::string &) const) &mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation, std::string>::direct, "C++: mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation, std::string>::direct(const enum mrpt::maps::CHeightGridMap2D::TMapRepresentation &, std::string &) const --> bool", pybind11::arg("k"), pybind11::arg("out_v"));
		cl.def("inverse", (bool (mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation,std::string>::*)(const std::string &, enum mrpt::maps::CHeightGridMap2D::TMapRepresentation &) const) &mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation, std::string>::inverse, "C++: mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation, std::string>::inverse(const std::string &, enum mrpt::maps::CHeightGridMap2D::TMapRepresentation &) const --> bool", pybind11::arg("v"), pybind11::arg("out_k"));
		cl.def("insert", (void (mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation,std::string>::*)(const enum mrpt::maps::CHeightGridMap2D::TMapRepresentation &, const std::string &)) &mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation, std::string>::insert, "C++: mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation, std::string>::insert(const enum mrpt::maps::CHeightGridMap2D::TMapRepresentation &, const std::string &) --> void", pybind11::arg("k"), pybind11::arg("v"));
		cl.def("assign", (struct mrpt::typemeta::internal::bimap<enum mrpt::maps::CHeightGridMap2D::TMapRepresentation, std::string > & (mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation,std::string>::*)(const struct mrpt::typemeta::internal::bimap<enum mrpt::maps::CHeightGridMap2D::TMapRepresentation, std::string > &)) &mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation, std::string>::operator=, "C++: mrpt::typemeta::internal::bimap<mrpt::maps::CHeightGridMap2D::TMapRepresentation, std::string>::operator=(const struct mrpt::typemeta::internal::bimap<enum mrpt::maps::CHeightGridMap2D::TMapRepresentation, std::string > &) --> struct mrpt::typemeta::internal::bimap<enum mrpt::maps::CHeightGridMap2D::TMapRepresentation, std::string > &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
}
