/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QMainWindow>
#include <QSortFilterProxyModel>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "ui_MassSearchDlg.h"
#include "AbstractSeqEdWndDependentDlg.hpp"
#include "SequenceEditorWnd.hpp"
#include "MassSearchOligomerTableViewModel.hpp"
#include "MassSearchOligomerTableViewSortProxyModel.hpp"


namespace MsXpS
{
namespace MassXpert
{


class MassSearchOligomerTableViewModel;
class MassSearchOligomerTableViewSortProxyModel;

class MassSearchDlg : public AbstractSeqEdWndDependentDlg
{
  Q_OBJECT
  public:
  MassSearchDlg(SequenceEditorWnd *editor_wnd_p,
                libXpertMassCore::PolymerQSPtr polymer_sp,
                /* no libXpertMassCore::PolChemDef **/
                const QString &config_settings_file_path,
                const QString &application_name,
                const QString &description,
                const libXpertMassCore::CalcOptions &calc_options,
                const libXpertMassCore::Ionizer &ionizer_p);

  ~MassSearchDlg();

  bool initialize();

  bool populateSelectedOligomerData();
  bool populateToleranceTypeComboBoxes();
  void setupTableViews();

  void updateIonizationData();
  void updateProgressDetails(libXpertMassCore::Enums::MassType mass_type,
                             bool                     = false,
                             libXpertMassCore::Oligomer * = 0);

  void updateMassSearchDetails(const libXpertMassCore::CalcOptions &);
  void updateOligomerSequence(QString *);

  bool checkTolerance(libXpertMassCore::Enums::MassType mass_type);
  bool calculateTolerance(double, libXpertMassCore::Enums::MassType mass_type);
  bool calculateFilterTolerance(double,
                                libXpertMassCore::Enums::MassType mass_type);

  bool parseMassText(libXpertMassCore::Enums::MassType mass_type);
  bool searchMasses(libXpertMassCore::Enums::MassType mass_type);
  bool searchMass(double value, libXpertMassCore::Enums::MassType mass_type);

  void clearOligomerCollections();
  void emptyAllMassLists();

  bool updateSelectionData(bool = true);

  // The results-exporting functions. ////////////////////////////////
  void prepareResultsTxtString();
  bool exportResultsClipboard();
  bool exportResultsFile();
  bool selectResultsFile();
  //////////////////////////////////// The results-exporting functions.

  public slots:

  void updateWholeSelectedSequenceData();

  void search();
  void abort();

  void exportResults(int);

  // MONO set of filtering widgets
  void monoFilterOptions(bool);
  void monoFilterOptionsToggled();

  void monoFilterSearched();
  void monoFilterError();
  void monoFilterMonoMass();
  void monoFilterAvgMass();

  // AVG set of filtering widgets
  void avgFilterOptions(bool);
  void avgFilterOptionsToggled();

  void avgFilterSearched();
  void avgFilterError();
  void avgFilterMonoMass();
  void avgFilterAvgMass();

  private:
  Ui::MassSearchDlg m_ui;

  // The results-exporting strings. ////////////////////////////////
  QString *mpa_resultsString;
  QString m_resultsFilePath;
  //////////////////////////////////// The results-exporting strings.

  libXpertMassCore::CalcOptions m_calcOptions;
  libXpertMassCore::IndexRange m_searchIndexRange;
  libXpertMassCore::Ionizer m_ionizer;

  double m_monoTolerance = 0;
  double m_avgTolerance  = 0;

  double m_currentMass    = 0;
  int m_foundOligosCount  = 0;
  int m_testedOligosCount = 0;
  int m_progressValue     = 0;

  int m_ionizeStart = 0;
  int m_ionizeStop  = 0;

  bool m_abort;
  bool m_sequenceEmbedded;

  // For the filtering of the data in the treeview.
  QAction *monoFilterAct;
  QAction *avgFilterAct;
  double m_filterTolerance;
  QWidget *mp_monoFocusWidget;
  QWidget *mp_avgFocusWidget;

  QList<double> m_monoMassesList;
  QList<double> m_avgMassesList;

  libXpertMassCore::OligomerCollection m_monoOligomers;
  libXpertMassCore::OligomerCollection m_avgOligomers;

  MassSearchOligomerTableViewModel *mpa_monoOligomerTableViewModel;
  MassSearchOligomerTableViewModel *mpa_avgOligomerTableViewModel;

  MassSearchOligomerTableViewSortProxyModel *mpa_monoProxyModel;
  MassSearchOligomerTableViewSortProxyModel *mpa_avgProxyModel;

  void writeSettings();
  void readSettings();
};


} // namespace MassXpert
} // namespace MsXpS
