/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright 2009--2026 by Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// Qt includes
#include <QObject>
#include <QString>
#include <QDomElement>


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

#include "MsXpS/libXpertMassCore/globals.hpp"
#include "MsXpS/libXpertMassCore/Utils.hpp"

namespace MsXpS
{
namespace libXpertMassCore
{


class PolChemDef;
typedef std::shared_ptr<const PolChemDef> PolChemDefCstSPtr;

//////////////////////// Prop ////////////////////////
//////////////////////// Prop ////////////////////////


class DECLSPEC Prop
{
  public:
  Prop();
  Prop(const QString &name);
  Prop(const Prop &other);

  // Destructor.
  virtual ~Prop();

  void setName(QString &);
  const QString &name();

  void setData(void *data_p);
  virtual void *data() const;
  virtual void deleteData();

  virtual Prop &operator=(const Prop &other);

  virtual Prop *cloneOut() const = 0;

  virtual bool renderXmlElement(const QDomElement &, int = 1);
  virtual QString
  formatXmlElement(int offset,
                   const QString &indent = Utils::xmlIndentationToken);

  protected:
  QString m_name = "NOT_SET";
  void *mpa_data = nullptr;
};

class DECLSPEC StringProp: public Prop
{
  public:
  // Constructors
  StringProp(const QString &name = QString(), const QString &data = QString());
  StringProp(const StringProp &other);

  // Destructor.
  virtual ~StringProp();

  virtual void deleteData();

  using Prop::operator=;
  virtual StringProp &operator=(const StringProp &other);

  virtual StringProp *cloneOut() const;

  virtual bool renderXmlElement(const QDomElement &, int = 1);
  virtual QString
  formatXmlElement(int offset,
                   const QString &indent = Utils::xmlIndentationToken);
};

//////////////////////// IntProp ////////////////////////
//////////////////////// IntProp ////////////////////////

class DECLSPEC IntProp: public Prop
{
  public:
  // constructors
  IntProp(const QString & = QString(), int = 0);
  IntProp(const IntProp &other);

  // Destructor.
  virtual ~IntProp();

  virtual void deleteData();

  using Prop::operator=;
  virtual IntProp &operator=(const IntProp &other);

  virtual IntProp *cloneOut() const;

  virtual bool renderXmlElement(const QDomElement &, int = 1);
  virtual QString
  formatXmlElement(int offset,
                   const QString &indent = Utils::xmlIndentationToken);
};

//////////////////////// DoubleProp ////////////////////////
//////////////////////// DoubleProp ////////////////////////


class DECLSPEC DoubleProp: public Prop
{
  public:
  DoubleProp(const QString & = QString(), double = 0);
  DoubleProp(const DoubleProp &other);

  virtual ~DoubleProp();
  virtual void deleteData();

  using Prop::operator=;
  virtual DoubleProp &operator=(const DoubleProp &other);

  virtual DoubleProp *cloneOut() const;

  virtual bool renderXmlElement(const QDomElement &, int = 1);
  virtual QString
  formatXmlElement(int offset,
                   const QString &indent = Utils::xmlIndentationToken);
};

/////////////////// NoDeletePointerProp ///////////////////
/////////////////// NoDeletePointerProp ///////////////////

class DECLSPEC NoDeletePointerProp: public Prop
{
  public:
  NoDeletePointerProp(const QString & = QString(), void * = 0);
  NoDeletePointerProp(const NoDeletePointerProp &other);

  virtual ~NoDeletePointerProp();
  virtual void deleteData();

  using Prop::operator=;
  virtual NoDeletePointerProp &operator=(const NoDeletePointerProp &other);

  virtual NoDeletePointerProp *cloneOut() const;

  virtual bool renderXmlElement(const QDomElement &, int = 1);
  virtual QString
  formatXmlElement(int offset,
                   const QString &indent = Utils::xmlIndentationToken);
};


} // namespace libXpertMassCore
} // namespace MsXpS
