// Copyright 2021 The PDFium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONSTANTS_APPEARANCE_H_
#define CONSTANTS_APPEARANCE_H_

namespace pdfium {
namespace appearance {

// ISO 32000-1:2008 spec, table 189.
// Entries in an appearance characteristics dictionary.
inline constexpr char kR[] = "R";
inline constexpr char kBC[] = "BC";
inline constexpr char kBG[] = "BG";
inline constexpr char kCA[] = "CA";
inline constexpr char kRC[] = "RC";
inline constexpr char kAC[] = "AC";
inline constexpr char kI[] = "I";
inline constexpr char kRI[] = "RI";
inline constexpr char kIX[] = "IX";

}  // namespace appearance
}  // namespace pdfium

#endif  // CONSTANTS_APPEARANCE_H_
