/* Generated by wayland-scanner 1.23.1 */

#ifndef UKUI_STARTUP_V2_CLIENT_PROTOCOL_H
#define UKUI_STARTUP_V2_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_ukui_startup_v2 The ukui_startup_v2 protocol
 * @section page_ifaces_ukui_startup_v2 Interfaces
 * - @subpage page_iface_ukui_startup_management_v2 - ukui startup info management
 * - @subpage page_iface_ukui_startup_info_v2 - startup info for window
 * @section page_copyright_ukui_startup_v2 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2025 KylinSoft Co., Ltd.
 *
 * SPDX-License-Identifier: MulanPSL-2.0
 * </pre>
 */
struct ukui_startup_info_v2;
struct ukui_startup_management_v2;

#ifndef UKUI_STARTUP_MANAGEMENT_V2_INTERFACE
#define UKUI_STARTUP_MANAGEMENT_V2_INTERFACE
/**
 * @page page_iface_ukui_startup_management_v2 ukui_startup_management_v2
 * @section page_iface_ukui_startup_management_v2_desc Description
 *
 * This interface manages startup infos.
 * @section page_iface_ukui_startup_management_v2_api API
 * See @ref iface_ukui_startup_management_v2.
 */
/**
 * @defgroup iface_ukui_startup_management_v2 The ukui_startup_management_v2 interface
 *
 * This interface manages startup infos.
 */
extern const struct wl_interface ukui_startup_management_v2_interface;
#endif
#ifndef UKUI_STARTUP_INFO_V2_INTERFACE
#define UKUI_STARTUP_INFO_V2_INTERFACE
/**
 * @page page_iface_ukui_startup_info_v2 ukui_startup_info_v2
 * @section page_iface_ukui_startup_info_v2_desc Description
 *
 * The startup_info object provides a way sets the startup geometry of the
 * taskbar/desktop entry for app.
 * The object will auto destroy when arrive the retire time.
 * @section page_iface_ukui_startup_info_v2_api API
 * See @ref iface_ukui_startup_info_v2.
 */
/**
 * @defgroup iface_ukui_startup_info_v2 The ukui_startup_info_v2 interface
 *
 * The startup_info object provides a way sets the startup geometry of the
 * taskbar/desktop entry for app.
 * The object will auto destroy when arrive the retire time.
 */
extern const struct wl_interface ukui_startup_info_v2_interface;
#endif

#define UKUI_STARTUP_MANAGEMENT_V2_DESTROY 0
#define UKUI_STARTUP_MANAGEMENT_V2_CREATE_STARTUP_INFO 1


/**
 * @ingroup iface_ukui_startup_management_v2
 */
#define UKUI_STARTUP_MANAGEMENT_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_startup_management_v2
 */
#define UKUI_STARTUP_MANAGEMENT_V2_CREATE_STARTUP_INFO_SINCE_VERSION 1

/** @ingroup iface_ukui_startup_management_v2 */
static inline void
ukui_startup_management_v2_set_user_data(struct ukui_startup_management_v2 *ukui_startup_management_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ukui_startup_management_v2, user_data);
}

/** @ingroup iface_ukui_startup_management_v2 */
static inline void *
ukui_startup_management_v2_get_user_data(struct ukui_startup_management_v2 *ukui_startup_management_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ukui_startup_management_v2);
}

static inline uint32_t
ukui_startup_management_v2_get_version(struct ukui_startup_management_v2 *ukui_startup_management_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) ukui_startup_management_v2);
}

/**
 * @ingroup iface_ukui_startup_management_v2
 */
static inline void
ukui_startup_management_v2_destroy(struct ukui_startup_management_v2 *ukui_startup_management_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_startup_management_v2,
			 UKUI_STARTUP_MANAGEMENT_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_startup_management_v2), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_ukui_startup_management_v2
 */
static inline struct ukui_startup_info_v2 *
ukui_startup_management_v2_create_startup_info(struct ukui_startup_management_v2 *ukui_startup_management_v2)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) ukui_startup_management_v2,
			 UKUI_STARTUP_MANAGEMENT_V2_CREATE_STARTUP_INFO, &ukui_startup_info_v2_interface, wl_proxy_get_version((struct wl_proxy *) ukui_startup_management_v2), 0, NULL);

	return (struct ukui_startup_info_v2 *) id;
}

#define UKUI_STARTUP_INFO_V2_SET_STARTUP_GEOMETRY 0
#define UKUI_STARTUP_INFO_V2_SET_PID 1
#define UKUI_STARTUP_INFO_V2_SET_APPID 2
#define UKUI_STARTUP_INFO_V2_DESTROY 3


/**
 * @ingroup iface_ukui_startup_info_v2
 */
#define UKUI_STARTUP_INFO_V2_SET_STARTUP_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_startup_info_v2
 */
#define UKUI_STARTUP_INFO_V2_SET_PID_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_startup_info_v2
 */
#define UKUI_STARTUP_INFO_V2_SET_APPID_SINCE_VERSION 1
/**
 * @ingroup iface_ukui_startup_info_v2
 */
#define UKUI_STARTUP_INFO_V2_DESTROY_SINCE_VERSION 1

/** @ingroup iface_ukui_startup_info_v2 */
static inline void
ukui_startup_info_v2_set_user_data(struct ukui_startup_info_v2 *ukui_startup_info_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ukui_startup_info_v2, user_data);
}

/** @ingroup iface_ukui_startup_info_v2 */
static inline void *
ukui_startup_info_v2_get_user_data(struct ukui_startup_info_v2 *ukui_startup_info_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ukui_startup_info_v2);
}

static inline uint32_t
ukui_startup_info_v2_get_version(struct ukui_startup_info_v2 *ukui_startup_info_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) ukui_startup_info_v2);
}

/**
 * @ingroup iface_ukui_startup_info_v2
 *
 * Sets the startup geometry of the taskbar/desktop entry.
 * Coordinates are global.
 */
static inline void
ukui_startup_info_v2_set_startup_geometry(struct ukui_startup_info_v2 *ukui_startup_info_v2, int32_t x, int32_t y, uint32_t width, uint32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_startup_info_v2,
			 UKUI_STARTUP_INFO_V2_SET_STARTUP_GEOMETRY, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_startup_info_v2), 0, x, y, width, height);
}

/**
 * @ingroup iface_ukui_startup_info_v2
 *
 * The pid determines which process will use the startup_geometry.
 * The child process of this process will also use the startup_geometry.
 */
static inline void
ukui_startup_info_v2_set_pid(struct ukui_startup_info_v2 *ukui_startup_info_v2, uint32_t pid)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_startup_info_v2,
			 UKUI_STARTUP_INFO_V2_SET_PID, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_startup_info_v2), 0, pid);
}

/**
 * @ingroup iface_ukui_startup_info_v2
 *
 * The appid determines which app should use the startup_geometry.
 * It only uses when not set pid or not find the app from pid.
 */
static inline void
ukui_startup_info_v2_set_appid(struct ukui_startup_info_v2 *ukui_startup_info_v2, const char *app_id)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_startup_info_v2,
			 UKUI_STARTUP_INFO_V2_SET_APPID, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_startup_info_v2), 0, app_id);
}

/**
 * @ingroup iface_ukui_startup_info_v2
 *
 * Must call destroy after set info completely.
 */
static inline void
ukui_startup_info_v2_destroy(struct ukui_startup_info_v2 *ukui_startup_info_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ukui_startup_info_v2,
			 UKUI_STARTUP_INFO_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ukui_startup_info_v2), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
