#!/bin/bash
set -e

echo "************************************************"
echo " STARTING SCRIPT TO REBUILD iLOREST COMPONENT..."
echo "************************************************"

echo
echo " Expecting to be in ilorest working build directory.  Listing present working direcgtory..."
pwd

echo
echo " Listing original build directory and component generated by DSDK make: build/component dir..."
echo
ls -l build/component
BUILD_NUMBER=88

cd build/component
pwd
COMPONENTFILENAME=$(echo *.zip)
cd ../..

echo "Component FileName is " $COMPONENTFILENAME

pwd

#create working directory for component rebuild
echo "Creating working directory for component rebuild..."
mkdir rebuild
cp build/component/$COMPONENTFILENAME rebuild/.

echo "Go into new working directory..."
cd rebuild
ls -l

echo "Extract contents of original Component file..."
unzip $COMPONENTFILENAME

echo "Deleting unneeded files..."
rm -f $COMPONENTFILENAME index.xml vendor-index.xml

echo "Extracting contents of Component metadata file..."
unzip metadata.zip

echo "Pulling Component bulletin XML file from extracted metadata for later use..."
cd bulletins
BULLETINFILE=$(echo *.xml)
cd ..
echo "Component bulletin xml file is " $BULLETINFILE
cp bulletins/$BULLETINFILE .
ls -l

cd vib20/ilorest
VIBFILENAME=$(echo *.vib)
echo "VIB filename is " $VIBFILENAME
NEW_VIBFILENAME=$(echo "$VIBFILENAME" | sed "s/6\.1\.0\.0/6.1.0.${BUILD_NUMBER}/")
mv "$VIBFILENAME" "$NEW_VIBFILENAME"
echo "Renamed: $VIBFILENAME -> $NEW_VIBFILENAME"
VIBFILENAME=$NEW_VIBFILENAME

cd ../..
mv vib20/ilorest/$VIBFILENAME .
ls -l

echo "Deleting unneeded files and directories..."
rm -rf bulletins/ configSchemas/ metadata.zip vendor-index.xml vmware.xml vibs vib20

ls -l

echo
echo "Extracting contents of VIB file " $VIBFILENAME
/opt/vmware/esxpackagingkit/bin/vibauthor -e -v $VIBFILENAME -f -o .

echo
ls -l
echo

echo "Deleting old VIBFILE...."
rm -f $VIBFILENAME

echo
ls -l
echo


cd payloads/ilorest/opt/ilorest
cd data
TARFILE=$(echo *.tar.gz)
echo "TAR FILE to move from data to bin dir is " $TARFILE
echo
cd ..
echo "Moving tar file from payloads/ilorest/opt/ilorest/data onto payloads/ilorest/opt/ilorest/bin dir..."
mv data/$TARFILE bin/.
echo
echo "Listing files in data..."
ls -l data
echo
echo "Listing files in bin..."
ls -l bin
echo

echo "Extracting contents of tar file in bin dir..."
cd bin
tar xvf $TARFILE
echo
echo "Deleting tarfile..."
rm -f $TARFILE
echo
echo "Listing new contents of bin dir..."
ls -l
echo
cd ../../../../..
echo "Moved back to top rebuild working dir..."
pwd
echo
echo "Listing contents of rebuild working dir..."
ls -l

echo
echo "Listing original contents of descriptor.xml file from original VIB ..."
echo
cat descriptor.xml
echo
echo
echo "Editting descriptor.xml file..."

sed '/bootbank/d' descriptor.xml > descriptor2.xml
rm -f descriptor.xml

sed '/file/d' descriptor2.xml > descriptor.xml
rm -f descriptor2.xml

sed '/checksum/d' descriptor.xml > descriptor2.xml
rm -f descriptor.xml

sed '/payload name/d' descriptor2.xml > descriptor.xml
rm -f descriptor2.xml

#Fix for 80U2 vibauthor.  Leaving ConfigSchema in descriptor XML results in a duplicate entry 
#that causes component build to fail
sed '/ConfigSchema/d' descriptor.xml > descriptor2.xml
rm -f descriptor.xml

mv descriptor2.xml descriptor.xml

sed -i "s#version=\"5.0\"##g" descriptor.xml

sed -i "s#<payloads>#<payloads><payload name=\"ilorest\" type=\"vgz\">#g" descriptor.xml

sed -i "s/6\.0\.0\.0/6.0.0.${BUILD_NUMBER}/g" descriptor.xml

echo
echo "Listing updated contents of descriptor.xml file..."
echo
cat descriptor.xml
echo

echo "Generating new ilorest VIB..."
/opt/vmware/esxpackagingkit/bin/vibauthor -C -t . -v $VIBFILENAME -s -k /opt/vmware/esxpackagingkit/testcerts/accepted.key -r /opt/vmware/esxpackagingkit/testcerts/accepted.cert
echo

echo "Listing contents of current directory..."
ls -l
echo

echo "Creating VIB staging directory..."
mkdir VIB
mv $VIBFILENAME VIB/.

ls -l
ls -l VIB

echo
echo "Querying generated VIB..."
echo
/opt/vmware/esxpackagingkit/bin/vibauthor -i -v VIB/$VIBFILENAME

#echo
#echo "Temporarily skipping Component Build..."
#echo

echo
echo "Generating ilorest COMPONENT..."

sed -i "s/6\.0\.0\.0/6.0.0.${BUILD_NUMBER}/g" $BULLETINFILE

/opt/vmware/esxpackagingkit/bin/partnerDepotAuthor $COMPONENTFILENAME depot create --platformVersion 9.0.0 --vendorName="HPE" --vendorCode="HPE"

/opt/vmware/esxpackagingkit/bin/partnerDepotAuthor $COMPONENTFILENAME component create --componentxml $BULLETINFILE --vibDirectory VIB

echo
echo "Listing contents of  current directory..."
ls -l

echo

echo "************************************************"
echo " COMPLETED REBUILD iLOREST COMPONENT."
echo "************************************************"
echo "Bye!"

