# Changelog

## [1.6.0](https://github.com/KDAB/hotspot/compare/v1.5.1...v1.6.0) (2026-01-28)


### Features

* add support for archives ([f375adf](https://github.com/KDAB/hotspot/commit/f375adff8878e99738f99a01ef212f30cc8d63ef))
* allow handling of compressed perfparser files ([90451a7](https://github.com/KDAB/hotspot/commit/90451a74de3ad58367fa99f21c987177d0fe3aaa))
* allow user to specify perf and objdump via command line ([081812d](https://github.com/KDAB/hotspot/commit/081812dba0470990b3e7d1e5f435459767c8efca)), closes [#556](https://github.com/KDAB/hotspot/issues/556)
* associate application/x-perf-data and application/x-hotspot with hotspot ([8b8677f](https://github.com/KDAB/hotspot/commit/8b8677f9601465fa136c34279a173fb6a2d3fdf8)), closes [#718](https://github.com/KDAB/hotspot/issues/718)
* clarify "Filter In On Thread #%1 By Time" ([91fcdaa](https://github.com/KDAB/hotspot/commit/91fcdaaa6fcadcd7ba7cde37591169463f1d8a33))
* ignore empty command line arguments ([06cfd33](https://github.com/KDAB/hotspot/commit/06cfd336911b0ef8a55aa5faac7df082eb553b7c))
* move compressed test data to files instead of base64 strings ([3e74a87](https://github.com/KDAB/hotspot/commit/3e74a8782a1f8b9b16239b436ea74e18c9cb10b3))
* open more perf files ([b0d370f](https://github.com/KDAB/hotspot/commit/b0d370fa1348edbd0b46a90254f3af6e2f50c72a))
* Parse tracepoint data in hotspot ([1e2ae7b](https://github.com/KDAB/hotspot/commit/1e2ae7b2a212ad14af1a839cceff066c1186d220))
* remove memory leak when calling QLayout::replaceWidget ([0665717](https://github.com/KDAB/hotspot/commit/06657175eaff244d4d7233d2af6ce83557f8544a))
* show current unwind settings in settings dialog ([ec5632c](https://github.com/KDAB/hotspot/commit/ec5632c1090ac6e6ea71cf5325fd1b53feda2d49))
* support regex search ([9da82e4](https://github.com/KDAB/hotspot/commit/9da82e40ef2bba69f49d7df53654373a9cce420a)), closes [#666](https://github.com/KDAB/hotspot/issues/666)
* update icons ([d5d9cd4](https://github.com/KDAB/hotspot/commit/d5d9cd48aabf2cc7ef0e36363d3227f215b164f9)), closes [#472](https://github.com/KDAB/hotspot/issues/472)


### Bug Fixes

* -Wclazy-function-args-by-ref for signals ([e0c12f1](https://github.com/KDAB/hotspot/commit/e0c12f1875de14dbe2404b7c2324780127320145))
* also support ' and , as branch visualization characters ([f326ef0](https://github.com/KDAB/hotspot/commit/f326ef0d2f651d45ceff36050039cbccb2eac6c7))
* also use Qt6 for OpenSuse tumbleweed CI test coverage ([9185eb6](https://github.com/KDAB/hotspot/commit/9185eb649a1f2fabb2c68469dbca6449dbb2d59f))
* Always call QToolTip::showText with a widget ([ab177e0](https://github.com/KDAB/hotspot/commit/ab177e0c7daee2429ea2a32cb8afe7ee253a1f89))
* apply clang-format ([f77545b](https://github.com/KDAB/hotspot/commit/f77545b173c5bfcfa664d8638c8c54ac1d0b14e8))
* apply cmake-format ([222abb3](https://github.com/KDAB/hotspot/commit/222abb36e8770a373f6f0413efb8d903a10d593c))
* avoid OOB access if source code unreadable ([3a9ea36](https://github.com/KDAB/hotspot/commit/3a9ea36453f8e5c920914ea42051d4d33064b6c3))
* broken flamegraph ([c945f43](https://github.com/KDAB/hotspot/commit/c945f431bc80e86dfd333006e664fa1251bd9996)), closes [#624](https://github.com/KDAB/hotspot/issues/624)
* bump perfparser to fix crash on strlen(nullptr) ([9912340](https://github.com/KDAB/hotspot/commit/99123409c7a17afbe2c7a0d95b2d618f0a08a529))
* Bump perfparser to get fixes and silence clang-tidy/clazy CI ([8e468da](https://github.com/KDAB/hotspot/commit/8e468da9f56f1d164ff750d9aaa084a6a2eeb7a9))
* Bump perfparser to properly support COMPRESSED2 data ([b61451d](https://github.com/KDAB/hotspot/commit/b61451d827dd23e35c5f611e3626226a119dfa48))
* bump perfparser with fix for clazy-function-args-by-value ([ef74c0f](https://github.com/KDAB/hotspot/commit/ef74c0fc8c55132948741802d84533cf8d7d0288))
* cast to silence compiler warning for Qt6 without ksyntaxhighlighting ([e906456](https://github.com/KDAB/hotspot/commit/e906456dd72058797a7f726670fe3b3652963410))
* cleanup qcustomplot header to silence clazy warnings ([e27c66c](https://github.com/KDAB/hotspot/commit/e27c66cad874954fdb01a2b02e586ad2a775f1a9))
* clear more members in SourceCodeModel::clear ([ebdeab1](https://github.com/KDAB/hotspot/commit/ebdeab15bd6dc73e1747341b2de1811415bfa396))
* correct cost attribution of inline frames in disassembly view ([36bedef](https://github.com/KDAB/hotspot/commit/36bedef070d5b846d2be416e96a860220904e14a))
* crash if hotspot is closed while loading a file ([221d60e](https://github.com/KDAB/hotspot/commit/221d60e92f3ca2a5fe0530b1ec48b71f86112984)), closes [#654](https://github.com/KDAB/hotspot/issues/654)
* crash when attaching to a running process ([#699](https://github.com/KDAB/hotspot/issues/699)) ([37215fa](https://github.com/KDAB/hotspot/commit/37215fa0a5e69b7d3968feb323749a5fc65c65d5))
* display disassembly correctly on aarch64 ([fcdabab](https://github.com/KDAB/hotspot/commit/fcdabab5166ab26e7b60f2a0ad55cad2e4af1561))
* don't leak memory when extracting archives ([177fecf](https://github.com/KDAB/hotspot/commit/177fecf50da7bb78512cd9ec3b113acad57f56a6))
* don't try to use a cross-architecture objdump on the native architecture ([36309bf](https://github.com/KDAB/hotspot/commit/36309bf69c8f221b14014709efa6b89606ea47aa))
* escape special symbols in node labels of children, too ([71a3ca8](https://github.com/KDAB/hotspot/commit/71a3ca82832719357d720d66ea096f04a5a5d52a))
* formatTimeString ms format ([5cec693](https://github.com/KDAB/hotspot/commit/5cec69301a3f34ada86ce9fe01a9538b04b3cf7c))
* increase test timeout ([9b35d2b](https://github.com/KDAB/hotspot/commit/9b35d2b0fccc4881fe658e56396568628b8cbbd9))
* install test binaries to correct paths ([b57dee1](https://github.com/KDAB/hotspot/commit/b57dee178d53f8eea9acda34b77ff0ed48f1a94f))
* Move objdump setting to disassembly setting page ([2d1d958](https://github.com/KDAB/hotspot/commit/2d1d958996043857909277ef66931122b55277f7))
* Properly include kgraphviewer_interface.h ([0d216a5](https://github.com/KDAB/hotspot/commit/0d216a5b21f3df2380f63d19e5837729ec82ef19))
* read perf command early in tst_perfparser ([80a0884](https://github.com/KDAB/hotspot/commit/80a08841378b12fbafe7a203a11a7ed228f4378c))
* remove --no-buildid-cache arg that was not used in recorded perf file ([3ccedd4](https://github.com/KDAB/hotspot/commit/3ccedd470e0b637c32034386fc3e8877a87970f6))
* Save & restore custom perf.map path in settings ([ea75b0d](https://github.com/KDAB/hotspot/commit/ea75b0d03e3c988781dbbe645e988afcf4c27e59))
* set buddies and add missin colon in disassembly settings ([112aef3](https://github.com/KDAB/hotspot/commit/112aef32f86ae57eaafb0d06b1d7e19d286da56e))
* stabilize formatted time in timeline tooltips ([13565d5](https://github.com/KDAB/hotspot/commit/13565d5e9fc63f455ab8edffc685ff609acfe700))
* support special characters in callgraph ([fd9f7d1](https://github.com/KDAB/hotspot/commit/fd9f7d10cd00832f2212b36f07da1752cbe550d5)), closes [#691](https://github.com/KDAB/hotspot/issues/691)
* unbreak git in github actions ([5b47207](https://github.com/KDAB/hotspot/commit/5b47207b702f0aad46c1ca1eb6ec12ad123d86d5))
* unbreak inlining tst_perfparser tests ([697d846](https://github.com/KDAB/hotspot/commit/697d846c1ee23c13cf3f75500b6e8a2501725ff0))
* Update archlinux CI to use Qt6 ([922c5df](https://github.com/KDAB/hotspot/commit/922c5df6f2f444a5b326946b8491bcf69e55cece))
* update test.sh and push.sh with new container names ([e68038b](https://github.com/KDAB/hotspot/commit/e68038bc5d734b50d98db13295c4a7dd877bb16f))
* update to CI to fedora42 and use Qt6 ([e317188](https://github.com/KDAB/hotspot/commit/e31718820146ebfaf6f91090d03e8df69cb67d63))
* use new-style ENV A=B in docker file ([6ed6e87](https://github.com/KDAB/hotspot/commit/6ed6e8707bb825a54ec310061f731fbb09559f08))
