// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1beta/engine.proto

package discoveryenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Metadata that describes the training and serving parameters of an
// [Engine][google.cloud.discoveryengine.v1beta.Engine].
type Engine struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Additional config specs that defines the behavior of the engine.
	//
	// Types that are assignable to EngineConfig:
	//
	//	*Engine_ChatEngineConfig_
	//	*Engine_SearchEngineConfig_
	EngineConfig isEngine_EngineConfig `protobuf_oneof:"engine_config"`
	// Engine metadata to monitor the status of the engine.
	//
	// Types that are assignable to EngineMetadata:
	//
	//	*Engine_ChatEngineMetadata_
	EngineMetadata isEngine_EngineMetadata `protobuf_oneof:"engine_metadata"`
	// Immutable. The fully qualified resource name of the engine.
	//
	// This field must be a UTF-8 encoded string with a length limit of 1024
	// characters.
	//
	// Format:
	// `projects/{project_number}/locations/{location}/collections/{collection}/engines/{engine}`
	// engine should be 1-63 characters, and valid characters are
	// /[a-z0-9][a-z0-9-_]*/. Otherwise, an INVALID_ARGUMENT error is returned.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the engine. Should be human readable. UTF-8
	// encoded string with limit of 1024 characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Timestamp the Recommendation Engine was created at.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp the Recommendation Engine was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The data stores associated with this engine.
	//
	// For
	// [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH]
	// and
	// [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
	// type of engines, they can only associate with at most one data store.
	//
	// If
	// [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
	// is
	// [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT],
	// multiple [DataStore][google.cloud.discoveryengine.v1beta.DataStore]s in the
	// same [Collection][google.cloud.discoveryengine.v1beta.Collection] can be
	// associated here.
	//
	// Note that when used in
	// [CreateEngineRequest][google.cloud.discoveryengine.v1beta.CreateEngineRequest],
	// one DataStore id must be provided as the system will use it for necessary
	// initializations.
	DataStoreIds []string `protobuf:"bytes,5,rep,name=data_store_ids,json=dataStoreIds,proto3" json:"data_store_ids,omitempty"`
	// Required. The solutions of the engine.
	SolutionType SolutionType `protobuf:"varint,6,opt,name=solution_type,json=solutionType,proto3,enum=google.cloud.discoveryengine.v1beta.SolutionType" json:"solution_type,omitempty"`
	// The industry vertical that the engine registers.
	// The restriction of the Engine industry vertical is based on
	// [DataStore][google.cloud.discoveryengine.v1beta.DataStore]: If unspecified,
	// default to `GENERIC`. Vertical on Engine has to match vertical of the
	// DataStore linked to the engine.
	IndustryVertical IndustryVertical `protobuf:"varint,16,opt,name=industry_vertical,json=industryVertical,proto3,enum=google.cloud.discoveryengine.v1beta.IndustryVertical" json:"industry_vertical,omitempty"`
	// Common config spec that specifies the metadata of the engine.
	CommonConfig *Engine_CommonConfig `protobuf:"bytes,15,opt,name=common_config,json=commonConfig,proto3" json:"common_config,omitempty"`
}

func (x *Engine) Reset() {
	*x = Engine{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Engine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Engine) ProtoMessage() {}

func (x *Engine) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Engine.ProtoReflect.Descriptor instead.
func (*Engine) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_engine_proto_rawDescGZIP(), []int{0}
}

func (m *Engine) GetEngineConfig() isEngine_EngineConfig {
	if m != nil {
		return m.EngineConfig
	}
	return nil
}

func (x *Engine) GetChatEngineConfig() *Engine_ChatEngineConfig {
	if x, ok := x.GetEngineConfig().(*Engine_ChatEngineConfig_); ok {
		return x.ChatEngineConfig
	}
	return nil
}

func (x *Engine) GetSearchEngineConfig() *Engine_SearchEngineConfig {
	if x, ok := x.GetEngineConfig().(*Engine_SearchEngineConfig_); ok {
		return x.SearchEngineConfig
	}
	return nil
}

func (m *Engine) GetEngineMetadata() isEngine_EngineMetadata {
	if m != nil {
		return m.EngineMetadata
	}
	return nil
}

func (x *Engine) GetChatEngineMetadata() *Engine_ChatEngineMetadata {
	if x, ok := x.GetEngineMetadata().(*Engine_ChatEngineMetadata_); ok {
		return x.ChatEngineMetadata
	}
	return nil
}

func (x *Engine) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Engine) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Engine) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Engine) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Engine) GetDataStoreIds() []string {
	if x != nil {
		return x.DataStoreIds
	}
	return nil
}

func (x *Engine) GetSolutionType() SolutionType {
	if x != nil {
		return x.SolutionType
	}
	return SolutionType_SOLUTION_TYPE_UNSPECIFIED
}

func (x *Engine) GetIndustryVertical() IndustryVertical {
	if x != nil {
		return x.IndustryVertical
	}
	return IndustryVertical_INDUSTRY_VERTICAL_UNSPECIFIED
}

func (x *Engine) GetCommonConfig() *Engine_CommonConfig {
	if x != nil {
		return x.CommonConfig
	}
	return nil
}

type isEngine_EngineConfig interface {
	isEngine_EngineConfig()
}

type Engine_ChatEngineConfig_ struct {
	// Configurations for the Chat Engine. Only applicable if
	// [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
	// is
	// [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
	ChatEngineConfig *Engine_ChatEngineConfig `protobuf:"bytes,11,opt,name=chat_engine_config,json=chatEngineConfig,proto3,oneof"`
}

type Engine_SearchEngineConfig_ struct {
	// Configurations for the Search Engine. Only applicable if
	// [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
	// is
	// [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_SEARCH].
	SearchEngineConfig *Engine_SearchEngineConfig `protobuf:"bytes,13,opt,name=search_engine_config,json=searchEngineConfig,proto3,oneof"`
}

func (*Engine_ChatEngineConfig_) isEngine_EngineConfig() {}

func (*Engine_SearchEngineConfig_) isEngine_EngineConfig() {}

type isEngine_EngineMetadata interface {
	isEngine_EngineMetadata()
}

type Engine_ChatEngineMetadata_ struct {
	// Output only. Additional information of the Chat Engine. Only applicable
	// if
	// [solution_type][google.cloud.discoveryengine.v1beta.Engine.solution_type]
	// is
	// [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1beta.SolutionType.SOLUTION_TYPE_CHAT].
	ChatEngineMetadata *Engine_ChatEngineMetadata `protobuf:"bytes,12,opt,name=chat_engine_metadata,json=chatEngineMetadata,proto3,oneof"`
}

func (*Engine_ChatEngineMetadata_) isEngine_EngineMetadata() {}

// Configurations for a Search Engine.
type Engine_SearchEngineConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The search feature tier of this engine.
	//
	// Different tiers might have different
	// pricing. To learn more, check the pricing documentation.
	//
	// Defaults to
	// [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1beta.SearchTier.SEARCH_TIER_STANDARD]
	// if not specified.
	SearchTier SearchTier `protobuf:"varint,1,opt,name=search_tier,json=searchTier,proto3,enum=google.cloud.discoveryengine.v1beta.SearchTier" json:"search_tier,omitempty"`
	// The add-on that this search engine enables.
	SearchAddOns []SearchAddOn `protobuf:"varint,2,rep,packed,name=search_add_ons,json=searchAddOns,proto3,enum=google.cloud.discoveryengine.v1beta.SearchAddOn" json:"search_add_ons,omitempty"`
}

func (x *Engine_SearchEngineConfig) Reset() {
	*x = Engine_SearchEngineConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Engine_SearchEngineConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Engine_SearchEngineConfig) ProtoMessage() {}

func (x *Engine_SearchEngineConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Engine_SearchEngineConfig.ProtoReflect.Descriptor instead.
func (*Engine_SearchEngineConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_engine_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Engine_SearchEngineConfig) GetSearchTier() SearchTier {
	if x != nil {
		return x.SearchTier
	}
	return SearchTier_SEARCH_TIER_UNSPECIFIED
}

func (x *Engine_SearchEngineConfig) GetSearchAddOns() []SearchAddOn {
	if x != nil {
		return x.SearchAddOns
	}
	return nil
}

// Configurations for a Chat Engine.
type Engine_ChatEngineConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configurationt generate the Dialogflow agent that is associated to
	// this Engine.
	//
	// Note that these configurations are one-time consumed by
	// and passed to Dialogflow service. It means they cannot be retrieved using
	// [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
	// or
	// [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
	// API after engine creation.
	AgentCreationConfig *Engine_ChatEngineConfig_AgentCreationConfig `protobuf:"bytes,1,opt,name=agent_creation_config,json=agentCreationConfig,proto3" json:"agent_creation_config,omitempty"`
	// The resource name of an exist Dialogflow agent to link to this Chat
	// Engine. Customers can either provide `agent_creation_config` to create
	// agent or provide an agent name that links the agent with the Chat engine.
	//
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>`.
	//
	// Note that the `dialogflow_agent_to_link` are one-time consumed by and
	// passed to Dialogflow service. It means they cannot be retrieved using
	// [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
	// or
	// [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
	// API after engine creation. Use
	// [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata.dialogflow_agent]
	// for actual agent association after Engine is created.
	DialogflowAgentToLink string `protobuf:"bytes,2,opt,name=dialogflow_agent_to_link,json=dialogflowAgentToLink,proto3" json:"dialogflow_agent_to_link,omitempty"`
}

func (x *Engine_ChatEngineConfig) Reset() {
	*x = Engine_ChatEngineConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Engine_ChatEngineConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Engine_ChatEngineConfig) ProtoMessage() {}

func (x *Engine_ChatEngineConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Engine_ChatEngineConfig.ProtoReflect.Descriptor instead.
func (*Engine_ChatEngineConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_engine_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Engine_ChatEngineConfig) GetAgentCreationConfig() *Engine_ChatEngineConfig_AgentCreationConfig {
	if x != nil {
		return x.AgentCreationConfig
	}
	return nil
}

func (x *Engine_ChatEngineConfig) GetDialogflowAgentToLink() string {
	if x != nil {
		return x.DialogflowAgentToLink
	}
	return ""
}

// Common configurations for an Engine.
type Engine_CommonConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the company, business or entity that is associated with the
	// engine. Setting this may help improve LLM related features.
	CompanyName string `protobuf:"bytes,1,opt,name=company_name,json=companyName,proto3" json:"company_name,omitempty"`
}

func (x *Engine_CommonConfig) Reset() {
	*x = Engine_CommonConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Engine_CommonConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Engine_CommonConfig) ProtoMessage() {}

func (x *Engine_CommonConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Engine_CommonConfig.ProtoReflect.Descriptor instead.
func (*Engine_CommonConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_engine_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Engine_CommonConfig) GetCompanyName() string {
	if x != nil {
		return x.CompanyName
	}
	return ""
}

// Additional information of a Chat Engine.
// Fields in this message are output only.
type Engine_ChatEngineMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of a Dialogflow agent, that this Chat Engine refers
	// to.
	//
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>`.
	DialogflowAgent string `protobuf:"bytes,1,opt,name=dialogflow_agent,json=dialogflowAgent,proto3" json:"dialogflow_agent,omitempty"`
}

func (x *Engine_ChatEngineMetadata) Reset() {
	*x = Engine_ChatEngineMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Engine_ChatEngineMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Engine_ChatEngineMetadata) ProtoMessage() {}

func (x *Engine_ChatEngineMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Engine_ChatEngineMetadata.ProtoReflect.Descriptor instead.
func (*Engine_ChatEngineMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_engine_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Engine_ChatEngineMetadata) GetDialogflowAgent() string {
	if x != nil {
		return x.DialogflowAgent
	}
	return ""
}

// Configurations for generating a Dialogflow agent.
//
// Note that these configurations are one-time consumed by
// and passed to Dialogflow service. It means they cannot be retrieved using
// [EngineService.GetEngine][google.cloud.discoveryengine.v1beta.EngineService.GetEngine]
// or
// [EngineService.ListEngines][google.cloud.discoveryengine.v1beta.EngineService.ListEngines]
// API after engine creation.
type Engine_ChatEngineConfig_AgentCreationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the company, organization or other entity that the agent
	// represents. Used for knowledge connector LLM prompt and for knowledge
	// search.
	Business string `protobuf:"bytes,1,opt,name=business,proto3" json:"business,omitempty"`
	// Required. The default language of the agent as a language tag.
	// See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes.
	DefaultLanguageCode string `protobuf:"bytes,2,opt,name=default_language_code,json=defaultLanguageCode,proto3" json:"default_language_code,omitempty"`
	// Required. The time zone of the agent from the [time zone
	// database](https://www.iana.org/time-zones), e.g., America/New_York,
	// Europe/Paris.
	TimeZone string `protobuf:"bytes,3,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Agent location for Agent creation, supported values: global/us/eu.
	// If not provided, us Engine will create Agent using us-central-1 by
	// default; eu Engine will create Agent using eu-west-1 by default.
	Location string `protobuf:"bytes,4,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *Engine_ChatEngineConfig_AgentCreationConfig) Reset() {
	*x = Engine_ChatEngineConfig_AgentCreationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Engine_ChatEngineConfig_AgentCreationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Engine_ChatEngineConfig_AgentCreationConfig) ProtoMessage() {}

func (x *Engine_ChatEngineConfig_AgentCreationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Engine_ChatEngineConfig_AgentCreationConfig.ProtoReflect.Descriptor instead.
func (*Engine_ChatEngineConfig_AgentCreationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_engine_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *Engine_ChatEngineConfig_AgentCreationConfig) GetBusiness() string {
	if x != nil {
		return x.Business
	}
	return ""
}

func (x *Engine_ChatEngineConfig_AgentCreationConfig) GetDefaultLanguageCode() string {
	if x != nil {
		return x.DefaultLanguageCode
	}
	return ""
}

func (x *Engine_ChatEngineConfig_AgentCreationConfig) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

func (x *Engine_ChatEngineConfig_AgentCreationConfig) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

var File_google_cloud_discoveryengine_v1beta_engine_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1beta_engine_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc1, 0x0d, 0x0a, 0x06, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x12, 0x6c, 0x0a, 0x12, 0x63, 0x68, 0x61, 0x74, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x43, 0x68, 0x61, 0x74, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x10, 0x63,
	0x68, 0x61, 0x74, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x72, 0x0a, 0x14, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52,
	0x12, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x77, 0x0a, 0x14, 0x63, 0x68, 0x61, 0x74, 0x5f, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x43,
	0x68, 0x61, 0x74, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x12, 0x63, 0x68, 0x61, 0x74, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x24, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x73, 0x12, 0x5b, 0x0a, 0x0d, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x62, 0x0a, 0x11, 0x69, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79,
	0x5f, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x56, 0x65,
	0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x52, 0x10, 0x69, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79,
	0x56, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x12, 0x5d, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xbe, 0x01, 0x0a, 0x12, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x50,
	0x0a, 0x0b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x54, 0x69, 0x65, 0x72, 0x52, 0x0a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x69, 0x65, 0x72,
	0x12, 0x56, 0x0a, 0x0e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x64, 0x5f, 0x6f,
	0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x64, 0x4f, 0x6e, 0x52, 0x0c, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x41, 0x64, 0x64, 0x4f, 0x6e, 0x73, 0x1a, 0xf8, 0x02, 0x0a, 0x10, 0x43, 0x68, 0x61,
	0x74, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x84, 0x01,
	0x0a, 0x15, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x43, 0x68, 0x61, 0x74, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x13, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x0a, 0x18, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x6f, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x4c, 0x69, 0x6e, 0x6b, 0x1a, 0xa3, 0x01,
	0x0a, 0x13, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73,
	0x73, 0x12, 0x32, 0x0a, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x13, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f,
	0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74,
	0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0x31, 0x0a, 0x0c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6d, 0x70, 0x61,
	0x6e, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x3f, 0x0a, 0x12, 0x43, 0x68, 0x61, 0x74, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x29, 0x0a, 0x10,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x3a, 0x7d, 0xea, 0x41, 0x7a, 0x0a, 0x25, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d, 0x42, 0x0f, 0x0a, 0x0d, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x11, 0x0a, 0x0f, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x92, 0x02, 0x0a, 0x27, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0b, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x51, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f,
	0x56, 0x45, 0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61,
	0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c,
	0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1beta_engine_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1beta_engine_proto_rawDescData = file_google_cloud_discoveryengine_v1beta_engine_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1beta_engine_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1beta_engine_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1beta_engine_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1beta_engine_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1beta_engine_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_discoveryengine_v1beta_engine_proto_goTypes = []interface{}{
	(*Engine)(nil),                                      // 0: google.cloud.discoveryengine.v1beta.Engine
	(*Engine_SearchEngineConfig)(nil),                   // 1: google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig
	(*Engine_ChatEngineConfig)(nil),                     // 2: google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
	(*Engine_CommonConfig)(nil),                         // 3: google.cloud.discoveryengine.v1beta.Engine.CommonConfig
	(*Engine_ChatEngineMetadata)(nil),                   // 4: google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata
	(*Engine_ChatEngineConfig_AgentCreationConfig)(nil), // 5: google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
	(*timestamppb.Timestamp)(nil),                       // 6: google.protobuf.Timestamp
	(SolutionType)(0),                                   // 7: google.cloud.discoveryengine.v1beta.SolutionType
	(IndustryVertical)(0),                               // 8: google.cloud.discoveryengine.v1beta.IndustryVertical
	(SearchTier)(0),                                     // 9: google.cloud.discoveryengine.v1beta.SearchTier
	(SearchAddOn)(0),                                    // 10: google.cloud.discoveryengine.v1beta.SearchAddOn
}
var file_google_cloud_discoveryengine_v1beta_engine_proto_depIdxs = []int32{
	2,  // 0: google.cloud.discoveryengine.v1beta.Engine.chat_engine_config:type_name -> google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig
	1,  // 1: google.cloud.discoveryengine.v1beta.Engine.search_engine_config:type_name -> google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig
	4,  // 2: google.cloud.discoveryengine.v1beta.Engine.chat_engine_metadata:type_name -> google.cloud.discoveryengine.v1beta.Engine.ChatEngineMetadata
	6,  // 3: google.cloud.discoveryengine.v1beta.Engine.create_time:type_name -> google.protobuf.Timestamp
	6,  // 4: google.cloud.discoveryengine.v1beta.Engine.update_time:type_name -> google.protobuf.Timestamp
	7,  // 5: google.cloud.discoveryengine.v1beta.Engine.solution_type:type_name -> google.cloud.discoveryengine.v1beta.SolutionType
	8,  // 6: google.cloud.discoveryengine.v1beta.Engine.industry_vertical:type_name -> google.cloud.discoveryengine.v1beta.IndustryVertical
	3,  // 7: google.cloud.discoveryengine.v1beta.Engine.common_config:type_name -> google.cloud.discoveryengine.v1beta.Engine.CommonConfig
	9,  // 8: google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig.search_tier:type_name -> google.cloud.discoveryengine.v1beta.SearchTier
	10, // 9: google.cloud.discoveryengine.v1beta.Engine.SearchEngineConfig.search_add_ons:type_name -> google.cloud.discoveryengine.v1beta.SearchAddOn
	5,  // 10: google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.agent_creation_config:type_name -> google.cloud.discoveryengine.v1beta.Engine.ChatEngineConfig.AgentCreationConfig
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1beta_engine_proto_init() }
func file_google_cloud_discoveryengine_v1beta_engine_proto_init() {
	if File_google_cloud_discoveryengine_v1beta_engine_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1beta_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Engine); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Engine_SearchEngineConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Engine_ChatEngineConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Engine_CommonConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Engine_ChatEngineMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Engine_ChatEngineConfig_AgentCreationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Engine_ChatEngineConfig_)(nil),
		(*Engine_SearchEngineConfig_)(nil),
		(*Engine_ChatEngineMetadata_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1beta_engine_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1beta_engine_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1beta_engine_proto_depIdxs,
		MessageInfos:      file_google_cloud_discoveryengine_v1beta_engine_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1beta_engine_proto = out.File
	file_google_cloud_discoveryengine_v1beta_engine_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1beta_engine_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1beta_engine_proto_depIdxs = nil
}
