//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerVulnerabilityAssessmentGet.json
func ExampleServerVulnerabilityAssessmentsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServerVulnerabilityAssessmentsClient().Get(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", armsql.VulnerabilityAssessmentNameDefault, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerVulnerabilityAssessment = armsql.ServerVulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/vulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/vulnerabilityAssessments/default"),
	// 	Properties: &armsql.ServerVulnerabilityAssessmentProperties{
	// 		RecurringScans: &armsql.VulnerabilityAssessmentRecurringScansProperties{
	// 			EmailSubscriptionAdmins: to.Ptr(true),
	// 			Emails: []*string{
	// 				to.Ptr("email1@mail.com"),
	// 				to.Ptr("email2@mail.com")},
	// 				IsEnabled: to.Ptr(true),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerVulnerabilityAssessmentCreateMax.json
func ExampleServerVulnerabilityAssessmentsClient_CreateOrUpdate_createAServersVulnerabilityAssessmentWithAllParameters() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServerVulnerabilityAssessmentsClient().CreateOrUpdate(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", armsql.VulnerabilityAssessmentNameDefault, armsql.ServerVulnerabilityAssessment{
		Properties: &armsql.ServerVulnerabilityAssessmentProperties{
			RecurringScans: &armsql.VulnerabilityAssessmentRecurringScansProperties{
				EmailSubscriptionAdmins: to.Ptr(true),
				Emails: []*string{
					to.Ptr("email1@mail.com"),
					to.Ptr("email2@mail.com")},
				IsEnabled: to.Ptr(true),
			},
			StorageAccountAccessKey: to.Ptr("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
			StorageContainerPath:    to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
			StorageContainerSasKey:  to.Ptr("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerVulnerabilityAssessment = armsql.ServerVulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/vulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/vulnerabilityAssessments/default"),
	// 	Properties: &armsql.ServerVulnerabilityAssessmentProperties{
	// 		RecurringScans: &armsql.VulnerabilityAssessmentRecurringScansProperties{
	// 			EmailSubscriptionAdmins: to.Ptr(true),
	// 			Emails: []*string{
	// 				to.Ptr("email1@mail.com"),
	// 				to.Ptr("email2@mail.com")},
	// 				IsEnabled: to.Ptr(true),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerVulnerabilityAssessmentCreateStorageAccessKeyMin.json
func ExampleServerVulnerabilityAssessmentsClient_CreateOrUpdate_createAServersVulnerabilityAssessmentWithMinimalParametersWhenStorageAccountAccessKeyIsSpecified() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServerVulnerabilityAssessmentsClient().CreateOrUpdate(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", armsql.VulnerabilityAssessmentNameDefault, armsql.ServerVulnerabilityAssessment{
		Properties: &armsql.ServerVulnerabilityAssessmentProperties{
			StorageAccountAccessKey: to.Ptr("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
			StorageContainerPath:    to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerVulnerabilityAssessment = armsql.ServerVulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/vulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/vulnerabilityAssessments/default"),
	// 	Properties: &armsql.ServerVulnerabilityAssessmentProperties{
	// 		RecurringScans: &armsql.VulnerabilityAssessmentRecurringScansProperties{
	// 			EmailSubscriptionAdmins: to.Ptr(false),
	// 			Emails: []*string{
	// 			},
	// 			IsEnabled: to.Ptr(true),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerVulnerabilityAssessmentCreateContainerSasKeyMin.json
func ExampleServerVulnerabilityAssessmentsClient_CreateOrUpdate_createAServersVulnerabilityAssessmentWithMinimalParametersWhenStorageContainerSasKeyIsSpecified() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServerVulnerabilityAssessmentsClient().CreateOrUpdate(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", armsql.VulnerabilityAssessmentNameDefault, armsql.ServerVulnerabilityAssessment{
		Properties: &armsql.ServerVulnerabilityAssessmentProperties{
			StorageContainerPath:   to.Ptr("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
			StorageContainerSasKey: to.Ptr("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerVulnerabilityAssessment = armsql.ServerVulnerabilityAssessment{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/vulnerabilityAssessments"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/vulnerabilityAssessments/default"),
	// 	Properties: &armsql.ServerVulnerabilityAssessmentProperties{
	// 		RecurringScans: &armsql.VulnerabilityAssessmentRecurringScansProperties{
	// 			EmailSubscriptionAdmins: to.Ptr(false),
	// 			Emails: []*string{
	// 			},
	// 			IsEnabled: to.Ptr(true),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerVulnerabilityAssessmentDelete.json
func ExampleServerVulnerabilityAssessmentsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewServerVulnerabilityAssessmentsClient().Delete(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", armsql.VulnerabilityAssessmentNameDefault, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ServerVulnerabilityAssessmentListByServer.json
func ExampleServerVulnerabilityAssessmentsClient_NewListByServerPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServerVulnerabilityAssessmentsClient().NewListByServerPager("vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServerVulnerabilityAssessmentListResult = armsql.ServerVulnerabilityAssessmentListResult{
		// 	Value: []*armsql.ServerVulnerabilityAssessment{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/vulnerabilityAssessments"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/vulnerabilityAssessments/"),
		// 			Properties: &armsql.ServerVulnerabilityAssessmentProperties{
		// 				RecurringScans: &armsql.VulnerabilityAssessmentRecurringScansProperties{
		// 					EmailSubscriptionAdmins: to.Ptr(true),
		// 					Emails: []*string{
		// 						to.Ptr("email1@mail.com"),
		// 						to.Ptr("email2@mail.com")},
		// 						IsEnabled: to.Ptr(true),
		// 					},
		// 				},
		// 		}},
		// 	}
	}
}
