//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsaas

// AccessTokenResult - the ISV access token result response.
type AccessTokenResult struct {
	// The Publisher Offer Base Uri
	PublisherOfferBaseURI *string

	// The generated token
	Token *string
}

// App - the saasApp resource.
type App struct {
	// the resource location.
	Location *string

	// the resource name.
	Name *string

	// the resource properties.
	Properties *AppProperties

	// the resource tags.
	Tags map[string]*string

	// the resource type.
	Type *string

	// READ-ONLY; the resource Id.
	ID *string
}

// AppOperation - saas app operations
type AppOperation struct {
	// the operation display
	Display *AppOperationDisplay

	// whether the operation is a data action or not.
	IsDataAction *bool

	// the operation name
	Name *string

	// the operation origin
	Origin *string
}

// AppOperationDisplay - Saas app operation display
type AppOperationDisplay struct {
	// Description of the operation for display purposes
	Description *string

	// Name of the operation for display purposes
	Operation *string

	// Name of the provider for display purposes
	Provider *string

	// Name of the resource type for display purposes
	Resource *string
}

// AppOperationsResponseWithContinuation - saas app operation response with continuation.
type AppOperationsResponseWithContinuation struct {
	// the next link to query to get the remaining results.
	NextLink *string

	// the value of response.
	Value []*AppOperation
}

// AppPlan - Saas resource plan.
type AppPlan struct {
	// the plan id.
	Name *string

	// the offer id.
	Product *string

	// the publisher id.
	Publisher *string
}

// AppProperties - Saas resource properties.
type AppProperties struct {
	// the resource plan details.
	SaasAppPlan *AppPlan

	// the Saas resource status.
	Status *SaasAppStatus
}

// AppResponseWithContinuation - saas app response with continuation.
type AppResponseWithContinuation struct {
	// the next link to query to get the remaining results.
	NextLink *string

	// the value of response.
	Value []*App
}

// CreationProperties - properties for creation saas
type CreationProperties struct {
	// Whether the SaaS subscription will auto renew upon term end.
	AutoRenew *bool

	// The offer id.
	OfferID *string

	// The metadata about the SaaS subscription such as the AzureSubscriptionId and ResourceUri.
	PaymentChannelMetadata map[string]*string

	// The Payment channel for the SaasSubscription.
	PaymentChannelType *PaymentChannelType

	// The publisher id.
	PublisherID *string

	// The environment in the publisher side for this resource.
	PublisherTestEnvironment *string

	// The seat count.
	Quantity *float32

	// The plan id.
	SKUID *string

	// The SaaS resource name.
	SaasResourceName *string

	// The saas session id used for dev service migration request.
	SaasSessionID *string

	// The saas subscription id used for tenant to subscription level migration request.
	SaasSubscriptionID *string

	// The current Term id.
	TermID *string
}

// DeleteOptions - delete Options
type DeleteOptions struct {
	// the feedback
	Feedback *string

	// The reasonCode
	ReasonCode *float32

	// whether it is unsubscribeOnly
	UnsubscribeOnly *bool
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// MoveResource - Resource Move Options
type MoveResource struct {
	// The resource uris to move
	Resources []*string

	// The target resource group uri for the move
	TargetResourceGroup *string
}

// Properties - saas resource properties
type Properties struct {
	// Whether the current term is a Free Trial term
	IsFreeTrial *bool

	// The last modifier date if this resource.
	LastModified *string

	// The SaaS Subscription Status.
	Status *SaasResourceStatus

	// The current Term object.
	Term *PropertiesTerm

	// READ-ONLY; The created date of this resource.
	Created *string
}

// PropertiesTerm - The current Term object.
type PropertiesTerm struct {
	// The end date of the current term
	EndDate *string

	// The start date of the current term
	StartDate *string

	// The unit indicating Monthly / Yearly
	TermUnit *string
}

// Resource - SaaS REST API resource definition.
type Resource struct {
	// saas properties
	Properties *ResourceProperties

	// the resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource uri
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ResourceCreation - SaaS REST API resource definition for creation.
type ResourceCreation struct {
	// Resource location. Only value allowed for SaaS is 'global'
	Location *string

	// The resource name
	Name *string

	// Properties of the SaaS resource that are relevant for creation.
	Properties *CreationProperties

	// the resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource uri
	ID *string

	// READ-ONLY; Resource type.
	Type *string
}

// ResourceProperties - saas properties
type ResourceProperties struct {
	// Whether the SaaS subscription will auto renew upon term end.
	AutoRenew *bool

	// Whether the current term is a Free Trial term
	IsFreeTrial *bool

	// The last modifier date if this resource.
	LastModified *string

	// The offer id.
	OfferID *string

	// The metadata about the SaaS subscription such as the AzureSubscriptionId and ResourceUri.
	PaymentChannelMetadata map[string]*string

	// The Payment channel for the SaasSubscription.
	PaymentChannelType *PaymentChannelType

	// The publisher id.
	PublisherID *string

	// The environment in the publisher side for this resource.
	PublisherTestEnvironment *string

	// The seat count.
	Quantity *float32

	// The plan id.
	SKUID *string

	// The SaaS resource name.
	SaasResourceName *string

	// The saas session id used for dev service migration request.
	SaasSessionID *string

	// The saas subscription id used for tenant to subscription level migration request.
	SaasSubscriptionID *string

	// The SaaS Subscription Status.
	Status *SaasResourceStatus

	// The current Term object.
	Term *PropertiesTerm

	// The current Term id.
	TermID *string

	// READ-ONLY; The created date of this resource.
	Created *string
}

// ResourceResponseWithContinuation - saas resources response with continuation.
type ResourceResponseWithContinuation struct {
	// the next link to query to get the remaining results.
	NextLink *string

	// the value of response.
	Value []*Resource
}

// Result - Sample result definition
type Result struct {
	// Sample property of type string
	SampleProperty *string
}
