//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappservice

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// GlobalClient contains the methods for the Global group.
// Don't use this type directly, use NewGlobalClient() instead.
type GlobalClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewGlobalClient creates a new instance of GlobalClient with the specified values.
//   - subscriptionID - Your Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewGlobalClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*GlobalClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &GlobalClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// GetDeletedWebApp - Description for Get deleted app for a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - deletedSiteID - The numeric ID of the deleted app, e.g. 12345
//   - options - GlobalClientGetDeletedWebAppOptions contains the optional parameters for the GlobalClient.GetDeletedWebApp method.
func (client *GlobalClient) GetDeletedWebApp(ctx context.Context, deletedSiteID string, options *GlobalClientGetDeletedWebAppOptions) (GlobalClientGetDeletedWebAppResponse, error) {
	var err error
	const operationName = "GlobalClient.GetDeletedWebApp"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDeletedWebAppCreateRequest(ctx, deletedSiteID, options)
	if err != nil {
		return GlobalClientGetDeletedWebAppResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GlobalClientGetDeletedWebAppResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GlobalClientGetDeletedWebAppResponse{}, err
	}
	resp, err := client.getDeletedWebAppHandleResponse(httpResp)
	return resp, err
}

// getDeletedWebAppCreateRequest creates the GetDeletedWebApp request.
func (client *GlobalClient) getDeletedWebAppCreateRequest(ctx context.Context, deletedSiteID string, options *GlobalClientGetDeletedWebAppOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}"
	if deletedSiteID == "" {
		return nil, errors.New("parameter deletedSiteID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deletedSiteId}", url.PathEscape(deletedSiteID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDeletedWebAppHandleResponse handles the GetDeletedWebApp response.
func (client *GlobalClient) getDeletedWebAppHandleResponse(resp *http.Response) (GlobalClientGetDeletedWebAppResponse, error) {
	result := GlobalClientGetDeletedWebAppResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedSite); err != nil {
		return GlobalClientGetDeletedWebAppResponse{}, err
	}
	return result, nil
}

// GetDeletedWebAppSnapshots - Description for Get all deleted apps for a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - deletedSiteID - The numeric ID of the deleted app, e.g. 12345
//   - options - GlobalClientGetDeletedWebAppSnapshotsOptions contains the optional parameters for the GlobalClient.GetDeletedWebAppSnapshots
//     method.
func (client *GlobalClient) GetDeletedWebAppSnapshots(ctx context.Context, deletedSiteID string, options *GlobalClientGetDeletedWebAppSnapshotsOptions) (GlobalClientGetDeletedWebAppSnapshotsResponse, error) {
	var err error
	const operationName = "GlobalClient.GetDeletedWebAppSnapshots"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDeletedWebAppSnapshotsCreateRequest(ctx, deletedSiteID, options)
	if err != nil {
		return GlobalClientGetDeletedWebAppSnapshotsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GlobalClientGetDeletedWebAppSnapshotsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GlobalClientGetDeletedWebAppSnapshotsResponse{}, err
	}
	resp, err := client.getDeletedWebAppSnapshotsHandleResponse(httpResp)
	return resp, err
}

// getDeletedWebAppSnapshotsCreateRequest creates the GetDeletedWebAppSnapshots request.
func (client *GlobalClient) getDeletedWebAppSnapshotsCreateRequest(ctx context.Context, deletedSiteID string, options *GlobalClientGetDeletedWebAppSnapshotsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}/snapshots"
	if deletedSiteID == "" {
		return nil, errors.New("parameter deletedSiteID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{deletedSiteId}", url.PathEscape(deletedSiteID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDeletedWebAppSnapshotsHandleResponse handles the GetDeletedWebAppSnapshots response.
func (client *GlobalClient) getDeletedWebAppSnapshotsHandleResponse(resp *http.Response) (GlobalClientGetDeletedWebAppSnapshotsResponse, error) {
	result := GlobalClientGetDeletedWebAppSnapshotsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SnapshotArray); err != nil {
		return GlobalClientGetDeletedWebAppSnapshotsResponse{}, err
	}
	return result, nil
}

// GetSubscriptionOperationWithAsyncResponse - Description for Gets an operation in a subscription and given region
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - location - Location name
//   - operationID - Operation Id
//   - options - GlobalClientGetSubscriptionOperationWithAsyncResponseOptions contains the optional parameters for the GlobalClient.GetSubscriptionOperationWithAsyncResponse
//     method.
func (client *GlobalClient) GetSubscriptionOperationWithAsyncResponse(ctx context.Context, location string, operationID string, options *GlobalClientGetSubscriptionOperationWithAsyncResponseOptions) (GlobalClientGetSubscriptionOperationWithAsyncResponseResponse, error) {
	var err error
	const operationName = "GlobalClient.GetSubscriptionOperationWithAsyncResponse"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getSubscriptionOperationWithAsyncResponseCreateRequest(ctx, location, operationID, options)
	if err != nil {
		return GlobalClientGetSubscriptionOperationWithAsyncResponseResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GlobalClientGetSubscriptionOperationWithAsyncResponseResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return GlobalClientGetSubscriptionOperationWithAsyncResponseResponse{}, err
	}
	return GlobalClientGetSubscriptionOperationWithAsyncResponseResponse{}, nil
}

// getSubscriptionOperationWithAsyncResponseCreateRequest creates the GetSubscriptionOperationWithAsyncResponse request.
func (client *GlobalClient) getSubscriptionOperationWithAsyncResponseCreateRequest(ctx context.Context, location string, operationID string, options *GlobalClientGetSubscriptionOperationWithAsyncResponseOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/locations/{location}/operations/{operationId}"
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if operationID == "" {
		return nil, errors.New("parameter operationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", url.PathEscape(operationID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
