# version-stamp.m4
# serial 1
dnl Copyright (C) 2025-2026 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

# Manages a stamp file, that keeps track when $(VERSION) was last changed.
#
# gl_CONFIG_VERSION_STAMP
# needs to be invoked near the end of the package's top-level configure.ac,
# before AC_OUTPUT.
# It makes sure that during the build,
#   - $(top_srcdir)/.version exists, and
#   - when $(VERSION) is changed, $(top_srcdir)/.version gets modified.
#
# $(top_srcdir)/.version is a stamp file. Its contents wouldn't matter,
# except that for detecting the change, we store the value of $(VERSION)
# in it (but we could just as well store it in a different file).
AC_DEFUN([gl_CONFIG_VERSION_STAMP],
[
  AC_CONFIG_COMMANDS([version-timestamp],
    [if test -f "$ac_top_srcdir/.version" \
        && test `cat "$ac_top_srcdir/.version"` = "$gl_version"; then
       # The value of $(VERSION) is the same as last time.
       :
     else
       # The value of $(VERSION) has changed. Update the stamp.
       echo "$gl_version" > "$ac_top_srcdir/.version"
     fi
    ],
    [gl_version="$VERSION"])
])
