"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Table = exports.FontDirectionHint = exports.MacStyle = exports.Flags = exports.Tag = void 0;
exports.Tag = "head";
var Flags;
(function (Flags) {
    Flags[Flags["None"] = 0] = "None";
    Flags[Flags["BaseLineYAt0"] = 1] = "BaseLineYAt0";
    Flags[Flags["LeftSidebearingAtX0"] = 2] = "LeftSidebearingAtX0";
    Flags[Flags["InstructionsMayDependOnPointSize"] = 4] = "InstructionsMayDependOnPointSize";
    Flags[Flags["ForcePpemToBeInteger"] = 8] = "ForcePpemToBeInteger";
    Flags[Flags["InstructionMayAlterAdvanceWidth"] = 16] = "InstructionMayAlterAdvanceWidth";
    Flags[Flags["IntendedToBeVertical"] = 32] = "IntendedToBeVertical";
    Flags[Flags["Reserved6"] = 64] = "Reserved6";
    Flags[Flags["NeedComplexLayout"] = 128] = "NeedComplexLayout";
    Flags[Flags["HasAATMetamorphism"] = 256] = "HasAATMetamorphism";
    Flags[Flags["HasStrongRightToLeft"] = 512] = "HasStrongRightToLeft";
    Flags[Flags["HasIndicRearrangement"] = 1024] = "HasIndicRearrangement";
    Flags[Flags["Compressed"] = 2048] = "Compressed";
    Flags[Flags["Converted"] = 4096] = "Converted";
    Flags[Flags["OptimizedForClearType"] = 8192] = "OptimizedForClearType";
    Flags[Flags["LastResortFont"] = 16384] = "LastResortFont";
    Flags[Flags["Reserved15"] = 32768] = "Reserved15";
})(Flags || (exports.Flags = Flags = {}));
var MacStyle;
(function (MacStyle) {
    MacStyle[MacStyle["None"] = 0] = "None";
    MacStyle[MacStyle["Bold"] = 1] = "Bold";
    MacStyle[MacStyle["Italic"] = 2] = "Italic";
    MacStyle[MacStyle["Underline"] = 4] = "Underline";
    MacStyle[MacStyle["Outline"] = 8] = "Outline";
    MacStyle[MacStyle["Shadow"] = 16] = "Shadow";
    MacStyle[MacStyle["Condensed"] = 32] = "Condensed";
    MacStyle[MacStyle["Extended"] = 64] = "Extended";
})(MacStyle || (exports.MacStyle = MacStyle = {}));
var FontDirectionHint;
(function (FontDirectionHint) {
    FontDirectionHint[FontDirectionHint["FullyMixed"] = 0] = "FullyMixed";
    FontDirectionHint[FontDirectionHint["OnlyStrongLTR"] = 1] = "OnlyStrongLTR";
    FontDirectionHint[FontDirectionHint["StrongLTROrNeutral"] = 2] = "StrongLTROrNeutral";
    FontDirectionHint[FontDirectionHint["OnlyStrongRTL"] = -1] = "OnlyStrongRTL";
    FontDirectionHint[FontDirectionHint["StrongRTLOrNeutral"] = -2] = "StrongRTLOrNeutral";
})(FontDirectionHint || (exports.FontDirectionHint = FontDirectionHint = {}));
class Table {
    constructor(majorVersion = 0x1, minorVersion = 0) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.fontRevision = 0;
        this.checkSumAdjust = 0;
        this.magicNumber = 0x5f0f3cf5;
        this.flags = Flags.None;
        this.unitsPerEm = 1000;
        this.created = new Date();
        this.modified = new Date();
        this.xMin = 0; // VOLATILE
        this.yMin = 0; // VOLATILE
        this.xMax = 0; // VOLATILE
        this.yMax = 0; // VOLATILE
        this.macStyle = MacStyle.None;
        this.lowestRecPPEM = 0;
        this.fontDirectionHint = 2;
        this.indexToLocFormat = 0; // VOLATILE
        this.glyphDataFormat = 0;
    }
}
exports.Table = Table;
//# sourceMappingURL=head.js.map