# The idea behind `debputy`

> Reduce the learning curve and mental load for Debian packagers.

This is the key goal that we strive towards in `debputy`.

## The pillars of the `debputy` vision

How will `debputy` reduce the learning curve and mental load for Debian
packagers?

 1. Declarative and consolidated packaging instructions
 2. Unified interface
 3. Tool-assisted packaging

### Declarative and consolidated packaging instructions

In many cases, packaging tools cannot solve all packaging problems from
conventions alone. This is why all tools have a way to accept input from
the packager to alter or augment the default packaging rules. Every tool
has their own way of doing this.

In `debputy`, the goal is to consolidate these instructions into a single
declarative and machine-readable format.

Packaging building will need to interface with turning complete build
instructions (such as via upstream build system), so packagers will still
have access to turning complete instructions where relevant.

Note: From a `debhelper`-centric point of view, package instructions in this
context are anything covered by `debian/rules` (`dh_*` and their config files)
and also parts of `debian/control`.

### Unified interface

The `debhelper` commands have ubiquitous. So ubiquitous in fact that people
struggle to tell whether a given command is from `debhelper` or is a third-party
add-on. At most, they need to know "activate this `debhelper` add-on".

This means that the interface is smooth enough that people do not need to spend
a lot of energy when moving beyond the core features. This has been a good
property for `debhelper` and `debputy` has been built with a similar idea in
mind with the `debputy` plugins.

This implies that third-party features will have to hook into `debputy`'s
declarative and consolidated packaging instructions format.

### Tool-assistance packaging

Debian packaging has a lot of fields, toggles, and instructions. The
`debian/control` file has about 60 different known fields including
language or tooling specific ones. On top of this, `debhelper` itself
has about 65 commands each with their own command line options
and some configuration files.

In the 30 years of Debian, the best tool-assistance was `lintian`
followed with `lintian-brush` to find and fix some common mistakes.
The `lintian` command requires you to have a buildable package, so it
cannot help you with mistakes that prevent package builds. The
`lintian-brush` tool can do a bit more, but it is still built around
fixing `lintian` issues. Therefore, issues that `lintian` will not
detect are not covered by `lintian-brush`.

But our documentation support was non-existent. If you wanted to know
what a field did in `debian/control`, you had to know which tool or project
declared the field, so you could look up the documentation for that project
and then field the field documentation in it.

Even `debhelper` with its add-on support has its own helpers as first class
citizen. The `debhelper` framework provide a list of `debhelper` provided
addons in [man:dh(1)](https://manpages.debian.org/dh.1) along with what they do.
But what if it is a third-party add-on? Then you have to find the project providing
it first and then look up their documentation for it. Admittedly, this is a lot
easier than `debian/control` files thanks to `apt` and `apt-file`. But it is still
an extra step.

This is where `debputy` will stand apart from previous packaging tools, by focusing
on packaging as a whole. Giving the packager live in-editor feedback is part of
being a packaging *helper* rather than just being a packaging tool.

But it goes beyond that. The tool assistance should also challenge the status quo
and make more packaging features easier to provide tool assistance for.

## Derived consequences of the vision

As a consequence of this vision, it follows that:

 * Third-party plugins must be first class citizens. If a packager can tell the
   difference between `debputy` provided feature and a third-party plugin
   provided feature following `debputy`'s conventions, then `debputy` can be
   improved.


## Historical context of the goal

To understand the initial goal, it is also important to understand the historical
context that `debputy` was created in. Debian has existed for 30 years with its
primary packaging interface being `debian/control` + `debian/rules`, both of
which have grown organically.

Many people identified that the `debian/rules` had a lot of duplication between
packages and there were many of opportunities for removing such duplication.
The most notable projects were `debhelper` and `cdbs` with `debhelper` eventually
out-competing basically all other projects with its `dh` feature. At the time of
writing, `cdbs` is now unmaintained and deprecated with people working on migrating
packages away from it.

One thing that is important to know here is that both `debhelper` and `cdbs` were
built into the existing `debian/rules` framework and relies on `debian/rules` being
a GNU Makefile. This means that the entry point for all packaging instructions passes
through a turing complete language making introspection hard. Additionally,
`debhelper` consists of many small commands that each individually are easy to
understand. However, trying to piece them together easily becomes a
"death by a thousand" cuts problem. Since all the pieces are commands, they are
opaque pieces of code. Any tool assisting has to know about every command individually,
which in turn makes writing linting and tool assistance hard.

Finally, `debhelper` and `cdbs` comes from a time, where everyone had to write everything
themselves. Therefore, they are built around the packager being able to inject arbitrary
hooks at various point. While this is an excellent way to ensure people can always adopt
the helper, it affects introspectable and optimization opportunities. As an example, we
have heuristics for setting `Multi-Arch` in some cases. However, `debhelper`'s design plus
hooks makes it awkward to place the code.

It is in this context that vision behind `debputy` was formed.
