# Interface description for package helpers

Most Debian packages today are built using packaging helpers such
as **debhelper** or **debputy**. From here on out, these tools will
collectively be referred to as the `package-helper`.

The document written with the assumption that the reader is a maintainer
of a tool like this and want to integrate `deb-build-artifact-gather`.

## What is the `package-helper` required to do?

The `package-helper` *can* assist `deb-build-artifact-gather`
by providing information to it via the `DEB_ARTIFACTS_EXTRACTION_IPC_DIR`
directory.

The package helper should start by checking if `DEB_ARTIFACTS_EXTRACTION_IPC_DIR`
is set. If the variable is set, then that is the IPC directory used
to communicate with `deb-build-artifact-gather`. The communication
is one way.

Note that directory denoted by `DEB_ARTIFACTS_EXTRACTION_IPC_DIR` may not
exist. The `package-helper` should create directories when needed. The
`package-helper` should **not** clean up anything it creates here. Clean
up happens after the `package-helper` has completed it task.

### Providing variables

The `package-helper` can create 0 or more `.varlist` files in the
`${DEB_ARTIFACTS_EXTRACTION_IPC_DIR}/variables` directory.

Each `varlist` file should be a plaintext UTF-8 encoded file using
the format:

```text
# `dh_auto_configure --builddir path/to/build-dir` might trigger
# the the following line.
BUILD_DIR = path/to/build-dir
```

The same variable can be redefined multiple times. All definitions
are considered by `deb-build-artifact-gather`, which means the
`package-helper` can freely write a line for each build-directory
it uses (in case of multi-builds).

The `package-helper` can use relative (to the source root) paths or
absolute paths.

The basename of the file (before the `.varlist`) can be chosen
arbitrarily by the `package-helper`. This can be helpful if
the helper consist of smaller tools where it is hard to coordinate
centrally when parallelization is involved.

Note that the `package-helper` cannot assume it has exclusive control
of this directory. Other tools will have the option of using the
directory. Tools should generally namespace their files.

### Providing extraction patterns

The `package-helper` can create 0 or more `.pattern-list` files in the
`${DEB_ARTIFACTS_EXTRACTION_IPC_DIR}/collection-patterns` directory.

Each `pattern-list` file should be a plaintext UTF-8 encoded file using
the format:

```text
foo/test-*.log
foo/my-data.file
```

This can be used for custom patterns or for implementing a user-facing
feature to collect artifacts. However, generic patterns should preferably
be in `deb-build-artifact-gather` so everyone can benefit from them.

Each line except those that start with `#` are considered a glob-like
pattern. The `package-helper` should only assume that `*` and `?`
are supported as magic glob characters.

The same pattern can be used multiple times and will be deduplicated.
The `package-helper` can use relative (to the source root) or
absolute paths.

The basename of the file (before the `.pattern-list`) can be chosen
arbitrarily by the `package-helper`. This can be helpful if
the helper consist of smaller tools where it is hard to coordinate
centrally when parallelization is involved.

Note that the `package-helper` cannot assume it has exclusive control
of this directory. Other tools will have the option of using the
directory. Tools should generally namespace their files.


## What will `deb-build-artifact-gather` do for your tool?

The `deb-build-artifact-gather` will:

 1) handle collecting all relevant paths (logs, etc.) and interfacing 
    with the builder tool (such as `sbuild`).

 2) maintain common collection patterns

In other words, segregation of duties. The `package-helper` can focus
on performing builds and having a consistent interface with its
users.

Meanwhile, `deb-build-artifact-gather` can focus on maintaining the
pattern list, so it is not duplicated between each helper, and performing
the actual collection.
