# Security interface for `deb-build-artifact-gather`

The `deb-build-artifact-gather` is a tool that will extract artifacts
from a build after it completed. The build itself can influence what
is being extracted, which opens up security questions.

The `deb-build-artifact-gathre` tool is written with the context
of the build it is collecting from is running arbitrary code from
a trusted source. If said code wanted to be harmful, then you
already ran it before invoking `deb-build-artifact-gather`. That is,
there is a problem with the security policy or vetting of the code
being run.

If the malicious code wanted to perform a Denial of Service via
disk exhaustion or CPU (etc.), it can just do that directly rather
than trigger it indirectly via `deb-build-artifact-gather`. Therefore,
resource exhaustion triggered via input from the build process are
also not considered security issues either.

With that being said, `deb-build-artifact-gather` will open a way for
harmful code to be able to extract data using the
`deb-build-artifact-gather` interface without putting the data into
an existing artifact (such as `.deb` files). As in, code that was unable to
break the isolation of the build container is now granted a door to
extract data from inside the container and it can be done in a less
obvious channel. Especially if these build artifacts are published
automatically. There is no way for `deb-build-artifact-gather` to
decide whether what is being collected is benign or harmful. Such
a policy is beyond `deb-build-artifact-gather`.

Issues originating from any of the above are **not** considered
security issues / bugs in `deb-build-artifact-gather`. It falls upon
the consumer to guard themselves against the build process being
harmful via relevant security policies and processes. This includes
mitigation for any of the above known issues.

If you are concerned about this, you are recommended to either:

 * Not use `deb-build-artifact-gather`, OR
 * Only invoke `deb-build-artifact-gather` inside the build root / container
   and validate what is being extracted before publishing it.

Note: We might accept issues from the above as a regular (non-security)
bug.

## Security issues

For issues that are not covered by the above and should be embargoed, please
report the issue to the Debian Security Team, which has the relevant skill
set, policies, and infrastructure to handle this. While the salsa.debian.org
services provides support for **confidential** issues, all Debian Developers
can read those for the `deb-build-artifact-gather` project. This makes it
unsuitable for security bugs under embargo.

Please review <https://www.debian.org/security/faq#contact> for how to contact
the Debian Security Team.
