include(RunCTest)

function(run_InstrumentationInCTestXML CASE_NAME)
  cmake_parse_arguments(ARGS "USE_INSTRUMENTATION_ENV_VARS;USE_VERBOSE_INSTRUMENTATION;USE_CMAKE_INSTRUMENTATION_CMD" "" "" ${ARGN})
  if(ARGS_USE_VERBOSE_INSTRUMENTATION)
    set(ENV{CTEST_USE_VERBOSE_INSTRUMENTATION} "1")
    set(RunCMake_USE_VERBOSE_INSTRUMENTATION TRUE)
  else()
    set(ENV{CTEST_USE_VERBOSE_INSTRUMENTATION} "0")
    set(RunCMake_USE_VERBOSE_INSTRUMENTATION FALSE)
  endif()
  if(ARGS_USE_INSTRUMENTATION_ENV_VARS)
    set(ENV{CTEST_EXPERIMENTAL_INSTRUMENTATION} "ec7aa2dc-b87f-45a3-8022-fe01c5f59984")
    set(ENV{CTEST_USE_INSTRUMENTATION} "1")
    set(RunCMake_USE_INSTRUMENTATION TRUE)
  else()
    set(ENV{CTEST_EXPERIMENTAL_INSTRUMENTATION} "0")
    set(ENV{CTEST_USE_INSTRUMENTATION} "0")
    set(RunCMake_USE_INSTRUMENTATION FALSE)
  endif()
  if (ARGS_USE_CMAKE_INSTRUMENTATION_CMD)
    set(RunCMake_USE_CMAKE_INSTRUMENTATION_CMD TRUE)
    set(RunCMake_USE_INSTRUMENTATION TRUE)
  else()
    set(RunCMake_USE_CMAKE_INSTRUMENTATION_CMD FALSE)
    set(RunCMake_USE_INSTRUMENTATION FALSE)
  endif()

  configure_file(${RunCMake_SOURCE_DIR}/main.c
                 ${RunCMake_BINARY_DIR}/${CASE_NAME}/main.c COPYONLY)
  run_ctest("${CASE_NAME}")
  unset(RunCMake_USE_LAUNCHERS)
  unset(RunCMake_USE_INSTRUMENTATION)
endfunction()
run_InstrumentationInCTestXML(NoInstrumentationInCTestXML)
run_InstrumentationInCTestXML(InstrumentationInCTestXML
  USE_INSTRUMENTATION_ENV_VARS
)
run_InstrumentationInCTestXML(VerboseInstrumentationInCTestXML
  USE_INSTRUMENTATION_ENV_VARS
  USE_VERBOSE_INSTRUMENTATION
)
run_InstrumentationInCTestXML(InstrumentationInCTestXMLWithCmd
  USE_CMAKE_INSTRUMENTATION_CMD
)
