
Notable changes in 0.30.1 as compared to 0.30
=============================================

May require attention
---------------------

* Previous versions of bup might have saved filesystem directories
  with incorrect metadata, but the file contents should be fine.  This
  could have happened if bup encountered an error while trying to read
  the metadata for one of the files in a directory, or if bup were
  asked to save two different files with the same name to the same
  destination directory (e.g. via the strip/graft options).  In cases
  where this has happened bup may present either generic or incorrect
  metadata for some of the paths in the affected directory.

* The way `bup index --fake-valid` works has been made to match the
  documentation in the man page so that it can actually be used for
  the stated purpose (of avoiding 'boring' files.)

General
-------

* bup should more accurately recognize git versions.  Previously, for
  example, it would reject relase candidates like "1.5.2-rc3"
  or (apparently) "1.5.2-rc3 (something ...)".

* When `BUP_ASSUME_GIT_VERSION_IS_FINE` is set to true, yes or 1 in
  the environment,  bup will assume the version of git that's
  available in the `PATH` is acceptable, and skip the version check.

Bugs
----

* bup should close files more aggressively during various operations
  which, for example, should return space to the filesystem sooner
  during midx operations, whether explicit as `bup midx ...` or
  implicit during other operations like `bup save`.  Previously, it
  could leave deleted files open, preventing their space from being
  returned until bup exited.  Similar improvements should prevent bup
  from crashing during some operations like `gc` on filesystems that
  don't actually remove a deleted files's path from a directory until
  it the file is closed.

* bup should no longer crash when trying to read the target of
  synthetic symlinks like `/BRANCH/latest`.  For example:

    File "/usr/local/lib/bup/bup/vfs.py", line 524, in _compute_item_size
      return len(_readlink(repo, item.oid))
    AttributeError: 'FakeLink' object has no attribute 'oid'

* `bup bloom` should notice that it needs to regenerate the filter in
  some cases.  For example, it was supposed to regenerate the filter
  if the `-k` value changed, but it wouldn't.

* The DESIGN document is clearer about the fact that `bup save
  --smaller` will actually omit larger files from the saved tree
  entirely.

* Failing to specify a port for `bup web` on the command line (only
  specifying a hostname) should no longer cause an unrelated syntax
  error.

* Commit date timezone offsets of 0 will no longer be interpreted
  as local time instead in some cases.

* bup should release some midx-related data structures (mmap, etc.)
  immediately on close, instead of relying on garbage collection.

* A memory leak caused by some of bup's C-level stat calls has been
  fixed.

* Some syntax issues in the manpages have been fixed.

Build system
------------

* The automated tests have moved from FreeBSD 11.2 to 12.1.

* t/test-fuse should be more portable.  In particular, a compatibility
  issue with Fedora 31 has been fixed, and it should be less affected
  by local timezone variances.

* Some internal build dependencies have been fixed.

Thanks to (at least)
====================

Aidan Hobson Sayers, Greg Troxel, Johannes Berg, Luca Carlon, Reinier
Maas, Rob Browning, and Wyatt Alt
