#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Papo and Yo
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250312.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='papo-and-yo'
GAME_NAME='Papo and Yo'

ARCHIVE_BASE_0_NAME='PapoYo_linux_1389070953.sh'
ARCHIVE_BASE_0_MD5='d8222b87222f4eb05025584bf923da41'
ARCHIVE_BASE_0_SIZE='2000000'
ARCHIVE_BASE_0_VERSION='2014010601-humble1'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/papo-yo'

CONTENT_PATH_DEFAULT='data'
CONTENT_LIBS_BIN_RELATIVE_PATH='x86/Binaries/Linux/lib'
CONTENT_LIBS_BIN_FILES='
libPhysXCooking.so
libPhysXCore.so
libtcmalloc.so.0'
## The game binary is linked against libsteam_api.so,
## so this library can not be omitted.
CONTENT_LIBS_BIN_FILES="$CONTENT_LIBS_BIN_FILES
libsteam_api.so"
CONTENT_GAME_BIN_RELATIVE_PATH='x86'
CONTENT_GAME_BIN_FILES='
Binaries/Linux/steam_appid.txt
Binaries/Linux/PYGame-Linux'
CONTENT_GAME_DATA_RELATIVE_PATH='noarch'
CONTENT_GAME_DATA_FILES='
Engine
PYGame
PapoYoIcon.bmp
PapoYoIcon.png'
CONTENT_DOC_DATA_RELATIVE_PATH='noarch'
CONTENT_DOC_DATA_FILES='
about.html
BuildVersion.txt
README.linux
UpdateLog.txt'

APP_MAIN_EXE='Binaries/Linux/PYGame-Linux'
APP_MAIN_ICON='noarch/PapoYoIcon.png'
## Prevent a game crash when using the wayland backend of SDL
APP_MAIN_PRERUN='
# Prevent a game crash when using the wayland backend of SDL
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libstdc++.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Run the game binary from its parent directory
game_exec_line() {
	cat <<- 'EOF'
	cd Binaries/Linux
	./PYGame-Linux "$@"
	EOF
}

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
